/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.expressions;

import gw.config.CommonServices;
import gw.internal.gosu.parser.ParserBase;
import gw.internal.gosu.parser.expressions.ArithmeticExpression;
import gw.internal.gosu.parser.expressions.DimensionOperandResolver;
import gw.internal.gosu.parser.expressions.UnsupportedNumberTypeException;
import gw.lang.IDimension;
import gw.lang.parser.expressions.IMultiplicativeExpression;
import gw.lang.reflect.IPlaceholder;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.JavaTypes;
import java.math.BigDecimal;
import java.math.MathContext;

public final class MultiplicativeExpression
extends ArithmeticExpression
implements IMultiplicativeExpression {
    @Override
    public Object evaluate() {
        if (!this.isCompileTimeConstant()) {
            return super.evaluate();
        }
        return MultiplicativeExpression.evaluate(this.getType(), this.getLHS().evaluate(), this.getRHS().evaluate(), this.getLHS().getType(), this.getRHS().getType(), this.getOperator().charAt(0), false);
    }

    public static Object evaluate(IType type, Object lhsValue, Object rhsValue, IType lhsType, IType rhsType, int iOperator, boolean bNullSafe, Object ctx, int startLhs, int endLhs, int startRhs, int endRhs) {
        return MultiplicativeExpression.evaluate(type, lhsValue, rhsValue, lhsType, rhsType, iOperator, bNullSafe);
    }

    public static Object evaluate(IType type, Object lhsValue, Object rhsValue, IType lhsType, IType rhsType, int iOperator, boolean bNullSafe) {
        Object retValue;
        if (lhsType instanceof IPlaceholder && ((IPlaceholder)lhsType).isPlaceholder()) {
            lhsType = TypeSystem.getFromObject((Object)lhsValue);
            type = ParserBase.resolveRuntimeType(lhsType, iOperator, rhsType);
        }
        if (rhsType instanceof IPlaceholder && ((IPlaceholder)rhsType).isPlaceholder()) {
            rhsType = TypeSystem.getFromObject((Object)rhsValue);
            type = ParserBase.resolveRuntimeType(lhsType, iOperator, rhsType);
        }
        if (lhsValue == null) {
            if (bNullSafe) {
                return null;
            }
            throw new NullPointerException("left-hand operand was null");
        }
        if (rhsValue == null) {
            if (bNullSafe) {
                return null;
            }
            throw new NullPointerException("right-hand operand was null");
        }
        IDimension customNumberBase = null;
        if (JavaTypes.IDIMENSION().isAssignableFrom(type)) {
            DimensionOperandResolver customNumberResolver = DimensionOperandResolver.resolve(type, lhsType, lhsValue, rhsType, rhsValue);
            type = customNumberResolver.getRawNumberType();
            lhsValue = customNumberResolver.getLhsValue();
            rhsValue = customNumberResolver.getRhsValue();
            customNumberBase = customNumberResolver.getBase();
        }
        switch (iOperator) {
            case 42: {
                if (type == JavaTypes.BIG_DECIMAL()) {
                    BigDecimal lhsBD = CommonServices.getCoercionManager().makeBigDecimalFrom(lhsValue);
                    BigDecimal rhsBD = CommonServices.getCoercionManager().makeBigDecimalFrom(rhsValue);
                    retValue = lhsBD.multiply(rhsBD);
                    break;
                }
                if (type == JavaTypes.BIG_INTEGER()) {
                    retValue = CommonServices.getCoercionManager().makeBigIntegerFrom(lhsValue).multiply(CommonServices.getCoercionManager().makeBigIntegerFrom(rhsValue));
                    break;
                }
                if (type == JavaTypes.INTEGER() || type == JavaTypes.pINT()) {
                    retValue = CommonServices.getCoercionManager().makeIntegerFrom(lhsValue) * CommonServices.getCoercionManager().makeIntegerFrom(rhsValue);
                    break;
                }
                if (type == JavaTypes.LONG() || type == JavaTypes.pLONG()) {
                    retValue = MultiplicativeExpression.makeLong(CommonServices.getCoercionManager().makeLongFrom(lhsValue) * CommonServices.getCoercionManager().makeLongFrom(rhsValue));
                    break;
                }
                if (type == JavaTypes.DOUBLE() || type == JavaTypes.pDOUBLE()) {
                    retValue = MultiplicativeExpression.makeDoubleValue(MultiplicativeExpression.makeDoubleValue(lhsValue) * MultiplicativeExpression.makeDoubleValue(rhsValue));
                    break;
                }
                if (type == JavaTypes.FLOAT() || type == JavaTypes.pFLOAT()) {
                    retValue = Float.valueOf(MultiplicativeExpression.makeFloatValue(Float.valueOf(MultiplicativeExpression.makeFloatValue(lhsValue) * MultiplicativeExpression.makeFloatValue(rhsValue))));
                    break;
                }
                if (type == JavaTypes.SHORT() || type == JavaTypes.pSHORT()) {
                    retValue = Integer.valueOf(CommonServices.getCoercionManager().makeIntegerFrom(lhsValue) * CommonServices.getCoercionManager().makeIntegerFrom(rhsValue)).shortValue();
                    break;
                }
                if (type == JavaTypes.BYTE() || type == JavaTypes.pBYTE()) {
                    retValue = (byte)(CommonServices.getCoercionManager().makeIntegerFrom(lhsValue) * CommonServices.getCoercionManager().makeIntegerFrom(rhsValue));
                    break;
                }
                throw new UnsupportedNumberTypeException(type);
            }
            case 47: {
                if (type == JavaTypes.BIG_DECIMAL()) {
                    BigDecimal lhsBD = CommonServices.getCoercionManager().makeBigDecimalFrom(lhsValue);
                    BigDecimal rhsBD = CommonServices.getCoercionManager().makeBigDecimalFrom(rhsValue);
                    retValue = lhsBD.divide(rhsBD, MathContext.DECIMAL128);
                    break;
                }
                if (type == JavaTypes.BIG_INTEGER()) {
                    retValue = CommonServices.getCoercionManager().makeBigIntegerFrom(lhsValue).divide(CommonServices.getCoercionManager().makeBigIntegerFrom(rhsValue));
                    break;
                }
                if (type == JavaTypes.INTEGER() || type == JavaTypes.pINT()) {
                    retValue = CommonServices.getCoercionManager().makeIntegerFrom(lhsValue) / CommonServices.getCoercionManager().makeIntegerFrom(rhsValue);
                    break;
                }
                if (type == JavaTypes.LONG() || type == JavaTypes.pLONG()) {
                    retValue = MultiplicativeExpression.makeLong(CommonServices.getCoercionManager().makeLongFrom(lhsValue) / CommonServices.getCoercionManager().makeLongFrom(rhsValue));
                    break;
                }
                if (type == JavaTypes.DOUBLE() || type == JavaTypes.pDOUBLE()) {
                    retValue = MultiplicativeExpression.makeDoubleValue(MultiplicativeExpression.makeDoubleValue(lhsValue) / MultiplicativeExpression.makeDoubleValue(rhsValue));
                    break;
                }
                if (type == JavaTypes.FLOAT() || type == JavaTypes.pFLOAT()) {
                    retValue = Float.valueOf(MultiplicativeExpression.makeFloatValue(Float.valueOf(MultiplicativeExpression.makeFloatValue(lhsValue) / MultiplicativeExpression.makeFloatValue(rhsValue))));
                    break;
                }
                if (type == JavaTypes.SHORT() || type == JavaTypes.pSHORT()) {
                    retValue = Integer.valueOf(CommonServices.getCoercionManager().makeIntegerFrom(lhsValue) / CommonServices.getCoercionManager().makeIntegerFrom(rhsValue)).shortValue();
                    break;
                }
                if (type == JavaTypes.BYTE() || type == JavaTypes.pBYTE()) {
                    retValue = (byte)(CommonServices.getCoercionManager().makeIntegerFrom(lhsValue) / CommonServices.getCoercionManager().makeIntegerFrom(rhsValue));
                    break;
                }
                throw new UnsupportedNumberTypeException(type);
            }
            case 37: {
                if (type == JavaTypes.BIG_DECIMAL()) {
                    BigDecimal lhsBD = CommonServices.getCoercionManager().makeBigDecimalFrom(lhsValue);
                    BigDecimal rhsBD = CommonServices.getCoercionManager().makeBigDecimalFrom(rhsValue);
                    BigDecimal result = lhsBD.remainder(rhsBD, MathContext.DECIMAL128);
                    retValue = result.abs();
                    break;
                }
                if (type == JavaTypes.BIG_INTEGER()) {
                    retValue = CommonServices.getCoercionManager().makeBigIntegerFrom(lhsValue).mod(CommonServices.getCoercionManager().makeBigIntegerFrom(rhsValue));
                    break;
                }
                if (type == JavaTypes.INTEGER() || type == JavaTypes.pINT()) {
                    retValue = CommonServices.getCoercionManager().makeIntegerFrom(lhsValue) % CommonServices.getCoercionManager().makeIntegerFrom(rhsValue);
                    break;
                }
                if (type == JavaTypes.LONG() || type == JavaTypes.pLONG()) {
                    retValue = MultiplicativeExpression.makeLong(CommonServices.getCoercionManager().makeLongFrom(lhsValue) % CommonServices.getCoercionManager().makeLongFrom(rhsValue));
                    break;
                }
                if (type == JavaTypes.DOUBLE() || type == JavaTypes.pDOUBLE()) {
                    retValue = MultiplicativeExpression.makeDoubleValue(MultiplicativeExpression.makeDoubleValue(lhsValue) % MultiplicativeExpression.makeDoubleValue(rhsValue));
                    break;
                }
                if (type == JavaTypes.FLOAT() || type == JavaTypes.pFLOAT()) {
                    retValue = Float.valueOf(MultiplicativeExpression.makeFloatValue(Float.valueOf(MultiplicativeExpression.makeFloatValue(lhsValue) % MultiplicativeExpression.makeFloatValue(rhsValue))));
                    break;
                }
                if (type == JavaTypes.SHORT() || type == JavaTypes.pSHORT()) {
                    retValue = Integer.valueOf(CommonServices.getCoercionManager().makeIntegerFrom(lhsValue) % CommonServices.getCoercionManager().makeIntegerFrom(rhsValue)).shortValue();
                    break;
                }
                if (type == JavaTypes.BYTE() || type == JavaTypes.pBYTE()) {
                    retValue = (byte)(CommonServices.getCoercionManager().makeIntegerFrom(lhsValue) % CommonServices.getCoercionManager().makeIntegerFrom(rhsValue));
                    break;
                }
                throw new UnsupportedNumberTypeException(type);
            }
            default: {
                retValue = null;
            }
        }
        if (retValue != null && customNumberBase != null) {
            retValue = customNumberBase.fromNumber((Number)retValue);
        }
        return retValue;
    }
}

