/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.java.classinfo;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.tools.javac.tree.JCTree;
import gw.internal.gosu.parser.java.classinfo.IModifierList;
import gw.internal.gosu.parser.java.classinfo.JavaSourceAnnotationInfo;
import gw.internal.gosu.parser.java.classinfo.JavaSourceEnumConstant;
import gw.internal.gosu.parser.java.classinfo.JavaSourceField;
import gw.internal.gosu.parser.java.classinfo.JavaSourceInterface;
import gw.internal.gosu.parser.java.classinfo.JavaSourceMethod;
import gw.internal.gosu.parser.java.classinfo.JavaSourceType;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.java.IJavaAnnotatedElement;
import gw.lang.reflect.java.IJavaClassInfo;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Modifier;

public class JavaSourceModifierList
implements IModifierList {
    private static final JavaSourceAnnotationInfo[] NONE = new JavaSourceAnnotationInfo[0];
    private ModifiersTree _modifiersTree;
    private int _modifiers;
    private IJavaAnnotatedElement _owner;
    private JavaSourceAnnotationInfo[] _annotations;

    public JavaSourceModifierList(JavaSourceEnumConstant owner, ModifiersTree modifiersTree, int modifiers) {
        this._owner = owner;
        this._modifiers = modifiers;
        this._modifiersTree = modifiersTree;
    }

    public JavaSourceModifierList(IJavaAnnotatedElement owner, ModifiersTree modifiersTree) {
        IJavaClassInfo declaringOwner;
        this._owner = owner;
        this._modifiersTree = modifiersTree;
        this._modifiers = (int)((JCTree.JCModifiers)this._modifiersTree).flags;
        IJavaClassInfo iJavaClassInfo = declaringOwner = owner instanceof JavaSourceType ? (IJavaClassInfo)owner : owner.getEnclosingClass();
        if (declaringOwner.isInterface() || declaringOwner.isAnnotation()) {
            if (!modifiersTree.getFlags().contains((Object)Modifier.DEFAULT) && !modifiersTree.getFlags().contains((Object)Modifier.STATIC)) {
                this._modifiers |= 0x400;
            }
            if (owner instanceof JavaSourceField) {
                this._modifiers |= 8;
            }
            if (owner instanceof JavaSourceField || owner instanceof JavaSourceMethod) {
                this._modifiers |= 1;
            }
        }
        if (owner instanceof JavaSourceType && declaringOwner.getEnclosingClass() instanceof JavaSourceInterface) {
            this._modifiers |= 1;
            this._modifiers |= 8;
        }
        if (!(declaringOwner.getEnclosingClass() != null || this.hasModifier(1) || this.hasModifier(4) || this.hasModifier(2))) {
            this._modifiers |= 0x80000;
        }
    }

    @Override
    public boolean hasModifier(int modifierType) {
        return (this._modifiers & modifierType) != 0;
    }

    @Override
    public int getModifiers() {
        return this._modifiers;
    }

    private void maybeInitAnnotations() {
        if (this._annotations == null) {
            List<? extends AnnotationTree> annotationsTrees = this._modifiersTree.getAnnotations();
            if (annotationsTrees.isEmpty()) {
                this._annotations = NONE;
            } else {
                ArrayList<JavaSourceAnnotationInfo> annotations = new ArrayList<JavaSourceAnnotationInfo>();
                for (AnnotationTree annotationTree : annotationsTrees) {
                    annotations.add(new JavaSourceAnnotationInfo(annotationTree, this._owner));
                }
                this._annotations = annotations.toArray(new JavaSourceAnnotationInfo[annotations.size()]);
            }
        }
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getAnnotation(annotationClass) != null;
    }

    @Override
    public IAnnotationInfo[] getAnnotations() {
        this.maybeInitAnnotations();
        return this._annotations;
    }

    @Override
    public IAnnotationInfo getAnnotation(Class annotationClass) {
        this.maybeInitAnnotations();
        for (JavaSourceAnnotationInfo annotation : this._annotations) {
            if (!annotation.getName().equals(annotationClass.getName().replace('$', '.'))) continue;
            return annotation;
        }
        return null;
    }

    public void setModifiers(int modifiers) {
        this._modifiers = modifiers;
    }

    public String toString() {
        return this._owner.toString();
    }
}

