/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.statements;

import gw.internal.gosu.parser.statements.SwitchStatement;
import gw.internal.gosu.parser.statements.VarInitializationVerifier;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.IStatement;
import gw.lang.parser.expressions.IIdentifierExpression;
import gw.lang.parser.statements.ICatchClause;
import gw.lang.parser.statements.IIfStatement;
import gw.lang.parser.statements.ILoopStatement;
import gw.lang.parser.statements.ITerminalStatement;
import gw.lang.parser.statements.ITryCatchFinallyStatement;
import java.util.List;

class AssignmentOrReference {
    private IParsedElement _stmt;
    private ITerminalStatement _terminal;
    private VarInitializationVerifier.AssignedState _localState;
    private boolean _bBad;
    private boolean _bInLoop;
    private boolean _bReference;

    AssignmentOrReference(IStatement stmt, List<AssignmentOrReference> assignments, VarInitializationVerifier.AssignedState localState) {
        this._stmt = stmt;
        this._localState = localState;
        this.determineBad(assignments, false);
    }

    AssignmentOrReference(IIdentifierExpression idExpr, List<AssignmentOrReference> assignments, VarInitializationVerifier.AssignedState localState) {
        this._stmt = idExpr;
        this._bReference = true;
        this._localState = localState;
        this.determineBad(assignments, false);
    }

    IParsedElement getStmt() {
        return this._stmt;
    }

    ITerminalStatement getTerminal() {
        return this._terminal;
    }

    void setTerminal(ITerminalStatement terminal) {
        this._terminal = terminal;
    }

    VarInitializationVerifier.AssignedState getLocalState() {
        return this._localState;
    }

    boolean isBad() {
        return this._bBad;
    }

    private void setBad(boolean bBad) {
        this._bBad = bBad;
    }

    boolean isReference() {
        return this._bReference;
    }

    boolean isInLoop() {
        return this._bInLoop;
    }

    void determineBad(List<AssignmentOrReference> assignments, boolean bInLoop) {
        if (this.isBad()) {
            return;
        }
        if (bInLoop && this.isReference()) {
            return;
        }
        block5: for (AssignmentOrReference csr : assignments) {
            if (csr.isReference()) continue;
            if (csr.getTerminal() != null) {
                switch (csr.getTerminal().getTerminalType()) {
                    case ReturnOrThrow: 
                    case ForeverLoop: {
                        continue block5;
                    }
                    case Break: {
                        ITerminalStatement pe;
                        for (pe = csr.getTerminal(); pe != null; pe = pe.getParent()) {
                            if ((pe instanceof ILoopStatement || pe instanceof SwitchStatement) && VarInitializationVerifier.isStatementContainedIn(this.getStmt(), (IParsedElement)pe)) continue block5;
                        }
                        break;
                    }
                    case Continue: {
                        ITerminalStatement pe;
                        for (pe = csr.getTerminal(); pe != null; pe = pe.getParent()) {
                            if (pe instanceof ILoopStatement && VarInitializationVerifier.isStatementContainedIn(this.getStmt(), (IParsedElement)pe)) continue block5;
                        }
                        break;
                    }
                }
            } else if (this.separatedByIfElse(csr.getStmt(), this.getStmt()) || this.separatedByCatchClauses(csr.getStmt(), this.getStmt())) continue;
            this.setBad(true);
            this._bInLoop = bInLoop;
            break;
        }
        if (this.isReference()) {
            this.setBad(!this.isBad() || this.getLocalState() != VarInitializationVerifier.AssignedState.Fully);
        }
    }

    private boolean separatedByIfElse(IParsedElement stmt1, IParsedElement stmt2) {
        return this._separatedByIfElse(stmt1, stmt1, stmt2);
    }

    private boolean _separatedByIfElse(IParsedElement origStmt, IParsedElement stmt1, IParsedElement stmt2) {
        IStatement elseStmt;
        if (stmt1 == null) {
            return false;
        }
        if (stmt1 instanceof IIfStatement && VarInitializationVerifier.isStatementContainedIn(origStmt, (IParsedElement)((IIfStatement)stmt1).getStatement()) && (elseStmt = ((IIfStatement)stmt1).getElseStatement()) != null && VarInitializationVerifier.isStatementContainedIn(stmt2, (IParsedElement)elseStmt)) {
            return true;
        }
        return this._separatedByIfElse(origStmt, stmt1.getParent(), stmt2);
    }

    private boolean separatedByCatchClauses(IParsedElement stmt1, IParsedElement stmt2) {
        IParsedElement parent;
        if (stmt1 == null) {
            return false;
        }
        if (stmt1 instanceof ICatchClause && (parent = stmt1.getParent()) instanceof ITryCatchFinallyStatement) {
            for (ICatchClause catchClause : ((ITryCatchFinallyStatement)parent).getCatchStatements()) {
                if (catchClause == stmt1 || !VarInitializationVerifier.isStatementContainedIn(stmt2, (IParsedElement)catchClause)) continue;
                return true;
            }
        }
        return this.separatedByCatchClauses(stmt1.getParent(), stmt2);
    }
}

