/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.properties;

import gw.internal.gosu.properties.PropertySet;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGosuObject;
import gw.util.GosuClassUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class PropertyNode
implements IGosuObject {
    private final PropertyNode _parent;
    private final String _name;
    private final String _path;
    private final PropertySet _propertySet;
    private final Map<String, PropertyNode> _children = new TreeMap<String, PropertyNode>();

    public static PropertyNode buildTree(PropertySet propertySet) {
        PropertyNode root = new PropertyNode(null, "", propertySet);
        block0: for (String propertyPath : propertySet.getKeys()) {
            PropertyNode currentNode = root;
            for (String pathPart : propertyPath.split("\\.")) {
                PropertyNode childNode = currentNode.getChild(pathPart);
                if (childNode == null) {
                    if (!PropertyNode.isGosuIdentifier(pathPart)) continue block0;
                    childNode = new PropertyNode(currentNode, pathPart, propertySet);
                    currentNode.addChild(childNode);
                }
                currentNode = childNode;
            }
        }
        root.removeUseless();
        return root;
    }

    private PropertyNode(PropertyNode parent, String name, PropertySet propertySet) {
        this._name = name;
        this._parent = parent;
        this._path = parent != null ? PropertyNode.join(parent.getPath(), name) : name;
        this._propertySet = propertySet;
    }

    public String getFullName() {
        return PropertyNode.join(this._propertySet.getName(), this._path);
    }

    public String getRelativeName() {
        return GosuClassUtil.getShortClassName((String)this.getFullName());
    }

    public String getTypeName() {
        return this.isRoot() ? this.getFullName() : this.getFullName();
    }

    public IType getIntrinsicType() {
        return TypeSystem.getByFullName((String)this.getTypeName());
    }

    public boolean hasValue() {
        return this._propertySet.getKeys().contains(this._path);
    }

    public String getValue() {
        return this.hasValue() ? this._propertySet.getValue(this._path) : null;
    }

    public boolean isLeaf() {
        return this._children.isEmpty();
    }

    public boolean isRoot() {
        return this._parent == null;
    }

    public List<PropertyNode> getChildren() {
        return new ArrayList<PropertyNode>(this._children.values());
    }

    public String getChildValue(String name) {
        return this._propertySet.getValue(PropertyNode.join(this._path, name));
    }

    public String toString() {
        return this.hasValue() ? this.getValue() : String.format("Property <%s>", this._path);
    }

    private PropertyNode getChild(String name) {
        return this._children.get(name);
    }

    private void addChild(PropertyNode node) {
        this._children.put(node.getName(), node);
    }

    private boolean isUseless() {
        return this._children.isEmpty() && !this.hasValue();
    }

    private void removeUseless() {
        Set<Map.Entry<String, PropertyNode>> entries = this._children.entrySet();
        Iterator<Map.Entry<String, PropertyNode>> it = entries.iterator();
        while (it.hasNext()) {
            Map.Entry<String, PropertyNode> entry = it.next();
            PropertyNode child = entry.getValue();
            child.removeUseless();
            if (!child.isUseless()) continue;
            it.remove();
        }
    }

    static boolean isGosuIdentifier(String name) {
        boolean result = name.length() > 0 && PropertyNode.isGosuIdentifierStart(name.charAt(0));
        for (int i = 1; i < name.length() && result; ++i) {
            if (PropertyNode.isGosuIdentifierPart(name.charAt(i))) continue;
            result = false;
        }
        return result;
    }

    private static boolean isGosuIdentifierStart(char ch) {
        return Character.isJavaIdentifierStart(ch) && ch != '$';
    }

    private static boolean isGosuIdentifierPart(char ch) {
        return Character.isJavaIdentifierPart(ch) && ch != '$';
    }

    private static String join(String head, String tail) {
        if (head.isEmpty()) {
            return tail;
        }
        if (tail.isEmpty()) {
            return head;
        }
        return head + "." + tail;
    }

    private String getName() {
        return this._name;
    }

    public String getPath() {
        return this._path;
    }

    public PropertyNode getParent() {
        return this._parent;
    }
}

