/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.runtime;

import gw.config.CommonServices;
import gw.internal.gosu.ir.transform.AbstractElementTransformer;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.TypeLord;
import gw.lang.function.IBlock;
import gw.lang.parser.StandardCoercionManager;
import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IExpando;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IPlaceholder;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.ReflectUtil;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.java.JavaTypes;
import gw.util.GosuExceptionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.script.Bindings;

public class GosuRuntimeMethods {
    public static Object getProperty(Object root, IType type, String propertyName) {
        Object ret;
        if (root instanceof Bindings) {
            return ((Bindings)root).get(propertyName);
        }
        if (GosuRuntimeMethods.isDynamic(type)) {
            type = TypeSystem.getFromObject((Object)root);
        }
        if ((ret = GosuRuntimeMethods.invokePropertyGetter("$getProperty", root, type, propertyName)) != IPlaceholder.UNHANDLED) {
            return ret;
        }
        IPropertyInfo propertyInfo = GosuRuntimeMethods.getPropertyInfo(root, type, propertyName);
        if (propertyInfo == null) {
            ret = GosuRuntimeMethods.invokePropertyGetter("$getMissingProperty", root, type, propertyName);
            if (ret == IPlaceholder.UNHANDLED) {
                throw new IllegalArgumentException("No property named " + propertyName + " found on type " + type.getName());
            }
            return ret;
        }
        return propertyInfo.getAccessor().getValue(root);
    }

    private static boolean isDynamic(IType type) {
        return type != null && (type.isDynamic() || type instanceof IGosuClass && ((IGosuClass)type).isStructure());
    }

    private static Object invokePropertyGetter(String dispatchName, Object root, IType type, String propertyName) {
        ITypeInfo typeInfo = type.getTypeInfo();
        IMethodInfo method = typeInfo instanceof IRelativeTypeInfo ? ((IRelativeTypeInfo)typeInfo).getMethod(type, (CharSequence)dispatchName, new IType[]{JavaTypes.STRING()}) : typeInfo.getMethod((CharSequence)dispatchName, new IType[]{JavaTypes.STRING()});
        return method == null ? IPlaceholder.UNHANDLED : method.getCallHandler().handleCall(root, new Object[]{propertyName});
    }

    public static Object getPropertyDynamically(Object rootObject, String propertyName) {
        if (rootObject == null) {
            throw new NullPointerException();
        }
        return GosuRuntimeMethods.getProperty(rootObject, TypeSystem.getFromObject((Object)rootObject), propertyName);
    }

    public static void setProperty(Object root, IType type, String propertyName, Object value) {
        Object ret;
        if (root instanceof Bindings) {
            ((Bindings)root).put(propertyName, value);
            return;
        }
        if (GosuRuntimeMethods.isDynamic(type)) {
            type = TypeSystem.getFromObject((Object)root);
        }
        if ((ret = GosuRuntimeMethods.invokePropertySetter("$setProperty", root, type, propertyName, new Object[0])) != IPlaceholder.UNHANDLED) {
            return;
        }
        IPropertyInfo propertyInfo = GosuRuntimeMethods.getPropertyInfo(root, type, propertyName);
        if (propertyInfo == null) {
            ret = GosuRuntimeMethods.invokePropertySetter("$setMissingProperty", root, type, propertyName, new Object[0]);
            if (ret == IPlaceholder.UNHANDLED) {
                throw new IllegalArgumentException("No property named " + propertyName + " found on type " + type.getName());
            }
            return;
        }
        propertyInfo.getAccessor().setValue(root, value);
    }

    private static Object invokePropertySetter(String dispatchName, Object root, IType type, String propertyName, Object ... args) {
        ITypeInfo typeInfo = type.getTypeInfo();
        IMethodInfo method = typeInfo instanceof IRelativeTypeInfo ? ((IRelativeTypeInfo)typeInfo).getMethod(type, (CharSequence)dispatchName, new IType[]{JavaTypes.STRING(), JavaTypes.OBJECT()}) : typeInfo.getMethod((CharSequence)dispatchName, new IType[]{JavaTypes.STRING(), JavaTypes.OBJECT()});
        return method == null ? IPlaceholder.UNHANDLED : method.getCallHandler().handleCall(root, new Object[]{propertyName, args});
    }

    public static void setPropertyDynamically(Object rootObject, String propertyName, Object value) {
        if (rootObject == null) {
            throw new NullPointerException();
        }
        GosuRuntimeMethods.setProperty(rootObject, TypeSystem.getFromObject((Object)rootObject), propertyName, value);
    }

    private static IPropertyInfo getPropertyInfo(Object rootObject, IType type, String propertyName) {
        IPropertyInfo propertyInfo = ReflectUtil.findProperty((IType)type, (String)propertyName);
        if (propertyInfo == null && (propertyInfo = ReflectUtil.findProperty((IType)TypeSystem.getFromObject((Object)rootObject), (String)propertyName)) == null) {
            return null;
        }
        return propertyInfo;
    }

    public static Object initMultiArray(IType componentType, Object instance, int iDimension, int[] sizes) {
        if (sizes.length <= iDimension - 1) {
            return instance;
        }
        int iLength = componentType.getArrayLength(instance);
        componentType = componentType.getComponentType();
        for (int i = 0; i < iLength; ++i) {
            Object component = componentType.makeArrayInstance(sizes[iDimension - 1]);
            GosuRuntimeMethods.initMultiArray(componentType, component, iDimension + 1, sizes);
            componentType.setArrayComponent(instance, i, component);
        }
        return instance;
    }

    public static IType getType(Object obj) {
        return TypeSystem.get(obj.getClass());
    }

    public static Object newInstance(IType type, Object ctx, Object[] args) {
        ITypeInfo typeInfo = type.getTypeInfo();
        IType[] runtimeTypes = ReflectUtil.extractRuntimeTypes((Object[])args);
        IConstructorInfo method = typeInfo.getCallableConstructor(runtimeTypes);
        args = ReflectUtil.coerceArgsIfNecessary((IParameterInfo[])method.getParameters(), (Object[])args);
        args = GosuRuntimeMethods.maybeAddOuter(type, ctx, args);
        return method.getConstructor().newInstance(args);
    }

    private static Object[] maybeAddOuter(IType type, Object ctx, Object[] args) {
        if (ctx == null) {
            return args;
        }
        if (type instanceof IGosuClassInternal && ((IGosuClassInternal)type).isStatic()) {
            return args;
        }
        IType enclosingType = type.getEnclosingType();
        if (enclosingType == null) {
            return args;
        }
        IType outerType = TypeLord.getPureGenericType(TypeSystem.getFromObject((Object)ctx));
        enclosingType = TypeLord.getPureGenericType(enclosingType);
        while (outerType != enclosingType) {
            try {
                Field outerThis = ctx.getClass().getDeclaredField("this$0");
                outerThis.setAccessible(true);
                ctx = outerThis.get(ctx);
            }
            catch (Exception e) {
                return args;
            }
            outerType = TypeLord.getPureGenericType(TypeSystem.getFromObject((Object)ctx));
        }
        Object[] args2 = new Object[args.length + 1];
        args2[0] = ctx;
        System.arraycopy(args, 0, args2, 1, args.length);
        return args2;
    }

    public static Object invokeMethod(Class c, String methodName, Class[] argTypes, Object root, Object[] args) {
        Method declaredMethod = AbstractElementTransformer.getDeclaredMethod(c, methodName, argTypes);
        try {
            return declaredMethod.invoke(root, args);
        }
        catch (IllegalAccessException e) {
            throw GosuExceptionUtil.forceThrow((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw GosuExceptionUtil.forceThrow((Throwable)e.getTargetException());
        }
    }

    public static Object invokeMethodInfo(IType type, String methodName, IType[] parameterTypes, Object root, Object[] args) {
        IMethodInfo method;
        Object ret;
        Object ret2;
        if (root instanceof IExpando && (ret2 = ((IExpando)root).invoke(methodName, args)) != IPlaceholder.UNHANDLED) {
            return ret2;
        }
        if (root instanceof Bindings && (ret2 = GosuRuntimeMethods.invoke(((Bindings)root).get(methodName), args)) != IPlaceholder.UNHANDLED) {
            return ret2;
        }
        boolean bDynamicType = GosuRuntimeMethods.isDynamic(type);
        if (bDynamicType) {
            type = TypeSystem.getFromObject((Object)root);
        }
        if ((ret = GosuRuntimeMethods.invokeMethodInvoker("$invokeMethod", root, type, methodName, args)) != IPlaceholder.UNHANDLED) {
            return ret;
        }
        ITypeInfo typeInfo = type.getTypeInfo();
        if (bDynamicType) {
            IType[] runtimeTypes = ReflectUtil.extractRuntimeTypes((Object[])args);
            method = ReflectUtil.findCallableMethod((String)methodName, (IType[])runtimeTypes, (IType)type);
        } else {
            parameterTypes = GosuRuntimeMethods.replaceDynamicTypesWithRuntimeTypes(parameterTypes, args);
            method = typeInfo instanceof IRelativeTypeInfo ? ((IRelativeTypeInfo)typeInfo).getMethod(type, (CharSequence)methodName, parameterTypes) : typeInfo.getMethod((CharSequence)methodName, parameterTypes);
        }
        if (method == null) {
            ret = GosuRuntimeMethods.invokeMethodInvoker("$invokeMissingMethod", root, type, methodName, args);
            if (ret == IPlaceholder.UNHANDLED) {
                throw new IllegalStateException("Could not find method for " + methodName + " on " + type.getName() + " with specified param types");
            }
            return ret;
        }
        if (bDynamicType) {
            args = ReflectUtil.coerceArgsIfNecessary((IParameterInfo[])method.getParameters(), (Object[])args);
        }
        return method.getCallHandler().handleCall(root, args);
    }

    private static Object invoke(Object o, Object[] args) {
        if (o instanceof IBlock) {
            return ((IBlock)o).invokeWithArgs(args);
        }
        return IPlaceholder.UNHANDLED;
    }

    private static IType[] replaceDynamicTypesWithRuntimeTypes(IType[] parameterTypes, Object[] args) {
        if (parameterTypes == null) {
            return null;
        }
        IType[] ret = null;
        for (int i = 0; i < parameterTypes.length; ++i) {
            IType type = parameterTypes[i];
            if (!(type instanceof IPlaceholder) || !((IPlaceholder)type).isPlaceholder()) continue;
            if (ret == null) {
                ret = new IType[parameterTypes.length];
                System.arraycopy(parameterTypes, 0, ret, 0, ret.length);
            }
            ret[i] = args[i] == null ? ret[i] : TypeSystem.getFromObject((Object)args[i]);
        }
        return ret == null ? parameterTypes : ret;
    }

    private static Object invokeMethodInvoker(String dispatchName, Object root, IType type, String methodName, Object ... args) {
        ITypeInfo typeInfo = type.getTypeInfo();
        IMethodInfo method = typeInfo instanceof IRelativeTypeInfo ? ((IRelativeTypeInfo)typeInfo).getMethod(type, (CharSequence)dispatchName, new IType[]{JavaTypes.STRING(), JavaTypes.OBJECT().getArrayType()}) : typeInfo.getMethod((CharSequence)dispatchName, new IType[]{JavaTypes.STRING(), JavaTypes.OBJECT().getArrayType()});
        return method == null ? IPlaceholder.UNHANDLED : method.getCallHandler().handleCall(root, new Object[]{methodName, args});
    }

    public static Class lookUpClass(String className) {
        if (className.startsWith("L") && className.endsWith(";")) {
            className = className.substring(1, className.length() - 1);
        }
        className = className.replaceAll("/", ".");
        try {
            return Class.forName(className, false, GosuRuntimeMethods.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw GosuExceptionUtil.forceThrow((Throwable)e);
        }
    }

    public static void invokeLockMethod(Object o) {
        IMethodInfo iMethodInfo;
        if (o != null && (iMethodInfo = TypeSystem.getFromObject((Object)o).getTypeInfo().getMethod((CharSequence)"lock", new IType[0])) != null) {
            iMethodInfo.getCallHandler().handleCall(o, new Object[0]);
        }
    }

    public static IType typeof(Object o) {
        IType type = TypeSystem.getFromObject((Object)o);
        if (type instanceof IJavaType && type.isGenericType()) {
            type = TypeLord.getDefaultParameterizedType(type);
        }
        return type;
    }

    public static boolean logicalNot(Object o) {
        if (o instanceof Boolean) {
            return (Boolean)o == false;
        }
        return !CommonServices.getCoercionManager().makePrimitiveBooleanFrom(o);
    }

    public static void invokeUnlockOrDisposeOrCloseMethod(Object o) {
        if (o != null) {
            ITypeInfo ti = TypeSystem.getFromObject((Object)o).getTypeInfo();
            IMethodInfo mi = ti.getMethod((CharSequence)"unlock", new IType[0]);
            if (mi != null) {
                mi.getCallHandler().handleCall(o, new Object[0]);
            } else {
                mi = ti.getMethod((CharSequence)"dispose", new IType[0]);
                if (mi != null) {
                    mi.getCallHandler().handleCall(o, new Object[0]);
                } else {
                    mi = ti.getMethod((CharSequence)"close", new IType[0]);
                    if (mi != null) {
                        mi.getCallHandler().handleCall(o, new Object[0]);
                    }
                }
            }
        }
    }

    public static boolean isStructurallyAssignable(IType toType, IType fromType) {
        if (toType == null || fromType == null) {
            return false;
        }
        if (toType.isAssignableFrom(fromType)) {
            return true;
        }
        return StandardCoercionManager.isStructurallyAssignable((IType)toType, (IType)fromType);
    }

    public static void print(Object obj) {
        System.out.println(GosuRuntimeMethods.toString(obj));
    }

    public static String toString(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof Byte) {
            int value = ((Byte)obj).byteValue();
            if (value < 0) {
                value = 256 + value;
            }
            return "0x" + Integer.toHexString(value);
        }
        IType type = TypeSystem.getFromObject((Object)obj);
        if (type.isArray()) {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            int arrayLength = type.getArrayLength(obj);
            for (int idx = 0; idx < arrayLength; ++idx) {
                if (idx > 0) {
                    sb.append(", ");
                }
                sb.append(GosuRuntimeMethods.toString(type.getArrayComponent(obj, idx)));
            }
            sb.append(']');
            return sb.toString();
        }
        return obj.toString();
    }

    public static void error(Object strError) {
        System.out.println(strError);
        throw new Error(String.valueOf(strError));
    }
}

