/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.template;

import gw.internal.gosu.parser.CompiledGosuClassSymbolTable;
import gw.internal.gosu.parser.Symbol;
import gw.internal.gosu.template.TemplateGenerator;
import gw.lang.parser.ISymbol;
import gw.lang.parser.ISymbolTable;
import gw.lang.parser.template.ITemplateGenerator;
import gw.lang.parser.template.ITemplateHost;
import gw.lang.reflect.TypeSystem;
import java.io.Reader;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;

public class SimpleTemplateHost
implements ITemplateHost {
    private static final ThreadLocal g_symTableCtx = new ThreadLocal();

    private static ISymbolTable getSymTableCtx() {
        List list = (List)g_symTableCtx.get();
        if (list != null && list.size() > 0) {
            return (ISymbolTable)list.get(0);
        }
        return null;
    }

    private static void pushSymTableCtx(ISymbolTable ctx) {
        LinkedList<ISymbolTable> list = (LinkedList<ISymbolTable>)g_symTableCtx.get();
        if (list == null) {
            list = new LinkedList<ISymbolTable>();
            g_symTableCtx.set(list);
        }
        list.add(0, ctx);
    }

    private static void popSymTableCtx() {
        List list = (List)g_symTableCtx.get();
        list.remove(0);
    }

    public void executeTemplate(Reader readerTemplate, Writer writerOut) {
        this.executeTemplate(readerTemplate, writerOut, false);
    }

    public void executeTemplate(Reader readerTemplate, Writer writerOut, boolean strict) {
        try {
            TemplateGenerator.generateTemplate(readerTemplate, writerOut, SimpleTemplateHost.getThreadLocalSymbolTable(), strict);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void executeTemplate(ITemplateGenerator precompiledTemplate, Writer writerOut) {
        SimpleTemplateHost.pushSymTableCtx(this.getSymbolTable());
        try {
            precompiledTemplate.execute(writerOut, SimpleTemplateHost.getThreadLocalSymbolTable());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            SimpleTemplateHost.popSymTableCtx();
        }
    }

    public TemplateGenerator getTemplate(Reader readerTemplate) {
        try {
            return TemplateGenerator.getTemplate(readerTemplate);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public TemplateGenerator getTemplate(Reader readerTemplate, String strFqn) {
        try {
            return TemplateGenerator.getTemplate(readerTemplate, strFqn);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void pushScope() {
        SimpleTemplateHost.getThreadLocalSymbolTable().pushScope();
    }

    public synchronized void popScope() {
        SimpleTemplateHost.getThreadLocalSymbolTable().popScope();
    }

    public synchronized void putSymbol(String strName, Class type, Object value) {
        Class<?> typeValue;
        if (value != null && !type.isAssignableFrom(typeValue = value.getClass()) && !typeValue.isAssignableFrom(type)) {
            throw new IllegalArgumentException(type.getName() + " is not compatible with " + typeValue.getName());
        }
        Symbol root = new Symbol(strName, TypeSystem.get((Class)type), value);
        SimpleTemplateHost.getThreadLocalSymbolTable().putSymbol((ISymbol)root);
    }

    public synchronized void putSymbol(ISymbol symbol) {
        SimpleTemplateHost.getThreadLocalSymbolTable().putSymbol(symbol);
    }

    public synchronized void removeSymbol(String strName) {
        SimpleTemplateHost.getThreadLocalSymbolTable().removeSymbol((CharSequence)strName);
    }

    public ISymbolTable getSymbolTable() {
        return SimpleTemplateHost.getThreadLocalSymbolTable();
    }

    private static ISymbolTable getThreadLocalSymbolTable() {
        return CompiledGosuClassSymbolTable.instance();
    }
}

