/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.module;

import gw.config.CommonServices;
import gw.fs.IDirectory;
import gw.fs.jar.JarFileDirectoryImpl;
import gw.internal.gosu.dynamic.DynamicTypeLoader;
import gw.internal.gosu.parser.DefaultTypeLoader;
import gw.internal.gosu.parser.FileSystemGosuClassRepository;
import gw.internal.gosu.parser.IModuleClassLoader;
import gw.internal.gosu.parser.ModuleClassLoader;
import gw.internal.gosu.parser.ModuleTypeLoader;
import gw.internal.gosu.properties.PropertiesTypeLoader;
import gw.lang.parser.ILanguageLevel;
import gw.lang.reflect.ITypeLoader;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.TypeSystemShutdownListener;
import gw.lang.reflect.gs.GosuClassTypeLoader;
import gw.lang.reflect.gs.IFileSystemGosuClassRepository;
import gw.lang.reflect.gs.IGosuClassRepository;
import gw.lang.reflect.module.Dependency;
import gw.lang.reflect.module.IExecutionEnvironment;
import gw.lang.reflect.module.IModule;
import gw.lang.reflect.module.INativeModule;
import gw.util.Extensions;
import gw.util.GosuExceptionUtil;
import gw.util.concurrent.LocklessLazyVar;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class Module
implements IModule {
    private final IExecutionEnvironment _execEnv;
    private String _strName;
    private List<Dependency> _dependencies = new ArrayList<Dependency>();
    private LocklessLazyVar<IModule[]> _traversalList = new LocklessLazyVar<IModule[]>(){

        protected IModule[] init() {
            return Module.this.buildTraversalList();
        }
    };
    private ModuleTypeLoader _modTypeLoader;
    protected List<IDirectory> _classpath = new ArrayList<IDirectory>();
    private INativeModule _nativeModule;
    private ClassLoader _moduleClassLoader;
    private ClassLoader _extensionsClassLoader;
    private final IFileSystemGosuClassRepository _fileRepository = new FileSystemGosuClassRepository(this);

    public Module(IExecutionEnvironment execEnv, String strName) {
        this._execEnv = execEnv;
        this._strName = strName;
    }

    public final IExecutionEnvironment getExecutionEnvironment() {
        return this._execEnv;
    }

    public IFileSystemGosuClassRepository getFileRepository() {
        return this._fileRepository;
    }

    public void setDependencies(List<Dependency> newDeps) {
        this._dependencies = new ArrayList<Dependency>(newDeps);
        this._traversalList.clear();
    }

    public List<Dependency> getDependencies() {
        return this._dependencies;
    }

    public void addDependency(Dependency d) {
        this._dependencies.add(d);
        this._traversalList.clear();
    }

    public void removeDependency(Dependency d) {
        this._dependencies.remove(d);
        this._traversalList.clear();
    }

    public List<IDirectory> getSourcePath() {
        return Arrays.asList(this._fileRepository.getSourcePath());
    }

    public void setSourcePath(List<IDirectory> sourcePaths) {
        ArrayList<IDirectory> sources = new ArrayList<IDirectory>(sourcePaths);
        sources.addAll(this.getAdditionalSourceRoots());
        this._fileRepository.setSourcePath(sources.toArray(new IDirectory[sourcePaths.size()]));
    }

    public List<IDirectory> getExcludedPaths() {
        return Arrays.asList(this._fileRepository.getExcludedPath());
    }

    public void setExcludedPaths(List<IDirectory> paths) {
        this._fileRepository.setExcludedPath(paths.toArray(new IDirectory[paths.size()]));
    }

    public ClassLoader getModuleClassLoader() {
        if (this._moduleClassLoader == null) {
            this._moduleClassLoader = ModuleClassLoader.create(this);
        }
        return this._moduleClassLoader;
    }

    public void disposeLoader() {
        if (this._moduleClassLoader instanceof IModuleClassLoader) {
            ((IModuleClassLoader)this._moduleClassLoader).dispose();
        }
        this._moduleClassLoader = null;
    }

    private static void scanPaths(List<IDirectory> paths, Set<String> extensions, List<IDirectory> roots) {
        extensions.add(".java");
        extensions.add(".xsd");
        extensions.addAll(Arrays.asList(GosuClassTypeLoader.ALL_EXTS));
        for (IDirectory root : paths) {
            if (Extensions.containsManifest((IDirectory)root) && Extensions.getExtensions((IDirectory)root, (String)"Contains-Sources").isEmpty() && !root.getName().equals("_wl_cls_gen.jar")) continue;
            roots.add(root);
        }
    }

    public IDirectory getOutputPath() {
        return this._nativeModule.getOutputPath();
    }

    public ModuleTypeLoader getModuleTypeLoader() {
        return this._modTypeLoader;
    }

    public void setModuleTypeLoader(ModuleTypeLoader modTypeLoader) {
        this._modTypeLoader = modTypeLoader;
    }

    public void configurePaths(List<IDirectory> classpath, List<IDirectory> sourcePaths) {
        classpath = this.addFromManifestClassPath(classpath);
        sourcePaths = this.addFromManifestClassPath(sourcePaths);
        ArrayList<IDirectory> sourceRoots = new ArrayList<IDirectory>(sourcePaths);
        HashSet<String> extensions = new HashSet<String>();
        Module.scanPaths(classpath, extensions, sourceRoots);
        this.setSourcePath(sourceRoots);
        this.setJavaClassPath(classpath);
    }

    private List<IDirectory> addFromManifestClassPath(List<IDirectory> classpath) {
        if (classpath == null) {
            return classpath;
        }
        ArrayList<IDirectory> newClasspath = new ArrayList<IDirectory>();
        for (IDirectory root : classpath) {
            newClasspath.add(root);
            if (!(root instanceof JarFileDirectoryImpl)) continue;
            JarFile jarFile = ((JarFileDirectoryImpl)root).getJarFile();
            try {
                Attributes man;
                String paths;
                Manifest manifest = jarFile.getManifest();
                if (manifest == null || (paths = (man = manifest.getMainAttributes()).getValue(Attributes.Name.CLASS_PATH)) == null || paths.isEmpty()) continue;
                for (String j : paths.split(" ")) {
                    URL url;
                    try {
                        url = new URL(j);
                    }
                    catch (MalformedURLException e) {
                        continue;
                    }
                    File dirOrJar = new File(url.toURI());
                    IDirectory idir = CommonServices.getFileSystem().getIDirectory(dirOrJar);
                    newClasspath.add(idir);
                }
            }
            catch (Exception e) {
                throw GosuExceptionUtil.forceThrow((Throwable)e);
            }
        }
        return newClasspath;
    }

    public List<IDirectory> getJavaClassPath() {
        return this._classpath;
    }

    public void setJavaClassPath(List<IDirectory> classpath) {
        this._classpath = classpath;
    }

    public String toString() {
        return this._strName;
    }

    public Object getNativeModule() {
        return this._nativeModule != null ? this._nativeModule.getNativeModule() : null;
    }

    public void setNativeModule(INativeModule nativeModule) {
        this._nativeModule = nativeModule;
    }

    public void initializeTypeLoaders() {
        this.maybeCreateModuleTypeLoader();
        this.createStandardTypeLoaders();
        if (CommonServices.getEntityAccess().getLanguageLevel().isStandard()) {
            this.createExtensionTypeLoaders();
        }
        List<ITypeLoader> loaders = this.getModuleTypeLoader().getTypeLoaders();
        for (int i = loaders.size() - 1; i >= 0; --i) {
            loaders.get(i).init();
        }
    }

    protected void createExtensionTypeLoaders() {
        this.createExtensionTypeloadersImpl();
    }

    protected void createExtensionTypeloadersImpl() {
        Set<String> typeLoaders = this.getExtensionTypeloaderNames();
        for (String additionalTypeLoader : typeLoaders) {
            try {
                this.createAndPushTypeLoader(this._fileRepository, additionalTypeLoader);
            }
            catch (Throwable e) {
                System.err.println("==> WARNING: Cannot create extension typeloader " + additionalTypeLoader + ". " + e.getMessage());
                System.err.println("==> END WARNING.");
            }
        }
    }

    private Set<String> getExtensionTypeloaderNames() {
        HashSet<String> set = new HashSet<String>();
        for (IModule m : this.getModuleTraversalList()) {
            for (IDirectory dir : m.getJavaClassPath()) {
                Extensions.getExtensions(set, (IDirectory)dir, (String)"Gosu-Typeloaders");
            }
        }
        return set;
    }

    protected void createStandardTypeLoaders() {
        CommonServices.getTypeSystem().pushTypeLoader((IModule)this, (ITypeLoader)new GosuClassTypeLoader((IModule)this, (IGosuClassRepository)this._fileRepository));
        if (ILanguageLevel.Util.STANDARD_GOSU()) {
            CommonServices.getTypeSystem().pushTypeLoader((IModule)this, (ITypeLoader)new PropertiesTypeLoader(this));
        }
        if (ILanguageLevel.Util.DYNAMIC_TYPE()) {
            CommonServices.getTypeSystem().pushTypeLoader((IModule)this, (ITypeLoader)new DynamicTypeLoader(this));
        }
    }

    protected void maybeCreateModuleTypeLoader() {
        if (this.getModuleTypeLoader() == null) {
            ModuleTypeLoader tla = new ModuleTypeLoader((IModule)this, new DefaultTypeLoader(this));
            this.setModuleTypeLoader(tla);
        }
    }

    public final IModule[] getModuleTraversalList() {
        return (IModule[])this._traversalList.get();
    }

    private IModule[] buildTraversalList() {
        IModule globalModule;
        ArrayList<IModule> traversalList = new ArrayList<IModule>();
        this.traverse(this, traversalList);
        IModule jreModule = this.getExecutionEnvironment().getJreModule();
        if (traversalList.remove(jreModule)) {
            traversalList.add(jreModule);
        }
        if (this != (globalModule = this.getExecutionEnvironment().getGlobalModule())) {
            traversalList.add(0, globalModule);
        }
        return traversalList.toArray(new IModule[traversalList.size()]);
    }

    protected void traverse(IModule theModule, List<IModule> traversalList) {
        traversalList.add(theModule);
        for (Dependency dependency : theModule.getDependencies()) {
            IModule dependencyModule = dependency.getModule();
            if (traversalList.contains(dependencyModule) || !dependency.isExported() && theModule != this) continue;
            this.traverse(dependencyModule, traversalList);
        }
    }

    public <T extends ITypeLoader> List<? extends T> getTypeLoaders(Class<T> typeLoaderClass) {
        ArrayList<T> results = new ArrayList<T>();
        if (this._modTypeLoader == null) {
            return results;
        }
        for (ITypeLoader loader : this.getModuleTypeLoader().getTypeLoaderStack()) {
            if (!typeLoaderClass.isInstance(loader)) continue;
            results.add(typeLoaderClass.cast(loader));
        }
        return results;
    }

    private ITypeLoader createAndPushTypeLoader(IFileSystemGosuClassRepository classRepository, String className) {
        ITypeLoader typeLoader = null;
        try {
            Class<?> loaderClass = this.getExtensionClassLoader().loadClass(className);
            CommonServices.getGosuInitializationHooks().beforeTypeLoaderCreation(loaderClass);
            Constructor constructor = this.getConstructor(loaderClass, IModule.class);
            if (constructor != null) {
                typeLoader = (ITypeLoader)constructor.newInstance(this);
            } else {
                constructor = this.getConstructor(loaderClass, IModule.class);
                if (constructor != null) {
                    typeLoader = (ITypeLoader)constructor.newInstance(this);
                } else if (constructor != null) {
                    typeLoader = (ITypeLoader)constructor.newInstance(this);
                } else {
                    constructor = this.getConstructor(loaderClass, IGosuClassRepository.class);
                    if (constructor != null) {
                        typeLoader = (ITypeLoader)constructor.newInstance(classRepository);
                    } else {
                        constructor = this.getConstructor(loaderClass, new Class[0]);
                        if (constructor != null) {
                            typeLoader = (ITypeLoader)constructor.newInstance(new Object[0]);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw GosuExceptionUtil.forceThrow((Throwable)e);
        }
        if (typeLoader == null) {
            throw new IllegalStateException("TypeLoader class " + className + " must have one of the following constructor signatures:\n  <init>()\n  <init>(gw.lang.reflect.module.IModule)\n  <init>(gw.lang.reflect.gs.IGosuClassRepository)\n");
        }
        CommonServices.getTypeSystem().pushTypeLoader((IModule)this, typeLoader);
        CommonServices.getGosuInitializationHooks().afterTypeLoaderCreation();
        return typeLoader;
    }

    private ClassLoader getExtensionClassLoader() {
        if (this._extensionsClassLoader == null) {
            this._extensionsClassLoader = ExtensionClassLoader.create(this.getExtensionURLs());
        }
        return this._extensionsClassLoader;
    }

    private URL[] getExtensionURLs() {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (IModule m : this.getModuleTraversalList()) {
            for (IDirectory path : m.getJavaClassPath()) {
                try {
                    urls.add(path.toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private Constructor getConstructor(Class loaderClass, Class ... argTypes) {
        try {
            return loaderClass.getConstructor(argTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof IModule)) {
            return false;
        }
        IModule m = (IModule)o;
        return this.getName().equals(m.getName());
    }

    public int hashCode() {
        return this._strName.hashCode();
    }

    public String getName() {
        return this._strName;
    }

    public void setName(String name) {
        this._strName = name;
    }

    protected List<IDirectory> getAdditionalSourceRoots() {
        return Collections.emptyList();
    }

    private static class ExtensionClassLoader
    extends URLClassLoader {
        private static final LocklessLazyVar<ExtensionClassLoader> INSTANCE = new LocklessLazyVar<ExtensionClassLoader>(){

            protected ExtensionClassLoader init() {
                return new ExtensionClassLoader(ExtensionClassLoader.class.getClassLoader());
            }
        };

        public static ClassLoader create(URL[] urls) {
            ExtensionClassLoader loader = (ExtensionClassLoader)INSTANCE.get();
            for (URL url : urls) {
                loader.addURL(url);
            }
            return loader;
        }

        private ExtensionClassLoader(ClassLoader parent) {
            super(new URL[0], parent);
        }

        static {
            TypeSystem.addShutdownListener((TypeSystemShutdownListener)new TypeSystemShutdownListener(){

                public void shutdown() {
                    INSTANCE.clear();
                }
            });
        }
    }
}

