/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.parser.ParsedElement;
import gw.internal.gosu.parser.expressions.ImplicitTypeAsExpression;
import gw.lang.parser.IExpression;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IExternalSymbolMap;

public abstract class Expression
extends ParsedElement
implements IExpression {
    protected IType _type;

    public IType getType() {
        IType type = this.getTypeImpl();
        if (TypeSystem.isDeleted((IType)type)) {
            type = TypeSystem.getErrorType();
        }
        return type;
    }

    protected IType getTypeImpl() {
        return this._type;
    }

    public void setType(IType type) {
        this._type = type;
    }

    public boolean isNullSafe() {
        return false;
    }

    public boolean isUnchecked() {
        return true;
    }

    public Object evaluate() {
        if (this.getGosuProgram() == null) {
            throw new IllegalStateException("Expression was not compiled to bytecode");
        }
        return this.getGosuProgram().evaluate(null);
    }

    public Object evaluate(IExternalSymbolMap externalSymbols) {
        if (!this.isCompileTimeConstant()) {
            if (this.getGosuProgram() == null) {
                throw new IllegalStateException("Expression was not compiled to bytecode");
            }
            return this.getGosuProgram().evaluate(externalSymbols);
        }
        return this.evaluate();
    }

    public IType getReturnType() {
        return this.getType();
    }

    public IType getContextType() {
        if (this.getParent() instanceof ImplicitTypeAsExpression) {
            return ((Expression)this.getParent()).getType();
        }
        return this.getType();
    }

    public abstract String toString();
}

