/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.expressions;

import gw.internal.gosu.parser.StringCache;
import gw.internal.gosu.parser.expressions.Literal;
import gw.lang.parser.expressions.INumericLiteralExpression;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.TypeSystemShutdownListener;
import gw.lang.reflect.java.JavaTypes;
import gw.util.concurrent.LockingLazyVar;

public final class NumericLiteral
extends Literal
implements INumericLiteralExpression {
    public static final LockingLazyVar<NumericLiteral> NaN = new LockingLazyVar<NumericLiteral>(){

        protected NumericLiteral init() {
            return new NumericLiteral("NaN", Double.NaN, (IType)JavaTypes.pDOUBLE());
        }
    };
    public static final LockingLazyVar<NumericLiteral> INFINITY = new LockingLazyVar<NumericLiteral>(){

        protected NumericLiteral init() {
            return new NumericLiteral("Infinity", Double.POSITIVE_INFINITY, (IType)JavaTypes.pDOUBLE());
        }
    };
    protected Number _value;
    private String _strValue;
    private boolean _explicitlyTyped;

    public NumericLiteral(String strValue, Number value, IType type) {
        this._strValue = StringCache.get((String)strValue);
        this._value = value;
        this.setType(type);
    }

    public Object clone() {
        return this.copy();
    }

    public NumericLiteral copy() {
        return new NumericLiteral(this._strValue, this._value, this.getType());
    }

    public Number getValue() {
        return this._value;
    }

    @Override
    public boolean isCompileTimeConstant() {
        return true;
    }

    @Override
    public Object evaluate() {
        return this.getValue();
    }

    @Override
    public String toString() {
        return String.valueOf(this.getValue());
    }

    public String getStrValue() {
        return this._strValue;
    }

    public void setValue(Number dvalue) {
        this._value = dvalue;
    }

    public void setExplicitlyTyped(boolean b) {
        this._explicitlyTyped = b;
    }

    public boolean isExplicitlyTyped() {
        return this._explicitlyTyped;
    }

    static {
        TypeSystem.addShutdownListener((TypeSystemShutdownListener)new TypeSystemShutdownListener(){

            public void shutdown() {
                INFINITY.clear();
                NaN.clear();
            }
        });
    }
}

