package gw.internal.gosu.parser;

import gw.lang.reflect.java.IJavaPropertyInfo;

/**
 * Base class for extended Java properties.
 * <p/>
 * NOTE: The structure of this class is tightly coupled to the generation of bytecode in {@link JavaTypeExtensions}.
 * Please do not change it without understanding the associated changes that may be required in the generated bytecode.
 *
 * @see JavaTypeExtensions
 */
public abstract class AbstractExtendedProperty {
  protected final IJavaPropertyInfo _primary;

  protected AbstractExtendedProperty(IJavaPropertyInfo primary) {
    _primary = primary;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    AbstractExtendedProperty that = (AbstractExtendedProperty) o;

    return _primary.getOwnersType().equals(that._primary.getOwnersType()) &&
            _primary.getName().equals(that._primary.getName());

  }

  @Override
  public int hashCode() {
    int result = _primary.getOwnersType().hashCode();
    return 31 * result + _primary.getName().hashCode();
  }

  @Override
  public String toString() {
    return _primary.toString();
  }
}
