/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.compiler.bytecode.expression;

import gw.internal.ext.org.objectweb.asm.MethodVisitor;
import gw.internal.gosu.ir.compiler.bytecode.AbstractBytecodeCompiler;
import gw.internal.gosu.ir.compiler.bytecode.IRBytecodeCompiler;
import gw.internal.gosu.ir.compiler.bytecode.IRBytecodeContext;
import gw.lang.ir.ConditionContext;
import gw.lang.ir.IRElement;
import gw.lang.ir.IRExpression;
import gw.lang.ir.expression.IRNotExpression;
import java.util.List;

public class IRNotExpressionCompiler
extends AbstractBytecodeCompiler {
    public static void compile(IRNotExpression expression, IRBytecodeContext context) {
        MethodVisitor mv = context.getMv();
        if (expression.getType().isBoolean()) {
            IRExpression root = expression.getRoot();
            IRBytecodeCompiler.compileIRElement((IRElement)expression.getRoot(), context);
            ConditionContext condCxt = root.getConditionContext();
            condCxt.setOperator(IRNotExpressionCompiler.negateOpcode(condCxt.getOperator()));
            List tLabels = condCxt.getLabels(true);
            List fLabels = condCxt.getLabels(false);
            condCxt.setTrueLabels(fLabels);
            condCxt.setFalseLabels(tLabels);
            expression.getConditionContext().update(condCxt);
            condCxt.clear();
            if (IRNotExpressionCompiler.isNotPartOfBooleanExpr((IRExpression)expression)) {
                IRNotExpressionCompiler.compileConditionAssignment((IRExpression)expression, mv);
            }
        } else {
            IRBytecodeCompiler.compileIRElement((IRElement)expression.getRoot(), context);
            if (expression.getType().isInt()) {
                mv.visitInsn(2);
                mv.visitInsn(130);
            } else if (expression.getType().isLong()) {
                mv.visitLdcInsn((Object)-1L);
                mv.visitInsn(131);
            } else {
                throw new IllegalStateException("Cannot compile a not expression that operates on type " + expression.getType().getName());
            }
        }
    }
}

