/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.config.CommonServices;
import gw.internal.gosu.parser.GosuClassCompilingStack;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.IJavaTypeInternal;
import gw.internal.gosu.parser.JavaBaseFeatureInfo;
import gw.internal.gosu.parser.JavaConstructorInfo;
import gw.internal.gosu.parser.JavaFieldPropertyInfo;
import gw.internal.gosu.parser.JavaMethodInfo;
import gw.internal.gosu.parser.JavaTypeInfo;
import gw.internal.gosu.parser.TypeLord;
import gw.internal.gosu.parser.java.classinfo.JavaSourceDefaultValue;
import gw.lang.parser.ISource;
import gw.lang.parser.Keyword;
import gw.lang.reflect.IAnnotatedFeatureInfo;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IAttributedFeatureInfo;
import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.ITypeRef;
import gw.lang.reflect.Modifier;
import gw.lang.reflect.TypeInfoUtil;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.ClassType;
import gw.lang.reflect.gs.GosuClassTypeLoader;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuObject;
import gw.lang.reflect.gs.ISourceFileHandle;
import gw.lang.reflect.gs.StringSourceFileHandle;
import gw.lang.reflect.java.IJavaMethodInfo;
import gw.lang.reflect.java.IJavaPropertyInfo;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.java.JavaTypes;
import gw.lang.reflect.module.IModule;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;

public class GosuClassProxyFactory {
    private static final GosuClassProxyFactory INSTANCE = new GosuClassProxyFactory();

    private GosuClassProxyFactory() {
    }

    public static GosuClassProxyFactory instance() {
        return INSTANCE;
    }

    public IGosuClassInternal create(IType type) {
        if (type instanceof IJavaType) {
            IJavaTypeInternal javaType = (IJavaTypeInternal)type;
            return (IGosuClassInternal)this.createJavaProxy(javaType);
        }
        throw new IllegalArgumentException("No handler for type: " + type.getClass().getName());
    }

    public IGosuClassInternal createImmediately(IType type) {
        if (type.isParameterizedType()) {
            type = type.getGenericType();
        }
        if (type instanceof IJavaType) {
            IJavaTypeInternal javaType = (IJavaTypeInternal)type;
            return (IGosuClassInternal)this.createJavaProxyImmediately(javaType);
        }
        throw new IllegalArgumentException("No handler for type: " + type.getClass().getName());
    }

    private IGosuClass createJavaProxy(IJavaTypeInternal type) {
        IGosuClassInternal gsAdapterClass;
        if (type.isParameterizedType()) {
            type = (IJavaTypeInternal)type.getGenericType();
        }
        if ((gsAdapterClass = type.getAdapterClass()) != null) {
            return gsAdapterClass;
        }
        return this.createJavaProxyImmediately(type);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IGosuClass createJavaProxyImmediately(IJavaTypeInternal type) {
        IGosuClassInternal gsAdapterClass;
        if (type.getEnclosingType() != null) {
            IGosuClass outerProxy = (IGosuClass)TypeSystem.getByFullName((String)GosuClassProxyFactory.getProxyName(TypeLord.getOuterMostEnclosingClass((IType)type)));
            outerProxy.getInnerClasses();
            if (outerProxy.isCompilingDeclarations()) return null;
            gsAdapterClass = this.getAdapterClass(type, outerProxy);
            if (gsAdapterClass == null) {
                TypeSystem.refresh((ITypeRef)((ITypeRef)outerProxy));
                gsAdapterClass = this.getAdapterClass(type, outerProxy);
            }
        } else {
            gsAdapterClass = type.isInterface() ? (IGosuClassInternal)this.createJavaInterfaceProxy(type) : (IGosuClassInternal)this.createJavaClassProxy(type);
        }
        type.setAdapterClass(gsAdapterClass);
        if (gsAdapterClass == null) return gsAdapterClass;
        gsAdapterClass.setJavaType(type);
        return gsAdapterClass;
    }

    private IGosuClassInternal getAdapterClass(IJavaTypeInternal type, IGosuClass outerProxy) {
        IGosuClassInternal gsAdapterClass;
        String proxyName = GosuClassProxyFactory.getProxyName((IType)type);
        int index = outerProxy.getName().length() + 1;
        if (index < 0 || index >= proxyName.length()) {
            return null;
        }
        String[] dotPath = proxyName.substring(index).split("\\.");
        int i = 0;
        for (gsAdapterClass = (IGosuClassInternal)outerProxy; i < dotPath.length && gsAdapterClass != null; gsAdapterClass = (IGosuClassInternal)gsAdapterClass.getInnerClass(dotPath[i]), ++i) {
        }
        return gsAdapterClass;
    }

    private IGosuClass createJavaInterfaceProxy(final IJavaType type) {
        final IModule module = type.getTypeLoader().getModule();
        GosuClassTypeLoader loader = GosuClassTypeLoader.getDefaultClassLoader((IModule)module);
        return loader.makeNewClass((ISourceFileHandle)new LazyStringSourceFileHandle((IType)type, new Callable<StringBuilder>(){

            @Override
            public StringBuilder call() {
                TypeSystem.pushModule((IModule)module);
                try {
                    StringBuilder stringBuilder = GosuClassProxyFactory.this.genJavaInterfaceProxy(type);
                    return stringBuilder;
                }
                finally {
                    TypeSystem.popModule((IModule)module);
                }
            }
        }));
    }

    private IGosuClass createJavaClassProxy(final IJavaType type) {
        String strProxy = "_proxy_." + type.getName();
        IType compilingType = GosuClassCompilingStack.getCompilingType(strProxy);
        if (compilingType != null) {
            return (IGosuClass)compilingType;
        }
        final IModule module = type.getTypeLoader().getModule();
        return GosuClassTypeLoader.getDefaultClassLoader((IModule)module).makeNewClass((ISourceFileHandle)new LazyStringSourceFileHandle((IType)type, new Callable<StringBuilder>(){

            @Override
            public StringBuilder call() {
                TypeSystem.pushModule((IModule)module);
                try {
                    StringBuilder stringBuilder = GosuClassProxyFactory.this.genJavaClassProxy(type);
                    return stringBuilder;
                }
                finally {
                    TypeSystem.popModule((IModule)module);
                }
            }
        }));
    }

    private static String getProxyName(IType type) {
        if (type.isParameterizedType()) {
            type = type.getGenericType();
        }
        return "_proxy_." + type.getName();
    }

    private StringBuilder genJavaClassProxy(IJavaType type) {
        if (type.isParameterizedType()) {
            type = type.getGenericType();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("package ").append("_proxy_").append('.').append(type.getNamespace()).append('\n');
        this.genClassImpl(type, sb);
        return sb;
    }

    private void genClassImpl(IJavaType type, StringBuilder sb) {
        this.addAnnotations((IAnnotatedFeatureInfo)type.getTypeInfo(), sb);
        this.addModifiers(type, sb);
        sb.append("class ").append(this.getRelativeName(type)).append('\n');
        sb.append("{\n");
        if (!(type.getTypeInfo() instanceof JavaTypeInfo)) {
            throw new IllegalArgumentException(type + " is not a recognized Java type");
        }
        JavaTypeInfo ti = (JavaTypeInfo)type.getTypeInfo();
        Iterator iterator = ti.getConstructors((IType)type).iterator();
        while (iterator.hasNext()) {
            IConstructorInfo iConstructorInfo;
            IConstructorInfo ci = iConstructorInfo = iterator.next();
            this.genConstructor(sb, ci);
        }
        for (IConstructorInfo iConstructorInfo : ti.getProperties((IType)type)) {
            IPropertyInfo pi = (IPropertyInfo)iConstructorInfo;
            this.genProperty(pi, sb, type);
        }
        for (Object e : ti.getMethods((IType)type)) {
            IMethodInfo mi = (IMethodInfo)e;
            this.genMethodImpl(sb, mi);
        }
        for (IJavaType iJavaType : type.getInnerClasses()) {
            if (!Modifier.isPublic((int)iJavaType.getModifiers()) && !Modifier.isProtected((int)iJavaType.getModifiers()) && Modifier.isPrivate((int)iJavaType.getModifiers())) continue;
            if (iJavaType.isInterface()) {
                this.genInterfaceImpl(iJavaType, sb);
                continue;
            }
            this.genClassImpl(iJavaType, sb);
        }
        sb.append("}\n");
    }

    private void addModifiers(IJavaType type, StringBuilder sb) {
        if (type.isAbstract()) {
            sb.append("abstract ");
        }
        if (type.getEnclosingType() != null && Modifier.isStatic((int)type.getModifiers())) {
            sb.append("static ");
        }
        if (type.isFinal()) {
            sb.append((CharSequence)Keyword.KW_final).append(" ");
        }
        if (Modifier.isProtected((int)type.getModifiers())) {
            sb.append((CharSequence)Keyword.KW_protected).append(" ");
        } else if (!Modifier.isPrivate((int)type.getModifiers()) && !Modifier.isPublic((int)type.getModifiers())) {
            sb.append((CharSequence)Keyword.KW_internal).append(" ");
        }
    }

    private void addAnnotations(IAnnotatedFeatureInfo featureInfo, StringBuilder sb) {
        for (IAnnotationInfo annotation : featureInfo.getDeclaredAnnotations()) {
            sb.append(GosuClassProxyFactory.makeAnnotationSource(annotation)).append("\n");
        }
    }

    private static String makeAnnotationSource(IAnnotationInfo annotation) {
        if ("ErrorType".equals(annotation.getName())) {
            return "";
        }
        StringBuilder sb = new StringBuilder("@" + annotation.getName() + "(");
        boolean bFirst = true;
        for (IMethodInfo mi : annotation.getType().getTypeInfo().getMethods()) {
            String name;
            if (GosuClassProxyFactory.isObjectMethod(mi) || (name = mi.getDisplayName()).equals("annotationType")) continue;
            String value = GosuClassProxyFactory.makeValueString(annotation.getFieldValue(name), mi.getReturnType());
            if (!bFirst) {
                sb.append(", ");
            }
            sb.append(":").append(name).append("=").append(value);
            bFirst = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public static String makeValueString(Object value, IType returnType) {
        if (value == null) {
            return "null";
        }
        if (value instanceof JavaSourceDefaultValue) {
            return ((JavaSourceDefaultValue)value).getValue();
        }
        if (returnType == JavaTypes.STRING()) {
            return "\"" + value.toString().replace('\n', ' ') + "\"";
        }
        if (returnType.isEnum()) {
            return value.toString();
        }
        if (returnType.isPrimitive()) {
            return String.valueOf(value);
        }
        if (JavaTypes.CLASS().isAssignableFrom(returnType)) {
            if (value instanceof String) {
                return (String)value;
            }
            return ((Class)value).getName();
        }
        if (value instanceof IAnnotationInfo) {
            return GosuClassProxyFactory.makeAnnotationSource((IAnnotationInfo)value);
        }
        boolean isArray = returnType.isArray();
        if (value.getClass().isArray()) {
            assert (isArray);
            StringBuilder arrayValue = new StringBuilder("{");
            for (int i = 0; i < Array.getLength(value); ++i) {
                if (i > 0) {
                    arrayValue.append(", ");
                }
                arrayValue.append(GosuClassProxyFactory.makeValueString(Array.get(value, i), returnType.getComponentType()));
            }
            arrayValue.append("}");
            return arrayValue.toString();
        }
        if (List.class.isAssignableFrom(value.getClass())) {
            assert (isArray);
            List list = (List)value;
            StringBuilder arrayValue = new StringBuilder("{");
            for (int i = 0; i < list.size(); ++i) {
                if (i > 0) {
                    arrayValue.append(", ");
                }
                arrayValue.append(GosuClassProxyFactory.makeValueString(list.get(i), returnType.getComponentType()));
            }
            arrayValue.append("}");
            return arrayValue.toString();
        }
        if (isArray) {
            StringBuilder arrayValue = new StringBuilder("{");
            arrayValue.append(GosuClassProxyFactory.makeValueString(value, returnType.getComponentType()));
            arrayValue.append("}");
            return arrayValue.toString();
        }
        throw new IllegalStateException();
    }

    public static boolean isObjectMethod(IMethodInfo mi) {
        IParameterInfo[] params = mi.getParameters();
        IType[] paramTypes = new IType[params.length];
        for (int i = 0; i < params.length; ++i) {
            paramTypes[i] = params[i].getFeatureType();
        }
        IRelativeTypeInfo ti = (IRelativeTypeInfo)JavaTypes.OBJECT().getTypeInfo();
        IMethodInfo objMethod = ti.getMethod((IType)JavaTypes.OBJECT(), (CharSequence)mi.getDisplayName(), paramTypes);
        return objMethod != null;
    }

    public static boolean isObjectProperty(IPropertyInfo pi) {
        IRelativeTypeInfo ti = (IRelativeTypeInfo)JavaTypes.OBJECT().getTypeInfo();
        IPropertyInfo objProp = ti.getProperty((IType)JavaTypes.OBJECT(), (CharSequence)pi.getDisplayName());
        return objProp != null;
    }

    private String getRelativeName(IJavaType type) {
        String strName = TypeSystem.getGenericRelativeName((IType)type, (boolean)false);
        if (type.getEnclosingType() != null) {
            int iIndex;
            int iParamsIndex = strName.indexOf(60);
            int n = iIndex = iParamsIndex > 0 ? strName.substring(0, iParamsIndex).lastIndexOf(46) : strName.lastIndexOf(46);
            if (iIndex > 0) {
                strName = strName.substring(iIndex + 1);
            }
        }
        return strName;
    }

    private StringBuilder genJavaInterfaceProxy(IJavaType type) {
        if (type.isParameterizedType()) {
            type = type.getGenericType();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("package ").append("_proxy_").append('.').append(type.getNamespace()).append('\n');
        this.genInterfaceImpl(type, sb);
        return sb;
    }

    private void genInterfaceImpl(IJavaType type, StringBuilder sb) {
        sb.append(Modifier.toModifierString((int)type.getModifiers())).append(" interface ").append(this.getRelativeName(type)).append('\n');
        sb.append("{\n");
        ITypeInfo ti = type.getTypeInfo();
        for (Object o : ti.getProperties()) {
            IPropertyInfo pi = (IPropertyInfo)o;
            this.genInterfacePropertyDecl(sb, pi, type);
        }
        for (Object o : ti.getMethods()) {
            IMethodInfo mi = (IMethodInfo)o;
            if (mi.isDefaultImpl() || mi.isStatic()) {
                this.genMethodImpl(sb, mi);
                continue;
            }
            this.genInterfaceMethodDecl(sb, mi);
        }
        for (IJavaType iface : type.getInnerClasses()) {
            if (!iface.isInterface() || !Modifier.isPublic((int)iface.getModifiers()) && !Modifier.isProtected((int)iface.getModifiers()) && Modifier.isPrivate((int)iface.getModifiers()) || Modifier.isFinal((int)iface.getModifiers())) continue;
            this.genInterfaceImpl(iface, sb);
        }
        sb.append("}\n");
    }

    private void genMethodImpl(StringBuilder sb, IMethodInfo mi) {
        if (mi.isPrivate()) {
            return;
        }
        if (mi.isStatic() && mi.getDisplayName().indexOf(36) < 0) {
            this.genStaticMethod(sb, mi);
        } else {
            this.genMemberMethod(sb, mi);
        }
    }

    private void genConstructor(StringBuilder sb, IConstructorInfo ci) {
        if (ci instanceof JavaConstructorInfo && ((JavaConstructorInfo)ci).isSynthetic()) {
            return;
        }
        StringBuilder sbModifiers = this.appendVisibilityModifier((IAttributedFeatureInfo)ci);
        if (ci.getDescription() != null) {
            sb.append("\n/** ").append(ci.getDescription()).append(" */\n");
        }
        sb.append("  ").append((CharSequence)sbModifiers).append("  construct(");
        IParameterInfo[] params = ci.getParameters();
        for (int i = 0; i < params.length; ++i) {
            IParameterInfo pi = params[i];
            sb.append(' ').append("p").append(i).append(" : ").append(pi.getFeatureType().getName()).append(i < params.length - 1 ? (char)',' : ' ');
        }
        sb.append(")\n").append("{\n").append("}\n");
    }

    private StringBuilder appendVisibilityModifier(IAttributedFeatureInfo fi) {
        StringBuilder sb = new StringBuilder();
        this.addAnnotations((IAnnotatedFeatureInfo)fi, sb);
        if (!fi.isPublic()) {
            if (fi.isProtected()) {
                sb.append((CharSequence)Keyword.KW_protected).append(" ");
            } else if (fi.isPrivate()) {
                sb.append((CharSequence)Keyword.KW_private).append(" ");
            } else {
                sb.append((CharSequence)Keyword.KW_internal).append(" ");
            }
        }
        return sb;
    }

    private StringBuilder appendFieldVisibilityModifier(IAttributedFeatureInfo fi) {
        StringBuilder sb = new StringBuilder();
        this.addAnnotations((IAnnotatedFeatureInfo)fi, sb);
        if (fi.isPublic()) {
            sb.append((CharSequence)Keyword.KW_public).append(" ");
        } else if (fi.isProtected()) {
            sb.append((CharSequence)Keyword.KW_protected).append(" ");
        } else if (!fi.isPrivate()) {
            sb.append((CharSequence)Keyword.KW_internal).append(" ");
        }
        return sb;
    }

    private void genMemberMethod(StringBuilder sb, IMethodInfo mi) {
        if (!this.canExtendMethod(mi)) {
            return;
        }
        StringBuilder sbModifiers = this.buildModifiers((IAttributedFeatureInfo)mi);
        if (mi.getDescription() != null) {
            sb.append("\n/** ").append(mi.getDescription()).append(" */\n");
        }
        sb.append("  ").append((CharSequence)sbModifiers).append("function ").append(mi.getDisplayName()).append(TypeInfoUtil.getTypeVarList((IFeatureInfo)mi)).append("(");
        IParameterInfo[] params = mi.getParameters();
        for (int i = 0; i < params.length; ++i) {
            IParameterInfo pi = params[i];
            sb.append(' ').append("p").append(i).append(" : ").append(pi.getFeatureType().getName()).append(i < params.length - 1 ? (char)',' : ' ');
        }
        sb.append(") : ").append(mi.getReturnType().getName()).append("\n");
        if (!mi.isAbstract()) {
            GosuClassProxyFactory.generateStub(sb, mi.getReturnType());
        }
    }

    private static void generateStub(StringBuilder sb, IType returnType) {
        sb.append("{\n").append(returnType == JavaTypes.pVOID() ? "" : "    return " + (!returnType.isPrimitive() ? "null" : CommonServices.getCoercionManager().convertNullAsPrimitive(returnType, false)));
        sb.append("}\n");
    }

    private boolean canExtendMethod(IMethodInfo mi) {
        if (!(mi instanceof JavaMethodInfo)) {
            return false;
        }
        if (GosuClassProxyFactory.isPropertyMethod(mi)) {
            return false;
        }
        if (Keyword.isReservedKeyword((String)mi.getDisplayName())) {
            return false;
        }
        int iMethodModifiers = ((IJavaMethodInfo)mi).getModifiers();
        return !java.lang.reflect.Modifier.isNative(iMethodModifiers) && !mi.getDisplayName().equals("finalize") && mi.getDisplayName().indexOf(36) < 0;
    }

    private void genStaticMethod(StringBuilder sb, IMethodInfo mi) {
        if (!(mi instanceof JavaMethodInfo)) {
            return;
        }
        if (GosuClassProxyFactory.isPropertyMethod(mi)) {
            return;
        }
        StringBuilder sbModifiers = this.appendVisibilityModifier((IAttributedFeatureInfo)mi);
        if (mi.getDescription() != null) {
            sb.append("\n/** ").append(mi.getDescription()).append(" */\n");
        }
        sb.append("  ").append((CharSequence)sbModifiers).append("static function ").append(mi.getDisplayName()).append(TypeInfoUtil.getTypeVarList((IFeatureInfo)mi)).append("(");
        IParameterInfo[] params = mi.getParameters();
        for (int i = 0; i < params.length; ++i) {
            IParameterInfo pi = params[i];
            sb.append(' ').append("p").append(i).append(" : ").append(pi.getFeatureType().getName()).append(i < params.length - 1 ? (char)',' : ' ');
        }
        sb.append(") : ").append(mi.getReturnType().getName()).append("\n");
        GosuClassProxyFactory.generateStub(sb, mi.getReturnType());
    }

    private void genInterfaceMethodDecl(StringBuilder sb, IMethodInfo mi) {
        if (!(mi instanceof JavaMethodInfo)) {
            return;
        }
        if (GosuClassProxyFactory.isPropertyMethod(mi)) {
            return;
        }
        if ((mi.getDisplayName().equals("hashCode") || mi.getDisplayName().equals("equals") && mi.getParameters().length == 1 && mi.getParameters()[0].getFeatureType() == JavaTypes.OBJECT() || mi.getDisplayName().equals("toString")) && !mi.getOwnersType().getName().equals(IGosuObject.class.getName())) {
            return;
        }
        if (mi.getDescription() != null) {
            sb.append("\n/** ").append(mi.getDescription()).append(" */\n");
        }
        sb.append("  function ").append(mi.getDisplayName()).append(TypeInfoUtil.getTypeVarList((IFeatureInfo)mi)).append("(");
        IParameterInfo[] params = mi.getParameters();
        for (int i = 0; i < params.length; ++i) {
            IParameterInfo pi = params[i];
            sb.append(' ').append("p").append(i).append(" : ").append(pi.getFeatureType().getName());
            sb.append(i < params.length - 1 ? (char)',' : ' ');
        }
        sb.append(") : ").append(mi.getReturnType().getName()).append(";\n");
    }

    public static boolean isPropertyMethod(IMethodInfo mi) {
        return GosuClassProxyFactory.isPropertyGetter(mi) || GosuClassProxyFactory.isPropertySetter(mi);
    }

    public static boolean isPropertyGetter(IMethodInfo mi) {
        return GosuClassProxyFactory.isPropertyGetter(mi, "get") || GosuClassProxyFactory.isPropertyGetter(mi, "is");
    }

    public static boolean isPropertySetter(IMethodInfo mi) {
        String strProp;
        String strMethod = mi.getDisplayName();
        if (strMethod.startsWith("set") && strMethod.length() > 3 && mi.getParameters().length == 1 && mi.getReturnType() == JavaTypes.pVOID() && Character.isUpperCase((strProp = strMethod.substring("set".length())).charAt(0))) {
            IPropertyInfo pi;
            ITypeInfo ti = (ITypeInfo)mi.getContainer();
            IPropertyInfo iPropertyInfo = pi = ti instanceof IRelativeTypeInfo ? ((IRelativeTypeInfo)ti).getProperty(mi.getOwnersType(), (CharSequence)strProp) : ti.getProperty((CharSequence)strProp);
            if (pi != null && pi.isReadable() && mi.isStatic() == pi.isStatic() && pi.getFeatureType().getName().equals(mi.getParameters()[0].getFeatureType().getName())) {
                return !Keyword.isKeyword((String)pi.getName()) || Keyword.isValueKeyword((String)pi.getName());
            }
        }
        return false;
    }

    public static boolean isPropertyGetter(IMethodInfo mi, String strPrefix) {
        String strProp;
        String strMethod = mi.getDisplayName();
        if (strMethod.startsWith(strPrefix) && mi.getParameters().length == 0 && (strProp = strMethod.substring(strPrefix.length())).length() > 0 && Character.isUpperCase(strProp.charAt(0))) {
            IPropertyInfo pi;
            ITypeInfo ti = (ITypeInfo)mi.getContainer();
            IPropertyInfo iPropertyInfo = pi = ti instanceof IRelativeTypeInfo ? ((IRelativeTypeInfo)ti).getProperty(mi.getOwnersType(), (CharSequence)strProp) : ti.getProperty((CharSequence)strProp);
            if (pi != null && pi.getFeatureType().getName().equals(mi.getReturnType().getName())) {
                return !(pi instanceof IJavaPropertyInfo && !((IJavaPropertyInfo)pi).getPropertyDescriptor().getReadMethod().getName().equals(mi.getDisplayName()) || Keyword.isKeyword((String)pi.getName()) && !Keyword.isValueKeyword((String)pi.getName()));
            }
        }
        return false;
    }

    private void genInterfacePropertyDecl(StringBuilder sb, IPropertyInfo pi, IJavaType javaType) {
        if (pi.isStatic()) {
            this.genStaticProperty(pi, sb);
            return;
        }
        if (!pi.isReadable()) {
            return;
        }
        if (!(pi instanceof JavaBaseFeatureInfo)) {
            return;
        }
        IType type = pi.getFeatureType();
        if (pi.getDescription() != null) {
            sb.append("\n/** ").append(pi.getDescription()).append(" */\n");
        }
        sb.append(" property get ").append(pi.getName()).append("() : ").append(type.getName()).append("\n");
        IMethodInfo mi = this.getPropertyGetMethod(pi, javaType);
        if (mi != null && !mi.isAbstract()) {
            GosuClassProxyFactory.generateStub(sb, mi.getReturnType());
        }
        if (pi.isWritable(pi.getOwnersType())) {
            sb.append(" property set ").append(pi.getName()).append("( _proxy_arg_value : ").append(type.getName()).append(" )\n");
            mi = this.getPropertySetMethod(pi, javaType);
            if (mi != null && !mi.isAbstract()) {
                GosuClassProxyFactory.generateStub(sb, mi.getReturnType());
            }
        }
    }

    private void genProperty(IPropertyInfo pi, StringBuilder sb, IJavaType type) {
        if (pi.isPrivate()) {
            return;
        }
        if (pi.isStatic()) {
            this.genStaticProperty(pi, sb);
        } else {
            this.genMemberProperty(pi, sb, type);
        }
    }

    private void genMemberProperty(IPropertyInfo pi, StringBuilder sb, IJavaType type) {
        if (pi.isStatic()) {
            return;
        }
        if (!(pi instanceof JavaBaseFeatureInfo)) {
            return;
        }
        if (Keyword.isKeyword((String)pi.getName()) && !Keyword.isValueKeyword((String)pi.getName())) {
            return;
        }
        if (pi instanceof JavaFieldPropertyInfo) {
            StringBuilder sbModifiers = this.appendFieldVisibilityModifier((IAttributedFeatureInfo)pi);
            sb.append("  ").append((CharSequence)sbModifiers).append(" var ").append(pi.getName()).append(" : ").append(pi.getFeatureType().getName()).append("\n");
        } else {
            boolean bAbstact;
            StringBuilder sbModifiers;
            IMethodInfo mi = this.getPropertyGetMethod(pi, type);
            boolean bFinal = false;
            if (mi != null) {
                int iMethodModifiers = ((IJavaMethodInfo)mi).getModifiers();
                bFinal = java.lang.reflect.Modifier.isFinal(iMethodModifiers);
            }
            if (mi != null && !bFinal) {
                if (mi.getDescription() != null) {
                    sb.append("\n/** ").append(mi.getDescription()).append(" */\n");
                }
                sbModifiers = this.buildModifiers((IAttributedFeatureInfo)mi);
                sb.append("  ").append((CharSequence)sbModifiers).append("property get ").append(pi.getName()).append("() : ").append(pi.getFeatureType().getName()).append("\n");
                if (!mi.isAbstract()) {
                    GosuClassProxyFactory.generateStub(sb, mi.getReturnType());
                }
            } else {
                bAbstact = false;
                if (bFinal) {
                    bAbstact = mi.isAbstract();
                    sbModifiers = this.buildModifiers((IAttributedFeatureInfo)mi);
                } else {
                    sbModifiers = this.appendVisibilityModifier((IAttributedFeatureInfo)pi);
                }
                sb.append("  ").append((CharSequence)sbModifiers).append("property get ").append(pi.getName()).append("() : ").append(pi.getFeatureType().getName()).append("\n");
                if (!bAbstact) {
                    GosuClassProxyFactory.generateStub(sb, pi.getFeatureType());
                }
            }
            mi = this.getPropertySetMethod(pi, type);
            bFinal = false;
            if (mi != null) {
                int iMethodModifiers = ((IJavaMethodInfo)mi).getModifiers();
                bFinal = java.lang.reflect.Modifier.isFinal(iMethodModifiers);
            }
            if (mi != null && !bFinal) {
                StringBuilder sbModifiers2 = this.buildModifiers((IAttributedFeatureInfo)mi);
                if (pi.isWritable(pi.getOwnersType())) {
                    sb.append("  ").append((CharSequence)sbModifiers2).append("property set ").append(pi.getName()).append("( _proxy_arg_value : ").append(pi.getFeatureType().getName()).append(" )\n");
                    if (!mi.isAbstract()) {
                        GosuClassProxyFactory.generateStub(sb, (IType)JavaTypes.pVOID());
                    }
                }
            } else if (pi.isWritable(type.getEnclosingType() != null ? null : pi.getOwnersType())) {
                StringBuilder sbModifiers3;
                bAbstact = false;
                if (bFinal) {
                    bAbstact = mi.isAbstract();
                    sbModifiers3 = this.buildModifiers((IAttributedFeatureInfo)mi);
                } else {
                    sbModifiers3 = this.appendVisibilityModifier((IAttributedFeatureInfo)pi);
                }
                sb.append("  ").append((CharSequence)sbModifiers3).append("property set ").append(pi.getName()).append("( _proxy_arg_value : ").append(pi.getFeatureType().getName()).append(" )\n");
                if (!bAbstact) {
                    GosuClassProxyFactory.generateStub(sb, (IType)JavaTypes.pVOID());
                }
            }
        }
    }

    private StringBuilder buildModifiers(IAttributedFeatureInfo fi) {
        StringBuilder sbModifiers = new StringBuilder();
        this.addAnnotations((IAnnotatedFeatureInfo)fi, sbModifiers);
        if (fi.isAbstract()) {
            sbModifiers.append((CharSequence)Keyword.KW_abstract).append(" ");
        } else if (fi.isFinal()) {
            sbModifiers.append((CharSequence)Keyword.KW_final).append(" ");
        }
        if (fi.isProtected()) {
            sbModifiers.append((CharSequence)Keyword.KW_protected).append(" ");
        } else if (!fi.isPrivate() && !fi.isPublic()) {
            sbModifiers.append((CharSequence)Keyword.KW_internal).append(" ");
        }
        return sbModifiers;
    }

    private IMethodInfo getPropertyGetMethod(IPropertyInfo pi, IJavaType ownerType) {
        if (!(pi.getOwnersType() instanceof IJavaType)) {
            return null;
        }
        if (!(ownerType.getTypeInfo() instanceof JavaTypeInfo)) {
            throw new IllegalArgumentException(ownerType + " is not a recognized Java type");
        }
        JavaTypeInfo ti = (JavaTypeInfo)ownerType.getTypeInfo();
        IType propType = pi.getFeatureType();
        String strAccessor = "get" + pi.getDisplayName();
        IMethodInfo mi = ti.getMethod((IType)ownerType, strAccessor, new IType[0]);
        if (mi == null) {
            strAccessor = "is" + pi.getDisplayName();
            mi = ti.getMethod((IType)ownerType, strAccessor, new IType[0]);
        }
        if (mi != null && mi.getReturnType().equals(propType)) {
            return mi;
        }
        return null;
    }

    private IMethodInfo getPropertySetMethod(IPropertyInfo pi, IJavaType ownerType) {
        if (!(pi.getOwnersType() instanceof IJavaType)) {
            return null;
        }
        if (!(ownerType.getTypeInfo() instanceof JavaTypeInfo)) {
            throw new IllegalArgumentException(ownerType + " is not a recognized Java type");
        }
        JavaTypeInfo ti = (JavaTypeInfo)ownerType.getTypeInfo();
        IType propType = pi.getFeatureType();
        String strAccessor = "set" + pi.getDisplayName();
        IMethodInfo mi = ti.getMethod((IType)ownerType, strAccessor, propType);
        if (mi != null && mi.getReturnType() == JavaTypes.pVOID()) {
            return mi;
        }
        return null;
    }

    private void genStaticProperty(IPropertyInfo pi, StringBuilder sb) {
        if (!pi.isStatic()) {
            return;
        }
        if (!(pi instanceof JavaBaseFeatureInfo)) {
            return;
        }
        if (Keyword.isKeyword((String)pi.getName())) {
            return;
        }
        if (pi.getDescription() != null) {
            sb.append("\n/** ").append(pi.getDescription()).append(" */\n");
        }
        if (pi instanceof JavaFieldPropertyInfo) {
            StringBuilder sbModifiers = this.appendFieldVisibilityModifier((IAttributedFeatureInfo)pi);
            sb.append("  ").append((CharSequence)sbModifiers).append("static var ").append(pi.getName()).append(" : ").append(pi.getFeatureType().getName()).append("\n");
        } else {
            StringBuilder sbModifiers = this.appendVisibilityModifier((IAttributedFeatureInfo)pi);
            sb.append("  ").append((CharSequence)sbModifiers).append("static property get ").append(pi.getName()).append("() : ").append(pi.getFeatureType().getName()).append("\n");
            if (!pi.isAbstract()) {
                GosuClassProxyFactory.generateStub(sb, pi.getFeatureType());
            }
            if (pi.isWritable(pi.getOwnersType())) {
                sb.append("  static property set ").append(pi.getName()).append("( _proxy_arg_value : ").append(pi.getFeatureType().getName()).append(" )\n");
                if (!pi.isAbstract()) {
                    GosuClassProxyFactory.generateStub(sb, (IType)JavaTypes.pVOID());
                }
            }
        }
    }

    private static class LazyStringSourceFileHandle
    extends StringSourceFileHandle {
        private Callable<StringBuilder> _sourceGen;

        public LazyStringSourceFileHandle(IType type, Callable<StringBuilder> sourceGen) {
            super(GosuClassProxyFactory.getProxyName(type), null, false, ClassType.Class);
            this._sourceGen = sourceGen;
        }

        public ISource getSource() {
            if (this.getRawSource() == null) {
                try {
                    this.setRawSource(this._sourceGen.call().toString());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return super.getSource();
        }
    }
}

