/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.nodes;

import gw.internal.gosu.compiler.GosuClassLoader;
import gw.internal.gosu.ir.nodes.IRTypeFactory;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.lang.ir.IRType;
import gw.lang.reflect.IType;
import gw.lang.reflect.gs.IGosuArrayClass;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.java.IJavaType;
import gw.util.Array;
import gw.util.GosuClassUtil;

public class GosuClassIRType
implements IRType {
    private IType _type;
    private Boolean _structural;

    public static GosuClassIRType get(IType type) {
        if (!(type instanceof IGosuClassInternal) && !(type instanceof IGosuArrayClass)) {
            throw new IllegalArgumentException("Cannot create a GosuClassIRType from a type of type " + type.getClass());
        }
        return new GosuClassIRType(type);
    }

    private GosuClassIRType(IType type) {
        this._type = type;
    }

    public IType getType() {
        return this._type;
    }

    public String getName() {
        return this._type.getName();
    }

    public String getRelativeName() {
        return this._type.getRelativeName();
    }

    public String getDescriptor() {
        if (this.isArray()) {
            return '[' + this.getComponentType().getDescriptor();
        }
        return 'L' + this.getSlashName() + ';';
    }

    public boolean isStructural() {
        return this._structural == null ? (this._structural = Boolean.valueOf(this._type instanceof IGosuClass && ((IGosuClass)this._type).isStructure())) : this._structural;
    }

    public boolean isStructuralAndErased(IRType ownersType) {
        return this.isStructural() && ownersType instanceof GosuClassIRType;
    }

    public Class getJavaClass() {
        if (this.isArray()) {
            return Array.newInstance((Class)this.getComponentType().getJavaClass(), (int)0).getClass();
        }
        try {
            return GosuClassLoader.instance().loadClass(this._type.getName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public String getSlashName() {
        if (this.isArray()) {
            return this.getComponentType().getSlashName() + "[]";
        }
        IType outerType = this._type.getEnclosingType();
        if (outerType != null) {
            return IRTypeFactory.get(outerType).getSlashName() + "$" + GosuClassUtil.getNameNoPackage((String)this._type.getName());
        }
        IType type = this._type;
        IJavaType jtype = ((IGosuClassInternal)this._type).getJavaType();
        if (jtype != null && !jtype.getBackingClassInfo().isAnnotation()) {
            type = jtype;
        }
        return type.getName().replace('.', '/');
    }

    public IRType getArrayType() {
        return IRTypeFactory.get(this._type.getArrayType());
    }

    public IRType getComponentType() {
        return IRTypeFactory.get(this._type.getComponentType());
    }

    public boolean isArray() {
        return this._type.isArray();
    }

    public boolean equals(Object obj) {
        return obj instanceof GosuClassIRType && this._type.equals(((GosuClassIRType)obj)._type);
    }

    public boolean isAssignableFrom(IRType otherType) {
        if (this.isArray() && otherType.isArray()) {
            return this.getComponentType().isAssignableFrom(otherType.getComponentType());
        }
        if (this.isArray() || otherType.isArray()) {
            return false;
        }
        if (otherType instanceof GosuClassIRType) {
            return this._type.isAssignableFrom(((GosuClassIRType)otherType)._type);
        }
        return false;
    }

    public boolean isByte() {
        return false;
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isShort() {
        return false;
    }

    public boolean isChar() {
        return false;
    }

    public boolean isInt() {
        return false;
    }

    public boolean isLong() {
        return false;
    }

    public boolean isFloat() {
        return false;
    }

    public boolean isDouble() {
        return false;
    }

    public boolean isVoid() {
        return false;
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isInterface() {
        return this._type.isInterface();
    }

    public String toString() {
        return this.getName();
    }
}

