/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.statement;

import gw.internal.gosu.ir.nodes.IRMethodFactory;
import gw.internal.gosu.ir.transform.ExpressionTransformer;
import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.ir.transform.statement.AbstractStatementTransformer;
import gw.internal.gosu.parser.statements.UsingStatement;
import gw.internal.gosu.runtime.GosuRuntimeMethods;
import gw.lang.IReentrant;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRStatement;
import gw.lang.ir.IRSymbol;
import gw.lang.ir.expression.IRIdentifier;
import gw.lang.ir.statement.IRAssignmentStatement;
import gw.lang.ir.statement.IRMonitorLockAcquireStatement;
import gw.lang.ir.statement.IRMonitorLockReleaseStatement;
import gw.lang.ir.statement.IRStatementList;
import gw.lang.ir.statement.IRTryCatchFinallyStatement;
import gw.lang.parser.IExpression;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.IStatement;
import gw.lang.parser.expressions.IVarStatement;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.java.GosuTypes;
import gw.lang.reflect.java.JavaTypes;
import java.io.Closeable;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;

public class UsingStatementTransformer
extends AbstractStatementTransformer<UsingStatement> {
    public static IRStatement compile(TopLevelTransformationContext cc, UsingStatement stmt) {
        UsingStatementTransformer compiler = new UsingStatementTransformer(cc, stmt);
        return compiler.compile();
    }

    private UsingStatementTransformer(TopLevelTransformationContext cc, UsingStatement stmt) {
        super(cc, stmt);
    }

    @Override
    protected IRStatement compile_impl() {
        this._cc().pushScope(false);
        try {
            IRStatement iRStatement = this.compileUsingVars(this.getUsingVars());
            return iRStatement;
        }
        finally {
            this._cc().popScope();
        }
    }

    private Iterator<? extends IParsedElement> getUsingVars() {
        if (((UsingStatement)this._stmt()).hasVarStatements()) {
            return ((UsingStatement)this._stmt()).getVarStatements().iterator();
        }
        return Collections.singleton(((UsingStatement)this._stmt()).getExpression()).iterator();
    }

    private IRStatement compileUsingVars(Iterator<? extends IParsedElement> usingVars) {
        if (!usingVars.hasNext()) {
            IRStatement body = this._cc().compile(((UsingStatement)this._stmt()).getStatement());
            this.visitStatementLineNumber(body, ((UsingStatement)this._stmt()).getStatement());
            return body;
        }
        IParsedElement pe = usingVars.next();
        IType type = this.getType(pe);
        IRStatementList stmtList = new IRStatementList(false, new IRStatement[0]);
        IRSymbol symbol = this.initVar(pe, stmtList);
        stmtList.addStatement(this.acquire(symbol, type));
        stmtList.addStatement((IRStatement)new IRTryCatchFinallyStatement(this.compileUsingVars(usingVars), Collections.EMPTY_LIST, this.release(symbol, type)));
        return stmtList;
    }

    private IRSymbol initVar(IParsedElement pe, IRStatementList stmtList) {
        if (pe instanceof IExpression) {
            IRExpression expression = ExpressionTransformer.compile((IExpression)pe, this._cc());
            IRSymbol tempSymbol = this._cc().makeAndIndexTempSymbol(expression.getType());
            IRAssignmentStatement initAssignment = this.buildAssignment(tempSymbol, expression);
            stmtList.addStatement((IRStatement)initAssignment);
            return tempSymbol;
        }
        IVarStatement varStmt = (IVarStatement)pe;
        IRExpression expression = ExpressionTransformer.compile(varStmt.getAsExpression(), this._cc());
        if (varStmt.getSymbol().isValueBoxed()) {
            expression = this.buildInitializedArray(UsingStatementTransformer.getDescriptor(varStmt.getSymbol().getType()), Collections.singletonList(expression));
        }
        IRSymbol varSymbol = this._cc().createSymbol(varStmt.getSymbol().getName(), varStmt.getSymbol().isValueBoxed() ? UsingStatementTransformer.getDescriptor(varStmt.getSymbol().getType()).getArrayType() : UsingStatementTransformer.getDescriptor(varStmt.getSymbol().getType()));
        IRAssignmentStatement initAssignment = this.buildAssignment(varSymbol, expression);
        stmtList.addStatement((IRStatement)initAssignment);
        this.visitStatementLineNumber((IRStatement)initAssignment, (IStatement)varStmt);
        IRSymbol tempSymbol = this._cc().makeAndIndexTempSymbol(expression.getType());
        IRAssignmentStatement tempVar = this.buildAssignment(tempSymbol, (IRExpression)this.identifier(initAssignment.getSymbol()));
        stmtList.addStatement((IRStatement)tempVar);
        return tempSymbol;
    }

    private IType getType(IParsedElement pe) {
        if (pe instanceof IExpression) {
            return ((IExpression)pe).getType();
        }
        return ((IVarStatement)pe).getType();
    }

    private IRStatement acquire(IRSymbol symbol, IType type) {
        IRAssignmentStatement tempVar = null;
        if (symbol.getType().isArray()) {
            IRExpression boxedValue = this.buildArrayLoad((IRExpression)new IRIdentifier(symbol), 0, UsingStatementTransformer.getDescriptor(type));
            symbol = this._cc().makeAndIndexTempSymbol(UsingStatementTransformer.getDescriptor(type));
            tempVar = this.buildAssignment(symbol, boxedValue);
        }
        Object acquireStmt = type.equals(GosuTypes.IMONITORLOCK()) ? new IRMonitorLockAcquireStatement((IRExpression)this.identifier(symbol)) : (JavaTypes.LOCK().isAssignableFrom(type) ? this.buildIf((IRExpression)this.buildNotEquals((IRExpression)this.identifier(symbol), this.nullLiteral()), (IRStatement)this.buildMethodCall(this.callMethod(Lock.class, "lock", new Class[0], (IRExpression)this.identifier(symbol), UsingStatementTransformer.exprList(new IRExpression[0])))) : (JavaTypes.getGosuType(IReentrant.class).isAssignableFrom(type) ? this.buildIf((IRExpression)this.buildNotEquals((IRExpression)this.identifier(symbol), this.nullLiteral()), (IRStatement)this.buildMethodCall(this.callMethod(IReentrant.class, "enter", new Class[0], (IRExpression)this.identifier(symbol), UsingStatementTransformer.exprList(new IRExpression[0])))) : this.buildMethodCall(this.callStaticMethod(GosuRuntimeMethods.class, "invokeLockMethod", new Class[]{Object.class}, UsingStatementTransformer.exprList(new IRExpression[]{this.identifier(symbol)})))));
        if (tempVar != null) {
            acquireStmt = new IRStatementList(false, new IRStatement[]{tempVar, acquireStmt});
        }
        return acquireStmt;
    }

    private IRStatement release(IRSymbol symbol, IType type) {
        IRAssignmentStatement tempVar = null;
        if (symbol.getType().isArray()) {
            IRExpression boxedValue = this.buildArrayLoad((IRExpression)new IRIdentifier(symbol), 0, UsingStatementTransformer.getDescriptor(type));
            symbol = this._cc().makeAndIndexTempSymbol(UsingStatementTransformer.getDescriptor(type));
            tempVar = this.buildAssignment(symbol, boxedValue);
        }
        Object releaseStmt = type.equals(GosuTypes.IMONITORLOCK()) ? new IRMonitorLockReleaseStatement((IRExpression)this.identifier(symbol)) : (JavaTypes.LOCK().isAssignableFrom(type) ? this.buildIf((IRExpression)this.buildNotEquals((IRExpression)this.identifier(symbol), this.nullLiteral()), (IRStatement)this.buildMethodCall(this.callMethod(Lock.class, "unlock", new Class[0], (IRExpression)this.identifier(symbol), UsingStatementTransformer.exprList(new IRExpression[0])))) : (JavaTypes.getGosuType(IReentrant.class).isAssignableFrom(type) ? this.buildIf((IRExpression)this.buildNotEquals((IRExpression)this.identifier(symbol), this.nullLiteral()), (IRStatement)this.buildMethodCall(this.callMethod(IReentrant.class, "exit", new Class[0], (IRExpression)this.identifier(symbol), UsingStatementTransformer.exprList(new IRExpression[0])))) : (JavaTypes.getJreType(Closeable.class).isAssignableFrom(type) ? this.buildIf((IRExpression)this.buildNotEquals((IRExpression)this.identifier(symbol), this.nullLiteral()), (IRStatement)this.buildMethodCall(this.callMethod(Closeable.class, "close", new Class[0], (IRExpression)this.identifier(symbol), UsingStatementTransformer.exprList(new IRExpression[0])))) : (GosuTypes.IDISPOSABLE().isAssignableFrom(type) ? this.buildIf((IRExpression)this.buildNotEquals((IRExpression)this.identifier(symbol), this.nullLiteral()), (IRStatement)this.buildMethodCall(this.callMethod(IRMethodFactory.createIRMethod(GosuTypes.IDISPOSABLE(), "dispose", (IType)JavaTypes.pVOID(), IType.EMPTY_ARRAY, IRelativeTypeInfo.Accessibility.PUBLIC, false), (IRExpression)this.identifier(symbol), UsingStatementTransformer.exprList(new IRExpression[0])))) : this.buildMethodCall(this.callStaticMethod(GosuRuntimeMethods.class, "invokeUnlockOrDisposeOrCloseMethod", new Class[]{Object.class}, UsingStatementTransformer.exprList(new IRExpression[]{this.identifier(symbol)})))))));
        if (tempVar != null) {
            releaseStmt = new IRStatementList(false, new IRStatement[]{tempVar, releaseStmt});
        }
        if (((UsingStatement)this._stmt()).getFinallyStatement() != null) {
            IRStatement finallyBody = this._cc().compile(((UsingStatement)this._stmt()).getFinallyStatement());
            releaseStmt = new IRStatementList(false, new IRStatement[]{releaseStmt, finallyBody});
        }
        return releaseStmt;
    }
}

