/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.parser.CompoundTypeInfo;
import gw.internal.gosu.parser.ErrorType;
import gw.internal.gosu.parser.TypeLoaderAccess;
import gw.lang.parser.StandardCoercionManager;
import gw.lang.reflect.AbstractType;
import gw.lang.reflect.AbstractTypeSystemListener;
import gw.lang.reflect.DefaultNonLoadableArrayType;
import gw.lang.reflect.ICompoundType;
import gw.lang.reflect.INonLoadableType;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.ITypeLoader;
import gw.lang.reflect.ITypeLoaderListener;
import gw.lang.reflect.gs.IGenericTypeVariable;
import gw.lang.reflect.java.JavaTypes;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public class CompoundType
extends AbstractType
implements INonLoadableType,
ICompoundType {
    private static final Map<String, CompoundType> CACHE = new ConcurrentHashMap<String, CompoundType>();
    private static ITypeLoaderListener g_refreshListener;
    private transient SortedSet<IType> _types = new TreeSet<IType>(TypeComparator.access$100());
    private String _strRelativeName;
    private String _strName;
    private boolean _bInterface;
    private transient ITypeInfo _typeInfo;

    public static IType get(IType ... types) {
        HashSet<IType> typeSet = new HashSet<IType>();
        typeSet.addAll(Arrays.asList(types));
        return CompoundType.get(typeSet);
    }

    public static IType get(Set<IType> types) {
        String strName;
        CompoundType compoundType;
        if ((types = CompoundType.removeRedundantTypes(types)).size() == 1) {
            return types.iterator().next();
        }
        if (types.contains(JavaTypes.OBJECT())) {
            types.remove(JavaTypes.OBJECT());
            if (types.size() == 1) {
                return types.iterator().next();
            }
        }
        if ((compoundType = CACHE.get(strName = CompoundType.getNameFrom(types, false))) == null) {
            CompoundType.listenToTypeSystemRefresh();
            compoundType = new CompoundType(types, strName);
            CACHE.put(strName, compoundType);
        }
        return compoundType;
    }

    private static Set<IType> removeRedundantTypes(Set<IType> types) {
        HashSet<IType> reduced = new HashSet<IType>();
        block0: for (IType t : types) {
            if (!(t instanceof ErrorType)) {
                for (IType t2 : types) {
                    if (t == t2 || !t.isAssignableFrom(t2) && !StandardCoercionManager.isStructurallyAssignable((IType)t, (IType)t2)) continue;
                    continue block0;
                }
            }
            reduced.add(t);
        }
        if (types.size() > 0 && reduced.size() == 0) {
            throw new IllegalStateException();
        }
        return reduced;
    }

    private static void listenToTypeSystemRefresh() {
        if (g_refreshListener != null) {
            return;
        }
        g_refreshListener = new AbstractTypeSystemListener(){

            public void refreshed() {
                CACHE.clear();
            }
        };
        TypeLoaderAccess.instance().addTypeLoaderListenerAsWeakRef(g_refreshListener);
    }

    private CompoundType(Set<IType> types, String strName) {
        this._types.addAll(types);
        this._strName = strName;
        this._strRelativeName = CompoundType.getNameFrom(types, true);
        this._bInterface = this.areAllTypesInterfaces(types);
    }

    private boolean areAllTypesInterfaces(Set<IType> types) {
        for (IType type : types) {
            if (type.isInterface()) continue;
            return false;
        }
        return true;
    }

    private static String getNameFrom(Set<IType> types, boolean bRelative) {
        StringBuilder sbName = new StringBuilder();
        ArrayList<IType> sorted = new ArrayList<IType>(types);
        Collections.sort(sorted, TypeComparator.INSTANCE);
        for (int i = 0; i < sorted.size(); ++i) {
            IType type = (IType)sorted.get(i);
            sbName.append(bRelative ? type.getRelativeName() : type.getName());
            if (i == sorted.size() - 1) continue;
            sbName.append(" & ");
        }
        return sbName.toString();
    }

    public Set<IType> getTypes() {
        return this._types;
    }

    public String getName() {
        return this._strName;
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getRelativeName() {
        return this._strRelativeName;
    }

    public String getNamespace() {
        return null;
    }

    public ITypeLoader getTypeLoader() {
        return null;
    }

    public IType getSupertype() {
        return null;
    }

    public IType getEnclosingType() {
        return null;
    }

    public IType getGenericType() {
        return null;
    }

    public boolean isFinal() {
        return true;
    }

    public boolean isInterface() {
        return this._bInterface;
    }

    public boolean isEnum() {
        return false;
    }

    public IType[] getInterfaces() {
        ArrayList<IType> interfaces = new ArrayList<IType>();
        for (IType type : this._types) {
            if (type.isInterface()) {
                interfaces.add(type);
            }
            for (IType anInterface : type.getInterfaces()) {
                if (interfaces.contains(anInterface)) continue;
                interfaces.add(type);
            }
        }
        return interfaces.toArray(new IType[interfaces.size()]);
    }

    public boolean isParameterizedType() {
        return false;
    }

    public boolean isGenericType() {
        return false;
    }

    public IGenericTypeVariable[] getGenericTypeVariables() {
        return new IGenericTypeVariable[0];
    }

    public IType getParameterizedType(IType ... ofType) {
        return null;
    }

    public IType[] getTypeParameters() {
        return IType.EMPTY_ARRAY;
    }

    public Set<? extends IType> getAllTypesInHierarchy() {
        HashSet<CompoundType> allTypes = new HashSet<CompoundType>();
        for (IType iType : this._types) {
            allTypes.addAll(iType.getAllTypesInHierarchy());
        }
        allTypes.add(this);
        return allTypes;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isPrimitive() {
        return false;
    }

    public IType getArrayType() {
        return new DefaultNonLoadableArrayType((IType)this, JavaTypes.OBJECT().getBackingClassInfo(), this.getTypeLoader());
    }

    public Object makeArrayInstance(int iLength) {
        return new Object[iLength];
    }

    public Object getArrayComponent(Object array, int iIndex) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        return ((Object[])array)[iIndex];
    }

    public void setArrayComponent(Object array, int iIndex, Object value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        ((Object[])array)[iIndex] = value;
    }

    public int getArrayLength(Object array) throws IllegalArgumentException {
        return ((Object[])array).length;
    }

    public IType getComponentType() {
        return null;
    }

    public boolean isAssignableFrom(IType type) {
        if (type == this) {
            return true;
        }
        if (type == null) {
            return false;
        }
        for (IType t : this._types) {
            if (t.isAssignableFrom(type)) continue;
            return false;
        }
        return true;
    }

    public boolean isMutable() {
        return false;
    }

    public ITypeInfo getTypeInfo() {
        if (this._typeInfo == null) {
            this._typeInfo = new CompoundTypeInfo(this);
        }
        return this._typeInfo;
    }

    public void unloadTypeInfo() {
        this._typeInfo = null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this._types.size());
        for (IType ref : this._types) {
            out.writeObject(ref);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int iSize = in.readInt();
        this._types = new TreeSet<IType>();
        for (int i = 0; i < iSize; ++i) {
            this._types.add((IType)in.readObject());
        }
    }

    public Object readResolve() throws ObjectStreamException {
        return this;
    }

    public boolean isValid() {
        for (IType type : this._types) {
            if (type.isValid()) continue;
            return false;
        }
        return true;
    }

    public int getModifiers() {
        return 0;
    }

    public boolean isAbstract() {
        return true;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isDiscarded() {
        return false;
    }

    public void setDiscarded(boolean bDiscarded) {
    }

    public boolean isCompoundType() {
        return true;
    }

    public Set<IType> getCompoundTypeComponents() {
        return Collections.unmodifiableSet(this.getTypes());
    }

    private static class TypeComparator
    implements Comparator<IType> {
        private static TypeComparator INSTANCE = new TypeComparator();

        private TypeComparator() {
        }

        @Override
        public int compare(IType o1, IType o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

