/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.expressions;

import gw.config.CommonServices;
import gw.internal.gosu.parser.BeanAccess;
import gw.internal.gosu.parser.ParseTree;
import gw.internal.gosu.parser.ParserBase;
import gw.internal.gosu.parser.expressions.ArithmeticExpression;
import gw.internal.gosu.parser.expressions.DimensionOperandResolver;
import gw.internal.gosu.parser.expressions.UnsupportedNumberTypeException;
import gw.lang.IDimension;
import gw.lang.parser.ICoercionManager;
import gw.lang.parser.expressions.IAdditiveExpression;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IPlaceholder;
import gw.lang.reflect.IType;
import gw.lang.reflect.ReflectUtil;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.JavaTypes;
import gw.util.Rational;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class AdditiveExpression
extends ArithmeticExpression
implements IAdditiveExpression {
    public boolean isAdditive() {
        return this.getOperator() != null && this.getOperator().endsWith("+");
    }

    public boolean isAssignment() {
        ParseTree loc = this.getLocation();
        return loc != null && loc.getChildCount() < 2;
    }

    @Override
    public Object evaluate() {
        if (!this.isCompileTimeConstant()) {
            return super.evaluate();
        }
        return AdditiveExpression.evaluate(this.getType(), this.getLHS().evaluate(), this.getRHS().evaluate(), this.getLHS().getType(), this.getRHS().getType(), this.isAdditive(), false, !this.getType().equals(JavaTypes.STRING()));
    }

    public static Object evaluate(IType type, Object lhsValue, Object rhsValue, IType lhsType, IType rhsType, boolean bAdditive, boolean bNullSafe, boolean bNumericType, Object ctx, int startLhs, int endLhs, int startRhs, int endRhs) {
        return AdditiveExpression.evaluate(type, lhsValue, rhsValue, lhsType, rhsType, bAdditive, bNullSafe, bNumericType);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object evaluate(IType type, Object lhsValue, Object rhsValue, IType lhsType, IType rhsType, boolean bAdditive, boolean bNullSafe, boolean bNumericType) {
        void var11_32;
        void var11_30;
        boolean bDynamic = false;
        if (lhsType instanceof IPlaceholder && ((IPlaceholder)lhsType).isPlaceholder()) {
            bDynamic = true;
            lhsType = TypeSystem.getFromObject((Object)lhsValue);
        }
        if (rhsType instanceof IPlaceholder && ((IPlaceholder)rhsType).isPlaceholder()) {
            bDynamic = true;
            rhsType = TypeSystem.getFromObject((Object)rhsValue);
        }
        if (bDynamic) {
            AdditiveExpression overrideMethod = new AdditiveExpression();
            type = ParserBase.resolveRuntimeType(overrideMethod, lhsType, bAdditive ? 43 : 45, rhsType);
            IMethodInfo mi = overrideMethod.getOverride();
            if (mi != null) {
                return mi.getCallHandler().handleCall(lhsValue, ReflectUtil.coerceArgsIfNecessary((IParameterInfo[])mi.getParameters(), (Object[])new Object[]{rhsValue}));
            }
            bNumericType = BeanAccess.isNumericType(type);
        }
        ICoercionManager cm = CommonServices.getCoercionManager();
        if (!bNumericType) return cm.makeStringFrom(lhsValue) + cm.makeStringFrom(rhsValue);
        if (lhsValue == null) {
            if (!bNullSafe) throw new NullPointerException("left-hand operand was null");
            return null;
        }
        if (rhsValue == null) {
            if (!bNullSafe) throw new NullPointerException("right-hand operand was null");
            return null;
        }
        IDimension customNumberBase = null;
        if (JavaTypes.IDIMENSION().isAssignableFrom(type)) {
            DimensionOperandResolver dimensionOperandResolver = DimensionOperandResolver.resolve(type, lhsType, lhsValue, rhsType, rhsValue);
            type = dimensionOperandResolver.getRawNumberType();
            lhsValue = dimensionOperandResolver.getLhsValue();
            rhsValue = dimensionOperandResolver.getRhsValue();
            customNumberBase = dimensionOperandResolver.getBase();
        }
        if (bAdditive) {
            if (type == JavaTypes.RATIONAL()) {
                Rational rational = cm.makeRationalFrom(lhsValue).add(cm.makeRationalFrom(rhsValue));
            } else if (type == JavaTypes.BIG_DECIMAL()) {
                BigDecimal bigDecimal = cm.makeBigDecimalFrom(lhsValue).add(cm.makeBigDecimalFrom(rhsValue));
            } else if (type == JavaTypes.BIG_INTEGER()) {
                BigInteger bigInteger = cm.makeBigIntegerFrom(lhsValue).add(cm.makeBigIntegerFrom(rhsValue));
            } else if (type == JavaTypes.INTEGER() || type == JavaTypes.pINT()) {
                Integer n = cm.makeIntegerFrom(lhsValue) + cm.makeIntegerFrom(rhsValue);
            } else if (type == JavaTypes.LONG() || type == JavaTypes.pLONG()) {
                Long l = AdditiveExpression.makeLong(cm.makeLongFrom(lhsValue) + cm.makeLongFrom(rhsValue));
            } else if (type == JavaTypes.DOUBLE() || type == JavaTypes.pDOUBLE()) {
                Double d = AdditiveExpression.makeDoubleValue(AdditiveExpression.makeDoubleValue(lhsValue) + AdditiveExpression.makeDoubleValue(rhsValue));
            } else if (type == JavaTypes.FLOAT() || type == JavaTypes.pFLOAT()) {
                Float f = Float.valueOf(AdditiveExpression.makeFloatValue(Float.valueOf(AdditiveExpression.makeFloatValue(lhsValue) + AdditiveExpression.makeFloatValue(rhsValue))));
            } else if (type == JavaTypes.SHORT() || type == JavaTypes.pSHORT()) {
                Short s = Integer.valueOf(cm.makeIntegerFrom(lhsValue) + cm.makeIntegerFrom(rhsValue)).shortValue();
            } else {
                if (type != JavaTypes.BYTE() && type != JavaTypes.pBYTE()) throw new UnsupportedNumberTypeException(type);
                Byte by = (byte)(cm.makeIntegerFrom(lhsValue) + cm.makeIntegerFrom(rhsValue));
            }
        } else if (type == JavaTypes.RATIONAL()) {
            Rational rational = cm.makeRationalFrom(lhsValue).subtract(cm.makeRationalFrom(rhsValue));
        } else if (type == JavaTypes.BIG_DECIMAL()) {
            BigDecimal bigDecimal = cm.makeBigDecimalFrom(lhsValue).subtract(cm.makeBigDecimalFrom(rhsValue));
        } else if (type == JavaTypes.BIG_INTEGER()) {
            BigInteger bigInteger = cm.makeBigIntegerFrom(lhsValue).subtract(cm.makeBigIntegerFrom(rhsValue));
        } else if (type == JavaTypes.INTEGER() || type == JavaTypes.pINT()) {
            Integer n = cm.makeIntegerFrom(lhsValue) - cm.makeIntegerFrom(rhsValue);
        } else if (type == JavaTypes.LONG() || type == JavaTypes.pLONG()) {
            Long l = AdditiveExpression.makeLong(cm.makeLongFrom(lhsValue) - cm.makeLongFrom(rhsValue));
        } else if (type == JavaTypes.DOUBLE() || type == JavaTypes.pDOUBLE()) {
            Double d = AdditiveExpression.makeDoubleValue(AdditiveExpression.makeDoubleValue(lhsValue) - AdditiveExpression.makeDoubleValue(rhsValue));
        } else if (type == JavaTypes.FLOAT() || type == JavaTypes.pFLOAT()) {
            Float f = Float.valueOf(AdditiveExpression.makeFloatValue(Float.valueOf(AdditiveExpression.makeFloatValue(lhsValue) - AdditiveExpression.makeFloatValue(rhsValue))));
        } else if (type == JavaTypes.SHORT() || type == JavaTypes.pSHORT()) {
            Short s = Integer.valueOf(cm.makeIntegerFrom(lhsValue) - cm.makeIntegerFrom(rhsValue)).shortValue();
        } else {
            if (type != JavaTypes.BYTE() && type != JavaTypes.pBYTE()) throw new UnsupportedNumberTypeException(type);
            Byte by = (byte)(cm.makeIntegerFrom(lhsValue) - cm.makeIntegerFrom(rhsValue));
        }
        if (var11_30 == null || customNumberBase == null) return var11_32;
        IDimension iDimension = customNumberBase.fromNumber((Number)var11_30);
        return var11_32;
    }
}

