/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.java.classinfo;

import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import gw.internal.gosu.parser.GenericTypeVariable;
import gw.internal.gosu.parser.TypeLord;
import gw.internal.gosu.parser.java.classinfo.IModifierList;
import gw.internal.gosu.parser.java.classinfo.JavaArrayClassInfo;
import gw.internal.gosu.parser.java.classinfo.JavaSourceAnnotationMethod;
import gw.internal.gosu.parser.java.classinfo.JavaSourceConstructor;
import gw.internal.gosu.parser.java.classinfo.JavaSourceModifierList;
import gw.internal.gosu.parser.java.classinfo.JavaSourceParameter;
import gw.internal.gosu.parser.java.classinfo.JavaSourceType;
import gw.internal.gosu.parser.java.classinfo.JavaSourceTypeVariable;
import gw.lang.parser.TypeVarToTypeMap;
import gw.lang.reflect.FunctionType;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.SimpleParameterInfo;
import gw.lang.reflect.gs.IGenericTypeVariable;
import gw.lang.reflect.java.ClassInfoUtil;
import gw.lang.reflect.java.IJavaAnnotatedElement;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.IJavaClassMethod;
import gw.lang.reflect.java.IJavaClassType;
import gw.lang.reflect.java.IJavaClassTypeVariable;
import gw.lang.reflect.java.IJavaMethodInfo;
import gw.lang.reflect.java.ITypeInfoResolver;
import gw.lang.reflect.java.JavaSourceElement;
import gw.lang.reflect.java.Parameter;
import gw.lang.reflect.module.IModule;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.element.Name;

public class JavaSourceMethod
extends JavaSourceElement
implements IJavaClassMethod,
ITypeInfoResolver {
    protected MethodTree _method;
    protected JavaSourceType _containingClass;
    protected JavaSourceParameter[] _parameters;
    protected IJavaClassType _genericReturnType;
    protected JavaSourceModifierList _modifierList;
    protected IJavaClassTypeVariable[] _typeParameters;
    protected IJavaClassType[] _genericParameterTypes;
    protected IJavaClassInfo[] _parameterTypes;
    protected IJavaClassInfo _returnType;

    public JavaSourceMethod(MethodTree method, JavaSourceType containingClass) {
        this._containingClass = containingClass;
        this._method = method;
    }

    public IJavaClassInfo getReturnClassInfo() {
        if (this._returnType == null) {
            Tree returnType = this._method.getReturnType();
            this._returnType = (IJavaClassInfo)JavaSourceType.createType(this, JavaSourceType.getTypeName(returnType), 0).getConcreteType();
            if (this._returnType == null) {
                throw new RuntimeException("Cannot compute return type.");
            }
        }
        return this._returnType;
    }

    public IJavaClassType getGenericReturnType() {
        if (this._genericReturnType == null) {
            Tree returnType = this._method.getReturnType();
            this._genericReturnType = JavaSourceType.createType(this, returnType);
            if (this._genericReturnType == null) {
                throw new RuntimeException("Cannot compute return type.");
            }
        }
        return this._genericReturnType;
    }

    public String getReturnTypeName() {
        IJavaClassType type = this.getGenericReturnType();
        if (type instanceof JavaArrayClassInfo) {
            return "[" + ((JavaArrayClassInfo)type).getComponentType().getNameSignature();
        }
        return type.getName();
    }

    public IType getReturnType() {
        return this.getReturnClassInfo().getJavaType();
    }

    public IJavaClassType[] getGenericParameterTypes() {
        if (this._genericParameterTypes == null) {
            this._genericParameterTypes = this.initGenericParameterTypes();
        }
        return this._genericParameterTypes;
    }

    public IJavaClassInfo[] getParameterTypes() {
        if (this._parameterTypes == null) {
            this._parameterTypes = this.initParameterTypes();
        }
        return this._parameterTypes;
    }

    public String getName() {
        return this._method.getName().toString();
    }

    public List<Parameter> getParameterInfos() {
        return Arrays.asList(this.getParameters());
    }

    public JavaSourceParameter[] getParameters() {
        if (this._parameters == null) {
            List<? extends VariableTree> parameters = this._method.getParameters();
            if (parameters.isEmpty()) {
                this._parameters = new JavaSourceParameter[0];
            } else {
                this._parameters = new JavaSourceParameter[parameters.size()];
                for (int i = 0; i < this._parameters.length; ++i) {
                    this._parameters[i] = new JavaSourceParameter(this, parameters.get(i));
                }
            }
        }
        return this._parameters;
    }

    public boolean isConstructor() {
        return false;
    }

    public Tree getTree() {
        return this._method;
    }

    public JavaSourceType getEnclosingClass() {
        return this._containingClass;
    }

    public int getModifiers() {
        return this.getModifierList().getModifiers();
    }

    public IModifierList getModifierList() {
        if (this._modifierList == null) {
            this._modifierList = new JavaSourceModifierList((IJavaAnnotatedElement)this, this._method.getModifiers());
        }
        return this._modifierList;
    }

    public IJavaClassInfo[] getExceptionTypes() {
        return new IJavaClassInfo[0];
    }

    public IJavaClassType resolveType(String relativeName, int ignoreFlags) {
        IJavaClassTypeVariable[] typeParameters;
        for (IJavaClassTypeVariable typeParameter : typeParameters = this.getTypeParameters()) {
            if (!relativeName.equals(typeParameter.getName())) continue;
            return typeParameter;
        }
        return this._containingClass.resolveType(relativeName, ignoreFlags);
    }

    public IJavaClassType resolveType(String relativeName, IJavaClassInfo whosAskin, int ignoreFlags) {
        return null;
    }

    public IJavaClassType resolveImport(String relativeName) {
        return null;
    }

    public IModule getModule() {
        return this._containingClass.getModule();
    }

    public String toString() {
        return this.getName() + "(...)";
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getModifierList().isAnnotationPresent(annotationClass);
    }

    public IAnnotationInfo getAnnotation(Class annotationClass) {
        return this.getModifierList().getAnnotation(annotationClass);
    }

    public IAnnotationInfo[] getDeclaredAnnotations() {
        return this.getModifierList().getAnnotations();
    }

    protected IJavaClassInfo[] initParameterTypes() {
        JavaSourceParameter[] psiParameters = this.getParameters();
        IJavaClassInfo[] paramTypes = new IJavaClassInfo[psiParameters.length];
        for (int i = 0; i < psiParameters.length; ++i) {
            paramTypes[i] = psiParameters[i].getType();
        }
        return paramTypes;
    }

    protected IJavaClassType[] initGenericParameterTypes() {
        JavaSourceParameter[] parameters = this.getParameters();
        IJavaClassType[] types = new IJavaClassType[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            JavaSourceParameter parameter = parameters[i];
            types[i] = parameter.getGenericType();
        }
        return types;
    }

    public Object getDefaultValue() {
        throw new RuntimeException("Should never be called");
    }

    public Object invoke(Object ctx, Object[] args) throws InvocationTargetException, IllegalAccessException {
        throw new RuntimeException("Not supported");
    }

    public IJavaClassTypeVariable[] getTypeParameters() {
        if (this._typeParameters == null) {
            List<? extends TypeParameterTree> typeParameters = this._method.getTypeParameters();
            if (!typeParameters.isEmpty()) {
                this._typeParameters = new IJavaClassTypeVariable[typeParameters.size()];
                for (int i = 0; i < this._typeParameters.length; ++i) {
                    this._typeParameters[i] = JavaSourceTypeVariable.create(this, typeParameters.get(i));
                }
            } else {
                this._typeParameters = JavaSourceTypeVariable.EMPTY;
            }
        }
        return this._typeParameters;
    }

    public IGenericTypeVariable[] getTypeVariables(IJavaMethodInfo mi) {
        IJavaClassTypeVariable[] rawTypeParams = this.getTypeParameters();
        FunctionType functionType = new FunctionType((IMethodInfo)mi, true);
        return GenericTypeVariable.convertTypeVars((IType)functionType, mi.getOwnersType(), rawTypeParams);
    }

    public boolean isBridge() {
        return false;
    }

    public boolean isSynthetic() {
        return false;
    }

    public static JavaSourceMethod create(MethodTree method, JavaSourceType containingClass) {
        Name name = method.getName();
        if (name == null) {
            return null;
        }
        String methodName = name.toString();
        if (methodName.equals("<init>")) {
            return new JavaSourceConstructor(method, containingClass);
        }
        if (containingClass.isAnnotation()) {
            return new JavaSourceAnnotationMethod(method, containingClass);
        }
        return new JavaSourceMethod(method, containingClass);
    }

    protected IParameterInfo[] getActualParameterInfos(IFeatureInfo container, TypeVarToTypeMap actualParamByVarName, boolean bKeepTypeVars) {
        IType[] paramTypes = ClassInfoUtil.getActualTypes((IJavaClassType[])this.getGenericParameterTypes(), (TypeVarToTypeMap)actualParamByVarName, (boolean)bKeepTypeVars);
        IParameterInfo[] paramInfos = new IParameterInfo[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            IType paramType = paramTypes[i];
            paramType = TypeLord.replaceRawGenericTypesWithDefaultParameterizedTypes(paramType);
            paramInfos[i] = new SimpleParameterInfo(container, paramType, i);
        }
        return paramInfos;
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.getParameterTypes());
        result = 31 * result + this.getReturnType().hashCode();
        result = 31 * result + this.getName().hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof IJavaClassMethod)) {
            return false;
        }
        IJavaClassMethod jcm = (IJavaClassMethod)o;
        return this.getName().equals(jcm.getName()) && this.getReturnType() == jcm.getReturnType() && Arrays.equals(this.getParameterTypes(), jcm.getParameterTypes());
    }

    public int compareTo(IJavaClassMethod o) {
        return this.getName().compareTo(o.getName());
    }
}

