/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.compiler.java;

import gw.lang.ir.IRClass;
import gw.lang.ir.IRElement;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRStatement;
import gw.lang.ir.IRSymbol;
import gw.lang.ir.IRType;
import gw.lang.ir.expression.IRArithmeticExpression;
import gw.lang.ir.expression.IRArrayLengthExpression;
import gw.lang.ir.expression.IRArrayLoadExpression;
import gw.lang.ir.expression.IRBooleanLiteral;
import gw.lang.ir.expression.IRCastExpression;
import gw.lang.ir.expression.IRCharacterLiteral;
import gw.lang.ir.expression.IRClassLiteral;
import gw.lang.ir.expression.IRCompositeExpression;
import gw.lang.ir.expression.IRConditionalAndExpression;
import gw.lang.ir.expression.IRConditionalOrExpression;
import gw.lang.ir.expression.IREqualityExpression;
import gw.lang.ir.expression.IRFieldGetExpression;
import gw.lang.ir.expression.IRIdentifier;
import gw.lang.ir.expression.IRInstanceOfExpression;
import gw.lang.ir.expression.IRLazyTypeMethodCallExpression;
import gw.lang.ir.expression.IRMethodCallExpression;
import gw.lang.ir.expression.IRNegationExpression;
import gw.lang.ir.expression.IRNewArrayExpression;
import gw.lang.ir.expression.IRNewExpression;
import gw.lang.ir.expression.IRNewMultiDimensionalArrayExpression;
import gw.lang.ir.expression.IRNoOpExpression;
import gw.lang.ir.expression.IRNotExpression;
import gw.lang.ir.expression.IRNullLiteral;
import gw.lang.ir.expression.IRNumericLiteral;
import gw.lang.ir.expression.IRPrimitiveTypeConversion;
import gw.lang.ir.expression.IRRelationalExpression;
import gw.lang.ir.expression.IRStringLiteralExpression;
import gw.lang.ir.expression.IRTernaryExpression;
import gw.lang.ir.statement.IRArrayStoreStatement;
import gw.lang.ir.statement.IRAssignmentStatement;
import gw.lang.ir.statement.IRBreakStatement;
import gw.lang.ir.statement.IRCaseClause;
import gw.lang.ir.statement.IRCatchClause;
import gw.lang.ir.statement.IRContinueStatement;
import gw.lang.ir.statement.IRDoWhileStatement;
import gw.lang.ir.statement.IREvalStatement;
import gw.lang.ir.statement.IRFieldDecl;
import gw.lang.ir.statement.IRFieldSetStatement;
import gw.lang.ir.statement.IRForEachStatement;
import gw.lang.ir.statement.IRIfStatement;
import gw.lang.ir.statement.IRMethodCallStatement;
import gw.lang.ir.statement.IRMethodStatement;
import gw.lang.ir.statement.IRMonitorLockAcquireStatement;
import gw.lang.ir.statement.IRMonitorLockReleaseStatement;
import gw.lang.ir.statement.IRNewStatement;
import gw.lang.ir.statement.IRNoOpStatement;
import gw.lang.ir.statement.IRReturnStatement;
import gw.lang.ir.statement.IRStatementList;
import gw.lang.ir.statement.IRSwitchStatement;
import gw.lang.ir.statement.IRSyntheticStatement;
import gw.lang.ir.statement.IRThrowStatement;
import gw.lang.ir.statement.IRTryCatchFinallyStatement;
import gw.lang.ir.statement.IRWhileStatement;
import java.lang.reflect.Modifier;
import java.util.List;

public class IRJavaCompiler {
    private StringBuilder _output = new StringBuilder();
    private int _indent;
    static final int BRIDGE = 64;
    static final int VARARGS = 128;
    static final int SYNTHETIC = 4096;
    static final int ANNOTATION = 8192;
    static final int ENUM = 16384;

    public StringBuilder getOutput() {
        return this._output;
    }

    public void compileClassStatement(IRClass irClass) {
        this._output.append("// Compiled from ").append(irClass.getSourceFile()).append("\n");
        this._output.append(this.getModifierString(irClass.getModifiers())).append(irClass.getName());
        if (irClass.getSuperType() != null) {
            this._output.append(" extends ").append(irClass.getSuperType().getRelativeName());
        }
        if (!irClass.getInterfaces().isEmpty()) {
            this._output.append(" implements ").append(this.joinTypeNames(irClass.getInterfaces()));
            this._output.append(" ");
        }
        this._output.append("{\n");
        this.pushIndent();
        for (IRFieldDecl fieldDecl : irClass.getFields()) {
            this.compileIRFieldDecl(fieldDecl);
        }
        this._output.append("\n");
        for (IRMethodStatement methodStatement : irClass.getMethods()) {
            this.compileIRMethodStatement(methodStatement);
            this._output.append("\n");
        }
        this.popIndent();
        this._output.append("}");
    }

    private void compileIRElement(IRElement element) {
        if (element instanceof IRStatement) {
            this.compileIRStatement((IRStatement)element);
        } else {
            this.compileIRExpression((IRExpression)element);
        }
    }

    private void compileIRStatement(IRStatement statement) {
        if (statement == null) {
            return;
        }
        if (statement.getOriginalSourceStatement() != null) {
            this.appendOriginalSourceComment(statement.getOriginalSourceStatement());
        }
        if (statement instanceof IRAssignmentStatement) {
            this.compileIRAssignmentStatement((IRAssignmentStatement)statement);
        } else if (statement instanceof IRFieldDecl) {
            this.compileIRFieldDecl((IRFieldDecl)statement);
        } else if (statement instanceof IRFieldSetStatement) {
            this.compileIRFieldSetStatement((IRFieldSetStatement)statement);
        } else if (statement instanceof IRIfStatement) {
            this.compileIRIfStatement((IRIfStatement)statement);
        } else if (statement instanceof IRMethodCallStatement) {
            this.compileIRMethodCallStatement((IRMethodCallStatement)statement);
        } else if (statement instanceof IRNewStatement) {
            this.compileIRNewStatement((IRNewStatement)statement);
        } else if (statement instanceof IRMethodStatement) {
            this.compileIRMethodStatement((IRMethodStatement)statement);
        } else if (statement instanceof IRNoOpStatement) {
            this.compileIRNoOpStatement((IRNoOpStatement)statement);
        } else if (statement instanceof IRReturnStatement) {
            this.compileIRReturnStatement((IRReturnStatement)statement);
        } else if (statement instanceof IRStatementList) {
            this.compileIRStatementList((IRStatementList)statement);
        } else if (statement instanceof IRArrayStoreStatement) {
            this.compileIRArrayStoreStatement((IRArrayStoreStatement)statement);
        } else if (statement instanceof IRThrowStatement) {
            this.compileIRThrowStatement((IRThrowStatement)statement);
        } else if (statement instanceof IRTryCatchFinallyStatement) {
            this.compileIRTryCatchFinallyStatement((IRTryCatchFinallyStatement)statement);
        } else if (statement instanceof IRSyntheticStatement) {
            this.compileIRSyntheticStatement((IRSyntheticStatement)statement);
        } else if (statement instanceof IRWhileStatement) {
            this.compileIRWhileStatement((IRWhileStatement)statement);
        } else if (statement instanceof IRDoWhileStatement) {
            this.compileIRDoWhileStatement((IRDoWhileStatement)statement);
        } else if (statement instanceof IRForEachStatement) {
            this.compileIRForEachStatement((IRForEachStatement)statement);
        } else if (statement instanceof IRSwitchStatement) {
            this.compileIRSwitchStatement((IRSwitchStatement)statement);
        } else if (statement instanceof IRBreakStatement) {
            this.compileIRBreak((IRBreakStatement)statement);
        } else if (statement instanceof IRContinueStatement) {
            this.compileIRContinue((IRContinueStatement)statement);
        } else if (statement instanceof IREvalStatement) {
            this.compileIREvalStatement((IREvalStatement)statement);
        } else if (statement instanceof IRMonitorLockAcquireStatement) {
            this.compileIRMonitorLockAcquireStatement((IRMonitorLockAcquireStatement)statement);
        } else if (statement instanceof IRMonitorLockReleaseStatement) {
            this.compileIRMonitorLockReleaseStatement((IRMonitorLockReleaseStatement)statement);
        } else {
            throw new IllegalArgumentException("Unrecognized statement of type " + statement.getClass());
        }
    }

    private void compileIREvalStatement(IREvalStatement statement) {
        this.appendIndent();
        this._output.append("eval( ");
        this.compileIRElement((IRElement)statement.getExpression());
        this._output.append(" )");
    }

    private void compileIRDoWhileStatement(IRDoWhileStatement irDoWhileStatement) {
        this.appendIndent();
        this._output.append("do {\n");
        this.pushIndent();
        this.compileIRElement((IRElement)irDoWhileStatement.getBody());
        this.popIndent();
        this.appendIndent();
        this._output.append("} while (");
        this.compileIRElement((IRElement)irDoWhileStatement.getLoopTest());
        this._output.append(")\n");
    }

    private void compileIRBreak(IRBreakStatement irBreakStatement) {
        this.appendIndent();
        this._output.append("break;");
    }

    private void compileIRContinue(IRContinueStatement irBreakStatement) {
        this.appendIndent();
        this._output.append("continue;");
    }

    private void compileIRMonitorLockAcquireStatement(IRMonitorLockAcquireStatement irMonitorLockAcquireStatement) {
        this.appendIndent();
        this._output.append("synchronized( ");
        this.compileIRElement((IRElement)irMonitorLockAcquireStatement.getMonitoredObject());
        this._output.append(" )");
    }

    private void compileIRMonitorLockReleaseStatement(IRMonitorLockReleaseStatement irMonitorLockReleaseStatement) {
    }

    private void compileIRSwitchStatement(IRSwitchStatement irSwitchStatement) {
        this.appendIndent();
        this._output.append("switch(");
        this.compileIRElement((IRElement)irSwitchStatement.getInit());
        this._output.append(") {\n");
        this.pushIndent();
        for (IRCaseClause caseClause : irSwitchStatement.getCases()) {
            this.appendIndent();
            this._output.append("case ");
            this.compileIRElement((IRElement)caseClause.getCondition());
            this._output.append(":\n");
            this.pushIndent();
            for (IRStatement statement : caseClause.getStatements()) {
                this.compileIRElement((IRElement)statement);
            }
            this.popIndent();
        }
        if (!irSwitchStatement.getDefaultStatements().isEmpty()) {
            this.appendIndent();
            this._output.append("default:\n");
            this.pushIndent();
            for (IRStatement statement : irSwitchStatement.getDefaultStatements()) {
                this.compileIRElement((IRElement)statement);
            }
            this.popIndent();
        }
        this.popIndent();
        this.appendIndent();
        this._output.append("}\n");
    }

    private void compileIRForEachStatement(IRForEachStatement irForEachStatement) {
        this.appendIndent();
        this._output.append("/*foreach*/\n");
        for (IRStatement initializer : irForEachStatement.getInitializers()) {
            this.appendIndent();
            this.compileIRElement((IRElement)initializer);
            this._output.append("\n");
        }
        if (irForEachStatement.hasIdentifierToNullCheck()) {
            this.appendIndent();
            this._output.append("if (").append(irForEachStatement.getIdentifierToNullCheck().getSymbol().getName()).append(" != null) {\n");
            this.pushIndent();
        }
        this.appendIndent();
        this._output.append("while (");
        this.compileIRElement((IRElement)irForEachStatement.getLoopTest());
        this._output.append(") {\n");
        this.pushIndent();
        for (IRStatement initializer : irForEachStatement.getIncrementors()) {
            this.compileIRElement((IRElement)initializer);
            this._output.append("\n");
        }
        this.compileIRElement((IRElement)irForEachStatement.getBody());
        this.popIndent();
        this.appendIndent();
        this._output.append("}\n");
        if (irForEachStatement.hasIdentifierToNullCheck()) {
            this.popIndent();
            this.appendIndent();
            this._output.append("}\n");
        }
    }

    private void compileIRWhileStatement(IRWhileStatement irWhileStatement) {
        this.appendIndent();
        this._output.append("while (");
        this.compileIRElement((IRElement)irWhileStatement.getLoopTest());
        this._output.append(") {\n");
        this.pushIndent();
        this.compileIRElement((IRElement)irWhileStatement.getBody());
        this.popIndent();
        this.appendIndent();
        this._output.append("}\n");
    }

    private void compileIRSyntheticStatement(IRSyntheticStatement irSyntheticStatement) {
        this.appendIndent();
        this.compileIRElement((IRElement)irSyntheticStatement.getExpression());
        this._output.append(";\n");
    }

    private void compileIRTryCatchFinallyStatement(IRTryCatchFinallyStatement irTryCatchFinallyStatement) {
        this.appendIndent();
        this._output.append("try {\n");
        this.pushIndent();
        this.compileIRElement((IRElement)irTryCatchFinallyStatement.getTryBody());
        this.popIndent();
        this.appendIndent();
        this._output.append("}\n");
        for (IRCatchClause catchClause : irTryCatchFinallyStatement.getCatchStatements()) {
            this.appendIndent();
            this._output.append("catch( ").append(catchClause.getIdentifier().getType().getRelativeName()).append(" ").append(catchClause.getIdentifier().getName()).append(") {\n");
            this.pushIndent();
            this.compileIRElement((IRElement)catchClause.getBody());
            this.popIndent();
            this.appendIndent();
            this._output.append("}\n");
        }
        if (irTryCatchFinallyStatement.getFinallyBody() != null) {
            this.appendIndent();
            this._output.append("finally {\n");
            this.pushIndent();
            this.compileIRElement((IRElement)irTryCatchFinallyStatement.getFinallyBody());
            this.popIndent();
            this.appendIndent();
            this._output.append("}\n");
        }
    }

    private void compileIRThrowStatement(IRThrowStatement irThrowStatement) {
        this.appendIndent();
        this._output.append("throw ");
        this.compileIRElement((IRElement)irThrowStatement.getException());
        this._output.append(";\n");
    }

    private void compileIRArrayStoreStatement(IRArrayStoreStatement irArrayStoreStatement) {
        this.appendIndent();
        this.compileIRElement((IRElement)irArrayStoreStatement.getTarget());
        this._output.append("[");
        this.compileIRElement((IRElement)irArrayStoreStatement.getIndex());
        this._output.append("] = ");
        this.compileIRElement((IRElement)irArrayStoreStatement.getValue());
        this._output.append(";\n");
    }

    private void compileIRFieldSetStatement(IRFieldSetStatement irFieldSetStatement) {
        this.appendIndent();
        if (irFieldSetStatement.getLhs() == null) {
            this._output.append(irFieldSetStatement.getOwnersType().getRelativeName());
        } else {
            this.compileIRElement((IRElement)irFieldSetStatement.getLhs());
        }
        this._output.append(".");
        this._output.append(irFieldSetStatement.getName());
        this._output.append(" = ");
        this.compileIRElement((IRElement)irFieldSetStatement.getRhs());
        this._output.append(";\n");
    }

    private void compileIRIfStatement(IRIfStatement irIfStatement) {
        this.appendIndent();
        this._output.append("if (");
        this.compileIRElement((IRElement)irIfStatement.getExpression());
        this._output.append(") {\n");
        this.pushIndent();
        this.compileIRElement((IRElement)irIfStatement.getIfStatement());
        this.popIndent();
        this.appendIndent();
        this._output.append("}");
        if (irIfStatement.getElseStatement() != null) {
            this._output.append(" else {\n");
            this.pushIndent();
            this.compileIRElement((IRElement)irIfStatement.getElseStatement());
            this.popIndent();
            this.appendIndent();
            this._output.append("}");
        }
        this._output.append("\n");
    }

    private void compileIRMethodCallStatement(IRMethodCallStatement irMethodCallStatement) {
        this.appendIndent();
        this.compileIRElement((IRElement)irMethodCallStatement.getExpression());
        this._output.append(";\n");
    }

    private void compileIRNewStatement(IRNewStatement irNewExpr) {
        this.appendIndent();
        this.compileIRElement((IRElement)irNewExpr.getNewExpression());
        this._output.append(";\n");
    }

    private void compileIRNoOpStatement(IRNoOpStatement irNoOpStatement) {
        this._output.append("\n");
    }

    private void compileIRReturnStatement(IRReturnStatement irReturnStatement) {
        this.appendIndent();
        this._output.append("return");
        if (irReturnStatement.getReturnValue() != null) {
            this._output.append(" ");
            this.compileIRElement((IRElement)irReturnStatement.getReturnValue());
        }
        this._output.append(";\n");
    }

    private void compileIRStatementList(IRStatementList irStatementList) {
        for (IRStatement statement : irStatementList.getStatements()) {
            this.compileIRStatement(statement);
        }
    }

    private void compileIRAssignmentStatement(IRAssignmentStatement irAssignmentStatement) {
        this.appendIndent();
        this._output.append(irAssignmentStatement.getSymbol().getName());
        this._output.append(" = ");
        this.compileIRElement((IRElement)irAssignmentStatement.getValue());
        this._output.append(";\n");
    }

    private void compileIRExpression(IRExpression expression) {
        if (expression instanceof IRArithmeticExpression) {
            this.compileIRAdditiveExpression((IRArithmeticExpression)expression);
        } else if (expression instanceof IRArrayLoadExpression) {
            this.compileIRArrayLoadExpression((IRArrayLoadExpression)expression);
        } else if (expression instanceof IRBooleanLiteral) {
            this.compileIRBooleanLiteral((IRBooleanLiteral)expression);
        } else if (expression instanceof IRCompositeExpression) {
            this.compileIRCompositeExpression((IRCompositeExpression)expression);
        } else if (expression instanceof IREqualityExpression) {
            this.compileIREqualityExpression((IREqualityExpression)expression);
        } else if (expression instanceof IRFieldGetExpression) {
            this.compileIRFieldGetExpression((IRFieldGetExpression)expression);
        } else if (expression instanceof IRIdentifier) {
            this.compileIRIdentifier((IRIdentifier)expression);
        } else if (expression instanceof IRMethodCallExpression) {
            this.compileIRMethodCallExpression((IRMethodCallExpression)expression);
        } else if (expression instanceof IRLazyTypeMethodCallExpression) {
            this.compileIRLazyTypeMethodCallExpression((IRLazyTypeMethodCallExpression)expression);
        } else if (expression instanceof IRNullLiteral) {
            this.compileIRNullLiteral((IRNullLiteral)expression);
        } else if (expression instanceof IRPrimitiveTypeConversion) {
            this.compileIRPrimitiveTypeConversion((IRPrimitiveTypeConversion)expression);
        } else if (expression instanceof IRTernaryExpression) {
            this.compileIRTernaryExpression((IRTernaryExpression)expression);
        } else if (expression instanceof IRNumericLiteral) {
            this.compileIRNumericLiteral((IRNumericLiteral)expression);
        } else if (expression instanceof IRStringLiteralExpression) {
            this.compileIRStringLiteralExpression((IRStringLiteralExpression)expression);
        } else if (expression instanceof IRNewArrayExpression) {
            this.compileIRNewArrayExpression((IRNewArrayExpression)expression);
        } else if (expression instanceof IRNewMultiDimensionalArrayExpression) {
            this.compileIRNewMultiDimenstionalArrayExpression((IRNewMultiDimensionalArrayExpression)expression);
        } else if (expression instanceof IRArrayLengthExpression) {
            this.compileIRArrayLengthExpression((IRArrayLengthExpression)expression);
        } else if (expression instanceof IRCastExpression) {
            this.compileIRCastExpression((IRCastExpression)expression);
        } else if (expression instanceof IRNewExpression) {
            this.compileIRNewExpression((IRNewExpression)expression);
        } else if (expression instanceof IRRelationalExpression) {
            this.compileIRRelationalExpression((IRRelationalExpression)expression);
        } else if (expression instanceof IRClassLiteral) {
            this.compileIRClassLiteral((IRClassLiteral)expression);
        } else if (expression instanceof IRNegationExpression) {
            this.compileIRNegationExpression((IRNegationExpression)expression);
        } else if (expression instanceof IRConditionalOrExpression) {
            this.compileIRConditionalOrExpression((IRConditionalOrExpression)expression);
        } else if (expression instanceof IRConditionalAndExpression) {
            this.compileIRConditionalAndExpression((IRConditionalAndExpression)expression);
        } else if (expression instanceof IRNotExpression) {
            this.compileIRNotExpression((IRNotExpression)expression);
        } else if (expression instanceof IRInstanceOfExpression) {
            this.compileIRInstanceOfExpression((IRInstanceOfExpression)expression);
        } else if (expression instanceof IRCharacterLiteral) {
            this.compileIRCharacterLiteral((IRCharacterLiteral)expression);
        } else if (!(expression instanceof IRNoOpExpression)) {
            throw new IllegalArgumentException("Unrecognized expression of type " + expression.getClass());
        }
    }

    private void compileIRInstanceOfExpression(IRInstanceOfExpression irInstanceOfExpression) {
        this._output.append("(");
        this.compileIRElement((IRElement)irInstanceOfExpression.getRoot());
        this._output.append(" instanceof ");
        this._output.append(irInstanceOfExpression.getTestType().getRelativeName());
        this._output.append(")");
    }

    private void compileIRNotExpression(IRNotExpression irNotExpression) {
        this._output.append("!(");
        this.compileIRElement((IRElement)irNotExpression.getRoot());
        this._output.append(")");
    }

    private void compileIRConditionalAndExpression(IRConditionalAndExpression irConditionalAndExpression) {
        this._output.append("(");
        this.compileIRElement((IRElement)irConditionalAndExpression.getLhs());
        this._output.append(" && ");
        this.compileIRElement((IRElement)irConditionalAndExpression.getRhs());
        this._output.append(")");
    }

    private void compileIRConditionalOrExpression(IRConditionalOrExpression irConditionalOrExpression) {
        this._output.append("(");
        this.compileIRElement((IRElement)irConditionalOrExpression.getLhs());
        this._output.append(" || ");
        this.compileIRElement((IRElement)irConditionalOrExpression.getRhs());
        this._output.append(")");
    }

    private void compileIRNegationExpression(IRNegationExpression irNegationExpression) {
        this._output.append("-");
        this.compileIRElement((IRElement)irNegationExpression.getRoot());
    }

    private void compileIRClassLiteral(IRClassLiteral irClassLiteral) {
        this._output.append(irClassLiteral.getLiteralType().getName()).append(".class");
    }

    private void compileIRRelationalExpression(IRRelationalExpression irRelationalExpression) {
        String op;
        switch (irRelationalExpression.getOp()) {
            case GT: {
                op = " > ";
                break;
            }
            case GTE: {
                op = " >= ";
                break;
            }
            case LT: {
                op = " < ";
                break;
            }
            case LTE: {
                op = " <= ";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected operation " + irRelationalExpression.getOp());
            }
        }
        this.compileIRElement((IRElement)irRelationalExpression.getLhs());
        this._output.append(op);
        this.compileIRElement((IRElement)irRelationalExpression.getRhs());
    }

    private void compileIRNewExpression(IRNewExpression irNewExpression) {
        this._output.append("new " + irNewExpression.getOwnersType().getRelativeName() + "(");
        for (int i = 0; i < irNewExpression.getArgs().size(); ++i) {
            if (i > 0) {
                this._output.append(", ");
            }
            this.compileIRElement((IRElement)irNewExpression.getArgs().get(i));
        }
        this._output.append(")");
    }

    private void compileIRCastExpression(IRCastExpression irCastExpression) {
        this._output.append("((").append(irCastExpression.getType().getRelativeName()).append(") ");
        this.compileIRElement((IRElement)irCastExpression.getRoot());
        this._output.append(")");
    }

    private void compileIRNewArrayExpression(IRNewArrayExpression irNewArrayExpression) {
        this._output.append("new ").append(irNewArrayExpression.getComponentType().getRelativeName()).append("[");
        this.compileIRElement((IRElement)irNewArrayExpression.getSizeExpression());
        this._output.append("]");
    }

    private void compileIRNewMultiDimenstionalArrayExpression(IRNewMultiDimensionalArrayExpression expr) {
        this._output.append("new ").append(expr.getResultType().getRelativeName());
        for (IRExpression e : expr.getSizeExpressions()) {
            this._output.append("[");
            this.compileIRElement((IRElement)e);
            this._output.append("]");
        }
    }

    private void compileIRArrayLengthExpression(IRArrayLengthExpression irNewArrayExpression) {
        this.compileIRElement((IRElement)irNewArrayExpression.getRoot());
        this._output.append(".length");
    }

    private void compileIRStringLiteralExpression(IRStringLiteralExpression irStringLiteralExpression) {
        this._output.append("\"").append(irStringLiteralExpression.getValue()).append("\"");
    }

    private void compileIRCharacterLiteral(IRCharacterLiteral irCharacterLiteral) {
        this._output.append('\'');
        char literal = irCharacterLiteral.getValue();
        if (literal == '\'' || literal == '\\') {
            this._output.append('\\');
        }
        this._output.append(literal);
        this._output.append('\'');
    }

    private void compileIRNumericLiteral(IRNumericLiteral irNumericLiteral) {
        this._output.append(irNumericLiteral.getValue());
    }

    private void compileIRAdditiveExpression(IRArithmeticExpression irAdditiveExpression) {
        this.compileIRElement((IRElement)irAdditiveExpression.getLhs());
        switch (irAdditiveExpression.getOp()) {
            case Addition: {
                this._output.append(" + ");
                break;
            }
            case Subtraction: {
                this._output.append(" - ");
                break;
            }
            case Division: {
                this._output.append(" / ");
                break;
            }
            case Multiplication: {
                this._output.append(" * ");
                break;
            }
            case Remainder: {
                this._output.append(" % ");
                break;
            }
            case ShiftLeft: {
                this._output.append(" << ");
                break;
            }
            case ShiftRight: {
                this._output.append(" >> ");
                break;
            }
            case UnsignedShiftRight: {
                this._output.append(" >>> ");
                break;
            }
            case BitwiseAnd: {
                this._output.append(" & ");
                break;
            }
            case BitwiseXor: {
                this._output.append(" ^ ");
                break;
            }
            case BitwiseOr: {
                this._output.append(" | ");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected operation " + irAdditiveExpression.getOp().toString());
            }
        }
        this.compileIRElement((IRElement)irAdditiveExpression.getRhs());
    }

    private void compileIRArrayLoadExpression(IRArrayLoadExpression irArrayLoadExpression) {
        this.compileIRElement((IRElement)irArrayLoadExpression.getRoot());
        this._output.append("[");
        this.compileIRElement((IRElement)irArrayLoadExpression.getIndex());
        this._output.append("]");
    }

    private void compileIRBooleanLiteral(IRBooleanLiteral irBooleanLiteral) {
        this._output.append(irBooleanLiteral.getValue());
    }

    private void compileIRCompositeExpression(IRCompositeExpression irCompositeExpression) {
        this._output.append("[[\n");
        this.pushIndent();
        for (IRElement element : irCompositeExpression.getElements()) {
            if (element instanceof IRExpression) {
                this.appendIndent();
            }
            this.compileIRElement(element);
        }
        this._output.append("\n");
        this.popIndent();
        this.appendIndent();
        this._output.append("]]");
    }

    private void compileIREqualityExpression(IREqualityExpression irEqualityExpression) {
        this.compileIRExpression(irEqualityExpression.getLhs());
        this._output.append(irEqualityExpression.isEquals() ? " == " : " != ");
        this.compileIRExpression(irEqualityExpression.getRhs());
    }

    private void compileIRFieldGetExpression(IRFieldGetExpression irFieldGetExpression) {
        if (irFieldGetExpression.getLhs() == null) {
            this._output.append(irFieldGetExpression.getOwnersType().getRelativeName());
        } else {
            this.compileIRElement((IRElement)irFieldGetExpression.getLhs());
        }
        this._output.append(".");
        this._output.append(irFieldGetExpression.getName());
    }

    private void compileIRIdentifier(IRIdentifier irIdentifier) {
        this._output.append(irIdentifier.getSymbol().getName());
    }

    private void compileIRMethodCallExpression(IRMethodCallExpression irMethodCallExpression) {
        if (irMethodCallExpression.getRoot() == null) {
            this._output.append(irMethodCallExpression.getOwnersType().getRelativeName());
        } else {
            this.compileIRExpression(irMethodCallExpression.getRoot());
        }
        this._output.append(".");
        this._output.append(irMethodCallExpression.getName());
        this._output.append("(");
        for (int i = 0; i < irMethodCallExpression.getArgs().size(); ++i) {
            if (i > 0) {
                this._output.append(", ");
            }
            this.compileIRElement((IRElement)irMethodCallExpression.getArgs().get(i));
        }
        this._output.append(")");
    }

    private void compileIRLazyTypeMethodCallExpression(IRLazyTypeMethodCallExpression irMethodCallExpression) {
        this._output.append(irMethodCallExpression.getOwnerTypeName()).append('.').append(irMethodCallExpression.getName());
    }

    private void compileIRNullLiteral(IRNullLiteral irNullLiteral) {
        this._output.append("null");
    }

    private void compileIRPrimitiveTypeConversion(IRPrimitiveTypeConversion irPrimitiveTypeConversion) {
        this._output.append("(").append(irPrimitiveTypeConversion.getToType().getRelativeName()).append(") ");
        this.compileIRElement((IRElement)irPrimitiveTypeConversion.getRoot());
    }

    private void compileIRTernaryExpression(IRTernaryExpression irTernaryExpression) {
        this._output.append("(");
        this.compileIRElement((IRElement)irTernaryExpression.getTest());
        this._output.append(" ? ");
        this.compileIRElement((IRElement)irTernaryExpression.getTrueValue());
        this._output.append(" : ");
        this.compileIRElement((IRElement)irTernaryExpression.getFalseValue());
        this._output.append(")");
    }

    private void compileIRFieldDecl(IRFieldDecl fieldDecl) {
        this.appendIndent();
        this._output.append(this.getModifierString(fieldDecl.getModifiers())).append(fieldDecl.getType().getRelativeName()).append(" ").append(fieldDecl.getName());
        if (fieldDecl.getValue() != null) {
            this._output.append(" = ").append(fieldDecl.getValue());
        }
        this._output.append(";\n");
    }

    private void compileIRMethodStatement(IRMethodStatement methodStatement) {
        this.appendIndent();
        this._output.append(this.getModifierString(methodStatement.getModifiers()));
        this._output.append(methodStatement.getReturnType().getRelativeName()).append(" ");
        this._output.append(methodStatement.getName());
        this._output.append("(");
        this._output.append(this.joinParameters(methodStatement.getParameters()));
        this._output.append(") {\n");
        this.pushIndent();
        this.compileIRStatement(methodStatement.getMethodBody());
        this.popIndent();
        this.appendIndent();
        this._output.append("}\n");
    }

    private String getModifierString(int modifiers) {
        StringBuilder sb = new StringBuilder();
        if (Modifier.isPublic(modifiers)) {
            sb.append("public ");
        } else if (Modifier.isPrivate(modifiers)) {
            sb.append("private ");
        } else if (Modifier.isProtected(modifiers)) {
            sb.append("protected ");
        } else {
            sb.append("internal ");
        }
        if (Modifier.isAbstract(modifiers)) {
            sb.append("abstract ");
        }
        if (Modifier.isFinal(modifiers)) {
            sb.append("final ");
        }
        if (Modifier.isInterface(modifiers)) {
            sb.append("interface ");
        }
        if (Modifier.isNative(modifiers)) {
            sb.append("native ");
        }
        if (Modifier.isStatic(modifiers)) {
            sb.append("static ");
        }
        if (Modifier.isTransient(modifiers)) {
            sb.append("transient ");
        }
        if (Modifier.isVolatile(modifiers)) {
            sb.append("volatile ");
        }
        if ((modifiers & 0x40) != 0) {
            sb.append("bridge ");
        }
        if ((modifiers & 0x80) != 0) {
            sb.append("varargs ");
        }
        if ((modifiers & 0x1000) != 0) {
            sb.append("synthetic ");
        }
        if ((modifiers & 0x2000) != 0) {
            sb.append("annotation ");
        }
        if ((modifiers & 0x4000) != 0) {
            sb.append("enum ");
        }
        return sb.toString();
    }

    private String joinTypeNames(List<IRType> types) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < types.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(types.get(i).getRelativeName());
        }
        return sb.toString();
    }

    private String joinParameters(List<IRSymbol> symbols) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < symbols.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(symbols.get(i).getType().getRelativeName()).append(" ").append(symbols.get(i).getName());
        }
        return sb.toString();
    }

    private void pushIndent() {
        this._indent += 2;
    }

    private void popIndent() {
        this._indent -= 2;
    }

    private void appendIndent() {
        for (int i = 0; i < this._indent; ++i) {
            this._output.append(" ");
        }
    }

    private void appendOriginalSourceComment(String originalSource) {
    }
}

