/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform;

import gw.internal.gosu.ir.nodes.IRMethod;
import gw.internal.gosu.ir.nodes.IRMethodFactory;
import gw.internal.gosu.ir.transform.AbstractElementTransformer;
import gw.internal.gosu.ir.transform.ExpressionTransformer;
import gw.internal.gosu.ir.transform.GosuFragmentTransformationContext;
import gw.internal.gosu.ir.transform.StatementTransformer;
import gw.internal.gosu.parser.Statement;
import gw.internal.gosu.parser.expressions.ImplicitTypeAsExpression;
import gw.internal.gosu.parser.fragments.GosuFragment;
import gw.internal.gosu.parser.statements.ReturnStatement;
import gw.internal.gosu.parser.statements.ThrowStatement;
import gw.lang.ir.IRClass;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRStatement;
import gw.lang.ir.IRSymbol;
import gw.lang.ir.IRType;
import gw.lang.ir.IRTypeConstants;
import gw.lang.ir.SyntheticIRType;
import gw.lang.ir.statement.IRMethodCallStatement;
import gw.lang.ir.statement.IRMethodStatement;
import gw.lang.ir.statement.IRReturnStatement;
import gw.lang.ir.statement.IRStatementList;
import gw.lang.ir.statement.IRSyntheticStatement;
import gw.lang.parser.IExpression;
import gw.lang.parser.expressions.IMemberAccessExpression;
import gw.lang.parser.expressions.IParenthesizedExpression;
import gw.lang.parser.expressions.IProgram;
import gw.lang.parser.statements.ITerminalStatement;
import gw.lang.reflect.gs.FragmentInstance;
import gw.lang.reflect.gs.IExternalSymbolMap;
import gw.lang.reflect.java.JavaTypes;
import java.util.ArrayList;
import java.util.Collections;

public class GosuFragmentTransformer
extends AbstractElementTransformer<IExpression> {
    public static final String SYMBOLS_PARAM_NAME = "$symbols$";
    public static final String SYMBOLS_PARAM_ARG_NAME = "$symbols$arg";
    private GosuFragment _fragment;
    private GosuFragmentTransformationContext _context;
    private SyntheticIRType _irType;

    public GosuFragmentTransformer(GosuFragment fragment) {
        super(null, null);
        this._fragment = fragment;
        this._irType = new SyntheticIRType(FragmentInstance.class, fragment.getName(), fragment.getRelativeName());
        this._context = new GosuFragmentTransformationContext(this._fragment, (IRType)this._irType, fragment.getName(), false);
        this.setCc(this._context);
    }

    public static IRClass transform(GosuFragment fragment) {
        return new GosuFragmentTransformer(fragment).transform();
    }

    private IRClass transform() {
        IRClass irClass = new IRClass();
        this._cc().setIrClass(irClass);
        this.addHeader(irClass);
        this.addDefaultConstructor(irClass);
        this.addEvaluateMethod(irClass);
        this.addEvaluateRootMethod(irClass);
        return irClass;
    }

    private void addHeader(IRClass irClass) {
        irClass.setName(this._fragment.getName());
        irClass.setThisType((IRType)this._irType);
        irClass.setModifiers(49);
        irClass.setSuperType(GosuFragmentTransformer.getDescriptor(FragmentInstance.class));
    }

    private void addDefaultConstructor(IRClass irClass) {
        this._context.initBodyContext(false);
        this._context.pushScope(true);
        ArrayList<Object> statements = new ArrayList<Object>();
        IRMethod irMethod = IRMethodFactory.createConstructorIRMethod(this._cc().getSuperType(), new IRType[0]);
        statements.add(new IRMethodCallStatement(this.callSpecialMethod(GosuFragmentTransformer.getDescriptor(this._cc().getSuperType()), irMethod, this.pushThis(), Collections.emptyList())));
        statements.add(new IRReturnStatement());
        IRMethodStatement methodStatement = new IRMethodStatement((IRStatement)new IRStatementList(true, statements), "<init>", 1, false, IRTypeConstants.pVOID(), Collections.emptyList());
        irClass.addMethod(methodStatement);
    }

    private void addEvaluateMethod(IRClass irClass) {
        IRSymbol symbolsParam = new IRSymbol(SYMBOLS_PARAM_NAME, GosuFragmentTransformer.getDescriptor(IExternalSymbolMap.class), false);
        this._context.initBodyContext(false);
        this._context.pushScope(true);
        this._context.putSymbol(symbolsParam);
        ArrayList<Object> statements = new ArrayList<Object>();
        IExpression expression = this._fragment.getExpression();
        if (expression instanceof IProgram) {
            Statement mainStatement = (Statement)((IProgram)expression).getMainStatement();
            statements.add(StatementTransformer.compile(this._context, mainStatement));
            boolean[] bAbsolute = new boolean[]{false};
            ITerminalStatement terminalStmt = mainStatement.getLeastSignificantTerminalStatement(bAbsolute);
            if (!bAbsolute[0] || !(terminalStmt instanceof ReturnStatement) && !(terminalStmt instanceof ThrowStatement)) {
                statements.add(new IRReturnStatement(null, this.nullLiteral()));
            }
        } else if (expression.getType().equals(JavaTypes.pVOID())) {
            statements.add(new IRSyntheticStatement(ExpressionTransformer.compile(expression, this._context)));
            statements.add(new IRReturnStatement(null, this.nullLiteral()));
        } else {
            IRExpression returnValue = ExpressionTransformer.compile(expression, this._context);
            if (returnValue.getType().isPrimitive()) {
                returnValue = this.boxValue(returnValue.getType(), returnValue);
            }
            statements.add(new IRReturnStatement(null, returnValue));
        }
        IRMethodStatement methodStatement = new IRMethodStatement((IRStatement)new IRStatementList(true, statements), "evaluate", 1, false, IRTypeConstants.OBJECT(), Collections.singletonList(symbolsParam));
        irClass.addMethod(methodStatement);
    }

    private void addEvaluateRootMethod(IRClass irClass) {
        IExpression expr = this.maybeUnwrap(this._fragment.getExpression());
        if (expr instanceof IMemberAccessExpression) {
            IRSymbol symbolsParam = new IRSymbol(SYMBOLS_PARAM_NAME, GosuFragmentTransformer.getDescriptor(IExternalSymbolMap.class), false);
            this._context.initBodyContext(false);
            this._context.pushScope(true);
            this._context.putSymbol(symbolsParam);
            ArrayList<IRReturnStatement> statements = new ArrayList<IRReturnStatement>();
            IRExpression returnValue = ExpressionTransformer.compile(((IMemberAccessExpression)expr).getRootExpression(), this._context);
            if (returnValue.getType().isPrimitive()) {
                returnValue = this.boxValue(returnValue.getType(), returnValue);
            }
            statements.add(new IRReturnStatement(null, returnValue));
            IRMethodStatement methodStatement = new IRMethodStatement((IRStatement)new IRStatementList(true, statements), "evaluateRootExpression", 1, false, IRTypeConstants.OBJECT(), Collections.singletonList(symbolsParam));
            irClass.addMethod(methodStatement);
        }
    }

    private IExpression maybeUnwrap(IExpression expression) {
        if (expression instanceof ImplicitTypeAsExpression) {
            return this.maybeUnwrap(((ImplicitTypeAsExpression)expression).getLHS());
        }
        if (expression instanceof IParenthesizedExpression) {
            return this.maybeUnwrap(((IParenthesizedExpression)expression).getExpression());
        }
        return expression;
    }
}

