/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.parser.GosuClassProxyFactory;
import gw.internal.gosu.parser.java.classinfo.CompileTimeExpressionParser;
import gw.lang.annotation.Order;
import gw.lang.parser.IExpression;
import gw.lang.reflect.ConstructorInfoBuilder;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.ParameterInfoBuilder;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.ICanHaveAnnotationDefault;
import gw.lang.reflect.gs.IGosuMethodInfo;
import gw.lang.reflect.java.IJavaMethodInfo;
import gw.lang.reflect.java.IJavaType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class AnnotationConstructorGenerator {
    public static final Object STANDARD_CTOR_WITH_DEFAULT_PARAM_VALUES = new Object();
    private final IRelativeTypeInfo _owner;

    private AnnotationConstructorGenerator(IRelativeTypeInfo owner) {
        this._owner = owner;
    }

    static List<IConstructorInfo> generateAnnotationConstructors(IRelativeTypeInfo backingClass) {
        AnnotationConstructorGenerator gen = new AnnotationConstructorGenerator(backingClass);
        List declaredMethods = backingClass.getDeclaredMethods();
        IMethodInfo[] methods = declaredMethods.toArray(new IMethodInfo[declaredMethods.size()]);
        AnnotationConstructorGenerator.sortMethods(methods);
        ArrayList<IConstructorInfo> constructorInfoArrayList = new ArrayList<IConstructorInfo>();
        gen.addLegacyConstructors(methods, constructorInfoArrayList);
        constructorInfoArrayList.add(gen.makeStandardAnnotationConstructor(methods));
        return constructorInfoArrayList;
    }

    private void addLegacyConstructors(IMethodInfo[] methods, ArrayList<IConstructorInfo> constructorInfoArrayList) {
        this.addCtor(constructorInfoArrayList, this.makeLegacyAnnotationConstructor(methods));
        if (this.hasArrayArgs(methods)) {
            this.addCtor(constructorInfoArrayList, this.makeLegacyArrayAnnotationConstructor(methods));
        }
        if (this.hasDefaultArgs(methods)) {
            this.addCtor(constructorInfoArrayList, this.makeLegacyAllArgsAnnotationConstructor(methods));
        }
        if (this.hasArrayArgs(methods) && this.hasDefaultArgs(methods)) {
            this.addCtor(constructorInfoArrayList, this.makeDefaultArrayAnnotationConstructor(methods));
        }
    }

    private static void sortMethods(IMethodInfo[] methods) {
        Arrays.sort(methods, new Comparator<IMethodInfo>(){

            @Override
            public int compare(IMethodInfo o1, IMethodInfo o2) {
                IAnnotationInfo order1 = o1.getAnnotation(TypeSystem.get(Order.class));
                if (order1 != null) {
                    IAnnotationInfo order2 = o2.getAnnotation(TypeSystem.get(Order.class));
                    return ((Integer)order1.getFieldValue("index")).compareTo((Integer)order2.getFieldValue("index"));
                }
                return o1.getDisplayName().compareTo(o2.getDisplayName());
            }
        });
    }

    private void addCtor(ArrayList<IConstructorInfo> list, IConstructorInfo ci) {
        if (!list.contains(ci)) {
            list.add(ci);
        }
    }

    private boolean hasArrayArgs(IMethodInfo[] methods) {
        for (IMethodInfo method : methods) {
            if (!method.getReturnType().isArray()) continue;
            return true;
        }
        return false;
    }

    private boolean hasDefaultArgs(IMethodInfo[] methods) {
        for (IMethodInfo method : methods) {
            if (((ICanHaveAnnotationDefault)method).getAnnotationDefault() == null) continue;
            return true;
        }
        return false;
    }

    private IConstructorInfo makeStandardAnnotationConstructor(IMethodInfo[] methods) {
        ArrayList<Object> params = new ArrayList<Object>();
        ArrayList<ParameterInfoBuilder> paramsWDefaultValues = new ArrayList<ParameterInfoBuilder>();
        for (IMethodInfo method : methods) {
            ParameterInfoBuilder pib = new ParameterInfoBuilder().withName(method.getDisplayName()).withType(method.getReturnType());
            if (((ICanHaveAnnotationDefault)method).getAnnotationDefault() != null) {
                pib.withDefValue(this.makeDefaultValueExpression(method));
                paramsWDefaultValues.add(pib);
                continue;
            }
            params.add(pib);
        }
        params.addAll(paramsWDefaultValues);
        return new ConstructorInfoBuilder().withParameters(params.toArray(new ParameterInfoBuilder[params.size()])).withUserData(STANDARD_CTOR_WITH_DEFAULT_PARAM_VALUES).build((IFeatureInfo)this._owner);
    }

    private IConstructorInfo makeLegacyArrayAnnotationConstructor(IMethodInfo[] methods) {
        ArrayList<ParameterInfoBuilder> params = new ArrayList<ParameterInfoBuilder>();
        for (IMethodInfo method : methods) {
            if (method.getReturnType().isArray()) {
                params.add(new ParameterInfoBuilder().withName(method.getDisplayName()).withType(method.getReturnType().getComponentType()));
                continue;
            }
            params.add(new ParameterInfoBuilder().withName(method.getDisplayName()).withType(method.getReturnType()));
        }
        return new ConstructorInfoBuilder().withParameters(params.toArray(new ParameterInfoBuilder[params.size()])).build((IFeatureInfo)this._owner);
    }

    private IConstructorInfo makeLegacyAnnotationConstructor(IMethodInfo[] methods) {
        ArrayList<ParameterInfoBuilder> params = new ArrayList<ParameterInfoBuilder>();
        for (IMethodInfo method : methods) {
            ICanHaveAnnotationDefault annoMethod = (ICanHaveAnnotationDefault)method;
            if (annoMethod.getAnnotationDefault() != null) continue;
            params.add(new ParameterInfoBuilder().withName(method.getDisplayName()).withType(method.getReturnType()));
        }
        return new ConstructorInfoBuilder().withParameters(params.toArray(new ParameterInfoBuilder[params.size()])).build((IFeatureInfo)this._owner);
    }

    private IConstructorInfo makeLegacyAllArgsAnnotationConstructor(IMethodInfo[] methods) {
        ArrayList<ParameterInfoBuilder> params = new ArrayList<ParameterInfoBuilder>();
        for (IMethodInfo method : methods) {
            ICanHaveAnnotationDefault annoMethod = (ICanHaveAnnotationDefault)method;
            if (annoMethod.getAnnotationDefault() != null) {
                params.add(new ParameterInfoBuilder().withName(method.getDisplayName()).withType(method.getReturnType()).withDefValue(this.makeDefaultValueExpression(method)));
                continue;
            }
            params.add(new ParameterInfoBuilder().withName(method.getDisplayName()).withType(method.getReturnType()));
        }
        return new ConstructorInfoBuilder().withParameters(params.toArray(new ParameterInfoBuilder[params.size()])).build((IFeatureInfo)this._owner);
    }

    private IExpression makeDefaultValueExpression(IMethodInfo method) {
        if (method instanceof IGosuMethodInfo) {
            return ((IGosuMethodInfo)method).getDfs().getDefaultValueExpression();
        }
        String exprString = GosuClassProxyFactory.makeValueString(((IJavaMethodInfo)method).getMethod().getDefaultValue(), method.getReturnType());
        return CompileTimeExpressionParser.parse(exprString, ((IJavaType)this._owner.getOwnersType()).getBackingClassInfo(), method.getReturnType());
    }

    private IConstructorInfo makeDefaultArrayAnnotationConstructor(IMethodInfo[] methods) {
        ArrayList<ParameterInfoBuilder> params = new ArrayList<ParameterInfoBuilder>();
        for (IMethodInfo method : methods) {
            if (((ICanHaveAnnotationDefault)method).getAnnotationDefault() != null) continue;
            if (method.getReturnType().isArray()) {
                params.add(new ParameterInfoBuilder().withName(method.getDisplayName()).withType(method.getReturnType().getComponentType()));
                continue;
            }
            params.add(new ParameterInfoBuilder().withName(method.getDisplayName()).withType(method.getReturnType()));
        }
        return new ConstructorInfoBuilder().withParameters(params.toArray(new ParameterInfoBuilder[params.size()])).build((IFeatureInfo)this._owner);
    }
}

