/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.parser.GenericTypeVariable;
import gw.lang.reflect.AbstractType;
import gw.lang.reflect.DefaultNonLoadableArrayType;
import gw.lang.reflect.INamespaceType;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.ITypeLoader;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.TypeName;
import gw.lang.reflect.java.JavaTypes;
import gw.lang.reflect.module.IModule;
import java.io.ObjectStreamException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class NamespaceType
extends AbstractType
implements INamespaceType {
    private String _strFqNamespace;
    private String _strRelativeNamespace;
    private String _strParent;
    private boolean _bDiscarded;
    private IModule _module;
    private Set<TypeName> _children;

    public NamespaceType(String strFqNamespace, IModule module) {
        this._strFqNamespace = strFqNamespace;
        this._module = module;
        this.assignRelativePackageAndParent();
    }

    private void assignRelativePackageAndParent() {
        int iLastDot = this._strFqNamespace.lastIndexOf(46);
        if (iLastDot >= 0) {
            this._strRelativeNamespace = this._strFqNamespace.substring(iLastDot + 1);
            this._strParent = this._strFqNamespace.substring(0, iLastDot);
        } else {
            this._strRelativeNamespace = this._strFqNamespace;
            this._strParent = "";
        }
    }

    public String getName() {
        return this._strFqNamespace;
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getRelativeName() {
        return this._strRelativeNamespace;
    }

    public String getNamespace() {
        return this._strParent;
    }

    public ITypeLoader getTypeLoader() {
        return null;
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isEnum() {
        return false;
    }

    public IType[] getInterfaces() {
        return EMPTY_TYPE_ARRAY;
    }

    public INamespaceType getSupertype() {
        return this.getEnclosingType();
    }

    public INamespaceType getEnclosingType() {
        if (this._strParent == null) {
            return null;
        }
        return TypeSystem.getNamespace((String)this._strParent);
    }

    public IType getGenericType() {
        return null;
    }

    public boolean isFinal() {
        return true;
    }

    public boolean isParameterizedType() {
        return false;
    }

    public boolean isGenericType() {
        return false;
    }

    public GenericTypeVariable[] getGenericTypeVariables() {
        return GenericTypeVariable.EMPTY_TYPEVARS;
    }

    public IType getParameterizedType(IType ... ofType) {
        return null;
    }

    public IType[] getTypeParameters() {
        return IType.EMPTY_ARRAY;
    }

    public Set<? extends IType> getAllTypesInHierarchy() {
        return Collections.singleton(this);
    }

    public boolean isArray() {
        return false;
    }

    public boolean isPrimitive() {
        return false;
    }

    public IType getArrayType() {
        return new DefaultNonLoadableArrayType((IType)this, JavaTypes.OBJECT().getBackingClassInfo(), this.getTypeLoader());
    }

    public Object makeArrayInstance(int iLength) {
        throw new UnsupportedOperationException();
    }

    public Object getArrayComponent(Object array, int iIndex) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        return null;
    }

    public void setArrayComponent(Object array, int iIndex, Object value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
    }

    public int getArrayLength(Object array) throws IllegalArgumentException {
        return 0;
    }

    public IType getComponentType() {
        return null;
    }

    public boolean isAssignableFrom(IType type) {
        return type == this;
    }

    public boolean isMutable() {
        return false;
    }

    public ITypeInfo getTypeInfo() {
        return null;
    }

    public void unloadTypeInfo() {
    }

    public Object readResolve() throws ObjectStreamException {
        return TypeSystem.getNamespace((String)this._strFqNamespace);
    }

    public boolean isValid() {
        return true;
    }

    public int getModifiers() {
        return 1;
    }

    public boolean isAbstract() {
        return false;
    }

    public boolean isDiscarded() {
        return this._bDiscarded;
    }

    public void setDiscarded(boolean bDiscarded) {
        this._bDiscarded = bDiscarded;
    }

    public boolean isCompoundType() {
        return false;
    }

    public Set<IType> getCompoundTypeComponents() {
        return null;
    }

    public String toString() {
        return this._strFqNamespace;
    }

    public Set<TypeName> getChildren(IType whosaskin) {
        if (this._children == null) {
            HashSet<TypeName> allNames = new HashSet<TypeName>();
            allNames.addAll(TypeSystem.getGlobalModule().getModuleTypeLoader().getTypeNames(this._strFqNamespace));
            for (IModule module : this._module.getModuleTraversalList()) {
                if (module == TypeSystem.getGlobalModule()) continue;
                allNames.addAll(module.getModuleTypeLoader().getTypeNames(this._strFqNamespace));
            }
            this._children = allNames;
        }
        return this._children;
    }

    public IModule getModule() {
        return this._module;
    }
}

