/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.java.compiler;

import com.sun.tools.javac.file.BaseFileObject;
import com.sun.tools.javac.file.JavacFileManager;
import gw.lang.ir.SignatureUtil;
import gw.util.concurrent.LocklessLazyVar;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.util.function.Supplier;
import javax.tools.JavaFileObject;

public class GeneratedJavaStubFileObject
extends BaseFileObject {
    private String _name;
    private long _timestamp;
    private Supplier<String> _sourceSupplier;
    private LocklessLazyVar<String> _src = LocklessLazyVar.make(() -> this._sourceSupplier.get());

    public GeneratedJavaStubFileObject(JavacFileManager mgr, String name, Supplier<String> sourceSupplier) {
        super(mgr);
        this._name = name;
        this._timestamp = System.currentTimeMillis();
        this._sourceSupplier = sourceSupplier;
    }

    public URI toUri() {
        return URI.create("genstub:///" + this._name.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension);
    }

    public String getName() {
        return this._name;
    }

    public InputStream openInputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    public OutputStream openOutputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        return (CharSequence)this._src.get();
    }

    public Writer openWriter() throws IOException {
        throw new UnsupportedOperationException();
    }

    public long getLastModified() {
        return this._timestamp;
    }

    public boolean delete() {
        throw new UnsupportedOperationException();
    }

    public String getShortName() {
        return SignatureUtil.getSimpleName((String)this._name);
    }

    protected String inferBinaryName(Iterable<? extends File> files) {
        return this._name;
    }

    public boolean equals(Object o) {
        if (!(o instanceof GeneratedJavaStubFileObject)) {
            return false;
        }
        return this._name.equals(((GeneratedJavaStubFileObject)((Object)o)).getName());
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public JavaFileObject.Kind getKind() {
        return JavaFileObject.Kind.SOURCE;
    }

    public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
        return true;
    }
}

