/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.util;

import gw.lang.parser.IReducedSymbol;
import gw.lang.reflect.IAttributedFeatureInfo;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.Modifier;
import gw.lang.reflect.gs.BytecodeOptions;
import gw.lang.reflect.java.IJavaClassMethod;
import gw.lang.reflect.java.IJavaType;
import java.lang.reflect.Method;

public class AccessibilityUtil {
    public static IRelativeTypeInfo.Accessibility forMethod(Method method) {
        if (Modifier.isPublic((int)method.getModifiers())) {
            return IRelativeTypeInfo.Accessibility.PUBLIC;
        }
        if (Modifier.isProtected((int)method.getModifiers())) {
            return IRelativeTypeInfo.Accessibility.PROTECTED;
        }
        if (Modifier.isPrivate((int)method.getModifiers())) {
            return IRelativeTypeInfo.Accessibility.PRIVATE;
        }
        return IRelativeTypeInfo.Accessibility.INTERNAL;
    }

    public static IRelativeTypeInfo.Accessibility forMethod(IJavaClassMethod method) {
        if (Modifier.isPublic((int)method.getModifiers())) {
            return IRelativeTypeInfo.Accessibility.PUBLIC;
        }
        if (Modifier.isProtected((int)method.getModifiers())) {
            return IRelativeTypeInfo.Accessibility.PROTECTED;
        }
        if (Modifier.isPrivate((int)method.getModifiers())) {
            return IRelativeTypeInfo.Accessibility.PRIVATE;
        }
        return IRelativeTypeInfo.Accessibility.INTERNAL;
    }

    public static IRelativeTypeInfo.Accessibility forFeatureInfo(IAttributedFeatureInfo feature) {
        if (feature.isPublic()) {
            return IRelativeTypeInfo.Accessibility.PUBLIC;
        }
        if (feature.isProtected()) {
            return IRelativeTypeInfo.Accessibility.PROTECTED;
        }
        if (feature.isPrivate()) {
            return IRelativeTypeInfo.Accessibility.PRIVATE;
        }
        return IRelativeTypeInfo.Accessibility.INTERNAL;
    }

    public static IRelativeTypeInfo.Accessibility forSymbol(IReducedSymbol symbol) {
        if (symbol.isPublic()) {
            return IRelativeTypeInfo.Accessibility.PUBLIC;
        }
        if (symbol.isProtected()) {
            return IRelativeTypeInfo.Accessibility.PROTECTED;
        }
        if (symbol.isPrivate()) {
            return IRelativeTypeInfo.Accessibility.PRIVATE;
        }
        return IRelativeTypeInfo.Accessibility.INTERNAL;
    }

    public static IRelativeTypeInfo.Accessibility forCapturedVar() {
        if (BytecodeOptions.isSingleServingLoader()) {
            return IRelativeTypeInfo.Accessibility.PUBLIC;
        }
        return IRelativeTypeInfo.Accessibility.PRIVATE;
    }

    public static IRelativeTypeInfo.Accessibility forTypeParameter() {
        if (BytecodeOptions.isSingleServingLoader()) {
            return IRelativeTypeInfo.Accessibility.PUBLIC;
        }
        return IRelativeTypeInfo.Accessibility.INTERNAL;
    }

    public static IRelativeTypeInfo.Accessibility forOuter() {
        if (BytecodeOptions.isSingleServingLoader()) {
            return IRelativeTypeInfo.Accessibility.PUBLIC;
        }
        return IRelativeTypeInfo.Accessibility.INTERNAL;
    }

    public static IRelativeTypeInfo.Accessibility forOuterAccess() {
        if (BytecodeOptions.isSingleServingLoader()) {
            return IRelativeTypeInfo.Accessibility.PUBLIC;
        }
        return IRelativeTypeInfo.Accessibility.INTERNAL;
    }

    public static IRelativeTypeInfo.Accessibility forType(IType type) {
        int modifiers = type.getModifiers();
        if (Modifier.isPublic((int)modifiers)) {
            return IRelativeTypeInfo.Accessibility.PUBLIC;
        }
        if (Modifier.isInternal((int)modifiers)) {
            return IRelativeTypeInfo.Accessibility.INTERNAL;
        }
        if (Modifier.isPrivate((int)modifiers)) {
            return IRelativeTypeInfo.Accessibility.PRIVATE;
        }
        if (type instanceof IJavaType) {
            return IRelativeTypeInfo.Accessibility.INTERNAL;
        }
        return IRelativeTypeInfo.Accessibility.PUBLIC;
    }
}

