/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.loader;

import gw.internal.gosu.compiler.GosuClassLoader;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.ICompilableType;
import gw.lang.reflect.java.IJavaBackedType;
import gw.lang.reflect.module.TypeSystemLockHelper;

public class Loader {
    private static final String[] JAVA_NAMESPACES_TO_IGNORE = new String[]{"java.", "javax.", "sun."};

    public static Object getBytesOrClass(String strType) {
        IType type2;
        ICompilableType type = null;
        if (!Loader.ignoreJavaClass(strType)) {
            strType = strType.replace('$', '.');
            type = Loader.maybeAssignGosuType(strType);
        }
        if (type != null) {
            return GosuClassLoader.instance().getBytes(type);
        }
        if (strType.startsWith("com.guidewire.commons.metadata.proxy._generated.iface.") && (type2 = TypeSystem.getByFullNameIfValid((String)(strType = "entity." + strType.substring(strType.lastIndexOf(46) + 1)))) instanceof IJavaBackedType) {
            return ((IJavaBackedType)type2).getBackingClass();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ICompilableType maybeAssignGosuType(String strType) {
        ClassLoader loader = TypeSystem.getGosuClassLoader().getActualLoader();
        TypeSystemLockHelper.getTypeSystemLockWithMonitor((Object)loader);
        try {
            IType type = TypeSystem.getByFullNameIfValid((String)strType);
            if (type instanceof ICompilableType) {
                ICompilableType iCompilableType = (ICompilableType)type;
                return iCompilableType;
            }
        }
        finally {
            TypeSystem.unlock();
        }
        return null;
    }

    private static boolean ignoreJavaClass(String strClass) {
        for (String namespace : JAVA_NAMESPACES_TO_IGNORE) {
            if (!strClass.startsWith(namespace)) continue;
            return true;
        }
        return false;
    }
}

