/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import com.sun.source.tree.Tree;
import gw.internal.gosu.parser.AsmTypeJavaClassType;
import gw.internal.gosu.parser.JavaMethodInfo;
import gw.internal.gosu.parser.java.classinfo.AsmClassAnnotationInfo;
import gw.internal.gosu.parser.java.classinfo.JavaSourceType;
import gw.internal.gosu.parser.java.classinfo.JavaSourceUtil;
import gw.lang.parser.TypeVarToTypeMap;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.gs.ISourceFileHandle;
import gw.lang.reflect.java.IJavaAnnotatedElement;
import gw.lang.reflect.java.IJavaClassBytecodeConstructor;
import gw.lang.reflect.java.IJavaClassConstructor;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.IJavaClassType;
import gw.lang.reflect.java.JavaSourceElement;
import gw.lang.reflect.java.Parameter;
import gw.lang.reflect.java.asm.AsmAnnotation;
import gw.lang.reflect.java.asm.AsmMethod;
import gw.lang.reflect.java.asm.AsmType;
import gw.lang.reflect.java.asm.IAsmType;
import gw.lang.reflect.module.IModule;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

public class AsmConstructorJavaClassConstructor
extends JavaSourceElement
implements IJavaClassConstructor,
IJavaClassBytecodeConstructor {
    private AsmMethod _ctor;
    private IModule _module;

    public AsmConstructorJavaClassConstructor(AsmMethod ctor, IModule module) {
        this._ctor = ctor;
        this._module = module;
    }

    public IJavaClassInfo[] getExceptionTypes() {
        List rawTypes = this._ctor.getExceptions();
        IJavaClassInfo[] types = new IJavaClassInfo[rawTypes.size()];
        for (int i = 0; i < rawTypes.size(); ++i) {
            types[i] = JavaSourceUtil.getClassInfo(((AsmType)rawTypes.get(i)).getRawType().getName(), this._module);
        }
        return types;
    }

    public List<Parameter> getParameterInfos() {
        return this._ctor.getParameterInfos();
    }

    public int getModifiers() {
        return this._ctor.getModifiers();
    }

    public boolean isSynthetic() {
        return this._ctor.isSynthetic();
    }

    public IParameterInfo[] convertGenericParameterTypes(IFeatureInfo container, TypeVarToTypeMap actualParamByVarName) {
        return JavaMethodInfo.convertGenericParameterTypes(container, actualParamByVarName, this.getGenericParameterTypes(), this.getEnclosingClass(), this.getParameterInfos());
    }

    private IJavaClassType[] getGenericParameterTypes() {
        List rawTypes = this._ctor.getGenericParameters();
        IJavaClassType[] types = new IJavaClassType[rawTypes.size()];
        for (int i = 0; i < rawTypes.size(); ++i) {
            types[i] = AsmTypeJavaClassType.createType((IAsmType)rawTypes.get(i), this._module);
        }
        return types;
    }

    public IJavaClassInfo[] getParameterTypes() {
        List rawParamTypes = this._ctor.getParameters();
        IJavaClassInfo[] paramTypes = new IJavaClassInfo[rawParamTypes.size()];
        for (int i = 0; i < rawParamTypes.size(); ++i) {
            paramTypes[i] = JavaSourceUtil.getClassInfo(((AsmType)rawParamTypes.get(i)).getRawType().getNameWithArrayBrackets(), this._module);
        }
        return paramTypes;
    }

    public Object newInstance(Object[] objects) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        throw new UnsupportedOperationException();
    }

    public boolean isDefault() {
        return false;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this._ctor.isAnnotationPresent(annotationClass);
    }

    public IAnnotationInfo getAnnotation(Class annotationClass) {
        AsmAnnotation annotation = this._ctor.getAnnotation(annotationClass);
        return annotation != null ? new AsmClassAnnotationInfo(annotation, (IJavaAnnotatedElement)this) : null;
    }

    public IAnnotationInfo[] getDeclaredAnnotations() {
        List annotations = this._ctor.getAnnotations();
        IAnnotationInfo[] declaredAnnotations = new IAnnotationInfo[annotations.size()];
        for (int i = 0; i < declaredAnnotations.length; ++i) {
            declaredAnnotations[i] = new AsmClassAnnotationInfo((AsmAnnotation)annotations.get(i), (IJavaAnnotatedElement)this);
        }
        return declaredAnnotations;
    }

    public IJavaClassInfo getEnclosingClass() {
        return JavaSourceUtil.getClassInfo(this._ctor.getDeclaringClass(), this._module);
    }

    public Tree getTree() {
        JavaSourceElement sourceCtor = this.findSourceConstructor();
        if (sourceCtor != null) {
            return sourceCtor.getTree();
        }
        return null;
    }

    private JavaSourceElement findSourceConstructor() {
        ISourceFileHandle sfh = this.getEnclosingClass().getSourceFileHandle();
        if (sfh == null) {
            return null;
        }
        IJavaClassInfo sourceType = JavaSourceType.createTopLevel(sfh, this.getEnclosingClass().getModule());
        if (sourceType == null) {
            return null;
        }
        IType enclosingClass = this.getEnclosingClass().getJavaType();
        if (enclosingClass.getEnclosingType() != null) {
            sourceType = this.findInnerSourceType(sourceType, enclosingClass.getName());
        }
        try {
            return (JavaSourceElement)sourceType.getConstructor(this.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

