/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.config.CommonServices;
import gw.fs.IDirectory;
import gw.fs.IDirectoryUtil;
import gw.fs.IFile;
import gw.fs.IResource;
import gw.fs.IncludeModuleDirectory;
import gw.internal.gosu.parser.InnerClassFileSystemSourceFileHandle;
import gw.internal.gosu.parser.PackageToClassPathEntryTreeMap;
import gw.lang.parser.FileSource;
import gw.lang.parser.ISource;
import gw.lang.reflect.ITypeLoader;
import gw.lang.reflect.RefreshKind;
import gw.lang.reflect.RefreshRequest;
import gw.lang.reflect.gs.ClassType;
import gw.lang.reflect.gs.GosuClassTypeLoader;
import gw.lang.reflect.gs.IFileSystemGosuClassRepository;
import gw.lang.reflect.gs.ISourceFileHandle;
import gw.lang.reflect.gs.TypeName;
import gw.lang.reflect.module.IModule;
import gw.util.DynamicArray;
import gw.util.StreamUtil;
import gw.util.cache.FqnCache;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;
import manifold.api.type.TypeName;

public class FileSystemGosuClassRepository
implements IFileSystemGosuClassRepository {
    private final Map<String, FqnCache> _missCaches = new HashMap<String, FqnCache>();
    public static final String RESOURCE_LOCATED_W_CLASSES = "gw/config/default.xml";
    private final IModule _module;
    private List<IFileSystemGosuClassRepository.ClassPathEntry> _sourcePath = new CopyOnWriteArrayList<IFileSystemGosuClassRepository.ClassPathEntry>();
    private Set<IDirectory> _excludedPath = new HashSet<IDirectory>();
    private String[] _extensions = new String[0];
    private PackageToClassPathEntryTreeMap _rootNode;
    private Set<String> _allTypeNames;

    public FileSystemGosuClassRepository(IModule module) {
        this._module = module;
        this._extensions = GosuClassTypeLoader.ALL_EXTS;
    }

    public IModule getModule() {
        return this._module;
    }

    public IDirectory[] getSourcePath() {
        IDirectory[] sourcepath = new IDirectory[this._sourcePath.size()];
        int i = 0;
        for (IFileSystemGosuClassRepository.ClassPathEntry e : this._sourcePath) {
            sourcepath[i++] = e.getPath();
        }
        return sourcepath;
    }

    public void setSourcePath(IDirectory[] sourcePath) {
        if (this.areDifferent(sourcePath, this._sourcePath)) {
            this._sourcePath.clear();
            HashSet<String> extensions = new HashSet<String>();
            extensions.add(".java");
            extensions.add(".xsd");
            extensions.addAll(Arrays.asList(GosuClassTypeLoader.ALL_EXTS));
            for (IDirectory file : sourcePath) {
                this._sourcePath.add(new IFileSystemGosuClassRepository.ClassPathEntry(file, FileSystemGosuClassRepository.isTestFolder(file)));
            }
            this._extensions = extensions.toArray(new String[extensions.size()]);
            this.reset();
        }
    }

    public IDirectory[] getExcludedPath() {
        return this._excludedPath.toArray(new IDirectory[this._excludedPath.size()]);
    }

    public void setExcludedPath(IDirectory[] excludedPath) {
        this._excludedPath = new HashSet<IDirectory>(Arrays.asList(excludedPath));
        this.reset();
    }

    public ISourceFileHandle findClass(String strQualifiedClassName, String[] extensions) {
        ClassFileInfo fileInfo = this.findFileInfoOnDisk(strQualifiedClassName, extensions);
        return fileInfo != null ? fileInfo.getSourceFileHandle() : null;
    }

    public URL findResource(String resourceName) {
        URL resource;
        if (resourceName == null) {
            return null;
        }
        if (this.inMissCache(resourceName = resourceName.replace('/', '.'), this._extensions)) {
            return null;
        }
        if (resourceName.endsWith(".")) {
            return null;
        }
        PackageToClassPathEntryTreeMap aPackage = this.getCachedPackage(resourceName);
        URL uRL = resource = aPackage == null ? null : aPackage.resolveToResource(resourceName);
        if (resource == null) {
            this.addToMissCache(resourceName, this._extensions);
        }
        return resource;
    }

    public Set<String> getAllTypeNames() {
        if (this._allTypeNames == null) {
            HashSet<String> classNames = new HashSet<String>();
            for (IFileSystemGosuClassRepository.ClassPathEntry path : this._sourcePath) {
                this.addTypeNames(path.getPath(), path.getPath(), classNames, this._extensions);
            }
            this._allTypeNames = classNames;
        }
        return this._allTypeNames;
    }

    public Set<String> getAllTypeNames(String ... extensions) {
        HashSet<String> enhancementNames = new HashSet<String>();
        for (IFileSystemGosuClassRepository.ClassPathEntry path : this._sourcePath) {
            this.addTypeNames(path.getPath(), path.getPath(), enhancementNames, extensions);
        }
        return enhancementNames;
    }

    public String getClassNameFromFile(IDirectory root, IFile file, String[] fileExts) {
        String strClassPath = root.getPath().getFileSystemPathString() + File.separatorChar;
        String strQualifiedClassName = file.getPath().getFileSystemPathString().substring(strClassPath.length());
        if (!IFileSystemGosuClassRepository.Util.isClassFileName((String)strQualifiedClassName, (String[])fileExts)) {
            String strExts = "";
            for (String strExt : fileExts) {
                strExts = strExts + " " + strExt;
            }
            throw new IllegalArgumentException(file.getPath().getName() + " is not a legal Gosu class name. It does not end with [" + strExts.trim() + "]");
        }
        strQualifiedClassName = strQualifiedClassName.substring(0, strQualifiedClassName.lastIndexOf(46));
        if ((strQualifiedClassName = strQualifiedClassName.replace('/', '.').replace('\\', '.')).startsWith(".")) {
            strQualifiedClassName = strQualifiedClassName.substring(1);
        }
        return strQualifiedClassName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void typesRefreshed(RefreshRequest request) {
        Map<String, FqnCache> map = this._missCaches;
        synchronized (map) {
            if (request == null) {
                this.reset();
            } else {
                for (FqnCache cache : this._missCaches.values()) {
                    cache.remove(request.types);
                }
                if (request.kind == RefreshKind.CREATION) {
                    for (String type : request.types) {
                        if (this._allTypeNames == null) continue;
                        this._allTypeNames.add(type);
                    }
                } else if (request.kind == RefreshKind.DELETION && this._allTypeNames != null) {
                    for (String type : request.types) {
                        this._allTypeNames.remove(type);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        Map<String, FqnCache> map = this._missCaches;
        synchronized (map) {
            this._missCaches.clear();
            this._rootNode = null;
            this._allTypeNames = null;
        }
    }

    private void addToPackageCache(String fqn, IResource file) {
        IFileSystemGosuClassRepository.ClassPathEntry classPathEntry = this.findClassPathEntry(file);
        if (this._rootNode != null && classPathEntry != null) {
            PackageToClassPathEntryTreeMap node = this._rootNode;
            while (fqn != null) {
                int i = fqn.indexOf(46);
                String segment = fqn.substring(0, i < 0 ? fqn.length() : i);
                PackageToClassPathEntryTreeMap child = node.getChild(segment);
                if (child != null) {
                    child.addClassPathEntry(classPathEntry);
                    node = child;
                } else {
                    node = node.createChildForDir(classPathEntry, segment);
                }
                if (i < 0) break;
                fqn = i + 1 < fqn.length() ? fqn.substring(i + 1) : null;
            }
            for (FqnCache cache : this._missCaches.values()) {
                cache.remove(fqn);
            }
        }
    }

    private IFileSystemGosuClassRepository.ClassPathEntry findClassPathEntry(IResource file) {
        for (IFileSystemGosuClassRepository.ClassPathEntry classPathEntry : this._sourcePath) {
            if (!file.isDescendantOf(classPathEntry.getPath())) continue;
            return classPathEntry;
        }
        return null;
    }

    private void removeFromPackageCache(String fqn, IDirectory dir) {
        PackageToClassPathEntryTreeMap thePackage = this.getCachedPackageCorrectly(fqn);
        if (thePackage != null) {
            thePackage.delete(dir);
        }
    }

    private synchronized PackageToClassPathEntryTreeMap getCachedPackageCorrectly(String fullyQualifiedName) {
        if (this._rootNode == null) {
            this._rootNode = this.loadPackageRoots();
        }
        PackageToClassPathEntryTreeMap currNode = this._rootNode;
        int iRelativeNameIndex = 0;
        while (iRelativeNameIndex != -1) {
            int iNextDot = fullyQualifiedName.indexOf(46, iRelativeNameIndex);
            String strRelativeName = fullyQualifiedName.substring(iRelativeNameIndex, iNextDot == -1 ? fullyQualifiedName.length() : iNextDot);
            iRelativeNameIndex = iNextDot == -1 ? -1 : iNextDot + 1;
            PackageToClassPathEntryTreeMap newNode = this.getChildPackage(currNode, strRelativeName);
            if (newNode == null) {
                return null;
            }
            currNode = newNode;
        }
        return currNode == this._rootNode ? null : currNode;
    }

    private synchronized PackageToClassPathEntryTreeMap getCachedPackage(String fullyQualifiedName) {
        if (this._rootNode == null) {
            this._rootNode = this.loadPackageRoots();
        }
        if (fullyQualifiedName.equals("")) {
            return this._rootNode;
        }
        PackageToClassPathEntryTreeMap currNode = this._rootNode;
        int iRelativeNameIndex = 0;
        while (iRelativeNameIndex != -1) {
            int iNextDot = fullyQualifiedName.indexOf(46, iRelativeNameIndex);
            String strRelativeName = fullyQualifiedName.substring(iRelativeNameIndex, iNextDot == -1 ? fullyQualifiedName.length() : iNextDot);
            iRelativeNameIndex = iNextDot == -1 ? -1 : iNextDot + 1;
            PackageToClassPathEntryTreeMap newNode = this.getChildPackage(currNode, strRelativeName);
            if (newNode == null) break;
            currNode = newNode;
        }
        return currNode == this._rootNode ? null : currNode;
    }

    private PackageToClassPathEntryTreeMap getChildPackage(PackageToClassPathEntryTreeMap parent, String strRelativeName) {
        PackageToClassPathEntryTreeMap child;
        if (parent == this._rootNode && strRelativeName.equals("Libraries")) {
            child = parent.getChild("libraries");
            if (child == null) {
                return null;
            }
        } else {
            child = parent.getChild(strRelativeName);
        }
        return child;
    }

    private PackageToClassPathEntryTreeMap loadPackageRoots() {
        PackageToClassPathEntryTreeMap root = new PackageToClassPathEntryTreeMap(null, "", this._module);
        PackageToClassPathEntryTreeMap gw = root.createChildForDir(null, "gw");
        gw.createChildForDir(null, "lang");
        gw.createChildForDir(null, "util");
        root.createChildForDir(null, "program_");
        for (IFileSystemGosuClassRepository.ClassPathEntry dir : this._sourcePath) {
            root.addClassPathEntry(dir);
            this.processDirectory(root, dir, dir.getPath());
        }
        return root;
    }

    private void processDirectory(PackageToClassPathEntryTreeMap node, IFileSystemGosuClassRepository.ClassPathEntry entry, IDirectory path) {
        if (this._excludedPath.contains(path)) {
            return;
        }
        IDirectory entryPath = entry.getPath();
        if (entryPath.equals(path) || !CommonServices.getPlatformHelper().isPathIgnored(entryPath.relativePath((IResource)path))) {
            List dirs = path.listDirs();
            for (IDirectory dir : dirs) {
                if (!this.isValidDirectory(dir)) continue;
                PackageToClassPathEntryTreeMap child = node.createChildForDir(entry, dir.getName());
                this.processDirectory(child, entry, dir);
            }
        }
    }

    private boolean isValidDirectory(IDirectory dir) {
        return !dir.getName().equals("META-INF");
    }

    private ClassFileInfo findFileInfoOnDisk(String strQualifiedClassName, String[] extensions) {
        if (this.inMissCache(strQualifiedClassName, extensions)) {
            return null;
        }
        if (strQualifiedClassName == null) {
            return null;
        }
        if (strQualifiedClassName.endsWith(".")) {
            return null;
        }
        ClassFileInfo info = null;
        String packageName = this.getPackageName(strQualifiedClassName);
        PackageToClassPathEntryTreeMap aPackage = this.getCachedPackage(packageName);
        if (aPackage != null) {
            info = aPackage.resolveToClassFileInfo(strQualifiedClassName, extensions);
        }
        if (info == null) {
            this.addToMissCache(strQualifiedClassName, extensions);
        }
        return info;
    }

    private String getPackageName(String strQualifiedClassName) {
        int i = strQualifiedClassName.lastIndexOf(46);
        return i < 0 ? "" : strQualifiedClassName.substring(0, i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean inMissCache(String strQualifiedClassName, String[] extensions) {
        Map<String, FqnCache> map = this._missCaches;
        synchronized (map) {
            for (String extension : extensions) {
                Object value = this.getMissCacheForExtension(extension).get(strQualifiedClassName);
                if (value == Boolean.TRUE) continue;
                return false;
            }
            return true;
        }
    }

    private FqnCache getMissCacheForExtension(String extension) {
        FqnCache cache = this._missCaches.get(extension);
        if (cache == null) {
            cache = new FqnCache();
            this._missCaches.put(extension, cache);
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToMissCache(String strQualifiedClassName, String[] extensions) {
        Map<String, FqnCache> map = this._missCaches;
        synchronized (map) {
            for (String extension : extensions) {
                this.getMissCacheForExtension(extension).add(strQualifiedClassName, (Object)Boolean.TRUE);
            }
        }
    }

    private void addTypeNames(IDirectory root, IDirectory path, Set<String> classNames, String[] fileExts) {
        DynamicArray iFiles = IDirectoryUtil.allContainedFilesExcludingIgnored((IDirectory)path);
        for (int i = 0; i < iFiles.size; ++i) {
            IFile file = (IFile)iFiles.data[i];
            if (!IFileSystemGosuClassRepository.Util.isClassFileName((String)file.getName(), (String[])fileExts)) continue;
            String className = this.getClassNameFromFile(root, file, fileExts);
            classNames.add(className);
        }
    }

    public Set<TypeName> getTypeNames(String namespace, Set<String> extensions, ITypeLoader loader) {
        HashSet<TypeName> setNames = new HashSet<TypeName>();
        if (namespace == null) {
            for (String name : this.getAllTypeNames()) {
                setNames.add(new TypeName(name, loader, TypeName.Kind.TYPE, TypeName.Visibility.PUBLIC));
            }
        } else {
            PackageToClassPathEntryTreeMap cachedPackage = this.getCachedPackageCorrectly(namespace);
            if (cachedPackage != null) {
                return cachedPackage.getTypeNames(extensions, loader);
            }
            return Collections.EMPTY_SET;
        }
        return setNames;
    }

    public int hasNamespace(String namespace) {
        PackageToClassPathEntryTreeMap cachedNamespace = this.getCachedPackageCorrectly(namespace);
        return cachedNamespace != null ? cachedNamespace.getSourceRootCount() : 0;
    }

    public void namespaceRefreshed(String namespace, IDirectory dir, RefreshKind kind) {
        if (kind == RefreshKind.CREATION) {
            this.addToPackageCache(namespace, (IResource)dir);
        } else if (kind == RefreshKind.DELETION) {
            this.removeFromPackageCache(namespace, dir);
        }
    }

    private boolean areDifferent(IDirectory[] cp1, List<IFileSystemGosuClassRepository.ClassPathEntry> cp2) {
        if (cp1.length != cp2.size()) {
            return true;
        }
        for (int i = 0; i < cp1.length; ++i) {
            if (cp1[i].equals(cp2.get(i).getPath())) continue;
            return true;
        }
        return false;
    }

    private static boolean isTestFolder(IDirectory file) {
        return file.toString().endsWith("gtest");
    }

    public IFile findFirstFile(String resourceName) {
        return this.findFirstFile(resourceName, this._module.getSourcePath());
    }

    private IFile findFirstFile(String resourceName, List<? extends IDirectory> searchPath) {
        for (IDirectory iDirectory : searchPath) {
            IFile file = iDirectory.file(resourceName);
            if (file == null || !file.exists()) continue;
            return file;
        }
        return null;
    }

    public String toString() {
        return this._module.getName();
    }

    public static class ClassFileInfo
    implements IFileSystemGosuClassRepository.IClassFileInfo {
        private IFileSystemGosuClassRepository.ClassPathEntry _entry;
        private ClassType _classType;
        private String _fileType;
        private List<String> _innerClassParts;
        private boolean _isTestClass;
        private SoftReference<String> _content;
        private IFile _file;

        public ClassFileInfo(IFileSystemGosuClassRepository.ClassPathEntry entry, IFile file, boolean isTestClass) {
            this._entry = entry;
            this._file = file;
            this._classType = this._file.getExtension().equalsIgnoreCase("java") ? ClassType.JavaClass : ClassType.Class;
            this._innerClassParts = Collections.emptyList();
            this._isTestClass = isTestClass;
            this._file = file;
        }

        public ClassFileInfo(ISourceFileHandle outerSfh, ClassType classType, String fileType, List<String> innerClassParts, boolean isTestClass) {
            this._classType = classType;
            this._fileType = fileType;
            this._innerClassParts = innerClassParts;
            this._isTestClass = isTestClass;
            this._file = outerSfh.getFile();
        }

        public IFile getFile() {
            return this._file;
        }

        public boolean hasInnerClass() {
            return this._innerClassParts.size() > 0;
        }

        public ISourceFileHandle getSourceFileHandle() {
            if (this.hasInnerClass()) {
                String enclosingType = this._fileType;
                for (int i = 0; i < this._innerClassParts.size() - 1; ++i) {
                    enclosingType = enclosingType + "." + this._innerClassParts.get(i);
                }
                return new InnerClassFileSystemSourceFileHandle(this._classType, enclosingType, this._innerClassParts.get(this._innerClassParts.size() - 1), this._isTestClass);
            }
            return new FileSystemSourceFileHandle(this, this._isTestClass);
        }

        public IFileSystemGosuClassRepository.ClassPathEntry getEntry() {
            return this._entry;
        }

        public IDirectory getParentFile() {
            return this._file.getParent();
        }

        public Reader getReader() {
            try {
                return StreamUtil.getInputStreamReader((InputStream)this._file.openInputStream());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String getFileName() {
            return this._file.getName();
        }

        public String getNonCanonicalFileName() {
            return this._file.getName();
        }

        public String getFilePath() {
            return this._file.getPath().getFileSystemPathString();
        }

        public int getClassPathLength() {
            return this.getEntry().getPath().getPath().getFileSystemPathString().length();
        }

        public String getContent() {
            String content = null;
            if (this._content != null) {
                content = this._content.get();
            }
            if (content == null) {
                try (Stream lines = null;){
                    if (this._file.isJavaFile() && this._classType != ClassType.JavaClass) {
                        lines = Files.lines(this._file.toJavaFile().toPath());
                    } else {
                        BufferedReader reader = new BufferedReader(this.getReader());
                        lines = (Stream)reader.lines().onClose(ClassFileInfo.callClose(reader));
                    }
                    StringBuilder sb = new StringBuilder();
                    lines.forEach(line -> sb.append((String)line).append('\n'));
                    if (sb.length() > 0) {
                        sb.setLength(sb.length() - 1);
                    }
                    content = sb.toString();
                }
                this._content = this._classType == ClassType.JavaClass ? new SoftReference<Object>(null) : new SoftReference<String>(content);
            }
            return content;
        }

        public void stopCachingContent() {
            this._content.clear();
        }

        private static Runnable callClose(Closeable c) {
            return () -> {
                try {
                    c.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            };
        }

        public String toString() {
            return this._file.toString();
        }
    }

    public static final class FileSystemSourceFileHandle
    implements ISourceFileHandle {
        ISource _source;
        boolean _isTestClass;
        private int _classPathLength;
        private ClassFileInfo _fileInfo;
        private int _iOffset;
        private int _iEnd;

        public FileSystemSourceFileHandle(ClassFileInfo fileInfo, boolean isTestClass) {
            this._isTestClass = isTestClass;
            this._fileInfo = fileInfo;
            this._classPathLength = fileInfo.getClassPathLength();
        }

        public ISource getSource() {
            if (this._source == null) {
                this._source = new FileSource((IFileSystemGosuClassRepository.IClassFileInfo)this._fileInfo);
            }
            return this._source;
        }

        public String getParentType() {
            return null;
        }

        public String getNamespace() {
            String namespace = this._fileInfo.getFilePath().substring(this._fileInfo.getEntry().getPath().toString().length() + 1);
            int fileSeparatorIndex = namespace.lastIndexOf(File.separatorChar);
            if (fileSeparatorIndex >= 0) {
                namespace = namespace.substring(0, fileSeparatorIndex);
                namespace = namespace.replace(File.separatorChar, '.');
            } else {
                namespace = "default";
            }
            return namespace;
        }

        public String getFilePath() {
            return this._fileInfo.getFilePath();
        }

        public IFile getFile() {
            return this._fileInfo.getFile();
        }

        public boolean isTestClass() {
            return this._isTestClass;
        }

        public boolean isValid() {
            return true;
        }

        public boolean isStandardPath() {
            return !this._fileInfo.getEntry().getPath().isAdditional();
        }

        public boolean isIncludeModulePath() {
            return this._fileInfo.getEntry().getPath() instanceof IncludeModuleDirectory;
        }

        public void cleanAfterCompile() {
            this._source = null;
        }

        public ClassType getClassType() {
            String name = this._fileInfo.getNonCanonicalFileName();
            return ClassType.getFromFileName((String)name);
        }

        public String getTypeNamespace() {
            int endPos;
            int startPos;
            String path = this._fileInfo.getFilePath().replace('/', '.').replace('\\', '.');
            if (path.charAt(startPos = this._classPathLength) == '!') {
                ++startPos;
            }
            if (path.charAt(startPos) == '.') {
                ++startPos;
            }
            return (endPos = path.length() - (this._fileInfo.getFileName().length() + 1)) < startPos ? "" : path.substring(startPos, endPos);
        }

        public String getRelativeName() {
            String name = this._fileInfo.getFileName();
            return name.substring(0, name.lastIndexOf(46));
        }

        public void setOffset(int iOffset) {
            this._iOffset = iOffset;
        }

        public int getOffset() {
            return this._iOffset;
        }

        public void setEnd(int iEnd) {
            this._iEnd = iEnd;
        }

        public int getEnd() {
            return this._iEnd;
        }

        public String getFileName() {
            String strFile = this.getFilePath();
            int iIndex = strFile.lastIndexOf(File.separatorChar);
            if (iIndex >= 0) {
                strFile = strFile.substring(iIndex + 1);
            }
            return strFile;
        }

        public String toString() {
            return this._fileInfo.getFilePath();
        }
    }
}

