/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.config.CommonServices;
import gw.internal.gosu.parser.AsmFieldJavaClassField;
import gw.internal.gosu.parser.FieldJavaClassField;
import gw.internal.gosu.parser.JavaBaseFeatureInfo;
import gw.internal.gosu.parser.JavaTypeInfo;
import gw.internal.gosu.parser.TypeLord;
import gw.internal.gosu.parser.java.classinfo.CompileTimeExpressionParser;
import gw.internal.gosu.parser.java.classinfo.JavaSourceEnumConstant;
import gw.internal.gosu.parser.java.classinfo.JavaSourceField;
import gw.lang.Deprecated;
import gw.lang.GosuShop;
import gw.lang.javadoc.IClassDocNode;
import gw.lang.javadoc.IDocRef;
import gw.lang.javadoc.IVarNode;
import gw.lang.parser.EvaluationException;
import gw.lang.parser.IExpression;
import gw.lang.reflect.FeatureManager;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IAttributedFeatureInfo;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.ILocationInfo;
import gw.lang.reflect.IPresentationInfo;
import gw.lang.reflect.IPropertyAccessor;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IScriptabilityModifier;
import gw.lang.reflect.IType;
import gw.lang.reflect.java.IJavaAnnotatedElement;
import gw.lang.reflect.java.IJavaClassField;
import gw.lang.reflect.java.IJavaFieldPropertyInfo;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.java.JavaSourceElement;
import gw.util.GosuExceptionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.List;

public class JavaFieldPropertyInfo
extends JavaBaseFeatureInfo
implements IJavaFieldPropertyInfo {
    private IJavaClassField _field;
    private boolean _isStatic;
    private IType _type;
    private IPropertyAccessor _accessor;
    private String _strName;
    private IDocRef<IVarNode> _docs = new IDocRef<IVarNode>(){

        public IVarNode get() {
            if (JavaFieldPropertyInfo.this.getContainer() instanceof JavaTypeInfo) {
                IClassDocNode classDocs = (IClassDocNode)((JavaTypeInfo)JavaFieldPropertyInfo.this.getContainer()).getDocNode().get();
                IVarNode varDoc = classDocs == null ? null : classDocs.getVar(JavaFieldPropertyInfo.this._field.getName());
                return varDoc;
            }
            return null;
        }
    };

    JavaFieldPropertyInfo(IFeatureInfo container, IType type, IJavaClassField field, boolean isStatic, boolean simplePropertyProcessing) {
        super(container);
        if (type == null) {
            throw new IllegalArgumentException("Feature type cannot be null");
        }
        this._type = type = TypeLord.replaceRawGenericTypesWithDefaultParameterizedTypes(type);
        this._field = field;
        if (this._field instanceof FieldJavaClassField) {
            ((FieldJavaClassField)this._field).setAccessible(true);
        }
        this._isStatic = isStatic;
        this._strName = simplePropertyProcessing ? this._field.getName() : this._field.getName().replace('$', '_');
        this._accessor = this._isStatic ? new StaticAccessor() : new NonStaticAccessor();
    }

    public String getName() {
        return this._strName;
    }

    void changeNameForNonStaticCollision() {
        this._strName = this._strName + "_";
    }

    public IType getFeatureType() {
        return this._type;
    }

    public boolean isStatic() {
        return this._isStatic;
    }

    public boolean isReadable() {
        return true;
    }

    public boolean isWritable(IType whosAskin) {
        IRelativeTypeInfo.Accessibility accessibilityForType = ((IRelativeTypeInfo)this.getContainer()).getAccessibilityForType(whosAskin);
        return !Modifier.isFinal(this._field.getModifiers()) && FeatureManager.isFeatureAccessible((IAttributedFeatureInfo)this, (IRelativeTypeInfo.Accessibility)accessibilityForType);
    }

    public boolean isWritable() {
        return this.isWritable(null);
    }

    public boolean isDeprecated() {
        return super.isDeprecated() || this.getField().isAnnotationPresent(Deprecated.class);
    }

    public String getDeprecatedReason() {
        String deprecated = super.getDeprecatedReason();
        if (this.isDeprecated() && deprecated == null) {
            return (String)this.getField().getAnnotation(Deprecated.class).getFieldValue("value");
        }
        return deprecated;
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this._field.getModifiers());
    }

    public boolean isInternal() {
        return !this.isPrivate() && !this.isProtected() && !this.isPublic();
    }

    public boolean isProtected() {
        return Modifier.isProtected(this._field.getModifiers());
    }

    public boolean isPublic() {
        return Modifier.isPublic(this._field.getModifiers());
    }

    public String getDescription() {
        return this.getVarDocs().get() == null ? null : ((IVarNode)this.getVarDocs().get()).getDescription();
    }

    private IDocRef<IVarNode> getVarDocs() {
        return this._docs;
    }

    public IPropertyAccessor getAccessor() {
        return this._accessor;
    }

    @Override
    public List<IAnnotationInfo> getDeclaredAnnotations() {
        List<IAnnotationInfo> annotations = super.getDeclaredAnnotations();
        if (this.getVarDocs().get() != null && ((IVarNode)this.getVarDocs().get()).isDeprecated()) {
            annotations.add(GosuShop.getAnnotationInfoFactory().createJavaAnnotation((Annotation)this.makeDeprecated(((IVarNode)this.getVarDocs().get()).getDeprecated()), (IFeatureInfo)this));
        }
        return annotations;
    }

    public IPresentationInfo getPresentationInfo() {
        return IPresentationInfo.Default.GET;
    }

    public IJavaClassField getField() {
        return this._field;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    protected IJavaAnnotatedElement getAnnotatedElement() {
        return this._field;
    }

    @Override
    protected boolean isVisibleViaFeatureDescriptor(IScriptabilityModifier constraint) {
        return true;
    }

    @Override
    protected boolean isHiddenViaFeatureDescriptor() {
        return false;
    }

    @Override
    protected boolean isDefaultEnumFeature() {
        return false;
    }

    public String getReturnDescription() {
        return null;
    }

    public boolean isCompileTimeConstantValue() {
        return Modifier.isStatic(this.getField().getModifiers()) && Modifier.isFinal(this.getField().getModifiers()) && this.isCompileTimeConstant();
    }

    private boolean isCompileTimeConstant() {
        IJavaClassField field = this.getField();
        if (field instanceof JavaSourceEnumConstant) {
            return true;
        }
        if (field instanceof JavaSourceField) {
            String rhs = ((JavaSourceField)field).getRhs();
            if (rhs == null) {
                return false;
            }
            IExpression pr = CompileTimeExpressionParser.parse(rhs, field.getEnclosingClass(), this.getFeatureType());
            return pr.isCompileTimeConstant();
        }
        if (field instanceof AsmFieldJavaClassField && ((AsmFieldJavaClassField)field).getStaticValue() != null) {
            return true;
        }
        if (field instanceof FieldJavaClassField || field instanceof AsmFieldJavaClassField) {
            return field.isEnumConstant() || field.getType().isPrimitive() || field.getType().getName().equals("java.lang.String") || field.getType().getName().equals("java.lang.Class");
        }
        return false;
    }

    public Object doCompileTimeEvaluation() {
        IJavaClassField field = this.getField();
        if (field instanceof JavaSourceEnumConstant) {
            return field.getName();
        }
        if (field instanceof JavaSourceField) {
            String rhs = ((JavaSourceField)field).getRhs();
            IExpression pr = CompileTimeExpressionParser.parse(rhs, ((IJavaType)this.getOwnersType()).getBackingClassInfo(), this.getFeatureType());
            return pr.evaluate();
        }
        if (field instanceof FieldJavaClassField) {
            try {
                Object value = ((FieldJavaClassField)field).get(null);
                return CompileTimeExpressionParser.convertValueToInfoFriendlyValue(value, (IFeatureInfo)this.getOwnersType().getTypeInfo());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        if (field instanceof AsmFieldJavaClassField) {
            if (field.isEnumConstant()) {
                return field.getName();
            }
            Object value = ((AsmFieldJavaClassField)field).getStaticValue();
            return CompileTimeExpressionParser.convertValueToInfoFriendlyValue(value, (IFeatureInfo)this.getOwnersType().getTypeInfo());
        }
        throw new IllegalStateException("Unexpected field type: " + field);
    }

    public ILocationInfo getLocationInfo() {
        if (this.getField() instanceof JavaSourceElement) {
            return this.getField().getLocationInfo();
        }
        return super.getLocationInfo();
    }

    private class NonStaticAccessor
    implements IPropertyAccessor {
        private NonStaticAccessor() {
        }

        public Object getValue(Object ctx) {
            try {
                return ((FieldJavaClassField)JavaFieldPropertyInfo.this._field).get(ctx);
            }
            catch (IllegalAccessException e) {
                throw GosuExceptionUtil.forceThrow((Throwable)e);
            }
        }

        public void setValue(Object ctx, Object value) {
            if (!JavaFieldPropertyInfo.this.isWritable(JavaFieldPropertyInfo.this.getOwnersType())) {
                throw new EvaluationException("Property, " + JavaFieldPropertyInfo.this.getName() + ", is not writable!");
            }
            try {
                value = CommonServices.getCoercionManager().convertValue(value, JavaFieldPropertyInfo.this.getFeatureType());
                ((FieldJavaClassField)JavaFieldPropertyInfo.this._field).set(ctx, value);
            }
            catch (IllegalAccessException e) {
                throw GosuExceptionUtil.forceThrow((Throwable)e);
            }
        }
    }

    private class StaticAccessor
    implements IPropertyAccessor {
        private StaticAccessor() {
        }

        public Object getValue(Object ctx) {
            try {
                return ((FieldJavaClassField)JavaFieldPropertyInfo.this._field).get(null);
            }
            catch (IllegalAccessException e) {
                throw GosuExceptionUtil.forceThrow((Throwable)e);
            }
        }

        public void setValue(Object ctx, Object value) {
            if (!JavaFieldPropertyInfo.this.isWritable(JavaFieldPropertyInfo.this.getOwnersType())) {
                throw new EvaluationException("Property, " + JavaFieldPropertyInfo.this.getName() + ", is not writable!");
            }
            try {
                value = CommonServices.getCoercionManager().convertValue(value, JavaFieldPropertyInfo.this.getFeatureType());
                ((FieldJavaClassField)JavaFieldPropertyInfo.this._field).set(null, value);
            }
            catch (IllegalAccessException e) {
                throw GosuExceptionUtil.forceThrow((Throwable)e);
            }
        }
    }
}

