/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.config.CommonServices;
import gw.config.ExecutionMode;
import gw.fs.IDirectory;
import gw.internal.gosu.parser.IModuleClassLoader;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.module.IExecutionEnvironment;
import gw.lang.reflect.module.IModule;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ModuleClassLoader
extends URLClassLoader
implements IModuleClassLoader {
    private IModule _module;

    private ModuleClassLoader(URL[] urls, ClassLoader parent, IModule module) {
        super(urls, parent);
        this._module = module;
        super.addURL(null);
    }

    public Class<?> loadLocalClass(String name, boolean resolve) throws ClassNotFoundException {
        return super.loadClass(name, resolve);
    }

    public boolean isDeferToParent() {
        return this.getURLs().length == 0 && this._module == this._module.getExecutionEnvironment().getJreModule();
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Throwable t;
        if (this._module == null) {
            throw new RuntimeException("This loader has been disposed and cannot be used for class loading purposes.");
        }
        if (name.equalsIgnoreCase("con") || name.toLowerCase().endsWith(".con")) {
            return null;
        }
        try {
            Class<?> aClass = this.loadLocalClass(name, resolve);
            return aClass;
        }
        catch (ClassNotFoundException e1) {
            t = e1;
        }
        catch (NoClassDefFoundError e2) {
            t = e2;
        }
        for (IModule m : this._module.getModuleTraversalList()) {
            if (m == this._module || m == TypeSystem.getGlobalModule()) continue;
            ClassLoader moduleClassLoader = m.getModuleClassLoader();
            try {
                Class aClass = moduleClassLoader instanceof IModuleClassLoader ? ((IModuleClassLoader)moduleClassLoader).loadLocalClass(name, resolve) : moduleClassLoader.loadClass(name);
                return aClass;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException("Class not found at all: " + name, t);
    }

    public static ClassLoader create(IModule module) {
        List javaClassPath = module.getJavaClassPath();
        List<Object> urls = new ArrayList<URL>(javaClassPath.size());
        for (IDirectory entry : javaClassPath) {
            try {
                urls.add(entry.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        IExecutionEnvironment environment = module.getExecutionEnvironment();
        if (ExecutionMode.isRuntime()) {
            urls = Collections.emptyList();
        }
        ClassLoader parent = module == environment.getJreModule() ? CommonServices.getEntityAccess().getPluginClassLoader() : null;
        return new ModuleClassLoader(urls.toArray(new URL[urls.size()]), parent, module);
    }

    public void dispose() {
        this._module = null;
    }
}

