/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.config.CommonServices;
import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.IGosuAnnotation;
import gw.internal.gosu.parser.IGosuProgramInternal;
import gw.internal.gosu.parser.ParseTree;
import gw.internal.gosu.parser.PositionToken;
import gw.internal.gosu.parser.StandardParserState;
import gw.internal.gosu.parser.Token;
import gw.internal.gosu.parser.expressions.AnnotationExpression;
import gw.internal.gosu.parser.expressions.Program;
import gw.internal.gosu.parser.statements.ClassFileStatement;
import gw.internal.gosu.parser.statements.ClassStatement;
import gw.internal.gosu.parser.statements.NoOpStatement;
import gw.lang.parser.IExpression;
import gw.lang.parser.IFullParserState;
import gw.lang.parser.IParseIssue;
import gw.lang.parser.IParseTree;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.IParsedElementWithAtLeastOneDeclaration;
import gw.lang.parser.IParserState;
import gw.lang.parser.IScriptPartId;
import gw.lang.parser.IToken;
import gw.lang.parser.exceptions.IWarningSuppressor;
import gw.lang.parser.exceptions.ParseException;
import gw.lang.parser.exceptions.ParseIssue;
import gw.lang.parser.exceptions.ParseWarning;
import gw.lang.parser.resources.ResourceKey;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.module.IModule;
import gw.util.GosuObjectUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.Consumer;

public abstract class ParsedElement
implements IParsedElement {
    private static final List<IParseTree> EMPTY_PARSETREE_LIST = Collections.emptyList();
    public static final String UNDEF_MODULE = "[undefined-module]";
    public static final String UNDEF_FUNCTION = "[undefined-function]";
    public static final String UNDEF_FILE = "undefined-module.gs";
    private ParseTree _location;
    private IParsedElement _parent;
    private int _iLineNum;
    private int _iColumn;
    private LikelyNullFields _lnf;
    private IGosuProgramInternal _gosuProgram;
    protected List<IToken> _tokens = new ArrayList<IToken>(2);

    ParsedElement() {
    }

    public IGosuProgramInternal getGosuProgram() {
        return this._gosuProgram;
    }

    public void setGosuProgram(IGosuProgramInternal gosuProgram) {
        this._gosuProgram = gosuProgram;
    }

    public void addExceptionsFrom(IParsedElement elem) {
        List warnings;
        List exceptions = elem.getParseExceptions();
        if (!exceptions.isEmpty()) {
            this.maybeInitLikelyNullFields();
            if (this._lnf._parseExceptions == Collections.EMPTY_LIST) {
                this._lnf._parseExceptions = new ArrayList(exceptions.size());
            }
            this._lnf._parseExceptions.addAll(exceptions);
        }
        if (!(warnings = elem.getParseWarnings()).isEmpty()) {
            this.maybeInitLikelyNullFields();
            if (this._lnf._parseWarnings == Collections.EMPTY_LIST) {
                this._lnf._parseWarnings = new ArrayList(warnings.size());
            }
            this._lnf._parseWarnings.addAll(warnings);
        }
    }

    private void maybeInitLikelyNullFields() {
        if (this._lnf == null) {
            this._lnf = new LikelyNullFields();
        }
    }

    public ParseTree getLocation() {
        return this._location;
    }

    public void setLocation(IParseTree location) {
        this._location = (ParseTree)location;
    }

    public ParseTree initLocation(int offset, int length, int lineNumber, int iColumn, IScriptPartId scriptPart) {
        this._iLineNum = lineNumber;
        this._iColumn = iColumn;
        if (this._location == null) {
            this._location = new ParseTree(this, offset, length, scriptPart);
        } else {
            this._location.initLocation(this, offset, length);
        }
        return this._location;
    }

    public void visit(Consumer<IParsedElement> visitor) {
        int count;
        ParseTree location = this.getLocation();
        if (location != null && (count = location.getChildCount()) > 0) {
            for (int i = 0; i < count; ++i) {
                ParseTree child = location.getChild(i);
                ParsedElement pe = child.getParsedElement();
                if (pe == null) continue;
                pe.visit(visitor);
            }
        }
        visitor.accept(this);
    }

    public void initEmptyParseTree() {
        this.initLocation(-1, -1, -1, -1, null);
    }

    public boolean hasParseIssues() {
        return this.hasParseExceptions() || this.hasParseWarnings();
    }

    public List<IParseIssue> getParseIssues() {
        List<Object> issues = new ArrayList<IParseIssue>();
        this.getParseExceptions(issues);
        this.getParseWarnings(issues);
        if (issues.isEmpty()) {
            issues = Collections.emptyList();
        } else {
            issues.trimToSize();
        }
        return issues;
    }

    public List<IParseIssue> getImmediateParseIssues() {
        List<IParseIssue> issues = null;
        if (this._lnf != null) {
            if (this._lnf._parseExceptions != null && this._lnf._parseExceptions.size() > 0) {
                if (issues == null) {
                    issues = new ArrayList<IParseIssue>();
                }
                ((ArrayList)issues).addAll(this._lnf._parseExceptions);
            }
            if (this._lnf._parseWarnings != null && this._lnf._parseWarnings.size() > 0) {
                if (issues == null) {
                    issues = new ArrayList<IParseIssue>();
                }
                for (IParseIssue exc : this._lnf._parseWarnings) {
                    if (this.isSuppressed(exc)) continue;
                    ((ArrayList)issues).add(exc);
                }
            }
        }
        return issues != null ? issues : Collections.emptyList();
    }

    public boolean hasParseExceptions() {
        List<IParseTree> children;
        if (this._lnf != null && !this._lnf._parseExceptions.isEmpty()) {
            return true;
        }
        ParseTree location = this.getLocation();
        List<IParseTree> list = children = location != null ? location.getChildren() : null;
        if (children != null) {
            for (int i = 0; i < children.size(); ++i) {
                IParsedElement pe;
                IParseTree child;
                try {
                    child = children.get(i);
                }
                catch (Throwable t) {
                    return false;
                }
                if (child == null || (pe = child.getParsedElement()) == null || !pe.hasParseExceptions()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasParseException(ResourceKey errKey) {
        for (IParseIssue err : this.getParseExceptions()) {
            if (err.getMessageKey() != errKey) continue;
            return true;
        }
        return false;
    }

    public IParseIssue getImmediateParseIssue(ResourceKey errKey) {
        for (IParseIssue err : this.getImmediateParseIssues()) {
            if (err.getMessageKey() != errKey) continue;
            return err;
        }
        return null;
    }

    public boolean hasImmediateParseIssue(ResourceKey errKey) {
        return this.getImmediateParseIssue(errKey) != null;
    }

    public boolean hasParseWarning(ResourceKey errKey) {
        for (int i = 0; i < this.getParseWarnings().size(); ++i) {
            IParseIssue warning = this.getParseWarnings().get(i);
            if (warning.getMessageKey() != errKey) continue;
            return true;
        }
        return false;
    }

    public void addParseWarnings(List<IParseIssue> parseWarnings) {
        for (int i = 0; i < parseWarnings.size(); ++i) {
            IParseIssue w = parseWarnings.get(i);
            this.addParseWarning(w);
        }
    }

    public void addParseExceptions(List<IParseIssue> parseExceptions) {
        for (IParseIssue w : parseExceptions) {
            this.addParseException(w);
        }
    }

    public void addParseIssues(List<IParseIssue> parseIssues) {
        for (IParseIssue p : parseIssues) {
            if (p instanceof ParseException) {
                this.addParseException(p);
                continue;
            }
            if (!(p instanceof ParseWarning)) continue;
            this.addParseWarning(p);
        }
    }

    public List<IParseIssue> getParseExceptions() {
        ArrayList<IParseIssue> list = new ArrayList<IParseIssue>();
        this.getParseExceptions(list);
        return list.isEmpty() ? Collections.emptyList() : list;
    }

    private void getParseExceptions(List<IParseIssue> allParseExceptions) {
        ParseTree location;
        List<IParseTree> children;
        if (this._lnf != null) {
            allParseExceptions.addAll(this._lnf._parseExceptions);
        }
        List<IParseTree> list = children = (location = this.getLocation()) == null ? null : location.getChildren();
        if (children != null) {
            for (int i = 0; i < children.size(); ++i) {
                IParseTree child = children.get(i);
                IParsedElement pe = child.getParsedElement();
                if (pe == null) continue;
                ((ParsedElement)pe).getParseExceptions(allParseExceptions);
            }
        }
    }

    public void addParseException(ResourceKey msgKey, Object ... args) {
        String src = this.getSource();
        this.addParseException((IParseIssue)new ParseException((IParserState)new StandardParserState(this, src, false), msgKey, args));
    }

    public void addParseException(IFullParserState parserState, ResourceKey msgKey, Object ... args) {
        String src = this.getSource();
        this.addParseException((IParseIssue)new ParseException((IParserState)parserState, msgKey, args));
    }

    public ParseException removeParseException(ResourceKey keyToRemove) {
        if (this._lnf != null) {
            return (ParseException)((Object)this.removeParseIssue(keyToRemove, this._lnf._parseExceptions));
        }
        return null;
    }

    public ParseWarning removeParseWarning(ResourceKey keyToRemove) {
        if (this._lnf != null) {
            return (ParseWarning)this.removeParseIssue(keyToRemove, this._lnf._parseWarnings);
        }
        return null;
    }

    public void removeParseWarningRecursively(ResourceKey keyToRemove) {
        List<IParseTree> children;
        while (this._lnf != null && this.removeParseWarning(keyToRemove) != null) {
        }
        ParseTree location = this.getLocation();
        List<IParseTree> list = children = location == null ? null : location.getChildren();
        if (children != null) {
            for (int i = 0; i < children.size(); ++i) {
                IParseTree child = children.get(i);
                IParsedElement pe = child.getParsedElement();
                if (pe == null) continue;
                ((ParsedElement)pe).removeParseWarningRecursively(keyToRemove);
            }
        }
    }

    private <E extends IParseIssue> E removeParseIssue(ResourceKey keyToRemove, List<E> issues) {
        IParseIssue pe = null;
        if (this._lnf != null && !issues.isEmpty()) {
            Iterator<E> it = issues.iterator();
            while (it.hasNext()) {
                IParseIssue parseIssue = (IParseIssue)it.next();
                if (keyToRemove != null && !keyToRemove.equals(parseIssue.getMessageKey())) continue;
                pe = parseIssue;
                it.remove();
            }
        }
        return (E)pe;
    }

    private String getSource() {
        String src = null;
        for (ParsedElement element = this; element != null; element = element.getParent()) {
            if (element instanceof ClassStatement) {
                src = ((ClassStatement)element).getGosuClass().getSource();
                break;
            }
            if (!(element instanceof Program)) continue;
            src = element.toString();
            break;
        }
        return src;
    }

    public IGosuClass getGosuClass() {
        IParsedElement parent = this.getParent();
        if (parent != null) {
            return parent.getGosuClass();
        }
        return null;
    }

    public void addParseWarning(ResourceKey msgKey, Object ... args) {
        String src = this.getSource();
        this.addParseWarning((IParseIssue)new ParseWarning((IParserState)new StandardParserState(this, src, false), msgKey, args));
    }

    public void addParseException(IParseIssue pe) {
        if (this.hasParseIssue(pe)) {
            return;
        }
        this.maybeInitLikelyNullFields();
        if (this._lnf._parseExceptions == Collections.EMPTY_LIST) {
            this._lnf._parseExceptions = new ArrayList(1);
        }
        this._lnf._parseExceptions.add(pe);
        ((ArrayList)this._lnf._parseExceptions).trimToSize();
        ((ParseException)pe).setSource((IParsedElement)this);
    }

    public void clearParseExceptions() {
        ParseTree location;
        List<IParseTree> children;
        if (this._lnf != null) {
            this._lnf._parseExceptions = Collections.emptyList();
        }
        List<IParseTree> list = children = (location = this.getLocation()) == null ? EMPTY_PARSETREE_LIST : location.getChildren();
        if (!children.isEmpty()) {
            for (IParseTree child : children) {
                child.getParsedElement().clearParseExceptions();
            }
        }
    }

    public void clearParseWarnings() {
        ParseTree location;
        List<IParseTree> children;
        if (this._lnf != null) {
            this._lnf._parseWarnings = Collections.emptyList();
        }
        List<IParseTree> list = children = (location = this.getLocation()) == null ? EMPTY_PARSETREE_LIST : location.getChildren();
        if (!children.isEmpty()) {
            for (IParseTree child : children) {
                child.getParsedElement().clearParseWarnings();
            }
        }
    }

    public boolean hasImmediateParseWarnings() {
        return this._lnf != null && this._lnf._parseWarnings.size() > 0;
    }

    public boolean hasImmediateParseWarning(ResourceKey errKey) {
        if (this._lnf == null || this._lnf._parseWarnings.isEmpty()) {
            return false;
        }
        for (IParseIssue w : this._lnf._parseWarnings) {
            if (!w.getMessageKey().equals(errKey)) continue;
            return true;
        }
        return false;
    }

    public boolean hasParseWarnings() {
        List<IParseTree> children;
        if (this._lnf != null && !this._lnf._parseWarnings.isEmpty()) {
            return true;
        }
        ParseTree location = this.getLocation();
        List<IParseTree> list = children = location != null ? location.getChildren() : EMPTY_PARSETREE_LIST;
        if (!children.isEmpty()) {
            for (IParseTree child : children) {
                IParsedElement pe = child.getParsedElement();
                if (pe == null || !pe.hasParseWarnings()) continue;
                return true;
            }
        }
        return false;
    }

    public List<IParseIssue> getParseWarnings() {
        ArrayList<IParseIssue> list = new ArrayList<IParseIssue>();
        this.getParseWarnings(list);
        return list.isEmpty() ? Collections.emptyList() : list;
    }

    private void getParseWarnings(List<IParseIssue> allWarnings) {
        ParseTree location;
        List<IParseTree> children;
        if (this._lnf != null) {
            for (IParseIssue exc : this._lnf._parseWarnings) {
                if (this.isSuppressed(exc)) continue;
                allWarnings.add(exc);
            }
        }
        List<IParseTree> list = children = (location = this.getLocation()) == null ? EMPTY_PARSETREE_LIST : location.getChildren();
        if (!children.isEmpty()) {
            for (int i = 0; i < children.size(); ++i) {
                IParseTree child = children.get(i);
                IParsedElement pe = child.getParsedElement();
                if (pe == null) continue;
                ((ParsedElement)pe).getParseWarnings(allWarnings);
            }
        }
    }

    public void addParseWarning(IParseIssue warning) {
        if (this.hasParseIssue(warning)) {
            return;
        }
        if (this.getLocation() == null || this.getLocation().getEnclosingType() == null || CommonServices.getEntityAccess().shouldAddWarning(this.getLocation().getEnclosingType(), warning)) {
            this.maybeInitLikelyNullFields();
            if (this._lnf._parseWarnings == Collections.emptyList()) {
                this._lnf._parseWarnings = new ArrayList(1);
            }
            this._lnf._parseWarnings.add(warning);
            ((ArrayList)this._lnf._parseWarnings).trimToSize();
            ((ParseIssue)warning).setSource((IParsedElement)this);
        }
    }

    public boolean hasParseIssue(IParseIssue pi) {
        if (this._lnf == null) {
            return false;
        }
        for (IParseIssue pw : this.getParseWarnings()) {
            if (!GosuObjectUtil.equals((Object)pw.getTokenStart(), (Object)pi.getTokenStart()) || pw.getMessageKey() != pi.getMessageKey() || !GosuObjectUtil.equals((Object)pw.getConsoleMessage(), (Object)pi.getConsoleMessage())) continue;
            return true;
        }
        for (IParseIssue pe : this._lnf._parseExceptions) {
            if (pe.getTokenStart() == null || !pe.getTokenStart().equals(pi.getTokenStart()) || pe.getMessageKey() != pi.getMessageKey() || !GosuObjectUtil.equals((Object)pe.getPlainMessage(), (Object)pi.getPlainMessage())) continue;
            return true;
        }
        return false;
    }

    public boolean isSuppressed(IParseIssue issue) {
        return issue instanceof IWarningSuppressor && this.isSuppressed((IWarningSuppressor)issue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSuppressed(IWarningSuppressor suppressor) {
        IModule mod;
        IModule iModule = mod = this.getGosuClass() == null ? null : this.getModule();
        if (mod != null) {
            TypeSystem.pushModule((IModule)mod);
        }
        try {
            for (IGosuAnnotation anno : this.getAnnotations()) {
                IExpression annoExpr;
                if (anno.getType() != TypeSystem.get(SuppressWarnings.class) || !((annoExpr = anno.getExpression()) instanceof AnnotationExpression) || ((AnnotationExpression)annoExpr).getArgs() == null) continue;
                for (Expression expr : ((AnnotationExpression)annoExpr).getArgs()) {
                    Object value = expr.evaluate();
                    if (value instanceof String) {
                        if (!suppressor.isSuppressed((String)value)) continue;
                        boolean bl = true;
                        return bl;
                    }
                    if (value instanceof Object[]) {
                        for (Object o : (Object[])value) {
                            if (!suppressor.isSuppressed((String)o)) continue;
                            boolean bl = true;
                            return bl;
                        }
                        continue;
                    }
                    if (!(value instanceof List)) continue;
                    for (Object o : (List)value) {
                        if (!suppressor.isSuppressed((String)o)) continue;
                        int n = 1;
                        return n != 0;
                    }
                }
            }
            ParsedElement parent = (ParsedElement)this.getParent();
            boolean bl = parent != null && parent.isSuppressed(suppressor);
            return bl;
        }
        finally {
            if (mod != null) {
                TypeSystem.popModule((IModule)mod);
            }
        }
    }

    public List<IGosuAnnotation> getAnnotations() {
        return Collections.emptyList();
    }

    public boolean isCompileTimeConstant() {
        return false;
    }

    public <E extends IParsedElement> boolean getContainedParsedElementsByType(Class<E> parsedElementType, List<E> listResults) {
        return this.getContainedParsedElementsByTypes(listResults, parsedElementType);
    }

    public boolean getContainedParsedElementsByTypes(List<IParsedElement> listResults, Class<? extends IParsedElement> ... parsedElementTypes) {
        return this.getContainedParsedElementsByTypesWithIgnoreSet(listResults, Collections.EMPTY_SET, parsedElementTypes);
    }

    public boolean getContainedParsedElementsByTypesWithIgnoreSet(List<IParsedElement> listResults, Set<Class<? extends IParsedElement>> ignoreSet, Class<? extends IParsedElement> ... parsedElementTypes) {
        List<IParseTree> children;
        ParseTree location;
        boolean isInstance = false;
        for (Class<? extends IParsedElement> parsedElementType : parsedElementTypes) {
            if (!parsedElementType.isInstance(this)) continue;
            isInstance = true;
            break;
        }
        if (isInstance) {
            if (listResults != null) {
                listResults.add(this);
            } else {
                return true;
            }
        }
        boolean bIgnore = false;
        for (Class<? extends IParsedElement> ignore : ignoreSet) {
            if (!ignore.isInstance(this)) continue;
            bIgnore = true;
            break;
        }
        if (!bIgnore && (location = this.getLocation()) != null && !(children = location.getChildren()).isEmpty()) {
            for (int i = 0; i < children.size(); ++i) {
                IParseTree child = children.get(i);
                IParsedElement parsedElement = child.getParsedElement();
                if (!parsedElement.getContainedParsedElementsByTypesWithIgnoreSet(listResults, ignoreSet, (Class[])parsedElementTypes) || listResults != null) continue;
                return true;
            }
        }
        return listResults != null && listResults.size() > 0;
    }

    public final Integer makeInteger(Object obj) {
        if (obj == null) {
            return null;
        }
        return CommonServices.getCoercionManager().makeIntegerFrom(obj);
    }

    public static Long makeLong(Object obj) {
        if (obj == null) {
            return null;
        }
        return CommonServices.getCoercionManager().makeLongFrom(obj);
    }

    public static double makeDoubleValue(Object obj) {
        if (obj == null) {
            return Double.NaN;
        }
        return CommonServices.getCoercionManager().makePrimitiveDoubleFrom(obj);
    }

    public static float makeFloatValue(Object obj) {
        if (obj == null) {
            return Float.NaN;
        }
        return CommonServices.getCoercionManager().makePrimitiveFloatFrom(obj);
    }

    public void compactParseTree() {
        if (this._location != null) {
            this._location.compactParseTree();
        }
    }

    public void clearParseTreeInformation() {
        if (this.shouldClearParseInfo()) {
            TypeSystem.lock();
            try {
                if (this._location != null) {
                    ParseTree loc = this._location;
                    IParseTree parent = loc.getParent();
                    this._location.clearParseTreeInformation();
                    if (parent != null) {
                        parent.removeChild((IParseTree)loc);
                    }
                }
                this._location = null;
                if (this._lnf != null) {
                    this._lnf._declaringStatements = null;
                }
            }
            finally {
                TypeSystem.unlock();
            }
        }
    }

    public IParsedElement getParent() {
        return this._parent;
    }

    public void setParent(IParsedElement parent) {
        this._parent = parent;
    }

    public int getLineNum() {
        return this._iLineNum;
    }

    public void adjustLineNum(int offset) {
        this._iLineNum += offset;
    }

    public void setLineNum(int iLineNum) {
        this._iLineNum = iLineNum;
    }

    public int getColumn() {
        return this._iColumn;
    }

    public void adjustColumn(int offset) {
        this._iColumn += offset;
    }

    public String getFunctionName() {
        return this.getParent() == null ? UNDEF_FUNCTION : this.getParent().getFunctionName();
    }

    public boolean isSynthetic() {
        return this._lnf != null && this._lnf._bSynthetic;
    }

    public void setSynthetic(boolean bSynthetic) {
        this.maybeInitLikelyNullFields();
        this._lnf._bSynthetic = bSynthetic;
    }

    public IModule getModule() {
        IParsedElement parent = this.getParent();
        return parent == null ? null : parent.getModule();
    }

    public static IFeatureInfo getEnclosingFeatureInfo(Stack<IFeatureInfo> enclosingFeatureInfos) {
        if (enclosingFeatureInfos.empty()) {
            return null;
        }
        return enclosingFeatureInfos.peek();
    }

    public static ITypeInfo getQualifyingEnclosingTypeInfo(Stack<IFeatureInfo> enclosingFeatureInfos) {
        if (enclosingFeatureInfos.empty()) {
            return null;
        }
        return (ITypeInfo)enclosingFeatureInfos.firstElement();
    }

    public int findLineNumberOfDeclaration(String identifierName) {
        IParsedElementWithAtLeastOneDeclaration statement = this.findDeclaringStatement(this, identifierName);
        return statement.getLineNum();
    }

    public IParsedElementWithAtLeastOneDeclaration findDeclaringStatement(IParsedElement element, String identifierName) {
        Object declaringStatement;
        IParsedElementWithAtLeastOneDeclaration iParsedElementWithAtLeastOneDeclaration = declaringStatement = this._lnf == null || this._lnf._declaringStatements == null ? null : (IParsedElementWithAtLeastOneDeclaration)this._lnf._declaringStatements.get(identifierName);
        if (declaringStatement == null) {
            declaringStatement = ParsedElement.checkIfDeclaringStatement(element, identifierName);
            if (declaringStatement == null && (declaringStatement = ParsedElement.findDeclaringStatementInChildren(element, identifierName)) == null) {
                IParsedElement parent = element.getParent();
                declaringStatement = parent != null ? this.findDeclaringStatement(parent, identifierName) : null;
            }
            if (element == this && declaringStatement != null) {
                this.maybeInitLikelyNullFields();
                this._lnf._declaringStatements = new HashMap(0);
                this._lnf._declaringStatements.put(identifierName, declaringStatement);
            }
        }
        return declaringStatement;
    }

    private static IParsedElementWithAtLeastOneDeclaration findDeclaringStatementInChildren(IParsedElement element, String identifierName) {
        if (element.getLocation() == null) {
            return null;
        }
        List children = element.getLocation().getChildren();
        for (IParseTree child : children) {
            IParsedElement parsedElement = child.getParsedElement();
            IParsedElementWithAtLeastOneDeclaration declaringStatement = ParsedElement.checkIfDeclaringStatement(parsedElement, identifierName);
            if (declaringStatement != null) {
                return declaringStatement;
            }
            if (!(parsedElement instanceof ClassStatement) && !(parsedElement instanceof ClassFileStatement) || (declaringStatement = ParsedElement.findDeclaringStatementInChildren(parsedElement, identifierName)) == null) continue;
            return declaringStatement;
        }
        return null;
    }

    private static IParsedElementWithAtLeastOneDeclaration checkIfDeclaringStatement(IParsedElement parsedElement, String identifierName) {
        IParsedElementWithAtLeastOneDeclaration declarativeStatement;
        if (parsedElement instanceof IParsedElementWithAtLeastOneDeclaration && (declarativeStatement = (IParsedElementWithAtLeastOneDeclaration)parsedElement).declares(identifierName)) {
            return declarativeStatement;
        }
        return null;
    }

    public IParsedElement findRootParsedElement() {
        IParsedElement parent = this.getParent();
        if (parent == null) {
            return this;
        }
        return parent.findRootParsedElement();
    }

    public IParsedElement findAncestorParsedElementByType(Class ... parsedElementClasses) {
        IParsedElement parent;
        for (parent = this.getParent(); parent != null && !ParsedElement.elementIsOneOfType(parent, parsedElementClasses); parent = parent.getParent()) {
        }
        if (parent != null) {
            return parent;
        }
        return null;
    }

    private static boolean elementIsOneOfType(IParsedElement element, Class[] parsedElementClasses) {
        for (Class statementClass : parsedElementClasses) {
            if (!statementClass.isAssignableFrom(element.getClass())) continue;
            return true;
        }
        return false;
    }

    public boolean shouldClearParseInfo() {
        return true;
    }

    public void assignTokens(List<Token> tokens) {
        List<IParseTree> children = this.getLocation().getChildren();
        for (IParseTree child : children) {
            ((ParsedElement)child.getParsedElement()).assignTokens(tokens);
        }
        this.assignTokensToJustMe(tokens);
    }

    protected void addToken(IToken token, IParseTree after) {
        token.setAfter(after);
        if (!this.containsToken(this._tokens, token)) {
            this._tokens.add(token);
        }
    }

    public List<IToken> getTokens() {
        return this._tokens;
    }

    private void assignTokensToJustMe(List<Token> tokens) {
        boolean bZeroLengthTree;
        int iTreeEnd;
        ParseTree parseTree = this.getLocation();
        int iStartOffset = -1;
        int iEndOffset = -1;
        IParseTree after = null;
        int iTreeOffset = parseTree.getOffset();
        int iStartIndex = this.binarySearchForFirstToken(tokens, iTreeOffset, iTreeEnd = parseTree.getExtent() + 1, bZeroLengthTree = parseTree.getLength() == 0);
        if (iStartIndex < 0) {
            return;
        }
        for (int i = iStartIndex; i < tokens.size(); ++i) {
            IToken token = tokens.get(i);
            int iTokenStart = token.getTokenStart();
            int iTokenEnd = token.getTokenEnd();
            if (iTokenStart >= iTreeOffset && iTokenEnd <= iTreeEnd) {
                if (iStartOffset < 0) {
                    iStartOffset = iTokenStart;
                }
                iEndOffset = iTokenEnd;
                if (this instanceof NoOpStatement && !this.isDescendent(after)) break;
                tokens.remove(i--);
                if (!(token instanceof PositionToken)) {
                    this.addToken(token, after);
                    continue;
                }
                after = ((PositionToken)token).getPos();
                continue;
            }
            if (bZeroLengthTree && iTreeOffset >= iTokenStart && iTreeOffset < iTokenEnd) {
                tokens.add(i, new PositionToken(parseTree, iTreeOffset, iTreeOffset));
                break;
            }
            if (iStartOffset < 0 || tokens.isEmpty()) continue;
            tokens.add(i, new PositionToken(parseTree, iStartOffset, iEndOffset));
            break;
        }
    }

    private int binarySearchForFirstToken(List<Token> tokens, int iTreeOffset, int iTreeEnd, boolean bZeroLengthTree) {
        int iStart = 0;
        int iEnd = tokens.size() - 1;
        while (iStart <= iEnd) {
            int iIndex = (iStart + iEnd) / 2;
            IToken token = tokens.get(iIndex);
            int iTokenStart = token.getTokenStart();
            int iTokenEnd = token.getTokenEnd();
            if (!bZeroLengthTree && iTokenStart >= iTreeOffset && iTokenEnd <= iTreeEnd) {
                int iSaveIndex = iIndex;
                if (iIndex > 0) {
                    --iIndex;
                    while (iIndex >= 0 && (token = (IToken)tokens.get(iIndex)) != null && token.getTokenStart() >= iTreeOffset && token.getTokenEnd() <= iTreeEnd) {
                        iSaveIndex = iIndex--;
                    }
                }
                return iSaveIndex;
            }
            if (bZeroLengthTree && iTreeOffset >= iTokenStart && iTreeOffset < iTokenEnd) {
                return iIndex;
            }
            if (iTokenStart < iTreeOffset) {
                iStart = iIndex + 1;
                continue;
            }
            iEnd = iIndex - 1;
        }
        return -1;
    }

    private boolean containsToken(List<IToken> tokens, IToken target) {
        int iStart = 0;
        int iEnd = tokens.size() - 1;
        int iOffset = target.getTokenStart();
        while (iStart <= iEnd) {
            int iIndex = (iStart + iEnd) / 2;
            IToken token = tokens.get(iIndex);
            if (token == target) {
                return true;
            }
            if (token.getTokenStart() < iOffset) {
                iStart = iIndex + 1;
                continue;
            }
            iEnd = iIndex - 1;
        }
        return false;
    }

    private boolean isDescendent(IParseTree after) {
        if (after == null) {
            return true;
        }
        if (after.getParsedElement() == this) {
            return true;
        }
        if (after.getParent() == null) {
            return false;
        }
        return this.isDescendent(after.getParent());
    }

    private static class LikelyNullFields {
        private List<IParseIssue> _parseExceptions = Collections.emptyList();
        private List<IParseIssue> _parseWarnings = Collections.emptyList();
        private Map<String, IParsedElementWithAtLeastOneDeclaration> _declaringStatements;
        private boolean _bSynthetic;

        private LikelyNullFields() {
        }
    }
}

