/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.gwPlatform;

import gw.config.CommonServices;
import gw.lang.parser.ICoercer;
import gw.lang.parser.IGosuParser;
import gw.lang.parser.StandardCoercionManager;
import gw.lang.parser.coercers.IdentityCoercer;
import gw.lang.reflect.IEnumConstant;
import gw.lang.reflect.IMetaType;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.util.Rational;
import java.math.BigDecimal;
import java.util.Date;

public class GWCoercionManager
extends StandardCoercionManager {
    public ICoercer getCoercerInternal(IType lhsType, IType rhsType, boolean runtime) {
        lhsType = TypeSystem.getTypeFromJavaBackedType((IType)lhsType);
        rhsType = TypeSystem.getTypeFromJavaBackedType((IType)rhsType);
        if (TypeSystem.isDeleted((IType)lhsType) || TypeSystem.isDeleted((IType)rhsType)) {
            return null;
        }
        ICoercer coercer = super.getCoercerInternal(lhsType, rhsType, runtime);
        if (coercer != null) {
            return coercer;
        }
        IType entityType = TypeSystem.getByFullNameIfValid((String)"gw.entity.IEntityType");
        if (entityType != null && entityType.equals(lhsType) && rhsType instanceof IMetaType && CommonServices.getEntityAccess().isEntityClass(((IMetaType)rhsType).getType())) {
            return IdentityCoercer.instance();
        }
        return null;
    }

    public String makeStringFrom(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Number) {
            Number number;
            long lValue;
            if (obj instanceof BigDecimal) {
                BigDecimal bd = (BigDecimal)obj;
                BigDecimal bdi = new BigDecimal(bd.toBigInteger());
                obj = bd.compareTo(bdi) == 0 ? bdi : bd;
            } else if ((obj instanceof Float || obj instanceof Double) && (double)(lValue = (number = (Number)obj).longValue()) == number.doubleValue()) {
                return String.valueOf(lValue);
            }
            return obj.toString();
        }
        if (obj instanceof Date) {
            return CommonServices.getCoercionManager().formatTime((Date)obj, "yyyy-MM-dd");
        }
        if (CommonServices.getEntityAccess().isDomainInstance(obj)) {
            return CommonServices.getEntityAccess().makeStringFrom(obj);
        }
        if (obj instanceof IEnumConstant) {
            return ((IEnumConstant)obj).getCode();
        }
        return obj.toString();
    }

    public BigDecimal makeBigDecimalFrom(Object obj) {
        if (obj instanceof String) {
            String strValue = (String)obj;
            if (strValue.length() == 0 || strValue.equals("-")) {
                return IGosuParser.BIGD_ZERO;
            }
            return new BigDecimal(this.parseNumber(strValue).toString());
        }
        return super.makeBigDecimalFrom(obj);
    }

    public Rational makeRationalFrom(Object obj) {
        return super.makeRationalFrom(obj);
    }
}

