/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.compiler;

import gw.config.CommonServices;
import gw.internal.gosu.compiler.DiscreteClassLoader;
import gw.internal.gosu.compiler.FunctionClassUtil;
import gw.internal.gosu.compiler.SingleServingGosuClassLoader;
import gw.internal.gosu.ir.TransformingCompiler;
import gw.internal.gosu.ir.transform.AbstractElementTransformer;
import gw.internal.gosu.parser.ExecutionEnvironment;
import gw.internal.gosu.parser.ICompilableTypeInternal;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.IGosuProgramInternal;
import gw.internal.gosu.parser.JavaMethodCache;
import gw.internal.gosu.parser.ModuleClassLoader;
import gw.internal.gosu.parser.TypeLord;
import gw.lang.parser.TypeSystemAwareCache;
import gw.lang.reflect.IGosuClassLoadingObserver;
import gw.lang.reflect.IHasJavaClass;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.BytecodeOptions;
import gw.lang.reflect.gs.ICompilableType;
import gw.lang.reflect.gs.IGosuClassLoader;
import gw.lang.reflect.gs.IGosuProgram;
import gw.lang.reflect.java.IJavaBackedType;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.java.JavaTypes;
import gw.lang.reflect.module.TypeSystemLockHelper;
import gw.util.GosuExceptionUtil;
import gw.util.concurrent.Cache;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import manifold.internal.runtime.Bootstrap;
import manifold.internal.runtime.UrlClassLoaderWrapper;

public class GosuClassLoader
implements IGosuClassLoader {
    private DiscreteLoaderCache _discreteLoaders = new DiscreteLoaderCache();
    private ClassLoader _loader;

    public static GosuClassLoader instance() {
        return (GosuClassLoader)TypeSystem.getGosuClassLoader();
    }

    public void dumpAllClasses() {
        AbstractElementTransformer.clearCustomRuntimes();
    }

    public byte[] getBytes(ICompilableType gsClass) {
        try {
            return GosuClassLoader.compileClass(gsClass, false);
        }
        catch (Exception pre) {
            throw GosuExceptionUtil.forceThrow((Throwable)new IOException(pre));
        }
    }

    public GosuClassLoader(ClassLoader parent) {
        this.assignParent(parent);
        this.init();
    }

    public void assignParent(ClassLoader parent) {
        if (parent instanceof ModuleClassLoader && ((ModuleClassLoader)parent).isDeferToParent()) {
            this._loader = parent.getParent();
            while (this._loader instanceof URLClassLoader && ((URLClassLoader)this._loader).getURLs().length == 0 && UrlClassLoaderWrapper.canWrap((ClassLoader)this._loader.getParent())) {
                this._loader = this._loader.getParent();
            }
        } else {
            this._loader = parent;
        }
    }

    private void init() {
    }

    public ClassLoader getLoader() {
        return this._loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadClass(String strName) throws ClassNotFoundException {
        IType type;
        String strGsName = strName.replace('$', '.');
        if (strGsName.startsWith("com.guidewire.commons.metadata.proxy._generated.iface.")) {
            strGsName = "entity." + strGsName.substring(strName.lastIndexOf(46) + 1);
        }
        if ((type = TypeSystem.getByFullNameIfValid((String)strGsName)) instanceof IGosuClassInternal) {
            return ((IGosuClassInternal)type).getBackingClass();
        }
        if (type instanceof IJavaBackedType) {
            return ((IJavaBackedType)type).getBackingClass();
        }
        TypeSystemLockHelper.getTypeSystemLockWithMonitor((Object)this._loader);
        try {
            Class<?> clazz = this._loader.loadClass(strName);
            return clazz;
        }
        finally {
            TypeSystem.unlock();
        }
    }

    public Class<?> findClass(String strName) throws ClassNotFoundException {
        return this.loadClass(strName);
    }

    public IJavaType getFunctionClassForArity(boolean hasReturn, int length) {
        return FunctionClassUtil.getFunctionClassForArity(hasReturn, length);
    }

    public Class defineClass(ICompilableTypeInternal gsClass, boolean useSingleServingLoader) throws ClassNotFoundException {
        try {
            if (gsClass instanceof IGosuClassInternal && ((IGosuClassInternal)gsClass).hasBackingClass()) {
                return ((IGosuClassInternal)gsClass).getBackingClass();
            }
            if (useSingleServingLoader || TypeLord.isEvalProgram((IType)gsClass) || this.isThrowawayProgram(gsClass) || this.isEnclosingTypeInSingleServingLoader(gsClass) || this.hasDiscreteNamespace(gsClass.getNamespace())) {
                return this.defineClassInLoader(gsClass, true);
            }
            return this.findOrDefineClass(gsClass);
        }
        catch (Exception e) {
            throw GosuExceptionUtil.forceThrow((Throwable)e, (String)gsClass.getName());
        }
    }

    boolean hasDiscreteNamespace(String namespace) {
        return this._discreteLoaders.getLoader(namespace) != null;
    }

    DiscreteClassLoader getDiscreteNamespaceLoader(String namespace) {
        return this._discreteLoaders.getLoader(namespace);
    }

    public boolean isLoaderUnloaded(String namespace) {
        return this._discreteLoaders.isLoaderUnloaded(namespace);
    }

    private boolean isEnclosingTypeInSingleServingLoader(ICompilableTypeInternal gsClass) {
        ICompilableTypeInternal enclosingType = gsClass.getEnclosingType();
        ClassLoader enclosingLoader = this.getClassLoader(enclosingType);
        return enclosingLoader instanceof SingleServingGosuClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class findOrDefineClass(ICompilableTypeInternal gsClass) throws ClassNotFoundException {
        String strName = gsClass.getJavaName();
        Class cls = null;
        try {
            cls = this._loader.loadClass(strName);
            if (cls.getClassLoader() instanceof SingleServingGosuClassLoader && ((SingleServingGosuClassLoader)cls.getClassLoader()).isDisposed()) {
                cls = null;
            }
        }
        catch (ClassNotFoundException cnfe) {
            TypeSystem.lock();
            try {
                cls = this.defineClassInLoader(gsClass, false);
            }
            finally {
                TypeSystem.unlock();
            }
        }
        return cls;
    }

    private Class defineClassInLoader(ICompilableTypeInternal gsClass, boolean forceSingleServingLoader) {
        if (forceSingleServingLoader || this.shouldUseSingleServingLoader(gsClass) || BytecodeOptions.isSingleServingLoader()) {
            SingleServingGosuClassLoader loader = this.getOrCreateSingleServingLoader(gsClass);
            return this.defineClassInSingleServingLoader(gsClass, loader);
        }
        return this.defineAndMaybeVerify(gsClass);
    }

    private SingleServingGosuClassLoader getOrCreateSingleServingLoader(ICompilableTypeInternal gsClass) {
        ClassLoader enclosingLoader;
        ICompilableTypeInternal enclosingType = gsClass.getEnclosingType();
        ClassLoader classLoader = enclosingLoader = this.isOldStyleGosuAnnotationExpression(gsClass) ? null : this.getClassLoader(enclosingType);
        if (enclosingLoader instanceof SingleServingGosuClassLoader && !(enclosingLoader instanceof DiscreteClassLoader)) {
            return (SingleServingGosuClassLoader)enclosingLoader;
        }
        DiscreteClassLoader namespaceLoader = this.getDiscreteNamespaceLoader(gsClass.getNamespace());
        return namespaceLoader == null ? new SingleServingGosuClassLoader(this) : namespaceLoader;
    }

    private boolean isOldStyleGosuAnnotationExpression(ICompilableTypeInternal gsClass) {
        if (!(gsClass instanceof IGosuProgram)) {
            return false;
        }
        IType expectedReturnType = ((IGosuProgram)gsClass).getExpectedReturnType();
        return expectedReturnType != null && JavaTypes.IANNOTATION().isAssignableFrom(expectedReturnType);
    }

    private ClassLoader getClassLoader(ICompilableTypeInternal enclosingType) {
        if (enclosingType == null) {
            return null;
        }
        Class cached = SingleServingGosuClassLoader.getCached(enclosingType);
        if (cached != null) {
            return cached.getClassLoader();
        }
        return enclosingType instanceof IJavaBackedType ? ((IJavaBackedType)enclosingType).getBackingClass().getClassLoader() : (enclosingType instanceof IHasJavaClass ? ((IHasJavaClass)enclosingType).getBackingClass().getClassLoader() : null);
    }

    private Class<?> defineClassInSingleServingLoader(ICompilableTypeInternal gsClass, SingleServingGosuClassLoader loader) {
        Class result = loader._defineClass(gsClass);
        for (int i = 0; i < gsClass.getBlockCount(); ++i) {
            this.defineClassInSingleServingLoader((ICompilableTypeInternal)gsClass.getBlock(i), loader);
        }
        if (gsClass.getInnerClasses() != null) {
            for (IType inner : gsClass.getInnerClasses()) {
                try {
                    this.defineClassInSingleServingLoader((ICompilableTypeInternal)inner, loader);
                }
                catch (LinkageError linkageError) {}
            }
        }
        return result;
    }

    private boolean shouldUseSingleServingLoader(ICompilableTypeInternal gsClass) {
        List observers = CommonServices.getEntityAccess().getGosuClassLoadingObservers();
        if (observers != null) {
            for (IGosuClassLoadingObserver observer : observers) {
                if (!observer.shouldUseSingleServingLoader((ICompilableType)gsClass)) continue;
                return true;
            }
        }
        return this.hasDiscreteNamespace(gsClass.getNamespace());
    }

    boolean shouldDebugClass(ICompilableType gsClass) {
        return BytecodeOptions.shouldDebug((String)gsClass.getName());
    }

    private Class defineAndMaybeVerify(ICompilableTypeInternal gsClass) {
        try {
            Bootstrap.init();
            String strJavaClass = gsClass.getJavaName();
            Class<?> cls = this._loader.loadClass(strJavaClass);
            if (BytecodeOptions.aggressivelyVerify()) {
                JavaMethodCache.getDeclaredMethods(cls);
                cls.getDeclaredMethods();
            }
            return cls;
        }
        catch (ClassFormatError | VerifyError ve) {
            if (BytecodeOptions.aggressivelyVerify()) {
                GosuClassLoader.compileClass(gsClass, true);
            }
            throw ve;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] compileClass(ICompilableType type, boolean debug) {
        return TransformingCompiler.compileClass(type, debug);
    }

    private boolean isThrowawayProgram(ICompilableType gsClass) {
        return gsClass instanceof IGosuProgramInternal && ((IGosuProgramInternal)gsClass).isThrowaway();
    }

    public ClassLoader getActualLoader() {
        return this.getLoader();
    }

    public Class defineClass(String name, byte[] bytes) {
        TypeSystem.lock();
        try {
            Method defineClass = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            defineClass.setAccessible(true);
            Class clazz = (Class)defineClass.invoke((Object)this._loader, name, bytes, 0, bytes.length);
            return clazz;
        }
        catch (Exception e) {
            throw GosuExceptionUtil.forceThrow((Throwable)e);
        }
        finally {
            TypeSystem.unlock();
        }
    }

    public boolean waitForLoaderToUnload(String packageName, long millisToWait) {
        long lStart = System.currentTimeMillis();
        while (!this._discreteLoaders.isLoaderUnloaded(packageName)) {
            if (System.currentTimeMillis() - lStart > millisToWait) {
                return false;
            }
            System.gc();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    public void evictLoader(String packageName) {
        this._discreteLoaders.evictLoader(packageName);
    }

    private class DiscreteLoaderCache {
        private DelegateCache _delegate = new DelegateCache();

        private DiscreteLoaderCache() {
        }

        public DiscreteClassLoader getLoader(String key) {
            if (this.getDiscretePackages().isEmpty()) {
                return null;
            }
            return this._delegate.getLoader(key);
        }

        public boolean isLoaderUnloaded(String key) {
            if (this.getDiscretePackages().isEmpty()) {
                return true;
            }
            return ((WeakReference)this._delegate.get(key)).get() == null;
        }

        public void evictLoader(String key) {
            this._delegate.evict(key);
        }

        private List<String> getDiscretePackages() {
            String[] discretePackages = ExecutionEnvironment.instance().getDiscretePackages();
            return discretePackages == null ? Collections.emptyList() : Arrays.asList(discretePackages);
        }

        private class DelegateCache
        extends TypeSystemAwareCache<String, WeakReference<DiscreteClassLoader>> {
            public DelegateCache() {
                super("Discrete Loaders", 100, (Cache.MissHandler)new Cache.MissHandler<String, WeakReference<DiscreteClassLoader>>(){

                    public WeakReference<DiscreteClassLoader> load(String key) {
                        Optional<String> match = DiscreteLoaderCache.this.getDiscretePackages().stream().filter(key::startsWith).findFirst();
                        if (!match.isPresent()) {
                            return new WeakReference<DiscreteClassLoader>(DiscreteClassLoader.NULL_SENTINAL);
                        }
                        String unloadableNamespace = match.get();
                        if (key.equals(unloadableNamespace)) {
                            return new WeakReference<Object>(null);
                        }
                        return (WeakReference)DiscreteLoaderCache.this._delegate.get(unloadableNamespace);
                    }
                });
            }

            private DiscreteClassLoader getLoader(String key) {
                WeakReference<DiscreteClassLoader> ref = (WeakReference<DiscreteClassLoader>)super.get((Object)key);
                if (ref.get() != DiscreteClassLoader.NULL_SENTINAL) {
                    DiscreteClassLoader[] loader = new DiscreteClassLoader[1];
                    if (ref.get() == null) {
                        String unloadableNamespace = DiscreteLoaderCache.this.getDiscretePackages().stream().filter(t -> {
                            if (key.equals(t)) {
                                return true;
                            }
                            if (!t.endsWith(".")) {
                                t = t + '.';
                            }
                            return key.startsWith((String)t);
                        }).findFirst().get();
                        loader[0] = new DiscreteClassLoader(unloadableNamespace, GosuClassLoader.this);
                        ref = new WeakReference<DiscreteClassLoader>(loader[0]);
                        this.put(unloadableNamespace, ref);
                    }
                    return (DiscreteClassLoader)ref.get();
                }
                return null;
            }
        }
    }
}

