/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.module.fs;

import gw.config.BaseService;
import gw.config.CommonServices;
import gw.fs.FileFactory;
import gw.fs.IDirectory;
import gw.fs.IFile;
import gw.fs.IResource;
import gw.fs.jar.JarFileDirectoryImpl;
import gw.fs.url.URLFileImpl;
import gw.internal.gosu.module.fs.JavaDirectoryImpl;
import gw.internal.gosu.module.fs.JavaFileImpl;
import gw.internal.gosu.module.fs.PathDirectoryImpl;
import gw.internal.gosu.module.fs.PathFileImpl;
import gw.lang.reflect.module.IFileSystem;
import gw.lang.reflect.module.IModule;
import gw.lang.reflect.module.IProtocolAdapter;
import gw.util.GosuStringUtil;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class FileSystemImpl
extends BaseService
implements IFileSystem {
    private Map<File, IDirectory> _cachedDirInfo = new HashMap<File, IDirectory>();
    private IFileSystem.CachingMode _cachingMode;
    private IDirectoryResourceExtractor _iDirectoryResourceExtractor;
    private IFileResourceExtractor _iFileResourceExtractor;
    private Map<String, IProtocolAdapter> _protocolAdapters;
    public static boolean USE_NEW_API = false;
    static final Object CACHED_FILE_SYSTEM_LOCK = new Object();
    private static final Set<String> FILE_SUFFIXES = new HashSet<String>();

    public FileSystemImpl(IFileSystem.CachingMode cachingMode) {
        this._cachingMode = cachingMode;
        this._iDirectoryResourceExtractor = new IDirectoryResourceExtractor();
        this._iFileResourceExtractor = new IFileResourceExtractor();
        this._protocolAdapters = new ConcurrentHashMap<String, IProtocolAdapter>();
        this.loadProtocolAdapters();
    }

    public IDirectory getIDirectory(Path dir) {
        if (dir.getFileSystem() == FileSystems.getDefault()) {
            return this.getIDirectory(dir.toFile());
        }
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new IllegalArgumentException("'" + dir + "' is not a directory of the '" + dir.getFileSystem() + "' file system");
        }
        return new PathDirectoryImpl(dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDirectory getIDirectory(File dir) {
        if (USE_NEW_API) {
            return FileFactory.instance().getIDirectory(dir);
        }
        if (dir == null) {
            return null;
        }
        dir = FileSystemImpl.normalizeFile(dir);
        Object object = CACHED_FILE_SYSTEM_LOCK;
        synchronized (object) {
            IDirectory directory = this._cachedDirInfo.get(dir);
            if (directory == null) {
                directory = this.createDir(dir);
                this._cachedDirInfo.put(dir, directory);
            }
            return directory;
        }
    }

    public IFile getIFile(Path path) {
        if (path.getFileSystem() == FileSystems.getDefault()) {
            return this.getIFile(path.toFile());
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            throw new IllegalArgumentException("'" + path + "' is not a file of the '" + path.getFileSystem() + "' file system");
        }
        return new PathFileImpl(path);
    }

    public IFile getIFile(File file) {
        if (USE_NEW_API) {
            return FileFactory.instance().getIFile(file);
        }
        if (file == null) {
            return null;
        }
        return new JavaFileImpl(FileSystemImpl.normalizeFile(file));
    }

    public static File normalizeFile(File file) {
        String absolutePath = file.getAbsolutePath();
        ArrayList<String> components = new ArrayList<String>();
        boolean reallyNormalized = false;
        int lastIndex = 0;
        for (int i = 0; i < absolutePath.length(); ++i) {
            char c = absolutePath.charAt(i);
            if (c != '/' && c != '\\') continue;
            String component = absolutePath.substring(lastIndex, i);
            if (component.equals(".")) {
                reallyNormalized = true;
            } else if (component.equals("..")) {
                components.remove(components.size() - 1);
                reallyNormalized = true;
            } else {
                components.add(component);
            }
            lastIndex = i + 1;
        }
        String component = absolutePath.substring(lastIndex);
        if (component.equals(".")) {
            reallyNormalized = true;
        } else if (component.equals("..")) {
            components.remove(components.size() - 1);
            reallyNormalized = true;
        } else {
            components.add(component);
        }
        return reallyNormalized ? new File(GosuStringUtil.join(components, (String)"/")) : file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCachingMode(IFileSystem.CachingMode cachingMode) {
        Object object = CACHED_FILE_SYSTEM_LOCK;
        synchronized (object) {
            this._cachingMode = cachingMode;
            for (IDirectory dir : this._cachedDirInfo.values()) {
                if (!(dir instanceof JavaDirectoryImpl)) continue;
                ((JavaDirectoryImpl)dir).setCachingMode(cachingMode);
            }
        }
    }

    private IDirectory createDir(File dir) {
        if ((dir.getName().toLowerCase().endsWith(".jar") || dir.getName().toLowerCase().endsWith(".zip") || dir.getName().equals("bundlefile")) && dir.isFile()) {
            return new JarFileDirectoryImpl(dir);
        }
        return new JavaDirectoryImpl(dir, this._cachingMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllCaches() {
        if (USE_NEW_API) {
            FileFactory.instance().getDefaultPhysicalFileSystem().clearAllCaches();
            return;
        }
        Object object = CACHED_FILE_SYSTEM_LOCK;
        synchronized (object) {
            for (IDirectory dir : this._cachedDirInfo.values()) {
                dir.clearCaches();
            }
        }
    }

    static boolean isDirectory(File f) {
        String name = f.getName();
        if (FileSystemImpl.isAssumedFileSuffix(FileSystemImpl.getFileSuffix(name))) {
            return false;
        }
        return f.isDirectory();
    }

    private static String getFileSuffix(String name) {
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1) {
            return null;
        }
        return name.substring(dotIndex + 1);
    }

    public IDirectory getIDirectory(URL url) {
        if (url == null) {
            return null;
        }
        IProtocolAdapter protocolAdapter = this._protocolAdapters.get(url.getProtocol());
        if (protocolAdapter != null) {
            return protocolAdapter.getIDirectory(url);
        }
        return (IDirectory)this._iDirectoryResourceExtractor.getClassResource(url);
    }

    public IFile getIFile(URL url) {
        if (url == null) {
            return null;
        }
        IProtocolAdapter protocolAdapter = this._protocolAdapters.get(url.getProtocol());
        if (protocolAdapter != null) {
            return protocolAdapter.getIFile(url);
        }
        if (USE_NEW_API) {
            return FileFactory.instance().getIFile(url);
        }
        return (IFile)this._iFileResourceExtractor.getClassResource(url);
    }

    public IFile getFakeFile(URL url, IModule module) {
        return null;
    }

    private void loadProtocolAdapters() {
        ServiceLoader<IProtocolAdapter> adapters = ServiceLoader.load(IProtocolAdapter.class, ((Object)((Object)this)).getClass().getClassLoader());
        for (IProtocolAdapter adapter : adapters) {
            for (String protocol : adapter.getSupportedProtocols()) {
                this._protocolAdapters.put(protocol, adapter);
            }
        }
    }

    private void loadProtocolAdapter(Collection<IProtocolAdapter> adapters, String adapterName) {
        try {
            Class<IProtocolAdapter> adapterClass = Class.forName(adapterName, true, Thread.currentThread().getContextClassLoader()).asSubclass(IProtocolAdapter.class);
            adapters.add(adapterClass.newInstance());
        }
        catch (ClassNotFoundException adapterClass) {
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isAssumedFileSuffix(String suffix) {
        return FILE_SUFFIXES.contains(suffix);
    }

    static {
        FILE_SUFFIXES.add("class");
        FILE_SUFFIXES.add("eti");
        FILE_SUFFIXES.add("etx");
        FILE_SUFFIXES.add("gif");
        FILE_SUFFIXES.add("gr");
        FILE_SUFFIXES.add("grs");
        FILE_SUFFIXES.add("gs");
        FILE_SUFFIXES.add("gst");
        FILE_SUFFIXES.add("gsx");
        FILE_SUFFIXES.add("gti");
        FILE_SUFFIXES.add("gx");
        FILE_SUFFIXES.add("jar");
        FILE_SUFFIXES.add("java");
        FILE_SUFFIXES.add("pcf");
        FILE_SUFFIXES.add("png");
        FILE_SUFFIXES.add("properties");
        FILE_SUFFIXES.add("tti");
        FILE_SUFFIXES.add("ttx");
        FILE_SUFFIXES.add("txt");
        FILE_SUFFIXES.add("wsdl");
        FILE_SUFFIXES.add("xml");
        FILE_SUFFIXES.add("xsd");
    }

    private class IDirectoryResourceExtractor
    extends ResourceExtractor<IDirectory> {
        private IDirectoryResourceExtractor() {
        }

        @Override
        protected IDirectory getIResourceFromJarDirectoryAndEntryName(IDirectory dir, String entryName) {
            return dir.dir(entryName);
        }

        @Override
        protected IDirectory getIResourceFromJavaFile(URL location) {
            return CommonServices.getFileSystem().getIDirectory(this.getFileFromURL(location));
        }

        @Override
        IDirectory getIResourceFromURL(URL location) {
            return null;
        }

        @Override
        IDirectory getIResourceFromPath(Path path) {
            return new PathDirectoryImpl(path);
        }
    }

    private class IFileResourceExtractor
    extends ResourceExtractor<IFile> {
        private IFileResourceExtractor() {
        }

        @Override
        IFile getIResourceFromJarDirectoryAndEntryName(IDirectory jarFS, String entryName) {
            return jarFS.file(entryName);
        }

        @Override
        IFile getIResourceFromJavaFile(URL location) {
            return CommonServices.getFileSystem().getIFile(this.getFileFromURL(location));
        }

        @Override
        IFile getIResourceFromURL(URL location) {
            return new URLFileImpl(location);
        }

        @Override
        IFile getIResourceFromPath(Path path) {
            return new PathFileImpl(path);
        }
    }

    private abstract class ResourceExtractor<J extends IResource> {
        private ResourceExtractor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        J getClassResource(URL _url) {
            if (_url == null) {
                return null;
            }
            if (_url.getProtocol().equals("file")) {
                return this.getIResourceFromJavaFile(_url);
            }
            if (_url.getProtocol().equals("jar")) {
                IDirectory jarFileDirectory;
                URL jarFileUrl;
                JarURLConnection urlConnection;
                try {
                    urlConnection = (JarURLConnection)_url.openConnection();
                    jarFileUrl = urlConnection.getJarFileURL();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                File dir = new File(jarFileUrl.getFile());
                Object object = CACHED_FILE_SYSTEM_LOCK;
                synchronized (object) {
                    jarFileDirectory = (IDirectory)FileSystemImpl.this._cachedDirInfo.get(dir);
                    if (jarFileDirectory == null) {
                        jarFileDirectory = FileSystemImpl.this.createDir(dir);
                        FileSystemImpl.this._cachedDirInfo.put(dir, jarFileDirectory);
                    }
                }
                return this.getIResourceFromJarDirectoryAndEntryName(jarFileDirectory, urlConnection.getEntryName());
            }
            if (_url.getProtocol().equals("http")) {
                J res = this.getIResourceFromURL(_url);
                if (res != null) {
                    return res;
                }
            } else {
                try {
                    Path path = Paths.get(_url.toURI());
                    return this.getIResourceFromPath(path);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new RuntimeException("Unrecognized protocol: " + _url.getProtocol());
        }

        abstract J getIResourceFromURL(URL var1);

        abstract J getIResourceFromJarDirectoryAndEntryName(IDirectory var1, String var2);

        abstract J getIResourceFromJavaFile(URL var1);

        abstract J getIResourceFromPath(Path var1);

        protected File getFileFromURL(URL url) {
            try {
                URI uri = url.toURI();
                if (uri.getFragment() != null) {
                    uri = new URI(uri.getScheme(), uri.getSchemeSpecificPart(), null);
                }
                return new File(uri);
            }
            catch (URISyntaxException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("Unable to parse URL " + url.toExternalForm(), ex);
            }
        }
    }
}

