/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.module.fs;

import gw.fs.IDirectory;
import gw.fs.IDirectoryUtil;
import gw.fs.IFile;
import gw.fs.IResource;
import gw.internal.gosu.module.fs.PathFileImpl;
import gw.internal.gosu.module.fs.PathResourceImpl;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import manifold.util.ManExceptionUtil;

public class PathDirectoryImpl
extends PathResourceImpl
implements IDirectory {
    PathDirectoryImpl(Path path) {
        super(path);
    }

    public IDirectory dir(String relativePath) {
        return new PathDirectoryImpl(this.get_Path().resolve(relativePath));
    }

    public IFile file(String path) {
        return new PathFileImpl(this.get_Path().resolve(path));
    }

    public boolean mkdir() throws IOException {
        return Files.createDirectory(this.get_Path(), new FileAttribute[0]) != null;
    }

    public List<? extends IDirectory> listDirs() {
        return this.list(e -> Files.isDirectory(e, new LinkOption[0]), PathDirectoryImpl::new);
    }

    public List<? extends IFile> listFiles() {
        return this.list(e -> !Files.isDirectory(e, new LinkOption[0]), PathFileImpl::new);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <E extends PathResourceImpl> List<E> list(DirectoryStream.Filter<Path> filter, Function<Path, E> creator) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.get_Path(), filter);){
            ArrayList<E> dirs = new ArrayList<E>();
            for (Path dir : stream) {
                dirs.add(creator.apply(dir));
            }
            ArrayList<E> arrayList = dirs;
            return arrayList;
        }
        catch (Exception e) {
            throw ManExceptionUtil.unchecked((Throwable)e);
        }
    }

    public String relativePath(IResource resource) {
        return IDirectoryUtil.relativePath((IResource)this, (IResource)resource);
    }

    public void clearCaches() {
    }

    public boolean hasChildFile(String path) {
        return Files.exists(this.get_Path().resolve(path), new LinkOption[0]);
    }

    public boolean isAdditional() {
        return false;
    }

    public boolean exists() {
        return Files.isDirectory(this.get_Path(), new LinkOption[0]);
    }
}

