/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.parser.CompoundType;
import gw.internal.gosu.parser.JavaTypeInfo;
import gw.lang.reflect.BaseTypeInfo;
import gw.lang.reflect.FeatureManager;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IAttributedFeatureInfo;
import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IEventInfo;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.MethodInfoDelegate;
import gw.lang.reflect.MethodList;
import gw.lang.reflect.PropertyInfoDelegate;
import gw.lang.reflect.TypeInfoUtil;
import gw.lang.reflect.TypeSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CompoundTypeInfo
extends BaseTypeInfo
implements IRelativeTypeInfo {
    private volatile Map<CharSequence, IPropertyInfo> _propertiesByName;
    private volatile List<IPropertyInfo> _properties;
    private volatile MethodList _methods;

    public CompoundTypeInfo(CompoundType intrType) {
        super((IType)intrType);
    }

    public CompoundType getOwnersType() {
        return (CompoundType)super.getOwnersType();
    }

    public List<? extends IPropertyInfo> getProperties() {
        if (this._properties == null) {
            this.extractProperties();
        }
        return this._properties;
    }

    public IPropertyInfo getProperty(CharSequence propName) {
        if (this._properties == null) {
            this.extractProperties();
        }
        return this._propertiesByName.get(propName);
    }

    public MethodList getMethods() {
        if (this._methods == null) {
            this.extractMethods();
        }
        return this._methods;
    }

    public IMethodInfo getMethod(CharSequence methodName, IType ... params) {
        return ITypeInfo.FIND.method((MethodList)this.getMethods(), (CharSequence)methodName, (IType[])params);
    }

    public List<IConstructorInfo> getConstructors() {
        return Collections.emptyList();
    }

    public IConstructorInfo getConstructor(IType ... params) {
        return null;
    }

    public IMethodInfo getCallableMethod(CharSequence strMethod, IType ... params) {
        return ITypeInfo.FIND.callableMethod((MethodList)this.getMethods(), (CharSequence)strMethod, (IType[])params);
    }

    public IConstructorInfo getCallableConstructor(IType ... params) {
        return ITypeInfo.FIND.callableConstructor(this.getConstructors(), (IType[])params);
    }

    public List<IEventInfo> getEvents() {
        return Collections.emptyList();
    }

    public IEventInfo getEvent(CharSequence strEvent) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractProperties() {
        if (this._properties == null) {
            TypeSystem.lock();
            try {
                if (this._properties == null) {
                    this._propertiesByName = new HashMap<CharSequence, IPropertyInfo>();
                    for (IType type : this.getOwnersType().getTypes()) {
                        ITypeInfo ti = type.getTypeInfo();
                        List properties = ti instanceof IRelativeTypeInfo ? ((IRelativeTypeInfo)ti).getProperties(type) : ti.getProperties();
                        for (IPropertyInfo pi : properties) {
                            this._propertiesByName.put(pi.getName(), (IPropertyInfo)new PropertyInfoDelegate((IFeatureInfo)this, pi));
                        }
                    }
                    this._properties = TypeInfoUtil.makeSortedUnmodifiableRandomAccessListFromFeatures(this._propertiesByName);
                }
            }
            finally {
                TypeSystem.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractMethods() {
        if (this._methods == null) {
            TypeSystem.lock();
            try {
                if (this._methods == null) {
                    MethodList allMethods = new MethodList();
                    for (IType type : this.getOwnersType().getTypes()) {
                        ITypeInfo ti = type.getTypeInfo();
                        MethodList methods = ti instanceof IRelativeTypeInfo ? ((IRelativeTypeInfo)ti).getMethods(type) : ti.getMethods();
                        for (IMethodInfo mi : methods) {
                            allMethods.add((IMethodInfo)new MethodInfoDelegate((IFeatureInfo)this, mi));
                        }
                    }
                    this._methods = TypeInfoUtil.makeSortedUnmodifiableRandomAccessList((MethodList)allMethods);
                }
            }
            finally {
                TypeSystem.unlock();
            }
        }
    }

    public List<IAnnotationInfo> getDeclaredAnnotations() {
        return Collections.emptyList();
    }

    public IRelativeTypeInfo.Accessibility getAccessibilityForType(IType whosAskin) {
        IRelativeTypeInfo.Accessibility accessibility = IRelativeTypeInfo.Accessibility.PRIVATE;
        IType iType = whosAskin = whosAskin == null ? JavaTypeInfo.getCompilingClass((IType)this.getOwnersType()) : whosAskin;
        if (whosAskin == this.getOwnersType()) {
            return accessibility;
        }
        for (IType type : this.getOwnersType().getTypes()) {
            if (type == null || whosAskin == null) {
                accessibility = IRelativeTypeInfo.Accessibility.PUBLIC;
                continue;
            }
            IRelativeTypeInfo.Accessibility csr = FeatureManager.getAccessibilityForClass((IType)type, (IType)whosAskin);
            if (csr.ordinal() >= accessibility.ordinal()) continue;
            accessibility = csr;
        }
        return accessibility;
    }

    public List<? extends IPropertyInfo> getProperties(IType whosaskin) {
        IRelativeTypeInfo.Accessibility accessibility = this.getAccessibilityForType(whosaskin);
        ArrayList<? extends IPropertyInfo> properties = new ArrayList<IPropertyInfo>(this.getProperties());
        Iterator iterator = properties.iterator();
        while (iterator.hasNext()) {
            IPropertyInfo propertyInfo = (IPropertyInfo)iterator.next();
            boolean hidden = this.isHidden(accessibility, (IAttributedFeatureInfo)propertyInfo);
            if (!hidden) continue;
            iterator.remove();
        }
        return properties;
    }

    public IPropertyInfo getProperty(IType whosaskin, CharSequence propName) {
        IPropertyInfo property = this.getProperty(propName);
        if (property == null || this.isHidden(this.getAccessibilityForType(whosaskin), (IAttributedFeatureInfo)property)) {
            return null;
        }
        return property;
    }

    public MethodList getMethods(IType whosaskin) {
        IRelativeTypeInfo.Accessibility accessibility = this.getAccessibilityForType(whosaskin);
        MethodList methods = new MethodList((List)this.getMethods());
        Iterator iterator = methods.iterator();
        while (iterator.hasNext()) {
            IMethodInfo methodInfo = (IMethodInfo)iterator.next();
            boolean hidden = this.isHidden(accessibility, (IAttributedFeatureInfo)methodInfo);
            if (!hidden) continue;
            iterator.remove();
        }
        return methods;
    }

    public IMethodInfo getMethod(IType whosaskin, CharSequence methodName, IType ... params) {
        IMethodInfo method = this.getMethod(methodName, params);
        if (method == null || this.isHidden(this.getAccessibilityForType(whosaskin), (IAttributedFeatureInfo)method)) {
            return null;
        }
        return method;
    }

    private boolean isHidden(IRelativeTypeInfo.Accessibility accessibility, IAttributedFeatureInfo fi) {
        boolean hidden = false;
        if (fi.isPrivate() && accessibility != IRelativeTypeInfo.Accessibility.PRIVATE) {
            hidden = true;
        } else if (fi.isInternal() && accessibility.ordinal() < IRelativeTypeInfo.Accessibility.INTERNAL.ordinal()) {
            hidden = true;
        } else if (fi.isProtected() && accessibility.ordinal() < IRelativeTypeInfo.Accessibility.PROTECTED.ordinal()) {
            hidden = true;
        }
        return hidden;
    }

    public List<? extends IConstructorInfo> getConstructors(IType whosaskin) {
        return Collections.emptyList();
    }

    public IConstructorInfo getConstructor(IType whosAskin, IType[] params) {
        return null;
    }

    public List<? extends IPropertyInfo> getDeclaredProperties() {
        return Collections.emptyList();
    }

    public List<? extends IMethodInfo> getDeclaredMethods() {
        return Collections.emptyList();
    }

    public List<? extends IConstructorInfo> getDeclaredConstructors() {
        return Collections.emptyList();
    }
}

