/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.ICompilableTypeInternal;
import gw.internal.gosu.parser.IGosuAnnotation;
import gw.internal.gosu.parser.expressions.AnnotationExpression;
import gw.lang.parser.AnnotationUseSiteTarget;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.ICompilableType;
import gw.lang.reflect.java.JavaTypes;
import java.io.Serializable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

public class GosuAnnotation
implements Serializable,
IGosuAnnotation {
    private ICompilableTypeInternal _enclosingType;
    private IType _type;
    private Expression _expression;
    private AnnotationUseSiteTarget _target;
    private int _start;
    private int _end;

    public GosuAnnotation(ICompilableTypeInternal enclosingType, IType type, Expression expression, AnnotationUseSiteTarget target, int iOffset, int end) {
        this._enclosingType = enclosingType;
        this._type = type;
        this._expression = expression;
        this._target = target;
        this._start = iOffset;
        this._end = end;
    }

    public String getName() {
        return this.getType().getRelativeName();
    }

    public IType getType() {
        return this._type;
    }

    public String getNewExpressionAsString() {
        String s;
        if (this._start > this._end) {
            return "";
        }
        String typeName = this._enclosingType.getSource().substring(this._start, this._end);
        if (typeName.startsWith("@")) {
            int iColon = this.getTarget() != null ? typeName.indexOf(":") : -1;
            typeName = typeName.substring(iColon > 0 ? iColon + 1 : 1);
        }
        if (!(s = "new " + typeName).contains("(")) {
            s = s + "()";
        }
        return s;
    }

    public Expression getExpression() {
        return this._expression;
    }

    public void setExpression(Expression expr) {
        if (expr instanceof AnnotationExpression) {
            ((AnnotationExpression)expr).setAnnotation(this);
        }
        this._expression = expr;
    }

    public void clearExpression() {
        this._expression = null;
    }

    public AnnotationUseSiteTarget getTarget() {
        return this._target;
    }

    public boolean shouldPersistToClass() {
        return this.isJavaAnnotation() && !this.hasRetentionPolicy(RetentionPolicy.SOURCE) && !this.hasBadArgs();
    }

    public boolean shouldRetainAtRuntime() {
        return this.isJavaAnnotation() && this.hasRetentionPolicy(RetentionPolicy.RUNTIME) && !this.hasBadArgs();
    }

    private boolean hasRetentionPolicy(RetentionPolicy policy) {
        List annotation = this._type.getTypeInfo().getAnnotationsOfType(TypeSystem.get(Retention.class));
        if (annotation != null) {
            for (IAnnotationInfo annotationInfo : annotation) {
                String value = (String)annotationInfo.getFieldValue("value");
                if (!value.equals(policy.name())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSourceAnnotation() {
        List annotations = this._type.getTypeInfo().getAnnotationsOfType((IType)JavaTypes.getJreType(Retention.class));
        if (annotations != null) {
            for (IAnnotationInfo annotationInfo : annotations) {
                String fieldValue = (String)annotationInfo.getFieldValue("value");
                if (!fieldValue.equals(RetentionPolicy.SOURCE.name())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasBadArgs() {
        if (this._expression instanceof AnnotationExpression && ((AnnotationExpression)this._expression).getArgs() != null) {
            for (Expression expr : ((AnnotationExpression)this._expression).getArgs()) {
                if (expr.isCompileTimeConstant()) continue;
                return true;
            }
        }
        return false;
    }

    public ICompilableType getOwnersType() {
        return this._enclosingType;
    }

    public void clearDebugInfo() {
        if (this._expression != null) {
            this._expression.clearParseTreeInformation();
        }
    }
}

