/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser.expressions;

import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.GosuAnnotation;
import gw.internal.gosu.parser.GosuAnnotationInfo;
import gw.internal.gosu.parser.ICompilableTypeInternal;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.ParseTree;
import gw.internal.gosu.parser.Primitives;
import gw.internal.gosu.parser.expressions.InferredNewExpression;
import gw.lang.parser.IExpression;
import gw.lang.parser.StandardCoercionManager;
import gw.lang.parser.expressions.IInitializerExpression;
import gw.lang.parser.expressions.INewExpression;
import gw.lang.parser.expressions.ITypeLiteralExpression;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.java.JavaTypes;
import gw.util.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class NewExpression
extends Expression
implements INewExpression {
    private IType[] _argTypes;
    private Expression[] _args;
    private IConstructorInfo _constructor;
    private List<Expression> _valueExpressions;
    private List<Expression> _sizeExpressions;
    private int _iArgPos;
    private ITypeLiteralExpression _typeLiteral;
    private IInitializerExpression _initExpr;
    private boolean _anonymous;
    private int[] _namedArgOrder;

    public IType[] getArgTypes() {
        return this._argTypes;
    }

    public void setArgTypes(IType ... argTypes) {
        this._argTypes = argTypes;
    }

    public Expression[] getArgs() {
        return this._args;
    }

    public void setArgs(Expression[] args) {
        this._args = args;
    }

    public IConstructorInfo getConstructor() {
        return this._constructor;
    }

    public int getArgPosition() {
        return this._iArgPos;
    }

    public void setArgPosition(int iArgPos) {
        this._iArgPos = iArgPos;
    }

    public void setConstructor(IConstructorInfo constructor) {
        this._constructor = constructor;
    }

    public void setValueExpressions(List<Expression> valueExpressions) {
        this._valueExpressions = valueExpressions;
    }

    public List<Expression> getValueExpressions() {
        return this._valueExpressions;
    }

    public void setInitializer(IInitializerExpression initializerExpression) {
        this._initExpr = initializerExpression;
    }

    public IInitializerExpression getInitializer() {
        return this._initExpr;
    }

    public void addSizeExpression(Expression sizeExpression) {
        if (this._sizeExpressions == null) {
            this._sizeExpressions = new ArrayList<Expression>(2);
        }
        this._sizeExpressions.add(sizeExpression);
    }

    public List<Expression> getSizeExpressions() {
        return this._sizeExpressions;
    }

    @Override
    public boolean isCompileTimeConstant() {
        IInitializerExpression initializer = this.getInitializer();
        if (initializer != null && initializer.isCompileTimeConstant()) {
            return true;
        }
        if (this.getValueExpressions() != null) {
            for (Expression v : this.getValueExpressions()) {
                if (v.isCompileTimeConstant()) continue;
                return false;
            }
            return true;
        }
        if (this.getSizeExpressions() != null) {
            for (Expression s : this.getSizeExpressions()) {
                if (s.isCompileTimeConstant()) continue;
                return false;
            }
            return true;
        }
        if (this.getType().isArray()) {
            return true;
        }
        return JavaTypes.ANNOTATION().isAssignableFrom(this.getType());
    }

    @Override
    public Object evaluate() {
        if (!this.isCompileTimeConstant()) {
            return super.evaluate();
        }
        IInitializerExpression initializer = this.getInitializer();
        if (initializer != null) {
            return this.getInitializer().evaluate();
        }
        if (this._valueExpressions != null) {
            Class<?> arrayClass = this.getArrayClass(this.getType().getComponentType());
            List<Expression> values = this._valueExpressions;
            Object instance = Array.newInstance(arrayClass.getComponentType(), (int)values.size());
            for (int i = 0; i < values.size(); ++i) {
                IExpression expr = values.get(i);
                Object value = expr.evaluate();
                if (value instanceof BigDecimal || value instanceof BigInteger) {
                    value = value.toString();
                }
                Array.set((Object)instance, (int)i, (Object)value);
            }
            return instance;
        }
        if (this._sizeExpressions != null) {
            Class<?> arrayClass = this.getArrayClass(this.getType().getComponentType());
            return Array.newInstance(arrayClass.getComponentType(), (int)((Number)this._sizeExpressions.get(0).evaluate()).intValue());
        }
        if (JavaTypes.ANNOTATION().isAssignableFrom(this.getType())) {
            ParseTree loc = this.getLocation();
            boolean bProbablyFromACrappyTest = this.getGosuClass() == null;
            return new GosuAnnotationInfo(new GosuAnnotation((ICompilableTypeInternal)this.getGosuClass(), this.getType(), this, null, bProbablyFromACrappyTest ? 0 : loc.getOffset(), bProbablyFromACrappyTest ? -1 : loc.getExtent() + 1), (IFeatureInfo)(this.getGosuClass() == null ? null : this.getGosuClass().getTypeInfo()), (IGosuClassInternal)this.getGosuClass());
        }
        if (this.getType().isArray()) {
            Class<?> arrayClass = this.getArrayClass(this.getType().getComponentType());
            return Array.newInstance(arrayClass.getComponentType(), (int)0);
        }
        if (this instanceof InferredNewExpression) {
            return new Object[0];
        }
        throw new UnsupportedOperationException("Cannot evaluate new-expression as compile-time constant value.");
    }

    private Class<?> getArrayClass(IType type) {
        return Array.newInstance(this.getComponentClass(type), (int)0).getClass();
    }

    private Class<?> getComponentClass(IType type) {
        if (StandardCoercionManager.isBoxed((IType)type)) {
            type = TypeSystem.getPrimitiveType((IType)type);
        } else if (type.isEnum()) {
            type = JavaTypes.STRING();
        } else if (JavaTypes.ANNOTATION().isAssignableFrom(type)) {
            type = TypeSystem.get(IAnnotationInfo.class);
        } else if (JavaTypes.CLASS().isAssignableFrom(type)) {
            type = JavaTypes.ITYPE();
        } else if (type == JavaTypes.BIG_DECIMAL() || type == JavaTypes.BIG_INTEGER()) {
            type = JavaTypes.STRING();
        }
        Class<?> cls = ((IJavaType)type).getBackingClass();
        cls = cls != null ? cls : this.getClassForRareCaseWhenRunningIJEditorProjectWhereGosuCoreJavaTypesAreSourceBased(type);
        return cls;
    }

    private Class<?> getClassForRareCaseWhenRunningIJEditorProjectWhereGosuCoreJavaTypesAreSourceBased(IType type) {
        String fqn = type.getName();
        Class<?> cls = Primitives.get(fqn);
        if (cls == null) {
            try {
                cls = Class.forName(fqn, false, this.getClass().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return cls;
    }

    @Override
    public String toString() {
        StringBuilder strOut = new StringBuilder("new ");
        if (this._constructor != null) {
            strOut.append(this.getType().getName()).append("(");
            if (this._args != null && this._args.length > 0) {
                strOut.append(" ");
                for (int i = 0; i < this._args.length; ++i) {
                    if (i != 0) {
                        strOut.append(", ");
                    }
                    strOut.append(this._args[i].toString());
                }
                strOut.append(" ");
            }
            strOut.append(")");
            if (this._initExpr != null) {
                strOut.append(this._initExpr.toString());
            }
            return strOut.toString();
        }
        if (this._valueExpressions != null) {
            strOut.append(this.getType().getName()).append(" {");
            for (int i = 0; i < this._valueExpressions.size(); ++i) {
                if (i != 0) {
                    strOut.append(", ");
                }
                strOut.append(this._valueExpressions.get(i).toString());
            }
            return strOut.append("}").toString();
        }
        if (this._sizeExpressions != null) {
            IType type = this.getType();
            int iDims = 0;
            do {
                ++iDims;
            } while ((type = type.getComponentType()).isArray());
            strOut.append(type.getName());
            for (int i = 0; i < iDims; ++i) {
                strOut.append('[');
                if (this._sizeExpressions.size() > i) {
                    strOut.append(this._sizeExpressions.get(i).toString());
                }
                strOut.append(']');
            }
            return strOut.toString();
        }
        if (this.getType() != null && this.getType().getComponentType() != null) {
            strOut.append(this.getType().getComponentType().getName()).append("[]{}");
        }
        return strOut.toString();
    }

    public boolean isAnonymousClass() {
        return this._anonymous;
    }

    public void setAnonymousClass(boolean anonymous) {
        this._anonymous = anonymous;
    }

    public ITypeLiteralExpression getTypeLiteral() {
        return this._typeLiteral;
    }

    public void setTypeLiteral(ITypeLiteralExpression typeLiteral) {
        this._typeLiteral = typeLiteral;
    }

    public int[] getNamedArgOrder() {
        return this._namedArgOrder;
    }

    public void setNamedArgOrder(int[] namedArgOrder) {
        this._namedArgOrder = namedArgOrder;
    }
}

