/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.nodes;

import gw.internal.gosu.ir.nodes.IRMethod;
import gw.internal.gosu.ir.nodes.IRMethodForConstructorSymbol;
import gw.internal.gosu.ir.nodes.IRMethodFromConstructorInfo;
import gw.internal.gosu.ir.nodes.IRMethodFromJavaMethodInfo;
import gw.internal.gosu.ir.nodes.IRMethodFromMethod;
import gw.internal.gosu.ir.nodes.IRMethodFromMethodInfo;
import gw.internal.gosu.ir.nodes.SyntheticIRMethod;
import gw.internal.gosu.ir.transform.AbstractElementTransformer;
import gw.internal.gosu.ir.transform.util.IRTypeResolver;
import gw.internal.gosu.parser.DynamicFunctionSymbol;
import gw.lang.ir.IRType;
import gw.lang.ir.IRTypeConstants;
import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.IJavaClassMethod;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class IRMethodFactory {
    public static IRMethodFromMethodInfo createIRMethod(IMethodInfo originalMethodInfo, IFunctionType functionType) {
        if (originalMethodInfo == null) {
            return null;
        }
        return new IRMethodFromMethodInfo(originalMethodInfo, functionType);
    }

    public static IRMethod createIRMethod(IConstructorInfo constructor) {
        return new IRMethodFromConstructorInfo(constructor);
    }

    public static IRMethod createIRMethod(Class cls, String name, Class ... paramTypes) {
        return IRMethodFactory.createIRMethod(AbstractElementTransformer.getDeclaredMethod(cls, name, paramTypes));
    }

    public static IRMethod createIRMethod(IJavaClassInfo cls, String name, Class ... paramTypes) {
        return IRMethodFactory.createIRMethod(AbstractElementTransformer.getDeclaredMethod(cls, name, paramTypes));
    }

    public static IRMethod createIRMethod(Method method) {
        return new IRMethodFromMethod(method);
    }

    public static IRMethod createIRMethod(IJavaClassMethod method) {
        return new IRMethodFromJavaMethodInfo(method);
    }

    public static IRMethod createConstructorIRMethod(IType gosuClass, DynamicFunctionSymbol dfs, int numberOfTypeParameters) {
        return new IRMethodForConstructorSymbol(gosuClass, dfs, numberOfTypeParameters);
    }

    public static IRMethod createIRMethod(IType owner, String name, IType returnType, IType[] parameterTypes, IRelativeTypeInfo.Accessibility accessibility, boolean bStatic) {
        return new SyntheticIRMethod(owner, name, IRTypeResolver.getDescriptor(returnType), IRMethodFactory.convertToIRTypes(parameterTypes), accessibility, bStatic);
    }

    public static IRMethod createIRMethod(IType owner, String name, IRType returnType, List<IRType> parameterTypes, IRelativeTypeInfo.Accessibility accessibility, boolean bStatic) {
        return new SyntheticIRMethod(owner, name, returnType, parameterTypes, accessibility, bStatic);
    }

    public static IRMethod createConstructorIRMethod(IType owner, IRType[] parameterTypes) {
        return new SyntheticIRMethod(owner, "<init>", IRTypeConstants.pVOID(), Arrays.asList(parameterTypes), IRelativeTypeInfo.Accessibility.PUBLIC, false);
    }

    private static List<IRType> convertToIRTypes(IType[] types) {
        ArrayList<IRType> result = new ArrayList<IRType>();
        for (IType type : types) {
            result.add(IRTypeResolver.getDescriptor(type));
        }
        return result;
    }
}

