/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform;

import gw.config.CommonServices;
import gw.internal.ext.org.objectweb.asm.Type;
import gw.internal.gosu.ir.nodes.GosuClassIRType;
import gw.internal.gosu.ir.nodes.IRMethod;
import gw.internal.gosu.ir.nodes.IRMethodFactory;
import gw.internal.gosu.ir.nodes.IRProperty;
import gw.internal.gosu.ir.nodes.JavaClassIRType;
import gw.internal.gosu.ir.nodes.SyntheticIRMethod;
import gw.internal.gosu.ir.transform.ExpressionTransformer;
import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.ir.transform.util.AccessibilityUtil;
import gw.internal.gosu.ir.transform.util.IRTypeResolver;
import gw.internal.gosu.ir.transform.util.RequiresReflectionDeterminer;
import gw.internal.gosu.parser.AbstractDynamicSymbol;
import gw.internal.gosu.parser.BeanAccess;
import gw.internal.gosu.parser.CompoundType;
import gw.internal.gosu.parser.DynamicFunctionSymbol;
import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.GosuAnnotationInfo;
import gw.internal.gosu.parser.GosuParser;
import gw.internal.gosu.parser.ICompilableTypeInternal;
import gw.internal.gosu.parser.IGosuAnnotation;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.IGosuTemplateInternal;
import gw.internal.gosu.parser.MetaType;
import gw.internal.gosu.parser.NewIntrospector;
import gw.internal.gosu.parser.ReducedDynamicFunctionSymbol;
import gw.internal.gosu.parser.Symbol;
import gw.internal.gosu.parser.TypeLord;
import gw.internal.gosu.parser.TypeVariableArrayType;
import gw.internal.gosu.parser.TypeVariableType;
import gw.internal.gosu.parser.expressions.BlockType;
import gw.internal.gosu.parser.fragments.GosuFragment;
import gw.internal.gosu.runtime.GosuRuntimeMethods;
import gw.lang.IDimension;
import gw.lang.ir.IRElement;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRStatement;
import gw.lang.ir.IRSymbol;
import gw.lang.ir.IRType;
import gw.lang.ir.IRTypeConstants;
import gw.lang.ir.builder.IRArgConverter;
import gw.lang.ir.expression.IRArithmeticExpression;
import gw.lang.ir.expression.IRArrayLengthExpression;
import gw.lang.ir.expression.IRArrayLoadExpression;
import gw.lang.ir.expression.IRBooleanLiteral;
import gw.lang.ir.expression.IRCastExpression;
import gw.lang.ir.expression.IRCharacterLiteral;
import gw.lang.ir.expression.IRClassLiteral;
import gw.lang.ir.expression.IRCompositeExpression;
import gw.lang.ir.expression.IREqualityExpression;
import gw.lang.ir.expression.IRFieldGetExpression;
import gw.lang.ir.expression.IRIdentifier;
import gw.lang.ir.expression.IRLazyTypeMethodCallExpression;
import gw.lang.ir.expression.IRMethodCallExpression;
import gw.lang.ir.expression.IRNegationExpression;
import gw.lang.ir.expression.IRNewArrayExpression;
import gw.lang.ir.expression.IRNewExpression;
import gw.lang.ir.expression.IRNullLiteral;
import gw.lang.ir.expression.IRNumericLiteral;
import gw.lang.ir.expression.IRPrimitiveTypeConversion;
import gw.lang.ir.expression.IRRelationalExpression;
import gw.lang.ir.expression.IRStringLiteralExpression;
import gw.lang.ir.expression.IRTernaryExpression;
import gw.lang.ir.statement.IRArrayStoreStatement;
import gw.lang.ir.statement.IRAssignmentStatement;
import gw.lang.ir.statement.IRFieldSetStatement;
import gw.lang.ir.statement.IRIfStatement;
import gw.lang.ir.statement.IRMethodCallStatement;
import gw.lang.ir.statement.IRMethodStatement;
import gw.lang.ir.statement.IRNewStatement;
import gw.lang.ir.statement.IRReturnStatement;
import gw.lang.ir.statement.IRStatementList;
import gw.lang.ir.statement.IRThrowStatement;
import gw.lang.parser.IBlockClass;
import gw.lang.parser.ICapturedSymbol;
import gw.lang.parser.ICoercionManager;
import gw.lang.parser.ICustomExpressionRuntime;
import gw.lang.parser.IDynamicFunctionSymbol;
import gw.lang.parser.IExpression;
import gw.lang.parser.ILanguageLevel;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.IReducedSymbol;
import gw.lang.parser.Keyword;
import gw.lang.parser.StandardCoercionManager;
import gw.lang.parser.statements.IFunctionStatement;
import gw.lang.reflect.ClassLazyTypeResolver;
import gw.lang.reflect.FunctionType;
import gw.lang.reflect.IBlockType;
import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IEnumConstant;
import gw.lang.reflect.IErrorType;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IMetaType;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.ITypeVariableType;
import gw.lang.reflect.LazyTypeResolver;
import gw.lang.reflect.Modifier;
import gw.lang.reflect.NotLazyTypeResolver;
import gw.lang.reflect.ParameterizedFunctionType;
import gw.lang.reflect.PropertyInfoDelegate;
import gw.lang.reflect.SimpleTypeLazyTypeResolver;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.BytecodeOptions;
import gw.lang.reflect.gs.ICompilableType;
import gw.lang.reflect.gs.IExternalSymbolMap;
import gw.lang.reflect.gs.IGenericTypeVariable;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuConstructorInfo;
import gw.lang.reflect.gs.IGosuEnhancement;
import gw.lang.reflect.gs.IGosuFragment;
import gw.lang.reflect.gs.IGosuMethodInfo;
import gw.lang.reflect.gs.IGosuProgram;
import gw.lang.reflect.gs.IGosuVarPropertyInfo;
import gw.lang.reflect.gs.StringSourceFileHandle;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.IJavaClassMethod;
import gw.lang.reflect.java.IJavaConstructorInfo;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.java.JavaTypes;
import gw.lang.reflect.module.IModule;
import gw.util.Rational;
import gw.util.concurrent.LocklessLazyVar;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractElementTransformer<T extends IParsedElement> {
    public static final String CTX_SYMBOL_SUFFIX = "_instr_ctx";
    public static final String CTX_SYMBOL = "*temp_instr_ctx";
    public static final Map<String, ICustomExpressionRuntime> CUSTOM_RUNTIMES = new ConcurrentHashMap<String, ICustomExpressionRuntime>();
    public static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    public static final String OUTER_ACCESS = "access$0";
    public static final String CAPTURED_VAR_PREFIX = "val$";
    public static final String ENHANCEMENT_TYPE_PARAM_PREFIX = "etypeparam$";
    public static final String TYPE_PARAM_PREFIX = "typeparam$";
    public static final String ENUM_PARAM_PREFIX = "enum$";
    public static final Type OBJECT_TYPE = Type.getType(Object.class);
    public static final String ENHANCEMENT_THIS_REF = "$that$";
    private TopLevelTransformationContext _cc;
    private T _parsedElement;
    private static LocklessLazyVar<Boolean> _checkedArithmetic = new LocklessLazyVar<Boolean>(){

        protected Boolean init() {
            return Boolean.valueOf(System.getProperty("checkedArithmetic"));
        }
    };

    public AbstractElementTransformer(TopLevelTransformationContext cc, T parsedElem) {
        this._cc = cc;
        this._parsedElement = parsedElem;
    }

    public static void clearCustomRuntimes() {
        CUSTOM_RUNTIMES.clear();
    }

    public TopLevelTransformationContext _cc() {
        return this._cc;
    }

    protected void setCc(TopLevelTransformationContext cc) {
        this._cc = cc;
    }

    protected T getParsedElement() {
        return this._parsedElement;
    }

    public ICompilableTypeInternal getGosuClass() {
        return this._cc().getGosuClass();
    }

    public IRExpression callStaticMethod(Class cls, String strMethod, Class[] paramTypes, List<IRExpression> args) {
        return this.callMethod(cls, strMethod, paramTypes, null, args);
    }

    public IRExpression callMethod(Class cls, String strMethod, Class[] paramTypes, IRExpression root, List<IRExpression> args) {
        return this.callMethod(IRMethodFactory.createIRMethod(cls, strMethod, paramTypes), root, args);
    }

    public IRExpression callMethod(IJavaClassInfo cls, String strMethod, Class[] paramTypes, IRExpression root, List<IRExpression> args) {
        return this.callMethod(IRMethodFactory.createIRMethod(cls, strMethod, paramTypes), root, args);
    }

    public IRExpression callMethod(IRMethod method, IRExpression root, List<IRExpression> explicitArgs) {
        return this.callMethod(method.getOwningIRType(), method, root, Collections.emptyList(), explicitArgs, null, false);
    }

    public IRExpression callMethod(IRMethod method, IRExpression root, List<IRExpression> explicitArgs, int[] namedArgOrder) {
        return this.callMethod(method.getOwningIRType(), method, root, Collections.emptyList(), explicitArgs, namedArgOrder, false);
    }

    public IRExpression callMethod(IRMethod method, IRExpression root, List<IRExpression> explicitArgs, int[] namedArgOrder, boolean special) {
        return this.callMethod(method.getOwningIRType(), method, root, Collections.emptyList(), explicitArgs, namedArgOrder, special);
    }

    public IRExpression callSpecialMethod(IRType rootType, IRMethod method, IRExpression root, List<IRExpression> explicitArgs) {
        return this.callMethod(rootType, method, root, Collections.emptyList(), explicitArgs, null, true);
    }

    public IRExpression callSpecialMethod(IRType rootType, IRMethod method, IRExpression root, List<IRExpression> explicitArgs, int[] namedArgOrder) {
        return this.callSpecialMethod(rootType, method, root, Collections.emptyList(), explicitArgs, namedArgOrder);
    }

    public IRExpression callSpecialMethod(IRType rootType, IRMethod method, IRExpression root, List<IRExpression> implicitArgs, List<IRExpression> explicitArgs, int[] namedArgOrder) {
        return this.callMethod(rootType, method, root, implicitArgs, explicitArgs, namedArgOrder, true);
    }

    private IRExpression callMethod(IRType rootType, IRMethod method, IRExpression root, List<IRExpression> implicitArgs, List<IRExpression> explicitArgs, int[] namedArgOrder, boolean special) {
        IType owner = method.getOwningIType();
        ArrayList<IRExpression> actualArgs = new ArrayList<IRExpression>();
        List<IRElement> namedArgElements = this.handleNamedArgs(explicitArgs, namedArgOrder);
        if (owner instanceof IGosuEnhancement && !method.isStatic()) {
            ArrayList<IRExpression> tempArgs = new ArrayList<IRExpression>();
            this.pushEnhancementTypeParams(owner, tempArgs);
            this.pushTypeParams(method, tempArgs);
            if (this.shouldAddExternalSymbolsMapToCall(method)) {
                actualArgs.add(this.pushExternalSymbolsMap());
            }
            tempArgs.addAll(implicitArgs);
            tempArgs.addAll(explicitArgs);
            ArrayList<Object> compositeElements = new ArrayList<Object>();
            IRSymbol tempRoot = this._cc().makeAndIndexTempSymbol(root.getType());
            compositeElements.add(this.buildAssignment(tempRoot, root));
            compositeElements.addAll(namedArgElements);
            for (IRExpression tempArg : tempArgs) {
                IRSymbol tempArgSymbol = this._cc().makeAndIndexTempSymbol(tempArg.getType());
                compositeElements.add(this.buildAssignment(tempArgSymbol, tempArg));
                actualArgs.add((IRExpression)this.identifier(tempArgSymbol));
            }
            compositeElements.add(this.nullCheckVar(tempRoot));
            actualArgs.add(0, (IRExpression)this.identifier(tempRoot));
            compositeElements.add(this.callMethod(method, null, special, owner, actualArgs));
            return new IRCompositeExpression(compositeElements);
        }
        this.pushTypeParams(method, actualArgs);
        if (this.shouldAddExternalSymbolsMapToCall(method)) {
            actualArgs.add(this.pushExternalSymbolsMap());
        }
        actualArgs.addAll(implicitArgs);
        actualArgs.addAll(explicitArgs);
        if (!namedArgElements.isEmpty()) {
            ArrayList<Object> compositeElements = new ArrayList<Object>();
            compositeElements.addAll(namedArgElements);
            compositeElements.add(this.callMethod(method, root, special, owner, actualArgs));
            return new IRCompositeExpression(compositeElements);
        }
        return this.callMethod(method, root, special, owner, actualArgs);
    }

    public List<IRElement> handleNamedArgs(List<IRExpression> explicitArgs, int[] namedArgOrder) {
        ArrayList<IRElement> namedArgElements = new ArrayList<IRElement>();
        if (namedArgOrder != null && namedArgOrder.length > 0) {
            boolean b;
            boolean bl = b = namedArgOrder.length == explicitArgs.size();
            assert (b);
            for (int i = 0; i < namedArgOrder.length; ++i) {
                IRExpression argExpr = explicitArgs.get(namedArgOrder[i]);
                IRSymbol tempArgSymbol = this._cc().makeAndIndexTempSymbol(argExpr.getType());
                namedArgElements.add((IRElement)this.buildAssignment(tempArgSymbol, argExpr));
                explicitArgs.set(namedArgOrder[i], (IRExpression)this.identifier(tempArgSymbol));
            }
        }
        return namedArgElements;
    }

    private boolean shouldAddExternalSymbolsMapToCall(IRMethod method) {
        return (method.getOwningIType() instanceof IGosuProgram || method.isStatic() && this.isProgramOrEnclosedInProgram(method.getOwningIType())) && !method.getName().equals(OUTER_ACCESS) && !method.isGeneratedEnumMethod() && !(method.getOwningIType() instanceof IGosuTemplateInternal) && !(method instanceof SyntheticIRMethod) && !AbstractElementTransformer.isExecuteMethod(method.getName());
    }

    public static boolean isExecuteMethod(String name) {
        return name.equals("execute") || name.equals("executeWithArgs");
    }

    private IRExpression callMethod(IRMethod method, IRExpression root, boolean special, IType owner, List<IRExpression> actualArgs) {
        IRType rootType;
        IRType iRType = rootType = root == null ? null : root.getType();
        if (rootType == null && method.isStatic()) {
            rootType = method.getOwningIRType();
        }
        if (!special && this._cc().shouldUseReflection(owner, rootType, method.getAccessibility())) {
            return this.callMethodReflectively(owner, method.getName(), method.getReturnType(), method.getAllParameterTypes(), root, actualArgs);
        }
        return this.callMethodDirectly(method, root, special, owner, actualArgs);
    }

    private IRMethodCallExpression callMethodDirectly(IRMethod method, IRExpression root, boolean special, IType owner, List<IRExpression> actualArgs) {
        ArrayList<IRExpression> convertedArgs = new ArrayList<IRExpression>();
        List<IRType> paramTypes = method.getAllParameterTypes();
        for (int i = 0; i < actualArgs.size(); ++i) {
            convertedArgs.add(IRArgConverter.castOrConvertIfNecessary((IRType)paramTypes.get(i), (IRExpression)actualArgs.get(i)));
        }
        IRMethodCallExpression result = this.buildMethodCall(method.getOwningIRType(), method.getName(), owner.isInterface(), method.getReturnType(), paramTypes, root, convertedArgs);
        if (special) {
            result.setSpecial(true);
        }
        return result;
    }

    private void pushEnhancementTypeParams(IType enhancementType, List<IRExpression> args) {
        block3: {
            block2: {
                if (!enhancementType.isParameterizedType()) break block2;
                for (IType typeParam : enhancementType.getTypeParameters()) {
                    args.add(this.pushLazyType(typeParam));
                }
                break block3;
            }
            if (!enhancementType.isGenericType()) break block3;
            for (IGenericTypeVariable typeVariable : enhancementType.getGenericTypeVariables()) {
                args.add(this.pushLazyType((IType)typeVariable.getTypeVariableDefinition().getType()));
            }
        }
    }

    private IRExpression callMethodReflectively(IType owner, String strMethod, IRType returnType, List<IRType> paramTypes, IRExpression root, List<IRExpression> args) {
        ArrayList<IRExpression> argExprs = new ArrayList<IRExpression>();
        IRType irOwnerType = AbstractElementTransformer.getDescriptor(owner);
        argExprs.add(this.classLiteral(irOwnerType));
        argExprs.add(this.stringLiteral(strMethod));
        ArrayList<IRExpression> paramClasses = new ArrayList<IRExpression>();
        for (IRType iRType : paramTypes) {
            paramClasses.add(this.classLiteral(IRElement.maybeEraseStructuralType((IRType)irOwnerType, (IRType)iRType)));
        }
        argExprs.add(this.buildInitializedArray(AbstractElementTransformer.getDescriptor(Class.class), paramClasses));
        ArrayList<IRExpression> boxedArgs = new ArrayList<IRExpression>();
        for (IRExpression arg : args) {
            boxedArgs.add(this.boxValue(arg.getType(), arg));
        }
        argExprs.add(root == null ? this.pushNull() : root);
        argExprs.add(this.buildInitializedArray(IRTypeConstants.OBJECT(), boxedArgs));
        IRMethodCallExpression iRMethodCallExpression = this.buildMethodCall(GosuRuntimeMethods.class, "invokeMethod", Object.class, new Class[]{Class.class, String.class, Class[].class, Object.class, Object[].class}, null, argExprs);
        if (returnType.isVoid()) {
            return iRMethodCallExpression;
        }
        return this.unboxValueToType(returnType, (IRExpression)iRMethodCallExpression);
    }

    private void pushTypeParams(IRMethod irMethod, List<IRExpression> args) {
        block5: {
            IFunctionType funcType;
            block6: {
                IGenericTypeVariable[] typeVars;
                block4: {
                    IType[] typeParams;
                    funcType = irMethod.getFunctionType();
                    if (funcType == null || !irMethod.couldHaveTypeVariables()) {
                        return;
                    }
                    if (!funcType.isParameterizedType()) break block4;
                    for (IType typeParam : typeParams = funcType.getTypeParameters()) {
                        args.add(this.pushLazyType(typeParam));
                    }
                    break block5;
                }
                if (irMethod.getTypeVariables() == null) break block6;
                for (IGenericTypeVariable typeVariable : typeVars = irMethod.getTypeVariables()) {
                    args.add(this.pushLazyType(typeVariable.getBoundingType()));
                }
                break block5;
            }
            if (!funcType.isGenericType()) break block5;
            for (IGenericTypeVariable typeVariable : funcType.getGenericTypeVariables()) {
                args.add(this.pushLazyType(typeVariable.getTypeVariableDefinition().getType().getBoundingType()));
            }
        }
    }

    public IRStatement nullCheckVar(IRSymbol symbol) {
        return new IRIfStatement((IRExpression)new IREqualityExpression((IRExpression)this.identifier(symbol), this.nullLiteral(), true), (IRStatement)new IRThrowStatement(this.buildNewExpression(AbstractElementTransformer.getDescriptor(NullPointerException.class), Collections.emptyList(), AbstractElementTransformer.exprList(new IRExpression[0]))), null);
    }

    public IRExpression pushLazyType(IType type) {
        return this.pushLazyType(type, null);
    }

    public IRExpression pushLazyType(IType type, IGenericTypeVariable[] tvs) {
        IRExpression fastAccessType;
        if ((tvs == null || tvs.length == 0) && (fastAccessType = this.maybePushFastLazyType(type)) != null) {
            return fastAccessType;
        }
        return this.pushLazyTypeWithInvokeDynamic(type, tvs);
    }

    private IRExpression pushLazyTypeWithInvokeDynamic(IType type, IGenericTypeVariable[] tvs) {
        IRMethodStatement method = this.makeLazyTypeMethod(type, tvs);
        this._cc().getIrClass().addMethod(method);
        return this.buildNewExpression(LazyTypeResolver.class, new Class[]{LazyTypeResolver.ITypeResolver.class}, Collections.singletonList(this.buildLazyTypeResolverCall(method, tvs)));
    }

    private IRExpression maybePushFastLazyType(IType type) {
        IType genType = TypeLord.getPureGenericType(type);
        if (!(genType != type || type.isArray() && TypeLord.getCoreType(type).isParameterizedType() || !Modifier.isPublic((int)TypeLord.getCoreType(type).getModifiers()))) {
            ClassLoader cl;
            Class backingClass;
            if (type instanceof IJavaType && (backingClass = ((IJavaType)type).getBackingClass()) != null && ((cl = backingClass.getClassLoader()) == null || cl == ClassLoader.getSystemClassLoader())) {
                String fieldName = ClassLazyTypeResolver.getCachedFieldName((Class)backingClass);
                if (fieldName != null) {
                    return this.buildFieldGet(AbstractElementTransformer.getDescriptor(ClassLazyTypeResolver.class), fieldName, AbstractElementTransformer.getDescriptor(ClassLazyTypeResolver.class), null);
                }
                return this.buildNewExpression(ClassLazyTypeResolver.class, new Class[]{Class.class}, Collections.singletonList(this.classLiteral(AbstractElementTransformer.getDescriptor(type))));
            }
            if (type instanceof IGosuClass) {
                return this.pushLazyTypeByFqn(type);
            }
            if (genType instanceof TypeVariableType) {
                return this.getRuntimeTypeParameter((TypeVariableType)genType);
            }
        }
        return null;
    }

    private IRCompositeExpression buildLazyTypeResolverCall(IRMethodStatement method, IGenericTypeVariable[] tvs) {
        DynamicFunctionSymbol compilingDfs = this._cc().getCurrentFunction();
        if (this._cc().isStatic() || compilingDfs != null && compilingDfs.isStatic() || !this._cc().hasSuperBeenInvoked() || this._cc().getGosuClass() instanceof IGosuFragment) {
            return this.buildStaticLazyTypeResolverCall(method);
        }
        if (this.getGosuClass() instanceof IGosuEnhancement) {
            return this.buildEnhancementLazyTypeResolverCall(method);
        }
        if (tvs != null) {
            return this.buildSuperCallLazyTypeResolverCall(method, tvs);
        }
        return this.buildInstanceLazyTypeResolverCall(method);
    }

    private IRCompositeExpression buildStaticLazyTypeResolverCall(IRMethodStatement method) {
        IGenericTypeVariable[] tvs = this.getGenericFunctionTypeVariables(this._cc().getCurrentFunction());
        IRElement[] exprs = new IRElement[1 + (tvs == null ? 0 : tvs.length)];
        int i = 0;
        if (tvs != null) {
            for (IGenericTypeVariable tv : tvs) {
                exprs[i++] = this.identifier(this._cc().getSymbol(this.getTypeVarParamName(tv)));
            }
        }
        exprs[i] = new IRLazyTypeMethodCallExpression(method.getName(), AbstractElementTransformer.getDescriptor((IType)this.getGosuClass()), this.getGosuClass().getName(), tvs == null ? 0 : tvs.length, true);
        return this.buildComposite(exprs);
    }

    private IRCompositeExpression buildEnhancementLazyTypeResolverCall(IRMethodStatement method) {
        IGenericTypeVariable[] tvs = this.getGenericFunctionTypeVariables(this._cc().getCurrentFunction());
        IRElement[] exprs = new IRElement[1 + (tvs == null ? 0 : tvs.length)];
        int i = 0;
        if (tvs != null) {
            for (IGenericTypeVariable tv : tvs) {
                exprs[i++] = this.identifier(this._cc().getSymbol(this.getTypeVarParamName(tv)));
            }
        }
        exprs[i] = new IRLazyTypeMethodCallExpression(method.getName(), AbstractElementTransformer.getDescriptor((IType)this.getGosuClass()), this.getGosuClass().getName(), tvs == null ? 0 : tvs.length, true);
        return this.buildComposite(exprs);
    }

    private IRCompositeExpression buildInstanceLazyTypeResolverCall(IRMethodStatement method) {
        IGenericTypeVariable[] tvs = this.getGenericFunctionTypeVariables(this._cc().getCurrentFunction());
        IRElement[] exprs = new IRElement[2 + (tvs == null ? 0 : tvs.length)];
        int i = 0;
        exprs[i++] = this.pushThis();
        if (tvs != null) {
            for (IGenericTypeVariable tv : tvs) {
                exprs[i++] = this.identifier(this._cc().getSymbol(this.getTypeVarParamName(tv)));
            }
        }
        exprs[i] = new IRLazyTypeMethodCallExpression(method.getName(), AbstractElementTransformer.getDescriptor((IType)this.getGosuClass()), this.getGosuClass().getName(), tvs == null ? 0 : tvs.length, false);
        return this.buildComposite(exprs);
    }

    private IRCompositeExpression buildSuperCallLazyTypeResolverCall(IRMethodStatement method, IGenericTypeVariable[] tvs) {
        tvs = tvs != null ? tvs : this.getGenericFunctionTypeVariables(this._cc().getCurrentFunction());
        IRElement[] exprs = new IRElement[1 + (tvs == null ? 0 : tvs.length)];
        int i = 0;
        if (tvs != null) {
            for (IGenericTypeVariable tv : tvs) {
                exprs[i++] = this.identifier(this._cc().getSymbol(this.getTypeVarParamName(tv)));
            }
        }
        exprs[i] = new IRLazyTypeMethodCallExpression(method.getName(), AbstractElementTransformer.getDescriptor((IType)this.getGosuClass()), this.getGosuClass().getName(), tvs == null ? 0 : tvs.length, true);
        return this.buildComposite(exprs);
    }

    private IRMethodStatement makeLazyTypeMethod(IType type, IGenericTypeVariable[] tvs) {
        DynamicFunctionSymbol compilingDfs = this._cc().getCurrentFunction();
        if (this._cc().isStatic() || compilingDfs != null && compilingDfs.isStatic() || !this._cc().hasSuperBeenInvoked() || this._cc().getGosuClass() instanceof IGosuFragment) {
            return this.makeStaticLazyTypeMethod(type);
        }
        if (this.getGosuClass() instanceof IGosuEnhancement) {
            return this.makeEnhancementLazyTypeMethod(type);
        }
        if (tvs != null) {
            return this.makeSuperCallLazyTypeMethod(type, tvs);
        }
        return this.makeInstanceLazyTypeMethod(type);
    }

    private IRMethodStatement makeStaticLazyTypeMethod(IType type) {
        IGenericTypeVariable[] tvs = this.getGenericFunctionTypeVariables(this._cc().getCurrentFunction());
        ArrayList<IRSymbol> functionTypeVarParams = new ArrayList<IRSymbol>();
        if (tvs != null) {
            for (IGenericTypeVariable tv : tvs) {
                functionTypeVarParams.add(this._cc().getSymbol(this.getTypeVarParamName(tv)));
            }
        }
        int iIndex = this._cc().incrementLazyTypeMethodCount();
        String methodName = "itype$" + iIndex;
        return new IRMethodStatement((IRStatement)new IRStatementList(true, new IRStatement[]{new IRReturnStatement(null, this.pushType(type))}), methodName, 4106, false, AbstractElementTransformer.getDescriptor(IType.class), functionTypeVarParams);
    }

    private IRMethodStatement makeEnhancementLazyTypeMethod(IType type) {
        IGenericTypeVariable[] tvs = this.getGenericFunctionTypeVariables(this._cc().getCurrentFunction());
        ArrayList<IRSymbol> functionTypeVarParams = new ArrayList<IRSymbol>();
        if (tvs != null) {
            for (IGenericTypeVariable tv : tvs) {
                functionTypeVarParams.add(this._cc().getSymbol(this.getTypeVarParamName(tv)));
            }
        }
        int iIndex = this._cc().incrementLazyTypeMethodCount();
        String methodName = "itype$" + iIndex;
        return new IRMethodStatement((IRStatement)new IRStatementList(true, new IRStatement[]{new IRReturnStatement(null, this.pushType(type))}), methodName, 4106, false, AbstractElementTransformer.getDescriptor(IType.class), functionTypeVarParams);
    }

    private IRMethodStatement makeSuperCallLazyTypeMethod(IType type, IGenericTypeVariable[] tvs) {
        boolean bStatic = tvs != null;
        tvs = tvs == null ? this.getGenericFunctionTypeVariables(this._cc().getCurrentFunction()) : tvs;
        ArrayList<IRSymbol> functionTypeVarParams = new ArrayList<IRSymbol>();
        if (tvs != null) {
            for (IGenericTypeVariable tv : tvs) {
                functionTypeVarParams.add(this._cc().getSymbol(this.getTypeVarParamName(tv)));
            }
        }
        int iIndex = this._cc().incrementLazyTypeMethodCount();
        String methodName = "itype$" + iIndex;
        return new IRMethodStatement((IRStatement)new IRStatementList(true, new IRStatement[]{new IRReturnStatement(null, this.pushType(type))}), methodName, 0x1002 | (bStatic ? 8 : 0), false, AbstractElementTransformer.getDescriptor(IType.class), functionTypeVarParams);
    }

    private IRMethodStatement makeInstanceLazyTypeMethod(IType type) {
        IGenericTypeVariable[] tvs = this.getGenericFunctionTypeVariables(this._cc().getCurrentFunction());
        ArrayList<IRSymbol> functionTypeVarParams = new ArrayList<IRSymbol>();
        if (tvs != null) {
            for (IGenericTypeVariable tv : tvs) {
                functionTypeVarParams.add(this._cc().getSymbol(this.getTypeVarParamName(tv)));
            }
        }
        int iIndex = this._cc().incrementLazyTypeMethodCount();
        String methodName = "itype$" + iIndex;
        return new IRMethodStatement((IRStatement)new IRStatementList(true, new IRStatement[]{new IRReturnStatement(null, this.pushType(type))}), methodName, 4098, false, AbstractElementTransformer.getDescriptor(IType.class), functionTypeVarParams);
    }

    private IGenericTypeVariable[] getGenericFunctionTypeVariables(IDynamicFunctionSymbol currentFunction) {
        if (currentFunction == null) {
            return null;
        }
        IDynamicFunctionSymbol csr = currentFunction;
        while (csr != null && csr.getType() instanceof ParameterizedFunctionType) {
            currentFunction = currentFunction.getBackingDfs();
        }
        List<IGenericTypeVariable> typeVarsForDFS = AbstractElementTransformer.getTypeVarsForDFS(currentFunction);
        return typeVarsForDFS.toArray(new IGenericTypeVariable[typeVarsForDFS.size()]);
    }

    public IRExpression pushType(IType type) {
        return this.pushType(type, false);
    }

    public IRExpression pushType(IType type, boolean bKeepLiteralType) {
        ArrayList<IRExpression> args;
        ClassLoader cl;
        Class backingClass;
        IType genType = TypeLord.getPureGenericType(type);
        if (!(genType != type || !(type instanceof IJavaType) || type.isArray() && TypeLord.getCoreType(type).isParameterizedType() || !Modifier.isPublic((int)TypeLord.getCoreType(type).getModifiers()) || (backingClass = ((IJavaType)type).getBackingClass()) == null || (cl = backingClass.getClassLoader()) != null && cl != ClassLoader.getSystemClassLoader())) {
            return this.callStaticMethod(TypeSystem.class, "get", new Class[]{Class.class}, AbstractElementTransformer.exprList(this.pushConstant(backingClass)));
        }
        if (type.isArray()) {
            IRExpression componentType = this.pushType(type.getComponentType(), bKeepLiteralType);
            return this.callMethod(IType.class, "getArrayType", new Class[0], componentType, AbstractElementTransformer.exprList(new IRExpression[0]));
        }
        if (genType instanceof TypeVariableType || genType instanceof TypeVariableArrayType) {
            return this.pushRuntimeTypeOfTypeVar(genType);
        }
        if (type instanceof MetaType) {
            if (bKeepLiteralType && ((MetaType)type).isLiteral()) {
                return this.callStaticMethod(MetaType.class, "getLiteral", new Class[]{IType.class}, Collections.singletonList(this.pushType(((MetaType)type).getType())));
            }
            return this.callStaticMethod(MetaType.class, "get", new Class[]{IType.class}, Collections.singletonList(this.pushType(((MetaType)type).getType())));
        }
        if (type instanceof IBlockType) {
            IBlockType blockType = (IBlockType)type;
            args = new ArrayList<IRExpression>();
            args.add(this.pushType(blockType.getReturnType()));
            args.add(this.pushArrayOfTypes(blockType.getParameterTypes()));
            args.add(this.pushArrayOfString(blockType.getParameterNames()));
            args.add(this.pushArrayOfDefValueExpr(blockType.getDefaultValueExpressions()));
            return this.buildNewExpression(AbstractElementTransformer.getDescriptor(BlockType.class), Arrays.asList(IRTypeConstants.ITYPE(), AbstractElementTransformer.getDescriptor(IType[].class), AbstractElementTransformer.getDescriptor(String[].class), AbstractElementTransformer.getDescriptor(IExpression[].class)), args);
        }
        if (type instanceof IFunctionType) {
            IFunctionType funcType = (IFunctionType)type;
            args = new ArrayList();
            args.add(this.pushConstant(funcType.getName()));
            args.add(this.pushType(funcType.getReturnType()));
            args.add(this.pushArrayOfTypes(funcType.getParameterTypes()));
            return this.buildNewExpression(AbstractElementTransformer.getDescriptor(FunctionType.class), Arrays.asList(IRTypeConstants.STRING(), IRTypeConstants.ITYPE(), AbstractElementTransformer.getDescriptor(IType[].class)), args);
        }
        if (type instanceof CompoundType) {
            CompoundType compoundType = (CompoundType)type;
            ArrayList<Object> elements = new ArrayList<Object>();
            IRSymbol tempSet = this._cc().makeAndIndexTempSymbol(AbstractElementTransformer.getDescriptor(HashSet.class));
            elements.add(this.buildAssignment(tempSet, this.buildNewExpression(AbstractElementTransformer.getDescriptor(HashSet.class), Collections.emptyList(), Collections.emptyList())));
            for (IType iType : compoundType.getTypes()) {
                this.pushType(iType);
                elements.add(new IRMethodCallStatement(this.callMethod(Set.class, "add", new Class[]{Object.class}, (IRExpression)this.identifier(tempSet), Collections.singletonList(this.pushType(iType)))));
            }
            elements.add(this.identifier(tempSet));
            IRCompositeExpression setCreation = new IRCompositeExpression(elements);
            return this.callStaticMethod(CompoundType.class, "get", new Class[]{Set.class}, Collections.singletonList(setCreation));
        }
        if (type instanceof IErrorType) {
            String errorMsg = "Unexpected Error Type: " + type.getName() + ", while compiling " + this._cc().getGosuClass().getName() + "\n  Enclosing class:  " + (this._cc().getEnclosingType() == null ? "" : this._cc().getEnclosingType().getName()) + "\n  Current function: " + this._cc().getCurrentFunctionName() + "\n  Parsed element: " + (this._parsedElement == null ? "" : this._parsedElement.toString()) + "\n  Class source: " + this._cc().getGosuClass().getSource() + "\n";
            throw new IllegalStateException(errorMsg);
        }
        IModule module = this.getModule(genType);
        IRExpression result = this.callStaticMethod(TypeSystem.class, "getByFullName", new Class[]{String.class, String.class}, Arrays.asList(this.pushConstant(genType.getName()), module == null ? this.pushNull() : this.pushConstant(module.getName())));
        if (type.isParameterizedType() && !TypeLord.isRecursiveType(type) && !this.isRecursiveTypeParsing(type)) {
            result = this.callMethod(IType.class, "getParameterizedType", new Class[]{IType[].class}, result, Collections.singletonList(this.pushArrayOfTypes(type.getTypeParameters())));
        }
        return result;
    }

    private boolean isRecursiveTypeParsing(IType type) {
        for (IType typeParam : type.getTypeParameters()) {
            if (typeParam != GosuParser.PENDING_BOUNDING_TYPE) continue;
            return true;
        }
        return false;
    }

    protected IRExpression pushArrayOfString(String[] array) {
        if (array != null) {
            ArrayList<IRExpression> elements = new ArrayList<IRExpression>(array.length);
            for (String o : array) {
                elements.add(this.pushConstant(o));
            }
            return this.buildInitializedArray(AbstractElementTransformer.getDescriptor(array.getClass().getComponentType()), elements);
        }
        return this.pushNull();
    }

    protected IRExpression pushArrayOfDefValueExpr(IExpression[] array) {
        if (array != null) {
            ArrayList<IRExpression> elements = new ArrayList<IRExpression>(array.length);
            for (IExpression o : array) {
                elements.add(this.pushConstant(o));
            }
            return this.buildInitializedArray(AbstractElementTransformer.getDescriptor(array.getClass().getComponentType()), elements);
        }
        return this.pushNull();
    }

    public IRExpression pushArrayOfTypes(IType[] types) {
        ArrayList<IRExpression> values = new ArrayList<IRExpression>();
        for (IType type : types) {
            values.add(this.pushType(type));
        }
        return this.buildInitializedArray(IRTypeConstants.ITYPE(), values);
    }

    public static boolean requiresImplicitEnhancementArg(ReducedDynamicFunctionSymbol dfs) {
        return AbstractElementTransformer.isEnhancementType((IType)dfs.getGosuClass()) && !dfs.isStatic();
    }

    public static boolean requiresImplicitEnhancementArg(IGosuMethodInfo mi) {
        return AbstractElementTransformer.isEnhancementType(mi.getOwnersType()) && !mi.isStatic();
    }

    public IJavaClassInfo[] getClassInfos(IType[] parameters) {
        IJavaClassInfo[] paramTypes = new IJavaClassInfo[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            IType paramType = parameters[i];
            if (paramType instanceof IJavaType) {
                paramTypes[i] = ((IJavaType)paramType).getBackingClassInfo();
                continue;
            }
            IRType descriptor = AbstractElementTransformer.getDescriptor(paramType);
            int iDims = 0;
            while (descriptor.isArray()) {
                descriptor = descriptor.getComponentType();
                ++iDims;
            }
            paramTypes[i] = TypeSystem.getJavaClassInfo((String)descriptor.getName(), (IModule)this.getModule(paramType));
            while (iDims-- > 0) {
                paramTypes[i] = paramTypes[i].getArrayType();
            }
        }
        return paramTypes;
    }

    private IModule getModule(IType type) {
        return TypeSystem.getGlobalModule();
    }

    public IType getConcreteType(IType type) {
        if (type != null) {
            if (type instanceof TypeVariableType) {
                return this.getConcreteType(((TypeVariableType)type).getBoundingType());
            }
            if (type instanceof TypeVariableArrayType) {
                return this.getConcreteType(type.getComponentType()).getArrayType();
            }
        }
        return type;
    }

    public static IRType getDescriptor(IType type) {
        return IRTypeResolver.getDescriptor(type);
    }

    public static IRType getDescriptor(IType type, boolean getConcreteTypeForMetaType) {
        return IRTypeResolver.getDescriptor(type, getConcreteTypeForMetaType);
    }

    public static IRType getDescriptor(Class cls) {
        return IRTypeResolver.getDescriptor(cls);
    }

    public static IRType getDescriptor(IJavaClassInfo cls) {
        return IRTypeResolver.getDescriptor(cls);
    }

    public IRExpression getDefaultConstIns(IType type) {
        if (type == JavaTypes.pBYTE()) {
            return this.numericLiteral((byte)0);
        }
        if (type == JavaTypes.pCHAR()) {
            return this.numericLiteral(0);
        }
        if (type == JavaTypes.pSHORT()) {
            return this.numericLiteral((short)0);
        }
        if (type == JavaTypes.pINT()) {
            return this.numericLiteral(0);
        }
        if (type == JavaTypes.pBOOLEAN()) {
            return this.booleanLiteral(false);
        }
        if (type == JavaTypes.pLONG()) {
            return this.numericLiteral(0L);
        }
        if (type == JavaTypes.pFLOAT()) {
            return this.numericLiteral(Float.valueOf(0.0f));
        }
        if (type == JavaTypes.pDOUBLE()) {
            return this.numericLiteral(0.0);
        }
        return this.nullLiteral();
    }

    public int getModifiers(Symbol symbol) {
        int iSymModifiers = symbol.getModifiers();
        int iAccModifiers = BytecodeOptions.isSingleServingLoader() ? (Modifier.isPrivate((int)iSymModifiers) && this.isReadObjectOrWriteObjectMethod(symbol) ? 2 : 1) : (Modifier.isPublic((int)iSymModifiers) || Modifier.isProtected((int)iSymModifiers) && this.isCompilingEnhancement() ? 1 : (Modifier.isProtected((int)iSymModifiers) ? 4 : (Modifier.isInternal((int)iSymModifiers) ? 0 : (Modifier.isPrivate((int)iSymModifiers) ? (this.isReadObjectOrWriteObjectMethod(symbol) ? 2 : 0) : 1))));
        if (Modifier.isFinal((int)iSymModifiers)) {
            iAccModifiers |= 0x10;
        }
        if (Modifier.isStatic((int)iSymModifiers)) {
            iAccModifiers |= 8;
        }
        if (Modifier.isAbstract((int)iSymModifiers)) {
            iAccModifiers |= 0x400;
        }
        if (Modifier.isEnum((int)iSymModifiers)) {
            iAccModifiers |= 0x4000;
        }
        if (Modifier.isTransient((int)iSymModifiers)) {
            iAccModifiers |= 0x80;
        }
        if (Modifier.isDeprecated((int)iSymModifiers)) {
            iAccModifiers |= 0x20000;
        }
        if (this.isCompilingEnhancement()) {
            iAccModifiers |= 8;
        }
        return iAccModifiers;
    }

    private boolean isReadObjectOrWriteObjectMethod(Symbol symbol) {
        if (symbol instanceof DynamicFunctionSymbol) {
            DynamicFunctionSymbol dfs = (DynamicFunctionSymbol)symbol;
            if (dfs.getDisplayName().equals("readObject")) {
                IType[] argTypes = dfs.getArgTypes();
                return argTypes != null && argTypes.length == 1 && argTypes[0].equals(JavaTypes.getJreType(ObjectInputStream.class)) && dfs.getReturnType().equals(JavaTypes.pVOID());
            }
            if (dfs.getDisplayName().equals("writeObject")) {
                IType[] argTypes = dfs.getArgTypes();
                return argTypes != null && argTypes.length == 1 && argTypes[0].equals(JavaTypes.getJreType(ObjectOutputStream.class)) && dfs.getReturnType().equals(JavaTypes.pVOID());
            }
            return false;
        }
        return false;
    }

    public boolean isCompilingEnhancement() {
        return this._cc.compilingEnhancement();
    }

    public boolean isProgramOrEnclosedInProgram(IType type) {
        if (type == null) {
            return false;
        }
        if (type instanceof IGosuProgram) {
            return true;
        }
        return this.isProgramOrEnclosedInProgram(type.getEnclosingType());
    }

    public IRExpression boxValue(IType lhsType, IRExpression root) {
        if (!lhsType.isPrimitive() || lhsType == JavaTypes.pVOID()) {
            return root;
        }
        if (lhsType == JavaTypes.pBOOLEAN()) {
            return this.callStaticMethod(Boolean.class, "valueOf", new Class[]{Boolean.TYPE}, Collections.singletonList(root));
        }
        if (lhsType == JavaTypes.pBYTE()) {
            return this.callStaticMethod(Byte.class, "valueOf", new Class[]{Byte.TYPE}, Collections.singletonList(root));
        }
        if (lhsType == JavaTypes.pCHAR()) {
            return this.callStaticMethod(AbstractElementTransformer.class, "valueOf", new Class[]{Character.TYPE}, Collections.singletonList(root));
        }
        if (lhsType == JavaTypes.pSHORT()) {
            return this.callStaticMethod(Short.class, "valueOf", new Class[]{Short.TYPE}, Collections.singletonList(root));
        }
        if (lhsType == JavaTypes.pINT()) {
            return this.callStaticMethod(Integer.class, "valueOf", new Class[]{Integer.TYPE}, Collections.singletonList(root));
        }
        if (lhsType == JavaTypes.pLONG()) {
            return this.callStaticMethod(Long.class, "valueOf", new Class[]{Long.TYPE}, Collections.singletonList(root));
        }
        if (lhsType == JavaTypes.pFLOAT()) {
            return this.callStaticMethod(Float.class, "valueOf", new Class[]{Float.TYPE}, Collections.singletonList(root));
        }
        if (lhsType == JavaTypes.pDOUBLE()) {
            return this.callStaticMethod(Double.class, "valueOf", new Class[]{Double.TYPE}, Collections.singletonList(root));
        }
        throw new IllegalArgumentException("Unexpected type " + lhsType.getName());
    }

    public static Character valueOf(char c) {
        if (c >= '\u0000' && c <= '\u007f') {
            return Character.valueOf(c);
        }
        return new Character(c);
    }

    public IRExpression boxValue(IRType lhsType, IRExpression root) {
        if (!lhsType.isPrimitive() || lhsType.isVoid()) {
            return root;
        }
        if (lhsType.isBoolean()) {
            return this.callStaticMethod(Boolean.class, "valueOf", new Class[]{Boolean.TYPE}, Collections.singletonList(root));
        }
        if (lhsType.isByte()) {
            return this.callStaticMethod(Byte.class, "valueOf", new Class[]{Byte.TYPE}, Collections.singletonList(root));
        }
        if (lhsType.isChar()) {
            return this.callStaticMethod(AbstractElementTransformer.class, "valueOf", new Class[]{Character.TYPE}, Collections.singletonList(root));
        }
        if (lhsType.isShort()) {
            return this.callStaticMethod(Short.class, "valueOf", new Class[]{Short.TYPE}, Collections.singletonList(root));
        }
        if (lhsType.isInt()) {
            return this.callStaticMethod(Integer.class, "valueOf", new Class[]{Integer.TYPE}, Collections.singletonList(root));
        }
        if (lhsType.isLong()) {
            return this.callStaticMethod(Long.class, "valueOf", new Class[]{Long.TYPE}, Collections.singletonList(root));
        }
        if (lhsType.isFloat()) {
            return this.callStaticMethod(Float.class, "valueOf", new Class[]{Float.TYPE}, Collections.singletonList(root));
        }
        if (lhsType.isDouble()) {
            return this.callStaticMethod(Double.class, "valueOf", new Class[]{Double.TYPE}, Collections.singletonList(root));
        }
        throw new IllegalArgumentException("Unexpected type " + lhsType.getName());
    }

    public IRExpression boxValueToType(IType toType, IRExpression root) {
        if (toType.isPrimitive()) {
            return this.boxValue(toType, root);
        }
        String VALUE_OF = "valueOf";
        if (toType == JavaTypes.BOOLEAN()) {
            return this.callStaticMethod(Boolean.class, VALUE_OF, new Class[]{Boolean.TYPE}, Collections.singletonList(root));
        }
        if (toType == JavaTypes.BYTE()) {
            return this.callStaticMethod(Byte.class, VALUE_OF, new Class[]{Byte.TYPE}, Collections.singletonList(root));
        }
        if (toType == JavaTypes.CHARACTER()) {
            return this.callStaticMethod(Character.class, VALUE_OF, new Class[]{Character.TYPE}, Collections.singletonList(root));
        }
        if (toType == JavaTypes.SHORT()) {
            return this.callStaticMethod(Short.class, VALUE_OF, new Class[]{Short.TYPE}, Collections.singletonList(root));
        }
        if (toType == JavaTypes.INTEGER()) {
            return this.callStaticMethod(Integer.class, VALUE_OF, new Class[]{Integer.TYPE}, Collections.singletonList(root));
        }
        if (toType == JavaTypes.LONG()) {
            return this.callStaticMethod(Long.class, VALUE_OF, new Class[]{Long.TYPE}, Collections.singletonList(root));
        }
        if (toType == JavaTypes.FLOAT()) {
            return this.callStaticMethod(Float.class, VALUE_OF, new Class[]{Float.TYPE}, Collections.singletonList(root));
        }
        if (toType == JavaTypes.DOUBLE()) {
            return this.callStaticMethod(Double.class, VALUE_OF, new Class[]{Double.TYPE}, Collections.singletonList(root));
        }
        return root;
    }

    public IRExpression unboxValueToType(IType lhsType, IRExpression expression) {
        if (!lhsType.isPrimitive()) {
            return this.checkCast(lhsType, expression);
        }
        if (lhsType == JavaTypes.pBOOLEAN()) {
            return this.callMethod(Boolean.class, "booleanValue", new Class[0], this.checkCast(Boolean.class, expression), Collections.emptyList());
        }
        if (lhsType == JavaTypes.pBYTE()) {
            return this.callMethod(Byte.class, "byteValue", new Class[0], this.checkCast(Byte.class, expression), Collections.emptyList());
        }
        if (lhsType == JavaTypes.pCHAR()) {
            return this.callMethod(Character.class, "charValue", new Class[0], this.checkCast(Character.class, expression), Collections.emptyList());
        }
        if (lhsType == JavaTypes.pSHORT()) {
            return this.callMethod(Short.class, "shortValue", new Class[0], this.checkCast(Short.class, expression), Collections.emptyList());
        }
        if (lhsType == JavaTypes.pINT()) {
            return this.callMethod(Integer.class, "intValue", new Class[0], this.checkCast(Integer.class, expression), Collections.emptyList());
        }
        if (lhsType == JavaTypes.pLONG()) {
            return this.callMethod(Long.class, "longValue", new Class[0], this.checkCast(Long.class, expression), Collections.emptyList());
        }
        if (lhsType == JavaTypes.pFLOAT()) {
            return this.callMethod(Float.class, "floatValue", new Class[0], this.checkCast(Float.class, expression), Collections.emptyList());
        }
        if (lhsType == JavaTypes.pDOUBLE()) {
            return this.callMethod(Double.class, "doubleValue", new Class[0], this.checkCast(Double.class, expression), Collections.emptyList());
        }
        if (lhsType == JavaTypes.pVOID()) {
            return expression;
        }
        throw new IllegalArgumentException("Unexpected type " + lhsType.getName());
    }

    public IRExpression unboxValueToType(IRType lhsType, IRExpression expression) {
        if (!lhsType.isPrimitive()) {
            return this.buildCast(lhsType, expression);
        }
        if (lhsType.isBoolean()) {
            return this.callMethod(Boolean.class, "booleanValue", new Class[0], this.checkCast(Boolean.class, expression), Collections.emptyList());
        }
        if (lhsType.isByte()) {
            return this.callMethod(Byte.class, "byteValue", new Class[0], this.checkCast(Byte.class, expression), Collections.emptyList());
        }
        if (lhsType.isChar()) {
            return this.callMethod(Character.class, "charValue", new Class[0], this.checkCast(Character.class, expression), Collections.emptyList());
        }
        if (lhsType.isShort()) {
            return this.callMethod(Short.class, "shortValue", new Class[0], this.checkCast(Short.class, expression), Collections.emptyList());
        }
        if (lhsType.isInt()) {
            return this.callMethod(Integer.class, "intValue", new Class[0], this.checkCast(Integer.class, expression), Collections.emptyList());
        }
        if (lhsType.isLong()) {
            return this.callMethod(Long.class, "longValue", new Class[0], this.checkCast(Long.class, expression), Collections.emptyList());
        }
        if (lhsType.isFloat()) {
            return this.callMethod(Float.class, "floatValue", new Class[0], this.checkCast(Float.class, expression), Collections.emptyList());
        }
        if (lhsType.isDouble()) {
            return this.callMethod(Double.class, "doubleValue", new Class[0], this.checkCast(Double.class, expression), Collections.emptyList());
        }
        if (lhsType.isVoid()) {
            return expression;
        }
        throw new IllegalArgumentException("Unexpected type " + lhsType.getName());
    }

    public IRExpression unboxValueFromType(IType boxedType, IRExpression root) {
        if (boxedType.isPrimitive()) {
            return root;
        }
        if (boxedType == JavaTypes.BOOLEAN()) {
            return this.callMethod(Boolean.class, "booleanValue", new Class[0], this.checkCast(Boolean.class, root), Collections.emptyList());
        }
        if (boxedType == JavaTypes.BYTE()) {
            return this.callMethod(Byte.class, "byteValue", new Class[0], this.checkCast(Byte.class, root), Collections.emptyList());
        }
        if (boxedType == JavaTypes.CHARACTER()) {
            return this.callMethod(Character.class, "charValue", new Class[0], this.checkCast(Character.class, root), Collections.emptyList());
        }
        if (boxedType == JavaTypes.SHORT()) {
            return this.callMethod(Short.class, "shortValue", new Class[0], this.checkCast(Short.class, root), Collections.emptyList());
        }
        if (boxedType == JavaTypes.INTEGER()) {
            return this.callMethod(Integer.class, "intValue", new Class[0], this.checkCast(Integer.class, root), Collections.emptyList());
        }
        if (boxedType == JavaTypes.LONG()) {
            return this.callMethod(Long.class, "longValue", new Class[0], this.checkCast(Long.class, root), Collections.emptyList());
        }
        if (boxedType == JavaTypes.FLOAT()) {
            return this.callMethod(Float.class, "floatValue", new Class[0], this.checkCast(Float.class, root), Collections.emptyList());
        }
        if (boxedType == JavaTypes.DOUBLE()) {
            return this.callMethod(Double.class, "doubleValue", new Class[0], this.checkCast(Double.class, root), Collections.emptyList());
        }
        throw new IllegalArgumentException("Unexpected type " + boxedType.getName());
    }

    public boolean isProgram(IType type) {
        return type instanceof IGosuProgram;
    }

    public static boolean isEnhancementType(IType type) {
        return type instanceof IGosuEnhancement;
    }

    public static boolean isBytecodeType(IType type) {
        return TypeSystem.isBytecodeType((IType)type);
    }

    public static boolean isBytecodeType(IConstructorInfo ci) {
        if (ci instanceof IJavaConstructorInfo) {
            return true;
        }
        return ci instanceof IGosuConstructorInfo;
    }

    public static IType[] getTypes(IParameterInfo[] parameters) {
        IType[] paramTypes = new IType[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            paramTypes[i] = parameters[i].getFeatureType();
        }
        return paramTypes;
    }

    protected IRExpression pushString(IExpression expr) {
        if (expr.getType() != JavaTypes.STRING()) {
            return this.callMethod(ICoercionManager.class, "makeStringFrom", new Class[]{Object.class}, this.callStaticMethod(CommonServices.class, "getCoercionManager", new Class[0], Collections.emptyList()), Collections.singletonList(ExpressionTransformer.compile(expr, this._cc())));
        }
        return ExpressionTransformer.compile(expr, this._cc());
    }

    protected IRExpression pushParamTypes(IParameterInfo[] parameters) {
        if (parameters.length == 0) {
            return this.pushNull();
        }
        return this.pushArrayOfTypes(AbstractElementTransformer.getTypes(parameters));
    }

    protected IRExpression pushNull() {
        return this.nullLiteral();
    }

    protected IRExpression pushConstant(Object constant) {
        if (constant instanceof Boolean) {
            return this.booleanLiteral((Boolean)constant);
        }
        if (constant instanceof Character) {
            return this.charLiteral(((Character)constant).charValue());
        }
        if (constant instanceof Number) {
            return this.numericLiteral((Number)constant);
        }
        if (constant instanceof String) {
            return this.stringLiteral((String)constant);
        }
        if (constant instanceof Class) {
            return this.classLiteral((Class)constant);
        }
        if (constant instanceof IJavaType) {
            return this.classLiteral(((IJavaType)constant).getBackingClassInfo());
        }
        if (constant instanceof IJavaClassInfo) {
            return this.classLiteral((IJavaClassInfo)constant);
        }
        if (constant instanceof IRType) {
            return this.classLiteral((IRType)constant);
        }
        if (constant == null) {
            return this.pushNull();
        }
        throw new IllegalArgumentException(constant.getClass() + " is not a supported constant type");
    }

    protected IRExpression convertBoxedNullToPrimitive(IType boxedType) {
        if (boxedType == JavaTypes.BOOLEAN()) {
            return this.convertNullToPrimitive((IType)JavaTypes.pBOOLEAN());
        }
        if (boxedType == JavaTypes.BYTE()) {
            return this.convertNullToPrimitive((IType)JavaTypes.pBYTE());
        }
        if (boxedType == JavaTypes.CHARACTER()) {
            return this.convertNullToPrimitive((IType)JavaTypes.pCHAR());
        }
        if (boxedType == JavaTypes.SHORT()) {
            return this.convertNullToPrimitive((IType)JavaTypes.pSHORT());
        }
        if (boxedType == JavaTypes.INTEGER()) {
            return this.convertNullToPrimitive((IType)JavaTypes.pINT());
        }
        if (boxedType == JavaTypes.LONG()) {
            return this.convertNullToPrimitive((IType)JavaTypes.pLONG());
        }
        if (boxedType == JavaTypes.FLOAT()) {
            return this.convertNullToPrimitive((IType)JavaTypes.pFLOAT());
        }
        if (boxedType == JavaTypes.DOUBLE()) {
            return this.convertNullToPrimitive((IType)JavaTypes.pDOUBLE());
        }
        throw new IllegalArgumentException("Unexpected type " + boxedType.getName());
    }

    protected IRExpression convertNullToPrimitive(IType primitive) {
        if (primitive == JavaTypes.pBOOLEAN()) {
            return this.booleanLiteral(false);
        }
        if (primitive == JavaTypes.pBYTE()) {
            return this.numericLiteral((byte)0);
        }
        if (primitive == JavaTypes.pSHORT()) {
            return this.numericLiteral((short)0);
        }
        if (primitive == JavaTypes.pCHAR() || primitive == JavaTypes.pINT()) {
            return this.numericLiteral(0);
        }
        if (primitive == JavaTypes.pLONG()) {
            return this.numericLiteral(0L);
        }
        if (primitive == JavaTypes.pFLOAT()) {
            return this.numericLiteral(Float.valueOf(0.0f));
        }
        if (primitive == JavaTypes.pDOUBLE()) {
            return this.numericLiteral(0.0);
        }
        throw new IllegalStateException("Unexpected type: " + primitive);
    }

    protected IRExpression checkCast(Class cls, IRExpression expression) {
        return this.checkCast(TypeSystem.get((Class)cls), expression);
    }

    protected IRExpression checkCast(IType type, IRExpression expression) {
        return this.checkCast(type, expression, true);
    }

    protected IRExpression checkCast(IType type, IRExpression expression, boolean bGetConcreteTypeForMetaType) {
        if (type instanceof CompoundType) {
            CompoundType ct = (CompoundType)type;
            Set<IType> types = ct.getTypes();
            ArrayList<IType> ltypes = new ArrayList<IType>(types);
            Collections.sort(ltypes, new Comparator<IType>(){

                @Override
                public int compare(IType t1, IType t2) {
                    return t1.isInterface() ? 0 : 1;
                }
            });
            IRExpression last = expression;
            Iterator iterator = ltypes.iterator();
            while (iterator.hasNext()) {
                IType t;
                last = this.checkCast(t, last, !((t = (IType)iterator.next()) instanceof IMetaType));
            }
            return last;
        }
        return this.buildCast(AbstractElementTransformer.getDescriptor(type, bGetConcreteTypeForMetaType), expression);
    }

    protected IRAssignmentStatement convertOperandToBig(IType bigType, Class bigClass, IType operandType, IRExpression operand, IRSymbol tempRet) {
        IRAssignmentStatement tempOperandAssn;
        if (operandType == bigType) {
            tempOperandAssn = this.buildAssignment(tempRet, operand);
        } else if (operandType == JavaTypes.RATIONAL()) {
            tempOperandAssn = bigType == JavaTypes.BIG_DECIMAL() ? this.buildAssignment(tempRet, (IRExpression)this.buildMethodCall(Rational.class, "toBigDecimal", BigInteger.class, new Class[0], operand, Collections.emptyList())) : this.buildAssignment(tempRet, (IRExpression)this.buildMethodCall(Rational.class, "toBigInteger", BigInteger.class, new Class[0], operand, Collections.emptyList()));
        } else {
            IType dimensionType = AbstractElementTransformer.findDimensionType(operandType);
            if (dimensionType != null) {
                return this.convertOperandToBig(bigType, bigClass, dimensionType, this.callMethod(IDimension.class, "toNumber", new Class[0], operand, Collections.emptyList()), tempRet);
            }
            if (operandType == JavaTypes.BIG_INTEGER()) {
                tempOperandAssn = this.buildAssignment(tempRet, this.buildNewExpression(BigDecimal.class, new Class[]{BigInteger.class}, Collections.singletonList(operand)));
            } else if (operandType == JavaTypes.BIG_DECIMAL()) {
                tempOperandAssn = this.buildAssignment(tempRet, (IRExpression)this.buildMethodCall(BigDecimal.class, "toBigInteger", BigInteger.class, new Class[0], operand, Collections.emptyList()));
            } else if (StandardCoercionManager.isBoxed((IType)operandType)) {
                tempOperandAssn = bigClass == BigInteger.class || AbstractElementTransformer.isBoxedIntType(operandType) || operandType == JavaTypes.LONG() ? (operandType == JavaTypes.CHARACTER() ? this.buildAssignment(tempRet, this.callStaticMethod(bigClass, "valueOf", new Class[]{Long.TYPE}, Collections.singletonList(this.numberConvert(AbstractElementTransformer.getDescriptor(Character.TYPE), AbstractElementTransformer.getDescriptor(Long.TYPE), (IRExpression)this.buildMethodCall(AbstractElementTransformer.getDescriptor(operandType), "charValue", false, AbstractElementTransformer.getDescriptor(Character.TYPE), Collections.emptyList(), operand, Collections.emptyList()))))) : this.buildAssignment(tempRet, this.callStaticMethod(bigClass, "valueOf", new Class[]{Long.TYPE}, Collections.singletonList(this.buildMethodCall(AbstractElementTransformer.getDescriptor(operandType), "longValue", false, AbstractElementTransformer.getDescriptor(Long.TYPE), Collections.emptyList(), operand, Collections.emptyList()))))) : (operandType == JavaTypes.CHARACTER() ? this.buildAssignment(tempRet, this.callStaticMethod(bigClass, "valueOf", new Class[]{Double.TYPE}, Collections.singletonList(this.numberConvert(AbstractElementTransformer.getDescriptor(Character.TYPE), AbstractElementTransformer.getDescriptor(Double.TYPE), (IRExpression)this.buildMethodCall(AbstractElementTransformer.getDescriptor(operandType), "charValue", false, AbstractElementTransformer.getDescriptor(Character.TYPE), Collections.emptyList(), operand, Collections.emptyList()))))) : (operandType == JavaTypes.FLOAT() ? this.buildAssignment(tempRet, this.buildNewExpression(bigClass, new Class[]{String.class}, Collections.singletonList(this.buildMethodCall(AbstractElementTransformer.getDescriptor(Float.class), "toString", false, AbstractElementTransformer.getDescriptor(String.class), Collections.emptyList(), operand, Collections.emptyList())))) : this.buildAssignment(tempRet, this.callStaticMethod(bigClass, "valueOf", new Class[]{Double.TYPE}, Collections.singletonList(this.buildMethodCall(AbstractElementTransformer.getDescriptor(operandType), "doubleValue", false, AbstractElementTransformer.getDescriptor(Double.TYPE), Collections.emptyList(), operand, Collections.emptyList()))))));
            } else if (operandType.isPrimitive()) {
                tempOperandAssn = bigClass == BigDecimal.class && operandType == JavaTypes.pFLOAT() ? this.buildAssignment(tempRet, this.buildNewExpression(bigClass, new Class[]{String.class}, Collections.singletonList(this.callStaticMethod(String.class, "valueOf", new Class[]{Float.TYPE}, Collections.singletonList(operand))))) : (bigClass == BigInteger.class || AbstractElementTransformer.isIntType(operandType) || operandType == JavaTypes.pLONG() ? this.buildAssignment(tempRet, this.callStaticMethod(bigClass, "valueOf", new Class[]{Long.TYPE}, Collections.singletonList(this.numberConvert(operandType, (IType)JavaTypes.pLONG(), operand)))) : this.buildAssignment(tempRet, this.callStaticMethod(BigDecimal.class, "valueOf", new Class[]{Double.TYPE}, Collections.singletonList(this.numberConvert(operandType, (IType)JavaTypes.pDOUBLE(), operand)))));
            } else {
                throw new IllegalStateException("Unhandled type: " + operandType.getName());
            }
        }
        return tempOperandAssn;
    }

    protected IRAssignmentStatement convertOperandToRational(IType operandType, IRExpression operand, IRSymbol tempRet) {
        IRAssignmentStatement tempOperandAssn;
        if (operandType == JavaTypes.RATIONAL()) {
            tempOperandAssn = this.buildAssignment(tempRet, operand);
        } else if (operandType == JavaTypes.BIG_DECIMAL()) {
            tempOperandAssn = this.buildAssignment(tempRet, (IRExpression)this.buildMethodCall(Rational.class, "get", Rational.class, new Class[]{BigDecimal.class}, null, Collections.singletonList(operand)));
        } else if (operandType == JavaTypes.BIG_INTEGER()) {
            tempOperandAssn = this.buildAssignment(tempRet, (IRExpression)this.buildMethodCall(Rational.class, "get", Rational.class, new Class[]{BigInteger.class}, null, Collections.singletonList(operand)));
        } else {
            IType dimensionType = AbstractElementTransformer.findDimensionType(operandType);
            if (dimensionType != null) {
                return this.convertOperandToRational(dimensionType, this.callMethod(IDimension.class, "toNumber", new Class[0], operand, Collections.emptyList()), tempRet);
            }
            if (StandardCoercionManager.isBoxed((IType)operandType)) {
                tempOperandAssn = AbstractElementTransformer.isBoxedIntType(operandType) || operandType == JavaTypes.LONG() ? (operandType == JavaTypes.CHARACTER() ? this.buildAssignment(tempRet, this.callStaticMethod(Rational.class, "get", new Class[]{Long.TYPE}, Collections.singletonList(this.numberConvert(AbstractElementTransformer.getDescriptor(Character.TYPE), AbstractElementTransformer.getDescriptor(Long.TYPE), (IRExpression)this.buildMethodCall(AbstractElementTransformer.getDescriptor(operandType), "charValue", false, AbstractElementTransformer.getDescriptor(Character.TYPE), Collections.emptyList(), operand, Collections.emptyList()))))) : this.buildAssignment(tempRet, this.callStaticMethod(Rational.class, "get", new Class[]{Long.TYPE}, Collections.singletonList(this.buildMethodCall(AbstractElementTransformer.getDescriptor(operandType), "longValue", false, AbstractElementTransformer.getDescriptor(Long.TYPE), Collections.emptyList(), operand, Collections.emptyList()))))) : (operandType == JavaTypes.CHARACTER() ? this.buildAssignment(tempRet, this.callStaticMethod(Rational.class, "valueOf", new Class[]{Double.TYPE}, Collections.singletonList(this.numberConvert(AbstractElementTransformer.getDescriptor(Character.TYPE), AbstractElementTransformer.getDescriptor(Double.TYPE), (IRExpression)this.buildMethodCall(AbstractElementTransformer.getDescriptor(operandType), "charValue", false, AbstractElementTransformer.getDescriptor(Character.TYPE), Collections.emptyList(), operand, Collections.emptyList()))))) : (operandType == JavaTypes.FLOAT() ? this.buildAssignment(tempRet, this.callStaticMethod(Rational.class, "get", new Class[]{String.class}, Collections.singletonList(this.buildMethodCall(AbstractElementTransformer.getDescriptor(Float.class), "toString", false, AbstractElementTransformer.getDescriptor(String.class), Collections.emptyList(), operand, Collections.emptyList())))) : this.buildAssignment(tempRet, this.callStaticMethod(Rational.class, "get", new Class[]{Double.TYPE}, Collections.singletonList(this.buildMethodCall(AbstractElementTransformer.getDescriptor(operandType), "doubleValue", false, AbstractElementTransformer.getDescriptor(Double.TYPE), Collections.emptyList(), operand, Collections.emptyList()))))));
            } else if (operandType.isPrimitive()) {
                tempOperandAssn = operandType == JavaTypes.pFLOAT() ? this.buildAssignment(tempRet, this.callStaticMethod(Rational.class, "get", new Class[]{String.class}, Collections.singletonList(this.callStaticMethod(String.class, "valueOf", new Class[]{Float.TYPE}, Collections.singletonList(operand))))) : (AbstractElementTransformer.isIntType(operandType) || operandType == JavaTypes.pLONG() ? this.buildAssignment(tempRet, this.callStaticMethod(Rational.class, "get", new Class[]{Long.TYPE}, Collections.singletonList(this.numberConvert(operandType, (IType)JavaTypes.pLONG(), operand)))) : this.buildAssignment(tempRet, this.callStaticMethod(Rational.class, "get", new Class[]{Double.TYPE}, Collections.singletonList(this.numberConvert(operandType, (IType)JavaTypes.pDOUBLE(), operand)))));
            } else {
                throw new IllegalStateException("Unhandled type: " + operandType.getName());
            }
        }
        return tempOperandAssn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected IRAssignmentStatement convertOperandToPrimitive(IType primitiveType, IType operandType, IRExpression operand, IRSymbol tempRet) {
        if (operandType == primitiveType) {
            return this.buildAssignment(tempRet, operand);
        }
        IType dimensionType = AbstractElementTransformer.findDimensionType(operandType);
        if (dimensionType != null) {
            return this.convertOperandToPrimitive(primitiveType, dimensionType, this.callMethod(IDimension.class, "toNumber", new Class[0], operand, Collections.emptyList()), tempRet);
        }
        if (operandType == JavaTypes.BIG_INTEGER()) {
            return this.buildAssignment(tempRet, this.numberConvert((IType)JavaTypes.pLONG(), primitiveType, this.callMethod(BigInteger.class, "longValue", new Class[0], operand, Collections.emptyList())));
        }
        if (operandType == JavaTypes.BIG_DECIMAL()) {
            return this.buildAssignment(tempRet, this.numberConvert((IType)JavaTypes.pDOUBLE(), primitiveType, this.callMethod(BigDecimal.class, "doubleValue", new Class[0], operand, Collections.emptyList())));
        }
        if (StandardCoercionManager.isBoxed((IType)operandType)) {
            if (operandType == JavaTypes.CHARACTER()) {
                return this.buildAssignment(tempRet, this.numberConvert((IType)JavaTypes.pCHAR(), primitiveType, this.callMethod(Character.class, "charValue", new Class[0], operand, Collections.emptyList())));
            }
            if (AbstractElementTransformer.isBoxedIntType(operandType)) return this.buildAssignment(tempRet, this.numberConvert((IType)JavaTypes.pLONG(), primitiveType, this.callMethod(Number.class, "longValue", new Class[0], operand, Collections.emptyList())));
            if (operandType == JavaTypes.LONG()) {
                return this.buildAssignment(tempRet, this.numberConvert((IType)JavaTypes.pLONG(), primitiveType, this.callMethod(Number.class, "longValue", new Class[0], operand, Collections.emptyList())));
            }
            if (operandType == JavaTypes.FLOAT()) {
                return this.buildAssignment(tempRet, this.numberConvert((IType)JavaTypes.pFLOAT(), primitiveType, this.callMethod(Float.class, "floatValue", new Class[0], operand, Collections.emptyList())));
            }
            if (operandType != JavaTypes.DOUBLE()) throw new IllegalStateException("Unhandled type: " + operandType.getName());
            return this.buildAssignment(tempRet, this.numberConvert((IType)JavaTypes.pDOUBLE(), primitiveType, this.callMethod(Float.class, "doubleValue", new Class[0], operand, Collections.emptyList())));
        }
        if (!operandType.isPrimitive()) throw new IllegalStateException("Unhandled type: " + operandType.getName());
        return this.buildAssignment(tempRet, this.numberConvert(operandType, primitiveType, operand));
    }

    protected IRExpression numberConvert(IType from, IType to, IRExpression root) {
        if (from.equals(to)) {
            return root;
        }
        return new IRPrimitiveTypeConversion(root, AbstractElementTransformer.getDescriptor(from), AbstractElementTransformer.getDescriptor(to));
    }

    protected IRExpression numberConvert(IRType from, IRType to, IRExpression root) {
        if (from.equals(to)) {
            return root;
        }
        return new IRPrimitiveTypeConversion(root, from, to);
    }

    public static boolean isIntType(IType from) {
        return from == JavaTypes.pBYTE() || from == JavaTypes.pCHAR() || from == JavaTypes.pSHORT() || from == JavaTypes.pINT();
    }

    protected boolean isPrimitiveNumberType(IType type) {
        return type.isPrimitive() && BeanAccess.isNumericType(type);
    }

    public static boolean isBigType(IType type) {
        return type == JavaTypes.BIG_DECIMAL() || type == JavaTypes.BIG_INTEGER();
    }

    public static boolean isNonBigBoxedNumberType(IType type) {
        return type == JavaTypes.BYTE() || type == JavaTypes.CHARACTER() || type == JavaTypes.SHORT() || type == JavaTypes.INTEGER() || type == JavaTypes.LONG() || type == JavaTypes.FLOAT() || type == JavaTypes.DOUBLE();
    }

    public static boolean isBoxedIntType(IType type) {
        return type == JavaTypes.BYTE() || type == JavaTypes.CHARACTER() || type == JavaTypes.SHORT() || type == JavaTypes.INTEGER();
    }

    public static boolean isNumberType(IType type) {
        return type != JavaTypes.pBOOLEAN() && type != JavaTypes.BOOLEAN() && CommonServices.getCoercionManager().isPrimitiveOrBoxed(type);
    }

    protected ICompilableTypeInternal isMemberOnEnclosingType(IReducedSymbol symbol) {
        if (!this._cc().isNonStaticInnerClass()) {
            return null;
        }
        IType symbolClass = AbstractElementTransformer.maybeUnwrapProxy((IType)symbol.getGosuClass());
        if (this.getGosuClass().getAllTypesInHierarchy().contains(symbolClass)) {
            return null;
        }
        ICompilableTypeInternal enclosingClass = this._cc().getEnclosingType();
        if (!(TypeLord.getOuterMostEnclosingClass((IType)this._cc().getEnclosingType()) instanceof IGosuEnhancement) && symbolClass instanceof IGosuEnhancement) {
            symbolClass = ((IGosuEnhancement)symbolClass).getEnhancedType();
        }
        while (enclosingClass != null) {
            if (enclosingClass.getAllTypesInHierarchy().contains(symbolClass)) {
                return enclosingClass;
            }
            enclosingClass = enclosingClass.getEnclosingType();
        }
        return null;
    }

    protected boolean isMemberOnEnhancementOfEnclosingType(AbstractDynamicSymbol symbol) {
        if (!this._cc().isNonStaticInnerClass()) {
            return false;
        }
        IGosuClassInternal enhancement = symbol.getGosuClass();
        if (!(enhancement instanceof IGosuEnhancement)) {
            return false;
        }
        IType enhancedType = ((IGosuEnhancement)enhancement).getEnhancedType();
        if (this.getGosuClass().getAllTypesInHierarchy().contains(enhancedType)) {
            return false;
        }
        for (ICompilableTypeInternal enclosingClass = this._cc().getEnclosingType(); enclosingClass != null; enclosingClass = enclosingClass.getEnclosingType()) {
            if (!enclosingClass.getAllTypesInHierarchy().contains(enhancedType)) continue;
            return true;
        }
        return false;
    }

    private static IType maybeUnwrapProxy(IType type) {
        if (type != null && type.isParameterizedType()) {
            type = type.getGenericType();
        }
        return type == null ? null : IGosuClass.ProxyUtil.getProxiedType((IType)type);
    }

    protected IRExpression pushThis() {
        String symbolName = this.isCompilingEnhancement() ? ENHANCEMENT_THIS_REF : Keyword.KW_this.getName();
        return this.identifier(this._cc.getSymbol(symbolName));
    }

    protected IRExpression pushThisOrOuter(IType currentType) {
        if (currentType.isAssignableFrom((IType)this.getGosuClass())) {
            return this.pushThis();
        }
        if (currentType instanceof IGosuEnhancement && currentType.isAssignableFrom(((IGosuEnhancement)currentType).getEnhancedType())) {
            return this.pushThis();
        }
        return this.pushOuter(currentType);
    }

    protected IRExpression pushOuter() {
        if (this._cc().getCurrentFunction() != null && this._cc().getCurrentFunction().isConstructor()) {
            return this.identifier(this._cc().getSymbol(this._cc().getOuterThisParamName()));
        }
        return this.getInstanceField((IType)this.getGosuClass(), this._cc().getOuterThisFieldName(), AbstractElementTransformer.getDescriptor(AbstractElementTransformer.getRuntimeEnclosingType((IType)this.getGosuClass())), AccessibilityUtil.forOuter(), this.pushThis());
    }

    protected IRExpression pushOuter(IType outerTarget) {
        return this.pushOuter(AbstractElementTransformer.maybeUnwrapProxy(outerTarget), AbstractElementTransformer.maybeUnwrapProxy((IType)this._cc().getEnclosingType()), this.pushOuter());
    }

    protected IRExpression pushOuter(IType outerTarget, IType currentOuter, IRExpression root) {
        IRExpression result = root;
        while (!outerTarget.isAssignableFrom(currentOuter)) {
            IRMethod irMethod = IRMethodFactory.createIRMethod(currentOuter, OUTER_ACCESS, AbstractElementTransformer.getRuntimeEnclosingType(currentOuter), new IType[]{currentOuter}, AccessibilityUtil.forOuter(), true);
            result = this.callMethod(irMethod, null, Collections.singletonList(result));
            currentOuter = AbstractElementTransformer.maybeUnwrapProxy(currentOuter.getEnclosingType());
        }
        return result;
    }

    protected IRExpression getInstanceField(IType owner, String strField, IRType fieldType, IRelativeTypeInfo.Accessibility accessibility, IRExpression root) {
        return this.getField(owner, strField, fieldType, accessibility, root);
    }

    protected IRExpression getStaticField(IType owner, String strField, IRType fieldType, IRelativeTypeInfo.Accessibility accessibility) {
        return this.getField(owner, strField, fieldType, accessibility, null);
    }

    protected IRExpression getField(IRProperty field, IRExpression root) {
        return this.getField(field.getOwningIType(), field.getName(), field.getType(), field.getAccessibility(), root);
    }

    protected IRStatement setField(IRProperty field, IRExpression root, IRExpression value) {
        return this.setField(field.getOwningIType(), field.getName(), field.getType(), field.getAccessibility(), root, value);
    }

    protected IRStatement setInstanceField(IType owner, String strField, IRType fieldType, IRelativeTypeInfo.Accessibility accessibility, IRExpression root, IRExpression value) {
        return this.setField(owner, strField, fieldType, accessibility, root, value);
    }

    protected IRStatement setStaticField(IType owner, String strField, IRType fieldType, IRelativeTypeInfo.Accessibility accessibility, IRExpression value) {
        return this.setField(owner, strField, fieldType, accessibility, null, value);
    }

    private IRExpression getField(IType owner, String strField, IRType fieldType, IRelativeTypeInfo.Accessibility accessibility, IRExpression root) {
        IRType rootType;
        IRType iRType = rootType = root == null ? null : root.getType();
        if (rootType == null) {
            rootType = AbstractElementTransformer.getDescriptor(owner);
        }
        if (this._cc().shouldUseReflection(owner, rootType, accessibility)) {
            return this.getFieldReflectively(owner, strField, fieldType, root);
        }
        return this.buildFieldGet(AbstractElementTransformer.getDescriptor(owner), strField, fieldType, root);
    }

    protected boolean avoidVerifyError(IType owner, IRType rootType, IRelativeTypeInfo.Accessibility accessibility) {
        return this._cc().isIllegalProtectedCall(owner, rootType, accessibility) || AccessibilityUtil.forType(owner) == IRelativeTypeInfo.Accessibility.INTERNAL;
    }

    private IRExpression getFieldReflectively(IType owner, String strField, IRType fieldType, IRExpression root) {
        IRMethodCallExpression getDeclaredFieldCall = this.buildMethodCall(AbstractElementTransformer.class, "getDeclaredField", Field.class, new Class[]{Class.class, String.class}, null, AbstractElementTransformer.exprList(this.classLiteral(AbstractElementTransformer.getDescriptor(owner)), this.stringLiteral(strField)));
        IRMethodCallExpression getCall = this.buildMethodCall(Field.class, "get", Object.class, new Class[]{Object.class}, (IRExpression)getDeclaredFieldCall, AbstractElementTransformer.exprList(root == null ? this.pushNull() : root));
        return this.unboxValueToType(fieldType, (IRExpression)getCall);
    }

    protected IRStatement setField(IType owner, String strField, IRType fieldType, IRelativeTypeInfo.Accessibility accessibility, IRExpression root, IRExpression value) {
        IRType rootType;
        IRType iRType = rootType = root == null ? null : root.getType();
        if (rootType == null) {
            rootType = AbstractElementTransformer.getDescriptor(owner);
        }
        if (this._cc().shouldUseReflection(owner, rootType, accessibility)) {
            return this.setFieldReflectively(owner, strField, root, value);
        }
        return this.buildFieldSet(AbstractElementTransformer.getDescriptor(owner), strField, fieldType, root, value);
    }

    private IRStatement setFieldReflectively(IType owner, String strField, IRExpression root, IRExpression value) {
        IRMethodCallExpression getDeclaredFieldCall = this.buildMethodCall(AbstractElementTransformer.class, "getDeclaredField", Field.class, new Class[]{Class.class, String.class}, null, AbstractElementTransformer.exprList(this.classLiteral(AbstractElementTransformer.getDescriptor(owner)), this.stringLiteral(strField)));
        IRMethodCallExpression setCall = this.buildMethodCall(Field.class, "set", Void.TYPE, new Class[]{Object.class, Object.class}, (IRExpression)getDeclaredFieldCall, AbstractElementTransformer.exprList(root == null ? this.pushNull() : root, this.boxValue(value.getType(), value)));
        return new IRMethodCallStatement((IRExpression)setCall);
    }

    protected static boolean isEvalProgram(IGosuClassInternal gsClass) {
        return gsClass instanceof IGosuProgram && gsClass.isAnonymous();
    }

    public static Field getDeclaredField(Class cls, String strName) {
        Field f = AbstractElementTransformer.getDeclaredFieldImpl(cls, strName);
        if (f == null) {
            throw new IllegalStateException("Failed to find field: " + strName + " starting from class " + cls);
        }
        return f;
    }

    public static Field getDeclaredFieldImpl(Class cls, String strName) {
        if (cls == null) {
            return null;
        }
        for (Field f : cls.getDeclaredFields()) {
            if (!f.getName().equals(strName)) continue;
            f.setAccessible(true);
            return f;
        }
        Field f = AbstractElementTransformer.getDeclaredFieldImpl(cls.getSuperclass(), strName);
        if (f != null) {
            return f;
        }
        for (Class<?> iface : cls.getInterfaces()) {
            f = AbstractElementTransformer.getDeclaredFieldImpl(iface, strName);
            if (f == null) continue;
            return f;
        }
        return null;
    }

    public static Method getDeclaredMethod(Class cls, String strName, Class ... params) {
        Method m = AbstractElementTransformer.getDeclaredMethodImpl(cls, strName, params);
        if (m == null) {
            throw new IllegalStateException("Failed to find method: " + strName + "(" + Arrays.asList(params) + ") starting from class " + cls);
        }
        return m;
    }

    public static IJavaClassMethod getDeclaredMethod(IJavaClassInfo cls, String strName, Class ... params) {
        IJavaClassMethod m = AbstractElementTransformer.getDeclaredMethodImpl(cls, strName, params);
        if (m == null) {
            throw new IllegalStateException("Failed to find method: " + strName + "(" + Arrays.asList(params) + ") starting from class " + cls);
        }
        return m;
    }

    private static Method getDeclaredMethodImpl(Class cls, String strName, Class ... params) {
        if (cls == null) {
            return null;
        }
        for (Method m : NewIntrospector.getDeclaredMethods(cls)) {
            Class<?>[] mParams;
            if (!m.getName().equals(strName) || (mParams = m.getParameterTypes()).length != params.length) continue;
            boolean bFound = true;
            for (int i = 0; i < mParams.length; ++i) {
                if (mParams[i].getName().equals(params[i].getName())) continue;
                bFound = false;
                break;
            }
            if (!bFound) continue;
            m.setAccessible(true);
            return m;
        }
        Method m = AbstractElementTransformer.getDeclaredMethodImpl(cls.getSuperclass(), strName, params);
        if (m != null) {
            return m;
        }
        for (Class<?> iface : cls.getInterfaces()) {
            m = AbstractElementTransformer.getDeclaredMethodImpl(iface, strName, params);
            if (m == null) continue;
            return m;
        }
        return null;
    }

    private static IJavaClassMethod getDeclaredMethodImpl(IJavaClassInfo cls, String strName, Class ... params) {
        if (cls == null) {
            return null;
        }
        for (IJavaClassMethod m : cls.getDeclaredMethods()) {
            IJavaClassInfo[] mParams;
            if (!m.getName().equals(strName) || (mParams = m.getParameterTypes()).length != params.length) continue;
            boolean bFound = true;
            for (int i = 0; i < mParams.length; ++i) {
                if (mParams[i].getName().equals(params[i].getName())) continue;
                bFound = false;
                break;
            }
            if (!bFound) continue;
            return m;
        }
        IJavaClassMethod m = AbstractElementTransformer.getDeclaredMethodImpl(cls.getSuperclass(), strName, params);
        if (m != null) {
            return m;
        }
        for (IJavaClassInfo iface : cls.getInterfaces()) {
            m = AbstractElementTransformer.getDeclaredMethodImpl(iface, strName, params);
            if (m == null) continue;
            return m;
        }
        return null;
    }

    protected IRExpression newArray(IRType atomicType, IRExpression sizeExpression) {
        return new IRNewArrayExpression(atomicType, sizeExpression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRExpression makeArrayViaTypeInfo(IType atomicType, List<Expression> valueExpressions) {
        this._cc().pushScope(false);
        try {
            this.pushType(atomicType);
            this.pushConstant(valueExpressions.size());
            IRExpression arrayCreation = this.callMethod(IType.class, "makeArrayInstance", new Class[]{Integer.TYPE}, this.pushType(atomicType), AbstractElementTransformer.exprList(this.pushConstant(valueExpressions.size())));
            if (valueExpressions.isEmpty()) {
                IRExpression iRExpression = this.checkCast(atomicType.getArrayType(), arrayCreation);
                return iRExpression;
            }
            IRSymbol temp = this._cc().makeAndIndexTempSymbol(IRTypeConstants.OBJECT());
            ArrayList<Object> statements = new ArrayList<Object>();
            statements.add(this.buildAssignment(temp, arrayCreation));
            for (int i = 0; i < valueExpressions.size(); ++i) {
                Expression expression = valueExpressions.get(i);
                IRExpression call = this.callMethod(IType.class, "setArrayComponent", new Class[]{Object.class, Integer.TYPE, Object.class}, this.pushType(atomicType), AbstractElementTransformer.exprList(new IRExpression[]{this.identifier(temp), this.numericLiteral(i), this.boxValue(expression.getType(), ExpressionTransformer.compile(expression, this._cc()))}));
                statements.add(new IRMethodCallStatement(call));
            }
            statements.add(this.checkCast(atomicType.getArrayType(), (IRExpression)this.identifier(temp)));
            IRCompositeExpression iRCompositeExpression = new IRCompositeExpression(statements);
            return iRCompositeExpression;
        }
        finally {
            this._cc().popScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRExpression makeEmptyArrayViaTypeInfo(IType atomicType, List<Expression> sizeExpressions) {
        this._cc().pushScope(false);
        try {
            IRExpression arrayCreation = this.callMethod(IType.class, "makeArrayInstance", new Class[]{Integer.TYPE}, this.pushType(atomicType), AbstractElementTransformer.exprList(ExpressionTransformer.compile(sizeExpressions.get(0), this._cc())));
            ArrayList<IRExpression> sizes = new ArrayList<IRExpression>();
            sizes.add(this.numericLiteral(0));
            for (int i = 1; i < sizeExpressions.size(); ++i) {
                sizes.add(ExpressionTransformer.compile(sizeExpressions.get(i), this._cc()));
            }
            IRExpression sizeArrays = this.buildInitializedArray(IRTypeConstants.pINT(), sizes);
            IRExpression initCall = this.callStaticMethod(this.getClass(), "initMultiArray", new Class[]{IType.class, Object.class, Integer.TYPE, int[].class}, AbstractElementTransformer.exprList(this.pushType(atomicType), arrayCreation, this.numericLiteral(1), sizeArrays));
            IRExpression iRExpression = this.checkCast(atomicType.getArrayType(), initCall);
            return iRExpression;
        }
        finally {
            this._cc().popScope();
        }
    }

    public static Object initMultiArray(IType componentType, Object instance, int iDimension, int[] sizes) {
        if (sizes.length <= iDimension) {
            return instance;
        }
        int iLength = componentType.getArrayLength(instance);
        componentType = componentType.getComponentType();
        for (int i = 0; i < iLength; ++i) {
            Object component = componentType.makeArrayInstance(sizes[iDimension]);
            AbstractElementTransformer.initMultiArray(componentType, component, iDimension + 1, sizes);
            componentType.setArrayComponent(instance, i, component);
        }
        return instance;
    }

    public IRExpression pushRuntimeTypeOfTypeVar(IType type) {
        IType rtType = type;
        if (rtType instanceof TypeVariableType) {
            return this.buildCast(AbstractElementTransformer.getDescriptor(IType.class), (IRExpression)this.buildMethodCall(LazyTypeResolver.class, "get", Object.class, new Class[0], this.getRuntimeTypeParameter((TypeVariableType)rtType), Collections.emptyList()));
        }
        if (rtType instanceof TypeVariableArrayType) {
            StringBuilder brackets = new StringBuilder();
            while (rtType.isArray()) {
                brackets.append('[');
                brackets.append(']');
                rtType = rtType.getComponentType();
            }
            IRExpression typeNameExpression = this.callMethod(String.class, "concat", new Class[]{String.class}, this.callMethod(IType.class, "getName", new Class[0], this.pushRuntimeTypeOfTypeVar(rtType), Collections.emptyList()), Collections.singletonList(this.pushConstant(brackets.toString())));
            return this.callStaticMethod(TypeSystem.class, "getByFullName", new Class[]{String.class}, Collections.singletonList(typeNameExpression));
        }
        throw new IllegalArgumentException("Only type variable types allowed in this method");
    }

    private IRExpression getRuntimeTypeParameter(TypeVariableType type) {
        IType enclosingType;
        int i;
        IFunctionType funcType;
        IRSymbol iTypeParamSymbol = this._cc().getTypeParamIndex(type);
        if (iTypeParamSymbol != null) {
            return this.identifier(iTypeParamSymbol);
        }
        if (type.isFunctionStatement() && this.equivalentTypes((funcType = (IFunctionType)type.getEnclosingType()).getScriptPart().getContainingType(), (IType)this.getGosuClass())) {
            IGenericTypeVariable[] genTypeVars = funcType.getGenericTypeVariables();
            for (i = 0; i < genTypeVars.length; ++i) {
                IGenericTypeVariable gv = genTypeVars[i];
                if (!gv.getName().equals(type.getName())) continue;
                return this.identifier(this._cc().getSymbol(this.getTypeVarParamName(gv)));
            }
        }
        if ((enclosingType = type.getEnclosingType()) instanceof IGosuEnhancement && this.equivalentTypes(enclosingType, (IType)this._cc().getGosuClass())) {
            IGenericTypeVariable[] typeVariables = enclosingType.getGenericTypeVariables();
            for (i = 0; i < typeVariables.length; ++i) {
                ITypeVariableType variableType = typeVariables[i].getTypeVariableDefinition().getType();
                if (!type.equals(variableType)) continue;
                return this.identifier(this._cc().getSymbol(this.getTypeVarParamName(typeVariables[i])));
            }
        }
        int i2 = 0;
        String strTypeVarField = TYPE_PARAM_PREFIX + type.getRelativeName();
        for (ITypeVariableType gv : this.getGosuClass().getGenericTypeVariables()) {
            if (gv.getName().equals(type.getName())) {
                if (this.getGosuClass().isInterface()) {
                    IRExpression typeExpr = this.callMethod(GosuRuntimeMethods.class, "getTypeForTypeVar", new Class[]{Object.class, IType.class, Integer.TYPE}, null, AbstractElementTransformer.exprList(this.pushThis(), this.pushType((IType)this.getGosuClass()), this.pushConstant(i2)));
                    return this.buildNewExpression(NotLazyTypeResolver.class, new Class[]{IType.class}, Collections.singletonList(typeExpr));
                }
                return this.getInstanceField((IType)this.getGosuClass(), strTypeVarField, AbstractElementTransformer.getDescriptor(LazyTypeResolver.class), AccessibilityUtil.forTypeParameter(), this.pushThis());
            }
            ++i2;
        }
        IRExpression fromEnclosingFunction = this.maybeGetFromEnclosingFunction(this.getGosuClass(), type, strTypeVarField);
        if (fromEnclosingFunction != null) {
            return fromEnclosingFunction;
        }
        for (ICompilableTypeInternal gsClass = this.getGosuClass().getEnclosingType(); gsClass != null; gsClass = gsClass.getEnclosingType()) {
            i2 = 0;
            for (IGenericTypeVariable gv : gsClass.getGenericTypeVariables()) {
                if (gv.getName().equals(type.getName())) {
                    if (gsClass.isInterface()) {
                        IRExpression typeExpr = this.callMethod(GosuRuntimeMethods.class, "getTypeForTypeVar", new Class[]{Object.class, IType.class, Integer.TYPE}, null, AbstractElementTransformer.exprList(this.pushThis(), this.pushType((IType)gsClass), this.pushConstant(i2)));
                        return this.buildNewExpression(NotLazyTypeResolver.class, new Class[]{IType.class}, Collections.singletonList(typeExpr));
                    }
                    return this.getInstanceField((IType)gsClass, strTypeVarField, AbstractElementTransformer.getDescriptor(LazyTypeResolver.class), AccessibilityUtil.forTypeParameter(), this.pushOuter((IType)gsClass));
                }
                ++i2;
            }
            fromEnclosingFunction = this.maybeGetFromEnclosingFunction(gsClass, type, strTypeVarField);
            if (fromEnclosingFunction == null) continue;
            return fromEnclosingFunction;
        }
        IType boundingType = type.getBoundingType();
        if (boundingType instanceof TypeVariableType) {
            return this.getRuntimeTypeParameter((TypeVariableType)boundingType);
        }
        return this.pushLazyTypeByFqn(boundingType);
    }

    private IRExpression pushLazyTypeByFqn(IType boundingType) {
        boundingType = TypeLord.getPureGenericType(boundingType);
        IModule module = this.getModule(boundingType);
        return this.buildNewExpression(SimpleTypeLazyTypeResolver.class, new Class[]{String.class, String.class}, Arrays.asList(this.pushConstant(boundingType.getName()), module == null ? this.pushNull() : this.pushConstant(module.getName())));
    }

    private boolean equivalentTypes(IType type1, IType type2) {
        return TypeLord.getPureGenericType(type1) == TypeLord.getPureGenericType(type2);
    }

    private IRExpression maybeGetFromEnclosingFunction(ICompilableType gsClass, TypeVariableType type, String strTypeVarField) {
        IDynamicFunctionSymbol dfs;
        if (gsClass.isAnonymous() && (dfs = AbstractElementTransformer.getEnclosingDFS(gsClass)) != null && dfs != AbstractElementTransformer.getEnclosingDFS(gsClass.getEnclosingType())) {
            for (IGenericTypeVariable gv : AbstractElementTransformer.getTypeVarsForDFS(dfs)) {
                if (!gv.getName().equals(type.getName())) continue;
                return this.getInstanceField((IType)gsClass, strTypeVarField, AbstractElementTransformer.getDescriptor(LazyTypeResolver.class), AccessibilityUtil.forTypeParameter(), this.pushThisOrOuter((IType)gsClass));
            }
        }
        return null;
    }

    public static IDynamicFunctionSymbol getEnclosingDFS(ICompilableType gsClass) {
        Object pe = gsClass instanceof IGosuProgram ? ((IGosuProgram)gsClass).getEnclosingEvalExpression() : (gsClass instanceof IBlockClass ? ((IBlockClass)gsClass).getBlock() : gsClass.getClassStatement());
        if (pe == null || pe.getLocation() == null || pe.getLocation().getEnclosingFunctionStatement() == null) {
            return null;
        }
        return pe.getLocation().getEnclosingFunctionStatement().getDynamicFunctionSymbol();
    }

    public static List<IGenericTypeVariable> getTypeVarsForDFS(IDynamicFunctionSymbol dfs) {
        IType declaringType;
        ArrayList<IGenericTypeVariable> typeVars = new ArrayList<IGenericTypeVariable>();
        if (!dfs.isStatic() && AbstractElementTransformer.isEnhancementType((IType)dfs.getGosuClass())) {
            typeVars.addAll(Arrays.asList(AbstractElementTransformer.getTypeVarsForEnhancement(dfs)));
        }
        if (dfs.getType().isGenericType()) {
            typeVars.addAll(Arrays.asList(dfs.getType().getGenericTypeVariables()));
        } else if (dfs.isConstructor() && (declaringType = TypeLord.getPureGenericType(dfs.getDeclaringTypeInfo().getOwnersType())).isGenericType()) {
            typeVars.addAll(Arrays.asList(declaringType.getGenericTypeVariables()));
        }
        return typeVars;
    }

    private static IGenericTypeVariable[] getTypeVarsForEnhancement(IDynamicFunctionSymbol dfs) {
        IGosuClass aClass = dfs.getGosuClass();
        if (aClass.isParameterizedType()) {
            aClass = (IGosuClass)aClass.getGenericType();
        }
        return aClass.getGenericTypeVariables();
    }

    protected IRType[] getConstructorParamTypes(IType[] declaredParams, int iTypeParams, IType type) {
        Map<String, ICapturedSymbol> capturedSymbols;
        ArrayList<IRType> params = new ArrayList<IRType>();
        if (AbstractElementTransformer.isNonStaticInnerClass(type)) {
            params.add(AbstractElementTransformer.getDescriptor(AbstractElementTransformer.getRuntimeEnclosingType(type)));
        }
        if (type instanceof IGosuClassInternal && type.isValid() && (capturedSymbols = ((IGosuClassInternal)type).getCapturedSymbols()) != null) {
            for (ICapturedSymbol sym : capturedSymbols.values()) {
                params.add(AbstractElementTransformer.getDescriptor(sym.getType().getArrayType()));
            }
        }
        if (AbstractElementTransformer.requiresExternalSymbolCapture(type)) {
            params.add(AbstractElementTransformer.getDescriptor(IExternalSymbolMap.class));
        }
        if (iTypeParams > 0) {
            for (int i = 0; i < iTypeParams; ++i) {
                params.add(AbstractElementTransformer.getDescriptor(LazyTypeResolver.class));
            }
        }
        if (type.isEnum()) {
            params.add(IRTypeConstants.STRING());
            params.add(IRTypeConstants.pINT());
        }
        for (IType declaredParam : declaredParams) {
            params.add(AbstractElementTransformer.getDescriptor(declaredParam));
        }
        return params.toArray(new IRType[params.size()]);
    }

    protected int pushTypeParametersForConstructor(IExpression expr, IType type, List<IRExpression> args, boolean bSuperCall) {
        if (!(type instanceof IGosuClassInternal)) {
            return 0;
        }
        int iCount = 0;
        if (type.isParameterizedType()) {
            for (IType typeParam : type.getTypeParameters()) {
                args.add(bSuperCall ? this.pushLazyType(typeParam, TypeLord.getPureGenericType(this.getGosuClass()).getGenericTypeVariables()) : this.pushLazyType(typeParam));
                ++iCount;
            }
        } else if (type.isGenericType()) {
            for (IGenericTypeVariable typeVariable : type.getGenericTypeVariables()) {
                args.add((IRExpression)this.identifier(new IRSymbol(this.getTypeVarParamName(typeVariable), AbstractElementTransformer.getDescriptor(LazyTypeResolver.class), false)));
                ++iCount;
            }
        }
        iCount = this.pushEnclosingFunctionTypeParams((IParsedElement)expr, type, iCount, args);
        return iCount;
    }

    protected void pushEnumSuperConstructorArguments(List<IRExpression> args) {
        if (this._cc().compilingEnum()) {
            args.add((IRExpression)this.identifier(this._cc().getSymbol("enum$name")));
            args.add((IRExpression)this.identifier(this._cc().getSymbol("enum$ordinal")));
        }
    }

    private int pushEnclosingFunctionTypeParams(IParsedElement pe, IType type, int iCount, List<IRExpression> args) {
        ICompilableTypeInternal gsClass = (ICompilableTypeInternal)type;
        while (gsClass.isAnonymous()) {
            IFunctionStatement funcStmt;
            if (pe != null && pe.getLocation() != null && (funcStmt = pe.getLocation().getEnclosingFunctionStatement()) != null) {
                IDynamicFunctionSymbol dfs = funcStmt.getDynamicFunctionSymbol();
                List<IGenericTypeVariable> genTypeVars = AbstractElementTransformer.getTypeVarsForDFS(dfs);
                while (AbstractElementTransformer.getEnclosingDFS(gsClass.getEnclosingType()) == dfs) {
                    gsClass = gsClass.getEnclosingType();
                }
                for (int i = 0; i < genTypeVars.size(); ++i) {
                    if (gsClass == type) {
                        args.add((IRExpression)this.identifier(this._cc().getSymbol(this.getTypeVarParamName(genTypeVars.get(i)))));
                    } else {
                        args.add(this.getInstanceField((IType)gsClass, TYPE_PARAM_PREFIX + genTypeVars.get(i).getName(), AbstractElementTransformer.getDescriptor(LazyTypeResolver.class), AccessibilityUtil.forTypeParameter(), this.pushThisOrOuter((IType)gsClass)));
                    }
                    ++iCount;
                }
            }
            if (!(gsClass = gsClass.getEnclosingType()).isAnonymous()) continue;
            pe = gsClass instanceof IGosuProgram ? ((IGosuProgram)gsClass).getEnclosingEvalExpression() : gsClass.getClassStatement();
        }
        return iCount;
    }

    protected IRAssignmentStatement initLocalVarWithDefault(Symbol varSym) {
        return this.initLocalVar(varSym, this.getDefaultConstIns(varSym.getType()));
    }

    protected IRAssignmentStatement initLocalVar(Symbol varSym, IRExpression initialValue) {
        IRSymbol symbol = this.makeIRSymbol(varSym);
        IRExpression actualValue = varSym.isValueBoxed() ? this.buildInitializedArray(symbol.getType().getComponentType(), AbstractElementTransformer.exprList(initialValue)) : initialValue;
        return this.buildAssignment(symbol, actualValue);
    }

    protected IRSymbol makeIRSymbol(Symbol varSym) {
        IType type = varSym.getType();
        if (varSym.isValueBoxed()) {
            type = type.getArrayType();
        }
        IRSymbol symbol = new IRSymbol(varSym.getName(), AbstractElementTransformer.getDescriptor(type), varSym.getName().startsWith("*temp"));
        this._cc().putSymbol(symbol);
        return symbol;
    }

    protected void pushCapturedSymbols(IType type, List<IRExpression> args, boolean ignoreExternalSymbols) {
        Map<String, ICapturedSymbol> capturedSymbols;
        if (type instanceof IGosuClassInternal && type.isValid() && (capturedSymbols = ((IGosuClassInternal)type).getCapturedSymbols()) != null) {
            for (ICapturedSymbol sym : capturedSymbols.values()) {
                if (this.isCapturedOnEnclosingAnonymousClass(sym, (IGosuClassInternal)type)) {
                    args.add(this.getInstanceField((IType)this.getGosuClass(), CAPTURED_VAR_PREFIX + sym.getName(), AbstractElementTransformer.getDescriptor(sym.getType().getArrayType()), AccessibilityUtil.forSymbol((IReducedSymbol)sym), this.pushThis()));
                    continue;
                }
                args.add((IRExpression)this.identifier(this._cc().getSymbol(sym.getName())));
            }
        }
        if (!ignoreExternalSymbols && AbstractElementTransformer.requiresExternalSymbolCapture(type)) {
            args.add(this.pushExternalSymbolsMap());
        }
    }

    private boolean isCapturedOnEnclosingAnonymousClass(ICapturedSymbol sym, IGosuClassInternal gsClass) {
        ICompilableTypeInternal enclosingType = gsClass.getEnclosingType();
        if (enclosingType.isAnonymous()) {
            return enclosingType.getCapturedSymbols().containsKey(sym.getName());
        }
        return false;
    }

    public IRExpression collectArgsIntoObjArray(List<IRExpression> args) {
        ArrayList<IRExpression> values = new ArrayList<IRExpression>();
        if (args != null) {
            for (IRExpression arg : args) {
                if (arg.getType().isPrimitive()) {
                    arg = this.boxValue(arg.getType(), arg);
                }
                values.add(arg);
            }
        }
        return this.buildInitializedArray(IRTypeConstants.OBJECT(), values);
    }

    protected IGosuVarPropertyInfo getActualPropertyInfo(IPropertyInfo pi) {
        if (pi instanceof PropertyInfoDelegate) {
            pi = ((PropertyInfoDelegate)pi).getDelegatePI();
        }
        return (IGosuVarPropertyInfo)pi;
    }

    protected IRExpression castResultingTypeIfNecessary(IRType expectedType, IRType actualReturnType, IRExpression root) {
        if (!(expectedType.isVoid() || expectedType.isPrimitive() || expectedType.isAssignableFrom(actualReturnType))) {
            return this.buildCast(expectedType, root);
        }
        return root;
    }

    public static IType getRuntimeEnclosingType(IType type) {
        IType enclosingType = AbstractElementTransformer.maybeUnwrapProxy(type.getEnclosingType());
        if (enclosingType instanceof IGosuEnhancement) {
            IGosuEnhancement enhancement = (IGosuEnhancement)enclosingType;
            enclosingType = enhancement.getEnhancedType();
        }
        return enclosingType;
    }

    public IType maybeUnwrapMetaType(IType rootType) {
        if (rootType instanceof IMetaType) {
            rootType = ((IMetaType)rootType).getType();
        }
        return rootType;
    }

    @Deprecated
    protected IRExpression classLiteral(Class value) {
        return this.classLiteral(AbstractElementTransformer.getDescriptor(value));
    }

    protected IRExpression classLiteral(IJavaClassInfo value) {
        return this.classLiteral(JavaClassIRType.get(value));
    }

    protected IRExpression classLiteral(IRType value) {
        IType type;
        if (value instanceof JavaClassIRType) {
            type = ((JavaClassIRType)value).getType();
        } else if (value instanceof GosuClassIRType) {
            type = ((GosuClassIRType)value).getType();
        } else {
            throw new RuntimeException("Unsupported IRType " + value.getClass());
        }
        return this.pushClassLiteral(value, type);
    }

    private IRExpression pushClassLiteral(IRType value, IType type) {
        if (type != null && RequiresReflectionDeterminer.shouldUseReflection(type, this._cc.getGosuClass(), null, IRelativeTypeInfo.Accessibility.PUBLIC)) {
            return this.callMethod(GosuRuntimeMethods.class, "lookUpClass", new Class[]{String.class}, null, AbstractElementTransformer.exprList(this.stringLiteral(value.getDescriptor())));
        }
        return new IRClassLiteral(value);
    }

    public static ICustomExpressionRuntime getCustomRuntime(String id, IType enclosingClass) {
        ICustomExpressionRuntime runtime = CUSTOM_RUNTIMES.get(id);
        if (runtime == null && enclosingClass instanceof ICompilableType) {
            ((ICompilableType)enclosingClass).compile();
            runtime = CUSTOM_RUNTIMES.get(id);
        }
        return runtime;
    }

    protected IRExpression handleCustomExpressionRuntime(ICustomExpressionRuntime customRuntime, IType expectedType) {
        int iLine = this.getParsedElement().getLineNum();
        int iColumnNum = this.getParsedElement().getColumn();
        String customRuntimeId = AbstractElementTransformer.makeCustomRuntimeKey((IType)this.getGosuClass(), iLine, iColumnNum);
        CUSTOM_RUNTIMES.put(customRuntimeId, customRuntime);
        IRExpression getCustomExpression = this.callMethod(AbstractElementTransformer.class, "getCustomRuntime", new Class[]{String.class, IType.class}, null, AbstractElementTransformer.exprList(this.pushConstant(customRuntimeId), this.pushType((IType)this.getGosuClass())));
        IRExpression result = this.callMethod(ICustomExpressionRuntime.class, "evaluate", new Class[0], getCustomExpression, AbstractElementTransformer.exprList(new IRExpression[0]));
        return this.unboxValueToType(expectedType, result);
    }

    private static String makeCustomRuntimeKey(IType enclosingClass, int iLineNum, int iColumnNum) {
        return enclosingClass.getName() + '.' + "__Program__" + "customRuntime_" + iLineNum + ":" + iColumnNum;
    }

    protected IRExpression pushExternalSymbolsMap() {
        if (this._cc().hasSymbol("$symbols$arg")) {
            return this.identifier(this._cc().getSymbol("$symbols$arg"));
        }
        if (AbstractElementTransformer.requiresExternalSymbolCapture((IType)this._cc().getGosuClass()) && !this.inStaticContext()) {
            return this.buildFieldGet(this._cc().getIRTypeForCurrentClass(), "$symbols$", AbstractElementTransformer.getDescriptor(IExternalSymbolMap.class), this.pushThis());
        }
        if (this._cc().hasSymbol("$symbols$")) {
            return this.identifier(this._cc().getSymbol("$symbols$"));
        }
        return this.pushNull();
    }

    public static boolean requiresExternalSymbolCapture(IType type) {
        IType enclosingType = type.getEnclosingType();
        if (enclosingType == null) {
            return false;
        }
        if (type instanceof IGosuClass && !(type instanceof IBlockClass) && ((IGosuClass)type).getSourceFileHandle() instanceof StringSourceFileHandle && type.getRelativeName().startsWith("ProxyFor_")) {
            return false;
        }
        if (enclosingType instanceof GosuFragment || enclosingType instanceof IGosuProgram) {
            return true;
        }
        return AbstractElementTransformer.requiresExternalSymbolCapture(enclosingType);
    }

    protected IRMethodCallExpression buildMethodCall(IRType ownersType, String name, boolean isInterface, IRType returnType, List<IRType> paramTypes, IRExpression root, List<IRExpression> args) {
        return new IRMethodCallExpression(name, ownersType, isInterface, returnType, paramTypes, root, args);
    }

    protected IRMethodCallExpression buildMethodCall(Class ownersType, String name, Class returnType, Class[] paramTypes, IRExpression root, List<IRExpression> args) {
        return new IRMethodCallExpression(name, AbstractElementTransformer.getDescriptor(ownersType), ownersType.isInterface(), AbstractElementTransformer.getDescriptor(returnType), AbstractElementTransformer.getIRTypes(paramTypes), root, args);
    }

    protected IRExpression buildCast(IRType castType, IRExpression expression) {
        if (castType.isPrimitive() && expression.getType().equals(JavaClassIRType.get(Object.class))) {
            return this.unboxValueToType(castType, expression);
        }
        return new IRCastExpression(expression, castType);
    }

    protected IRExpression numericLiteral(Number value) {
        return new IRNumericLiteral(value);
    }

    protected IRExpression charLiteral(char c) {
        return new IRCharacterLiteral(c);
    }

    protected IRExpression booleanLiteral(boolean value) {
        return new IRBooleanLiteral(value);
    }

    protected IRExpression nullLiteral() {
        return new IRNullLiteral();
    }

    protected IRExpression stringLiteral(String value) {
        return new IRStringLiteralExpression(value);
    }

    protected IRExpression buildArrayLoad(IRExpression root, int index, IRType componentType) {
        return new IRArrayLoadExpression(root, this.numericLiteral(index), componentType);
    }

    protected IRExpression buildArrayLoad(IRExpression root, IRExpression index, IRType componentType) {
        return new IRArrayLoadExpression(root, index, componentType);
    }

    protected IRExpression buildFieldGet(IRType owner, String fieldName, IRType fieldType, IRExpression root) {
        return new IRFieldGetExpression(root, fieldName, fieldType, owner);
    }

    protected IRStatement buildFieldSet(IRType owner, String fieldName, IRType fieldType, IRExpression root, IRExpression value) {
        return new IRFieldSetStatement(root, value, fieldName, fieldType, owner);
    }

    protected IRAssignmentStatement buildAssignment(IRSymbol symbol, IRExpression value) {
        return new IRAssignmentStatement(symbol, value);
    }

    protected IRIdentifier identifier(IRSymbol symbol) {
        return new IRIdentifier(symbol);
    }

    protected IRStatement buildArrayStore(IRExpression lhs, IRExpression index, IRExpression value, IRType componentType) {
        return new IRArrayStoreStatement(lhs, index, value, componentType);
    }

    protected IRExpression buildInitializedArray(IRType componentType, List<IRExpression> values) {
        componentType = IRElement.maybeEraseStructuralType((IRType)componentType);
        ArrayList<Object> elements = new ArrayList<Object>();
        IRSymbol tempArray = this._cc.makeAndIndexTempSymbol(componentType.getArrayType());
        elements.add(this.buildAssignment(tempArray, this.newArray(componentType, this.numericLiteral(values.size()))));
        for (int i = 0; i < values.size(); ++i) {
            IRExpression value = values.get(i);
            if (!(value instanceof IRNullLiteral) && !componentType.isAssignableFrom(value.getType())) {
                value = this.buildCast(componentType, value);
            }
            elements.add(this.buildArrayStore((IRExpression)this.identifier(tempArray), this.numericLiteral(i), value, componentType));
        }
        elements.add(this.identifier(tempArray));
        return new IRCompositeExpression(elements);
    }

    protected IRExpression buildNewExpression(IRType type, List<IRType> parameterTypes, List<IRExpression> args) {
        return new IRNewExpression(type, parameterTypes, args);
    }

    protected IRExpression buildNewExpression(Class type, Class[] parameterTypes, List<IRExpression> args) {
        return new IRNewExpression(AbstractElementTransformer.getDescriptor(type), AbstractElementTransformer.getIRTypes(parameterTypes), args);
    }

    protected final String getTypeVarParamName(IGenericTypeVariable typeVar) {
        return TYPE_PARAM_PREFIX + typeVar.getName();
    }

    protected String getCapturedSymbolParameterName(ICapturedSymbol sym) {
        return CAPTURED_VAR_PREFIX + sym.getName();
    }

    protected static List<IRExpression> exprList(IRExpression ... expressions) {
        return Arrays.asList(expressions);
    }

    protected static List<IRType> getIRTypes(Class[] classes) {
        ArrayList<IRType> types = new ArrayList<IRType>(classes.length);
        for (int i = 0; i < classes.length; ++i) {
            types.add(AbstractElementTransformer.getDescriptor(classes[i]));
        }
        return types;
    }

    protected static List<IRType> getIRTypes(IJavaClassInfo[] iJavaClassInfos) {
        ArrayList<IRType> types = new ArrayList<IRType>(iJavaClassInfos.length);
        for (int i = 0; i < iJavaClassInfos.length; ++i) {
            types.add(AbstractElementTransformer.getDescriptor(iJavaClassInfos[i]));
        }
        return types;
    }

    protected IRExpression buildNullCheckTernary(IRExpression root, IRExpression ifNull, IRExpression ifNotNull) {
        return new IRTernaryExpression((IRExpression)this.buildEquals(root, this.nullLiteral()), ifNull, ifNotNull, ifNotNull.getType());
    }

    protected IRThrowStatement buildThrow(IRExpression exception) {
        return new IRThrowStatement(exception);
    }

    protected IRIfStatement buildIf(IRExpression test, IRStatement ifStatement) {
        return new IRIfStatement(test, ifStatement, null);
    }

    protected IRIfStatement buildIfElse(IRExpression test, IRStatement ifStatement, IRStatement elseStatement) {
        return new IRIfStatement(test, ifStatement, elseStatement);
    }

    protected IRCompositeExpression buildComposite(IRElement ... elements) {
        return new IRCompositeExpression(elements);
    }

    protected IRCompositeExpression buildComposite(List<IRElement> elements) {
        return new IRCompositeExpression(elements);
    }

    protected IRMethodCallStatement buildMethodCall(IRExpression methodCall) {
        return new IRMethodCallStatement(methodCall);
    }

    protected IRNewStatement buildNewExpression(IRNewExpression newExpression) {
        return new IRNewStatement(newExpression);
    }

    protected IRStatement buildReturn() {
        return new IRReturnStatement();
    }

    protected IREqualityExpression buildEquals(IRExpression lhs, IRExpression rhs) {
        return new IREqualityExpression(lhs, rhs, true);
    }

    protected IREqualityExpression buildNotEquals(IRExpression lhs, IRExpression rhs) {
        return new IREqualityExpression(lhs, rhs, false);
    }

    protected IRRelationalExpression buildGreaterThan(IRExpression lhs, IRExpression rhs) {
        return new IRRelationalExpression(lhs, rhs, IRRelationalExpression.Operation.GT);
    }

    protected IRExpression buildTernary(IRExpression test, IRExpression trueValue, IRExpression falseValue, IRType resultType) {
        return new IRTernaryExpression(IRArgConverter.castOrConvertIfNecessary((IRType)IRTypeConstants.pBOOLEAN(), (IRExpression)test), trueValue, falseValue, resultType);
    }

    protected IRExpression buildAddition(IRExpression lhs, IRExpression rhs) {
        return this.buildArithmetic(lhs, rhs, IRArithmeticExpression.Operation.Addition);
    }

    protected IRExpression buildSubtraction(IRExpression lhs, IRExpression rhs) {
        return this.buildArithmetic(lhs, rhs, IRArithmeticExpression.Operation.Subtraction);
    }

    protected IRExpression buildArithmetic(IRExpression lhs, IRExpression rhs, IRArithmeticExpression.Operation operation) {
        if (!lhs.getType().equals(rhs.getType())) {
            throw new IllegalArgumentException("Arithmetic must be between identical types.  Found " + lhs.getType().getName() + " and " + rhs.getType().getName());
        }
        return new IRArithmeticExpression(lhs.getType(), lhs, rhs, operation);
    }

    protected IRExpression buildNegation(IRExpression root) {
        return new IRNegationExpression(root);
    }

    protected IRExpression buildArrayLength(IRExpression root) {
        return new IRArrayLengthExpression(root);
    }

    protected boolean inStaticContext() {
        return this._cc().isCurrentFunctionStatic();
    }

    protected List<GosuAnnotationInfo> makeAnnotationInfos(List<IGosuAnnotation> gosuAnnotations, IFeatureInfo fiAnnotated) {
        ArrayList<GosuAnnotationInfo> annotationInfos = new ArrayList<GosuAnnotationInfo>();
        for (int i = 0; i < gosuAnnotations.size(); ++i) {
            IGosuAnnotation ga = gosuAnnotations.get(i);
            annotationInfos.add(new GosuAnnotationInfo(ga, fiAnnotated, (IGosuClassInternal)ga.getOwnersType()));
        }
        return annotationInfos;
    }

    protected boolean isCheckedArithmeticEnabled() {
        DynamicFunctionSymbol currentFunction = this._cc().getCurrentFunction();
        return (Boolean)_checkedArithmetic.get() != false && currentFunction != null && !"hashCode()".equals(currentFunction.getName());
    }

    public static boolean isNonStaticInnerClass(IType type) {
        return type != null && type.getEnclosingType() != null && !Modifier.isStatic((int)type.getModifiers());
    }

    protected IRExpression getField_new(IRProperty irProp, IRExpression root, IRType expectedType) {
        IRType resultType;
        IRExpression result = this.getFieldImpl_new(irProp, root);
        if (irProp.isCaptured()) {
            result = this.buildArrayLoad(result, 0, irProp.getType().getComponentType());
            resultType = irProp.getType().getComponentType();
        } else {
            resultType = irProp.getType();
        }
        if (!expectedType.isAssignableFrom(resultType)) {
            result = this.buildCast(expectedType, result);
        }
        return result;
    }

    private IRExpression getFieldImpl_new(IRProperty irProp, IRExpression root) {
        IRType rootType;
        IRType iRType = rootType = root == null ? null : root.getType();
        if (rootType == null) {
            rootType = irProp.getOwningIRType();
        }
        if (this._cc().shouldUseReflection(irProp.getOwningIType(), rootType, irProp.getAccessibility())) {
            return this.getFieldReflectively_new(irProp, root);
        }
        return this.buildFieldGet(irProp.getOwningIRType(), irProp.getName(), irProp.getType(), root);
    }

    private IRExpression getFieldReflectively_new(IRProperty irProp, IRExpression root) {
        IRMethodCallExpression getDeclaredFieldCall = this.buildMethodCall(AbstractElementTransformer.class, "getDeclaredField", Field.class, new Class[]{Class.class, String.class}, null, AbstractElementTransformer.exprList(this.classLiteral(irProp.getOwningIRType()), this.stringLiteral(irProp.getName())));
        IRMethodCallExpression getCall = this.buildMethodCall(Field.class, "get", Object.class, new Class[]{Object.class}, (IRExpression)getDeclaredFieldCall, AbstractElementTransformer.exprList(root == null ? this.pushNull() : root));
        return this.unboxValueToType(irProp.getType(), (IRExpression)getCall);
    }

    protected void assignStructuralTypeOwner(IExpression rootExpr, IRExpression irMethodCall) {
        if (rootExpr != null && rootExpr.getType() instanceof IGosuClass && ((IGosuClass)rootExpr.getType()).isStructure()) {
            IRExpression mc = irMethodCall;
            while (mc instanceof IRCompositeExpression) {
                List elements = ((IRCompositeExpression)mc).getElements();
                mc = (IRExpression)elements.get(elements.size() - 1);
            }
            ((IRMethodCallExpression)mc).setStructuralTypeOwner((IRType)GosuClassIRType.get(TypeLord.getPureGenericType(rootExpr.getType())));
        }
    }

    protected IRExpression fastStringCoercion(IRExpression expr, IType operandType) {
        IRExpression stringValueExpr;
        if (!operandType.isPrimitive()) {
            stringValueExpr = JavaTypes.pCHAR().getArrayType().isAssignableFrom(operandType) ? this.callStaticMethod(String.class, "valueOf", new Class[]{char[].class}, Collections.singletonList(expr)) : (!this.isHandledByCustomCoercion(operandType) ? this.callMethod(Object.class, "toString", new Class[0], expr, Collections.emptyList()) : this.callMethod(ICoercionManager.class, "makeStringFrom", new Class[]{Object.class}, this.callStaticMethod(CommonServices.class, "getCoercionManager", new Class[0], Collections.emptyList()), Collections.singletonList(expr)));
        } else {
            Class<Integer> primitiveClass = AbstractElementTransformer.getDescriptor(operandType).getJavaClass();
            if (!this.isHandledByCustomCoercion(operandType)) {
                primitiveClass = primitiveClass == Short.TYPE || primitiveClass == Byte.TYPE ? Integer.TYPE : primitiveClass;
                stringValueExpr = primitiveClass == Void.TYPE ? this.nullLiteral() : this.callStaticMethod(String.class, "valueOf", new Class[]{primitiveClass}, Collections.singletonList(expr));
            } else {
                stringValueExpr = this.callMethod(ICoercionManager.class, "makeStringFrom", new Class[]{Object.class}, this.callStaticMethod(CommonServices.class, "getCoercionManager", new Class[0], Collections.emptyList()), Collections.singletonList(this.boxValue(AbstractElementTransformer.getDescriptor(primitiveClass), expr)));
            }
        }
        return stringValueExpr;
    }

    protected boolean isHandledByCustomCoercion(IType operandType) {
        if (ILanguageLevel.Util.STANDARD_GOSU()) {
            return false;
        }
        return operandType == JavaTypes.BIG_DECIMAL() || operandType == JavaTypes.FLOAT() || operandType == JavaTypes.pFLOAT() || operandType == JavaTypes.DOUBLE() || operandType == JavaTypes.pDOUBLE() || operandType == JavaTypes.DATE() || operandType == JavaTypes.OBJECT() || TypeSystem.get(IEnumConstant.class).isAssignableFrom(operandType) || CommonServices.getEntityAccess().isEntityClass(operandType);
    }

    public static IType findDimensionType(IType type) {
        if (!JavaTypes.IDIMENSION().isAssignableFrom(type)) {
            return null;
        }
        IType dimType = TypeLord.findParameterizedType(type, (IType)JavaTypes.IDIMENSION());
        return dimType.isGenericType() ? null : dimType.getTypeParameters()[1];
    }

    protected final IType findComparableParamType(IType type) {
        if (!JavaTypes.COMPARABLE().isAssignableFrom(type)) {
            return null;
        }
        type = TypeLord.getPureGenericType(type);
        return this.findCompareToParamType(type);
    }

    private IType findCompareToParamType(IType type) {
        IType paramType;
        if (type == null) {
            return null;
        }
        ITypeInfo ti = (type = TypeLord.getPureGenericType(type)).getTypeInfo();
        if (ti instanceof IRelativeTypeInfo) {
            for (IMethodInfo csr : ((IRelativeTypeInfo)ti).getDeclaredMethods()) {
                IType paramType2;
                IParameterInfo[] params;
                if (!"compareTo".equals(csr.getDisplayName()) || (params = csr.getParameters()) == null || params.length != 1 || !(paramType2 = TypeLord.getPureGenericType(TypeLord.getDefaultParameterizedTypeWithTypeVars(params[0].getFeatureType()))).isAssignableFrom(type)) continue;
                return paramType2;
            }
        }
        if (!type.isInterface() && (paramType = this.findCompareToParamType(type.getSupertype())) != null) {
            return paramType;
        }
        IType[] interfaces = type.getInterfaces();
        if (interfaces != null) {
            for (IType iface : interfaces) {
                IType paramType3 = this.findCompareToParamType(iface);
                if (paramType3 == null) continue;
                return paramType3;
            }
        }
        return null;
    }
}

