/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.expression;

import gw.config.CommonServices;
import gw.internal.gosu.compiler.SingleServingGosuClassLoader;
import gw.internal.gosu.ir.transform.ExpressionTransformer;
import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.ir.transform.expression.EvalBasedTransformer;
import gw.internal.gosu.parser.IGosuProgramInternal;
import gw.internal.gosu.parser.expressions.EvalExpression;
import gw.internal.gosu.util.LRUMap;
import gw.lang.ir.IRExpression;
import gw.lang.parser.GosuParserFactory;
import gw.lang.parser.ICapturedSymbol;
import gw.lang.parser.IGosuProgramParser;
import gw.lang.parser.IParseResult;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.ISymbolTable;
import gw.lang.reflect.IType;
import gw.lang.reflect.LazyTypeResolver;
import gw.lang.reflect.gs.ICompilableType;
import gw.lang.reflect.gs.IExternalSymbolMap;
import gw.lang.reflect.gs.IGosuProgram;
import gw.lang.reflect.gs.IProgramInstance;
import gw.util.GosuExceptionUtil;
import gw.util.GosuStringUtil;
import gw.util.concurrent.LocklessLazyVar;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class EvalExpressionTransformer
extends EvalBasedTransformer<EvalExpression> {
    public static final Map<String, EvalExpression> EVAL_EXPRESSIONS = Collections.synchronizedMap(new LRUMap(2000));
    public static LocklessLazyVar<DeclaredConstructorsAccessor> _ctorAccessor = new LocklessLazyVar<DeclaredConstructorsAccessor>(){

        protected DeclaredConstructorsAccessor init() {
            Method result = (Method)AccessController.doPrivileged(new PrivilegedAction(){

                public Method run() {
                    try {
                        Method m = Class.class.getDeclaredMethod("privateGetDeclaredConstructors", Boolean.TYPE);
                        m.setAccessible(true);
                        return m;
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            });
            if (result != null) {
                return new PrivateGetDeclaredConstructorsAccessor(result);
            }
            return new PublicGetDeclaredConstructorsAccessor();
        }
    };

    public static IRExpression compile(TopLevelTransformationContext cc, EvalExpression expr) {
        EvalExpressionTransformer compiler = new EvalExpressionTransformer(cc, expr);
        return compiler.compile();
    }

    private EvalExpressionTransformer(TopLevelTransformationContext cc, EvalExpression expr) {
        super(cc, expr);
    }

    @Override
    protected IRExpression compile_impl() {
        this.putEvalExpression((EvalExpression)this._expr());
        return this.callStaticMethod(EvalExpressionTransformer.class, "compileAndRunEvalSource", new Class[]{Object.class, Object.class, Object[].class, LazyTypeResolver[].class, IType.class, Integer.TYPE, Integer.TYPE, String.class}, EvalExpressionTransformer.exprList(this.boxValue(((EvalExpression)this._expr()).getType(), ExpressionTransformer.compile(((EvalExpression)this._expr()).getExpression(), this._cc())), this.pushEnclosingContext(), this.pushCapturedSymbols(this.getGosuClass(), ((EvalExpression)this._expr()).getCapturedForBytecode()), this.pushEnclosingFunctionTypeParamsInArray((IParsedElement)this._expr()), this.pushType((IType)this.getGosuClass()), this.pushConstant(((EvalExpression)this._expr()).getLineNum()), this.pushConstant(((EvalExpression)this._expr()).getColumn()), this.pushConstant(((EvalExpression)this._expr()).toString())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putEvalExpression(EvalExpression evalExpr) {
        Map<String, EvalExpression> map = EVAL_EXPRESSIONS;
        synchronized (map) {
            int iLine = ((EvalExpression)this._expr()).getLineNum();
            int iColumnNum = ((EvalExpression)this._expr()).getColumn();
            EVAL_EXPRESSIONS.put(EvalExpressionTransformer.makeEvalKey((IType)this.getGosuClass(), iLine, iColumnNum, ((EvalExpression)this._expr()).toString()), evalExpr);
        }
    }

    public static String makeEvalKey(IType enclosingClass, int iLineNum, int iColumnNum, String evalExprText) {
        return enclosingClass.getName() + '.' + "__Program__" + "eval_" + iLineNum + ":" + iColumnNum + ":" + GosuStringUtil.getSHA1String((String)evalExprText);
    }

    public static Object compileAndRunEvalSource(Object source, Object outer, Object[] capturedValues, LazyTypeResolver[] immediateFuncTypeParams, IType enclosingClass, int iLineNum, int iColumn, String evalExprText) {
        String evalExprKey = EvalExpressionTransformer.makeEvalKey(enclosingClass, iLineNum, iColumn, evalExprText);
        EvalExpression evalExpr = EVAL_EXPRESSIONS.get(evalExprKey);
        if (evalExpr == null && enclosingClass instanceof ICompilableType) {
            ((ICompilableType)enclosingClass).compile();
            evalExpr = EVAL_EXPRESSIONS.get(evalExprKey);
        }
        return EvalExpressionTransformer.compileAndRunEvalSource(source, outer, capturedValues, immediateFuncTypeParams, enclosingClass, evalExpr);
    }

    public static Object compileAndRunEvalSource(Object source, Object outer, Object[] capturedValues, LazyTypeResolver[] immediateFuncTypeParams, IType enclosingClass, IParsedElement evalExpr) {
        return EvalExpressionTransformer.compileAndRunEvalSource(source, outer, capturedValues, immediateFuncTypeParams, enclosingClass, evalExpr, null, null);
    }

    public static Object compileAndRunEvalSource(Object source, Object outer, Object[] capturedValues, LazyTypeResolver[] immediateFuncTypeParams, IType enclosingClass, IParsedElement evalExpr, ISymbolTable compileTimeLocalContextSymbols, IExternalSymbolMap runtimeLocalSymbolValues) {
        List<ICapturedSymbol> capturedSymbols;
        String strSource = CommonServices.getCoercionManager().makeStringFrom(source);
        IGosuProgramParser parser = GosuParserFactory.createProgramParser();
        IParseResult res = parser.parseEval(strSource, capturedSymbols = evalExpr instanceof EvalExpression ? ((EvalExpression)evalExpr).getCapturedForBytecode() : Collections.emptyList(), enclosingClass, evalExpr, compileTimeLocalContextSymbols);
        IGosuProgram gp = res.getProgram();
        if (!gp.isValid()) {
            System.out.println((Object)gp.getParseResultsException());
            throw GosuExceptionUtil.forceThrow((Throwable)gp.getParseResultsException());
        }
        Class javaClass = gp.getBackingClass();
        ClassLoader classLoader = javaClass.getClassLoader();
        assert (classLoader instanceof SingleServingGosuClassLoader);
        ArrayList<Object> args = new ArrayList<Object>();
        if (!gp.isStatic()) {
            args.add(outer);
        }
        EvalExpressionTransformer.addCapturedValues((IGosuProgramInternal)gp, capturedSymbols, capturedValues, args);
        EvalExpressionTransformer.addEnclosingTypeParams(immediateFuncTypeParams, args);
        Constructor ctor = ((DeclaredConstructorsAccessor)_ctorAccessor.get()).getConstructor(javaClass);
        Class<?>[] parameterTypes = ctor.getParameterTypes();
        if (parameterTypes.length != args.size()) {
            if (parameterTypes.length > args.size() && parameterTypes[parameterTypes.length - 1].getName().equals(IExternalSymbolMap.class.getName())) {
                args.add(runtimeLocalSymbolValues);
            } else {
                throw new IllegalStateException("Eval constructor param count is not " + args.size() + "\nPassed in args " + EvalExpressionTransformer.printArgs(args) + "\nActual args: " + EvalExpressionTransformer.printArgs(ctor.getParameterTypes()));
            }
        }
        try {
            IProgramInstance evalInstance = (IProgramInstance)ctor.newInstance(args.toArray());
            return evalInstance.evaluate(runtimeLocalSymbolValues);
        }
        catch (Exception e) {
            throw GosuExceptionUtil.forceThrow((Throwable)e);
        }
    }

    private static String printArgs(List<Object> args) {
        String str = "";
        for (Object a : args) {
            str = str + a + ", ";
        }
        return str;
    }

    private static String printArgs(Class[] parameterTypes) {
        String str = "";
        for (Class c : parameterTypes) {
            str = str + c.getName() + ", ";
        }
        return str;
    }

    private static void debugInfo(ISymbolTable compileTimeLocalContextSymbols) {
        if (compileTimeLocalContextSymbols != null) {
            Map symbols = compileTimeLocalContextSymbols.getSymbols();
            for (Object key : symbols.keySet()) {
                Object o = symbols.get(key);
                System.out.println("SYMBOL NAME: " + key + " SYMBOL: " + o);
            }
        }
    }

    private static void addCapturedValues(IGosuProgramInternal gp, List<ICapturedSymbol> capturedSymbols, Object[] capturedValues, List<Object> args) {
        if (capturedValues != null) {
            Map capturedSymbolsByName = gp.getCapturedSymbols();
            if (capturedSymbolsByName != null) {
                for (ICapturedSymbol sym : capturedSymbolsByName.values()) {
                    args.add(capturedValues[capturedSymbols.indexOf(sym)]);
                }
            }
            if (EvalExpressionTransformer.requiresExternalSymbolCapture((IType)gp)) {
                args.add(capturedValues[capturedValues.length - 1]);
            }
        }
    }

    public static void clearEvalExpressions() {
        EVAL_EXPRESSIONS.clear();
    }

    private static class PublicGetDeclaredConstructorsAccessor
    implements DeclaredConstructorsAccessor {
        private PublicGetDeclaredConstructorsAccessor() {
        }

        @Override
        public Constructor getConstructor(Class clz) {
            return clz.getConstructors()[0];
        }
    }

    private static class PrivateGetDeclaredConstructorsAccessor
    implements DeclaredConstructorsAccessor {
        private Method _getDeclaredConstructors;

        public PrivateGetDeclaredConstructorsAccessor(Method getDeclaredConstructors) {
            this._getDeclaredConstructors = getDeclaredConstructors;
        }

        @Override
        public Constructor getConstructor(final Class clz) {
            return (Constructor)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return ((Constructor[])_getDeclaredConstructors.invoke((Object)clz, false))[0];
                    }
                    catch (Exception e) {
                        System.err.println("WARNING Cannot load constructors of " + clz.getName() + ": " + e.toString());
                        return null;
                    }
                }
            });
        }
    }

    public static interface DeclaredConstructorsAccessor {
        public Constructor getConstructor(Class var1);
    }
}

