/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.expression;

import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.ir.transform.expression.AbstractExpressionTransformer;
import gw.internal.gosu.parser.expressions.TemplateStringLiteral;
import gw.lang.ir.IRElement;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRStatement;
import gw.lang.ir.IRSymbol;
import gw.lang.ir.IRType;
import gw.lang.ir.IRTypeConstants;
import gw.lang.ir.expression.IRCompositeExpression;
import gw.lang.ir.expression.IRMethodCallExpression;
import gw.lang.ir.expression.IRStringLiteralExpression;
import gw.lang.ir.statement.IRAssignmentStatement;
import gw.lang.parser.expressions.IProgram;
import gw.util.Stack;
import java.util.Collections;

public class TemplateStringLiteralTransformer
extends AbstractExpressionTransformer<TemplateStringLiteral> {
    private static final ThreadLocal<Stack<IRSymbol>> SYMBOL_STACK = new ThreadLocal();

    public static IRExpression compile(TopLevelTransformationContext cc, TemplateStringLiteral expr) {
        TemplateStringLiteralTransformer compiler = new TemplateStringLiteralTransformer(cc, expr);
        return compiler.compile();
    }

    private TemplateStringLiteralTransformer(TopLevelTransformationContext cc, TemplateStringLiteral expr) {
        super(cc, expr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IRExpression compile_impl() {
        TemplateStringLiteral stringLiteral = (TemplateStringLiteral)this._expr();
        IProgram iProgram = stringLiteral.getProgram();
        if (iProgram != null) {
            IRCompositeExpression template = new IRCompositeExpression(new IRElement[0]);
            IRType sbType = TemplateStringLiteralTransformer.getDescriptor(StringBuilder.class);
            IRSymbol symbol = this._cc().makeAndIndexTempSymbol(sbType);
            try {
                TemplateStringLiteralTransformer.getThreadLocalStack().push((Object)symbol);
                IRAssignmentStatement sbAssignment = this.buildAssignment(symbol, this.buildNewExpression(sbType, Collections.emptyList(), Collections.emptyList()));
                template.addElement((IRElement)sbAssignment);
                sbAssignment.setImplicit(true);
                IRStatement templateBody = this._cc().compile(iProgram.getMainStatement());
                template.addElement((IRElement)templateBody);
                templateBody.setImplicit(true);
                IRMethodCallExpression toString = this.buildMethodCall(sbType, "toString", false, IRTypeConstants.STRING(), Collections.emptyList(), (IRExpression)this.identifier(symbol), Collections.emptyList());
                template.addElement((IRElement)toString);
                template.setImplicit(true);
                IRCompositeExpression iRCompositeExpression = template;
                return iRCompositeExpression;
            }
            finally {
                TemplateStringLiteralTransformer.getThreadLocalStack().pop();
            }
        }
        return new IRStringLiteralExpression("Unsupported Template");
    }

    private static Stack<IRSymbol> getThreadLocalStack() {
        Stack symbolStack = SYMBOL_STACK.get();
        if (symbolStack == null) {
            symbolStack = new Stack();
            SYMBOL_STACK.set((Stack<IRSymbol>)symbolStack);
        }
        return symbolStack;
    }

    public static IRSymbol getCurrentTemplateSymbol() {
        Stack<IRSymbol> threadLocalStack = TemplateStringLiteralTransformer.getThreadLocalStack();
        return threadLocalStack.isEmpty() ? null : (IRSymbol)threadLocalStack.peek();
    }
}

