/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.config.CommonServices;
import gw.internal.gosu.compiler.SingleServingGosuClassLoader;
import gw.internal.gosu.ir.transform.expression.EvalExpressionTransformer;
import gw.internal.gosu.parser.GosuProgramParser;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.IGosuProgramInternal;
import gw.internal.gosu.parser.Symbol;
import gw.internal.gosu.parser.TypeLord;
import gw.lang.parser.ExternalSymbolMapForMap;
import gw.lang.parser.GosuParserFactory;
import gw.lang.parser.IGosuProgramParser;
import gw.lang.parser.IParseTree;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.ISymbolTable;
import gw.lang.parser.ParseResult;
import gw.lang.parser.StandardSymbolTable;
import gw.lang.parser.exceptions.ParseResultsException;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IExternalSymbolMap;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuProgram;
import gw.lang.reflect.gs.IProgramInstance;
import gw.lang.reflect.java.JavaTypes;
import gw.lang.reflect.module.IModule;
import gw.util.ContextSymbolTableUtil;
import gw.util.GosuExceptionUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class ContextSensitiveCodeRunner {
    private static ConcurrentHashMap<String, IGosuProgramInternal> _cacheProgramByFingerprint = new ConcurrentHashMap();
    private static int _refreshChecksum;

    static void ensureLoadedForDebuggerEval() {
        System.out.println("~~~~~LOADED");
    }

    public static Object runMeSomeCode(Object enclosingInstance, ClassLoader cl, Object[] extSyms, String strText, String strClassContext, String strContextElementClass, int iSourcePosition) {
        try {
            Class<?> cls = Class.forName(ContextSensitiveCodeRunner.class.getName(), false, cl);
            Method m = cls.getDeclaredMethod("_runMeSomeCode", Object.class, Object[].class, String.class, String.class, String.class, Integer.TYPE);
            m.setAccessible(true);
            return m.invoke(null, enclosingInstance, extSyms, strText, strClassContext, strContextElementClass, iSourcePosition);
        }
        catch (Exception e) {
            List parseExceptions;
            e.printStackTrace();
            Throwable cause = GosuExceptionUtil.findExceptionCause((Throwable)e);
            if (cause instanceof ParseResultsException && (parseExceptions = ((ParseResultsException)cause).getParseExceptions()) != null && parseExceptions.size() >= 0) {
                throw GosuExceptionUtil.forceThrow((Throwable)((Throwable)parseExceptions.get(0)));
            }
            throw GosuExceptionUtil.forceThrow((Throwable)cause);
        }
    }

    private static Object _runMeSomeCode(Object enclosingInstance, Object[] extSyms, String strText, String strClassContext, String strContextElementClass, int iSourcePosition) {
        if (strClassContext != null) {
            IType type = TypeSystem.getByFullName((String)strClassContext, (IModule)TypeSystem.getGlobalModule());
            if (!(type instanceof IGosuClassInternal)) {
                System.out.println(strClassContext + " is not a Gosu class");
                return null;
            }
            IGosuClassInternal gsClass = (IGosuClassInternal)type;
            gsClass.isValid();
            IGosuClassInternal gsImmediateClass = (IGosuClassInternal)TypeSystem.getByFullName((String)strContextElementClass);
            return ContextSensitiveCodeRunner.compileAndRunMeSomeCode(strText, gsClass, enclosingInstance, (IType)gsImmediateClass, extSyms, iSourcePosition);
        }
        IGosuClassInternal gsImmediateClass = (IGosuClassInternal)TypeSystem.getByFullName((String)strContextElementClass);
        return ContextSensitiveCodeRunner.compileAndRunMeSomeCode(strText, null, enclosingInstance, (IType)gsImmediateClass, extSyms, 0);
    }

    public static Object compileAndRunMeSomeCode(Object source, IGosuClass ctxClass, Object outer, IType enclosingClass, Object[] extSyms, int offset) {
        Constructor ctor;
        Class<?>[] parameterTypes;
        ParseResult res;
        String typeName = GosuProgramParser.makeEvalKey(source.toString(), enclosingClass, offset);
        IGosuProgramInternal program = ContextSensitiveCodeRunner.getCachedProgram(typeName);
        if (program != null) {
            program.isValid();
            res = new ParseResult((IGosuProgram)program);
        } else {
            StandardSymbolTable compileTimeLocalContextSymbols = ctxClass == null ? new StandardSymbolTable(true) : ContextSymbolTableUtil.getSymbolTableAtOffset((IGosuClass)ctxClass, (int)offset);
            String strSource = CommonServices.getCoercionManager().makeStringFrom(source);
            IGosuProgramParser parser = GosuParserFactory.createProgramParser();
            res = parser.parseRuntimeExpr(typeName, strSource, (IGosuClass)enclosingClass, (ISymbolTable)compileTimeLocalContextSymbols);
            ContextSensitiveCodeRunner.cacheProgram(typeName, (IGosuProgramInternal)res.getProgram());
        }
        IExternalSymbolMap runtimeLocalSymbolValues = ContextSensitiveCodeRunner.makeRuntimeNamesAndValues(extSyms);
        IGosuProgram gp = res.getProgram();
        if (!gp.isValid()) {
            System.out.println((Object)gp.getParseResultsException());
            throw GosuExceptionUtil.forceThrow((Throwable)gp.getParseResultsException());
        }
        Class javaClass = gp.getBackingClass();
        ClassLoader classLoader = javaClass.getClassLoader();
        assert (classLoader instanceof SingleServingGosuClassLoader);
        ArrayList<Object> args = new ArrayList<Object>();
        if (!gp.isStatic()) {
            args.add(outer);
        }
        if ((parameterTypes = (ctor = ((EvalExpressionTransformer.DeclaredConstructorsAccessor)EvalExpressionTransformer._ctorAccessor.get()).getConstructor(javaClass)).getParameterTypes()).length != args.size()) {
            if (parameterTypes.length > args.size() && parameterTypes[parameterTypes.length - 1].getName().equals(IExternalSymbolMap.class.getName())) {
                args.add(runtimeLocalSymbolValues);
            } else {
                throw new IllegalStateException("Runtime expr constructor param count is not " + args.size() + "\nPassed in args " + ContextSensitiveCodeRunner.printArgs(args) + "\nActual args: " + ContextSensitiveCodeRunner.printArgs(ctor.getParameterTypes()));
            }
        }
        try {
            IProgramInstance evalInstance = (IProgramInstance)ctor.newInstance(args.toArray());
            return evalInstance.evaluate(runtimeLocalSymbolValues);
        }
        catch (Exception e) {
            throw GosuExceptionUtil.forceThrow((Throwable)e);
        }
    }

    public static void cacheProgram(String strTypeName, IGosuProgramInternal program) {
        ContextSensitiveCodeRunner.clearCacheOnChecksumChange();
        _cacheProgramByFingerprint.put(strTypeName, program);
    }

    public static IGosuProgramInternal getCachedProgram(String strTypeName) {
        ContextSensitiveCodeRunner.clearCacheOnChecksumChange();
        return _cacheProgramByFingerprint.get(strTypeName);
    }

    private static void clearCacheOnChecksumChange() {
        if (_refreshChecksum != TypeSystem.getRefreshChecksum()) {
            _cacheProgramByFingerprint.clear();
            _refreshChecksum = TypeSystem.getRefreshChecksum();
        }
    }

    private static String printArgs(Class[] parameterTypes) {
        String str = "";
        for (Class c : parameterTypes) {
            str = str + c.getName() + ", ";
        }
        return str;
    }

    private static String printArgs(List<Object> args) {
        String str = "";
        for (Object a : args) {
            str = str + a + ", ";
        }
        return str;
    }

    private static IExternalSymbolMap makeRuntimeNamesAndValues(Object[] extSyms) {
        HashMap<String, Symbol> map = new HashMap<String, Symbol>();
        for (int i = 0; i < extSyms.length; ++i) {
            String name = (String)extSyms[i];
            Object value = extSyms[++i];
            map.put(name, new Symbol(name, (IType)JavaTypes.OBJECT(), value));
        }
        return new ExternalSymbolMapForMap(map);
    }

    private static IParsedElement findElemAt(IGosuClassInternal gsClass, int iContextLocation) {
        IParseTree elem = ((IGosuClass)TypeLord.getOuterMostEnclosingClass((IType)gsClass)).getClassStatement().getClassFileStatement().getLocation().getDeepestLocation(iContextLocation, false);
        return elem == null ? gsClass.getClassStatement().getClassFileStatement() : elem.getParsedElement();
    }
}

