/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.config.CommonServices;
import gw.config.ExecutionMode;
import gw.fs.AdditionalDirectory;
import gw.fs.IDirectory;
import gw.fs.IResource;
import gw.fs.IncludeModuleDirectory;
import gw.internal.gosu.module.DefaultSingleModule;
import gw.internal.gosu.module.GlobalModule;
import gw.internal.gosu.module.JreModule;
import gw.internal.gosu.module.Module;
import gw.internal.gosu.parser.ContextSensitiveCodeRunner;
import gw.internal.gosu.parser.FrequentUsedJavaTypeCache;
import gw.internal.gosu.parser.IGosuEnhancementInternal;
import gw.internal.gosu.parser.ReloadClassesIndicator;
import gw.internal.gosu.parser.TypeSystemState;
import gw.lang.ProgramFileContext;
import gw.lang.gosuc.GosucModule;
import gw.lang.gosuc.GosucProject;
import gw.lang.gosuc.GosucUtil;
import gw.lang.init.GosuPathEntry;
import gw.lang.parser.GosuParserFactory;
import gw.lang.parser.IFileContext;
import gw.lang.parser.IGosuParser;
import gw.lang.parser.IGosuProgramParser;
import gw.lang.parser.ILanguageLevel;
import gw.lang.parser.IParseResult;
import gw.lang.parser.ParserOptions;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeRef;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.BytecodeOptions;
import gw.lang.reflect.gs.GosuClassPathThing;
import gw.lang.reflect.gs.GosuClassTypeLoader;
import gw.lang.reflect.gs.IGosuEnhancement;
import gw.lang.reflect.java.JavaTypes;
import gw.lang.reflect.module.Dependency;
import gw.lang.reflect.module.IExecutionEnvironment;
import gw.lang.reflect.module.IModule;
import gw.lang.reflect.module.INativeModule;
import gw.lang.reflect.module.IProject;
import gw.util.GosuExceptionUtil;
import gw.util.ILogger;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class ExecutionEnvironment
implements IExecutionEnvironment {
    private static final IProject DEFAULT_PROJECT = new DefaultSingleModuleRuntimeProject();
    private static final Map<Object, ExecutionEnvironment> INSTANCES = new WeakHashMap<Object, ExecutionEnvironment>();
    private static ExecutionEnvironment THE_ONE;
    public static final String CLASS_REDEFINER_THREAD = "Gosu class redefiner";
    private static final List<String> SPECIAL_CLASSES;
    private IProject _project;
    private List<IModule> _modules;
    private IModule _defaultModule;
    private IModule _jreModule;
    private IModule _rootModule;
    private String[] _discretePackages;
    private TypeSystemState _state = TypeSystemState.STOPPED;
    private int counter;

    public static ExecutionEnvironment instance() {
        IModule mod;
        if (THE_ONE != null && !ExecutionMode.get().isRefreshSupportEnabled()) {
            return THE_ONE;
        }
        int count = INSTANCES.size();
        if (count == 1) {
            return THE_ONE == null ? (THE_ONE = INSTANCES.values().iterator().next()) : THE_ONE;
        }
        Object object = mod = count > 0 ? TypeSystem.getCurrentModule() : null;
        if (mod != null) {
            ExecutionEnvironment execEnv = (ExecutionEnvironment)mod.getExecutionEnvironment();
            if (execEnv == null) {
                throw new IllegalStateException("Module, " + mod.getName() + ", has a null execution environment. This is bad.");
            }
            return execEnv;
        }
        if (count > 0) {
            for (ExecutionEnvironment execEnv : INSTANCES.values()) {
                if (execEnv.getProject() == DEFAULT_PROJECT || execEnv.getProject().isDisposed()) continue;
                return execEnv;
            }
        }
        return ExecutionEnvironment.instance(DEFAULT_PROJECT);
    }

    public static ExecutionEnvironment instance(IProject project) {
        if (project == null) {
            throw new IllegalStateException("Project must not be null");
        }
        if (project instanceof IExecutionEnvironment) {
            throw new RuntimeException("Passed in ExecutionEnvironment as project");
        }
        ExecutionEnvironment execEnv = INSTANCES.get(project);
        if (execEnv == null) {
            execEnv = new ExecutionEnvironment(project);
            INSTANCES.put(project, execEnv);
        }
        return execEnv;
    }

    public static Collection<? extends IExecutionEnvironment> getAll() {
        return INSTANCES.values();
    }

    private ExecutionEnvironment(IProject project) {
        this._project = project;
        this._modules = new ArrayList<IModule>();
    }

    public IProject getProject() {
        return this._project;
    }

    public List<? extends IModule> getModules() {
        return this._modules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeDefaultSingleModule(List<? extends GosuPathEntry> pathEntries, String ... discretePackages) {
        this._state = TypeSystemState.STARTING;
        try {
            DefaultSingleModule singleModule = this._defaultModule == null ? new DefaultSingleModule(this) : (DefaultSingleModule)this._defaultModule;
            ArrayList<IDirectory> allSources = new ArrayList<IDirectory>();
            for (GosuPathEntry gosuPathEntry : pathEntries) {
                IDirectory root = gosuPathEntry.getRoot();
                for (IDirectory dir : gosuPathEntry.getSources()) {
                    Object srcDir = root instanceof IncludeModuleDirectory ? new IncludeModuleDirectory(dir) : (root.isAdditional() ? new AdditionalDirectory(dir) : dir);
                    allSources.add((IDirectory)srcDir);
                }
                allSources.addAll(gosuPathEntry.getSources());
            }
            singleModule.configurePaths(ExecutionEnvironment.createDefaultClassPath(), allSources);
            this._defaultModule = singleModule;
            this._modules = new ArrayList<DefaultSingleModule>(Collections.singletonList(singleModule));
            this.setDiscretePackages(discretePackages);
            singleModule.initializeTypeLoaders();
            CommonServices.getCoercionManager().init();
            this.startSneakyDebugThread();
        }
        finally {
            this._state = TypeSystemState.STARTED;
        }
    }

    public void uninitializeDefaultSingleModule() {
        this._state = TypeSystemState.STOPPING;
        try {
            if (this._defaultModule != null) {
                DefaultSingleModule m = (DefaultSingleModule)this._defaultModule;
                m.getModuleTypeLoader().uninitializeTypeLoaders();
                m.getModuleTypeLoader().reset();
                m.configurePaths(Collections.emptyList(), Collections.emptyList());
            }
            this._modules.clear();
        }
        finally {
            this._state = TypeSystemState.STOPPED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeMultipleModules(List<? extends IModule> modules) {
        this._state = TypeSystemState.STARTING;
        try {
            this._defaultModule = null;
            this._rootModule = null;
            this._modules = modules;
            for (IModule iModule : modules) {
                TypeSystem.pushModule((IModule)iModule);
                try {
                    ((Module)iModule).initializeTypeLoaders();
                }
                finally {
                    TypeSystem.popModule((IModule)iModule);
                }
            }
            CommonServices.getCoercionManager().init();
            FrequentUsedJavaTypeCache.instance(this).init();
        }
        finally {
            this._state = TypeSystemState.STARTED;
        }
    }

    public void uninitializeMultipleModules() {
        this._state = TypeSystemState.STOPPING;
        try {
            TypeSystem.shutdown((IExecutionEnvironment)this);
            for (IModule module : this._modules) {
                ((Module)module).getModuleTypeLoader().uninitializeTypeLoaders();
            }
            this._jreModule = null;
            this._rootModule = null;
            this._modules.clear();
        }
        finally {
            this._state = TypeSystemState.STOPPED;
        }
    }

    public void addModule(IModule module) {
        this.checkForDuplicates(module.getName());
        this._modules.add(module);
        TypeSystem.pushModule((IModule)module);
        try {
            ((Module)module).initializeTypeLoaders();
        }
        finally {
            TypeSystem.popModule((IModule)module);
        }
    }

    public void initializeCompiler(GosucModule gosucModule) {
        this._state = TypeSystemState.STARTING;
        try {
            DefaultSingleModule module = new DefaultSingleModule(this, gosucModule.getName());
            module.setNativeModule((INativeModule)gosucModule);
            module.configurePaths(GosucUtil.toDirectories((List)gosucModule.getClasspath()), GosucUtil.toDirectories((List)gosucModule.getAllSourceRoots()));
            this._defaultModule = module;
            this._modules = new ArrayList<DefaultSingleModule>(Collections.singletonList(module));
            module.initializeTypeLoaders();
            CommonServices.getEntityAccess().init();
            FrequentUsedJavaTypeCache.instance(this).init();
        }
        finally {
            this._state = TypeSystemState.STARTED;
        }
    }

    public void uninitializeCompiler() {
        this._state = TypeSystemState.STOPPING;
        try {
            if (this._defaultModule != null) {
                GlobalModule m = (GlobalModule)this._defaultModule;
                m.getModuleTypeLoader().uninitializeTypeLoaders();
                m.getModuleTypeLoader().reset();
                m.configurePaths(Collections.emptyList(), Collections.emptyList());
                GosuClassPathThing.cleanup();
            }
            this._jreModule = null;
        }
        finally {
            this._state = TypeSystemState.STOPPED;
        }
    }

    public void initializeSimpleIde(GosucModule gosucModule) {
        this._state = TypeSystemState.STARTING;
        try {
            DefaultSingleModule module = this._defaultModule == null ? new DefaultSingleModule(this) : (DefaultSingleModule)this._defaultModule;
            module.setNativeModule((INativeModule)gosucModule);
            module.configurePaths(GosucUtil.toDirectories((List)gosucModule.getClasspath()), GosucUtil.toDirectories((List)gosucModule.getAllSourceRoots()));
            this._defaultModule = module;
            this._jreModule = module;
            this._rootModule = module;
            this._modules = new ArrayList<DefaultSingleModule>(Collections.singletonList(module));
            module.initializeTypeLoaders();
            CommonServices.getCoercionManager().init();
        }
        finally {
            this._state = TypeSystemState.STARTED;
        }
    }

    public void uninitializeSimpleIde() {
        this._state = TypeSystemState.STOPPING;
        try {
            if (this._defaultModule != null) {
                DefaultSingleModule m = (DefaultSingleModule)this._defaultModule;
                m.getModuleTypeLoader().uninitializeTypeLoaders();
                m.getModuleTypeLoader().reset();
                m.configurePaths(Collections.emptyList(), Collections.emptyList());
            }
            this._modules.clear();
        }
        finally {
            this._state = TypeSystemState.STOPPED;
        }
    }

    void checkForDuplicates(String moduleName) {
        for (IModule iModule : this.getModules()) {
            if (!iModule.getName().equals(moduleName)) continue;
            throw new RuntimeException("Module " + moduleName + " already exists.");
        }
    }

    public String[] getDiscretePackages() {
        return this._discretePackages;
    }

    public void setDiscretePackages(String[] discretePackages) {
        ArrayList<String> packages = new ArrayList<String>();
        String fromCmdLine = System.getProperty("unloadable.packages");
        if (fromCmdLine != null && !fromCmdLine.isEmpty()) {
            packages.addAll(Arrays.asList(fromCmdLine.split(",")));
        }
        if (discretePackages != null) {
            Arrays.stream(discretePackages).forEach(packages::add);
        }
        this._discretePackages = packages.toArray(new String[packages.size()]);
        for (int i = 0; i < this._discretePackages.length; ++i) {
            int j = i + 1;
            while (j < this._discretePackages.length) {
                if (this._discretePackages[i].startsWith(this._discretePackages[j]) || this._discretePackages[j].startsWith(this._discretePackages[i])) {
                    throw new IllegalStateException("Unloadable packages overlap: " + this._discretePackages[i] + ", " + this._discretePackages[j]);
                }
                ++i;
            }
        }
    }

    public void removeModule(IModule module) {
        this._modules.remove(module);
    }

    public IModule getModule(String strModuleName) {
        for (IModule m : this._modules) {
            if (!m.getName().equals(strModuleName)) continue;
            return m;
        }
        if (!ExecutionMode.isIDE() && "_globalModule".equals(strModuleName) || TypeSystem.getJreModule() == TypeSystem.getGlobalModule()) {
            return this.getGlobalModule();
        }
        return null;
    }

    public IModule getModule(IResource file) {
        List<? extends IModule> modules = this.getModules();
        if (modules.size() == 1) {
            return modules.get(0);
        }
        for (IModule iModule : modules) {
            if (iModule == this._rootModule || !this.isInModule(iModule, file)) continue;
            return iModule;
        }
        if (this.isInModule(this._rootModule, file)) {
            return this._rootModule;
        }
        return null;
    }

    private boolean isInModule(IModule module, IResource file) {
        for (IDirectory src : module.getSourcePath()) {
            if (!file.equals(src) && !file.isDescendantOf(src)) continue;
            return true;
        }
        return false;
    }

    public IModule getModule(URL url) {
        return this.getModule((IResource)CommonServices.getFileSystem().getIFile(url));
    }

    public IModule createJreModule() {
        this._jreModule = new JreModule(this);
        return this._jreModule;
    }

    public IModule getJreModule() {
        if (this._jreModule == null) {
            if (!ExecutionMode.isIDE() || TypeSystem.getJreModule() == TypeSystem.getGlobalModule()) {
                this._jreModule = this.getGlobalModule();
            } else {
                throw new RuntimeException("The JRE module was not created. Please create it before trying to get it.");
            }
        }
        return this._jreModule;
    }

    public IModule getGlobalModule() {
        if (this._rootModule == null) {
            String moduleName = System.getProperty("GW_ROOT_MODULE");
            if (moduleName != null) {
                this._rootModule = this.getModule(moduleName);
                if (this._rootModule == null) {
                    throw new RuntimeException("The specified root module '" + moduleName + "' does not exist.");
                }
            } else {
                this._rootModule = this.findRootModule();
            }
        }
        return this._rootModule;
    }

    public IModule findRootModule() {
        ArrayList<IModule> moduleRoots = new ArrayList<IModule>(this._modules);
        for (IModule module : this._modules) {
            for (Dependency d : module.getDependencies()) {
                moduleRoots.remove(d.getModule());
            }
        }
        return moduleRoots.size() > 0 ? (IModule)moduleRoots.get(0) : null;
    }

    public TypeSystemState getState() {
        return this._state;
    }

    public void renameModule(IModule module, String newName) {
        ((ExecutionEnvironment)module.getExecutionEnvironment()).checkForDuplicates(newName);
        module.setName(newName);
    }

    public String makeGosucProjectFile(String projectClassName) {
        try {
            Class prjClass = ILanguageLevel.Util.STANDARD_GOSU() ? GosucProject.class : Class.forName("com.guidewire.pl.gosuc.PlGosucProject");
            GosucProject gosucProject = (GosucProject)prjClass.getConstructor(IExecutionEnvironment.class).newInstance(this);
            return gosucProject.write();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void shutdown() {
        for (IModule module : this._modules) {
            module.getModuleTypeLoader().shutdown();
        }
        INSTANCES.clear();
        THE_ONE = null;
    }

    private synchronized int getCounter() {
        return this.counter++;
    }

    private void startSneakyDebugThread() {
        if (!((Boolean)BytecodeOptions.JDWP_ENABLED.get()).booleanValue()) {
            return;
        }
        ContextSensitiveCodeRunner blah = new ContextSensitiveCodeRunner();
        Thread sneakyDebugThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized void run() {
                long timestamp = ReloadClassesIndicator.timestamp();
                long now = 0L;
                while (ExecutionEnvironment.this.getState() != TypeSystemState.STOPPED) {
                    try {
                        this.wait(2000L);
                        now = ReloadClassesIndicator.timestamp();
                        if (now <= timestamp) continue;
                        String script = ReloadClassesIndicator.getScript();
                        if (script != null && script.length() > 0) {
                            this.runScript(script);
                            continue;
                        }
                        this.refreshTypes();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        timestamp = now;
                    }
                }
            }

            private void refreshTypes() {
                String[] types = ReloadClassesIndicator.changedTypes();
                System.out.println("Refreshing " + types.length + " types at " + new Date());
                if (types.length > 0) {
                    for (String name : types) {
                        IType type = TypeSystem.getByFullNameIfValid((String)name);
                        if (type == null) continue;
                        TypeSystem.refresh((ITypeRef)((ITypeRef)type));
                        if (!(type instanceof IGosuEnhancementInternal)) continue;
                        ((GosuClassTypeLoader)type.getTypeLoader()).getEnhancementIndex().addEntry(((IGosuEnhancementInternal)type).getEnhancedType(), (IGosuEnhancement)((IGosuEnhancementInternal)type));
                    }
                }
                CommonServices.getEntityAccess().reloadedTypes(types);
            }

            private void runScript(String strScript) {
                String[] result = this.evaluate(strScript);
                if (result[0] != null && result[0].length() > 0) {
                    System.out.print(result[0]);
                }
                if (result[1] != null && result[1].length() > 0) {
                    System.err.print(result[1]);
                }
            }

            public String[] evaluate(String strScript) {
                IGosuParser scriptParser = GosuParserFactory.createParser((String)strScript);
                try {
                    IGosuProgramParser programParser = GosuParserFactory.createProgramParser();
                    String qualifiedName = ReloadClassesIndicator.getQualifiedName();
                    if (qualifiedName == null) {
                        qualifiedName = "_nopackage_.GosuScratchpad" + ExecutionEnvironment.this.getCounter();
                    }
                    ParserOptions options = new ParserOptions().withParser(scriptParser).asThrowawayProgram().withFileContext((IFileContext)new ProgramFileContext(null, qualifiedName));
                    IParseResult parseResult = programParser.parseExpressionOrProgram(strScript, scriptParser.getSymbolTable(), options);
                    Object result = parseResult.getProgram().evaluate(null);
                    if (result != null) {
                        System.out.println("Return Value: " + CommonServices.getCoercionManager().convertValue(result, (IType)JavaTypes.STRING()));
                    }
                }
                catch (Exception e) {
                    for (Throwable t = e; t != null; t = t.getCause()) {
                    }
                    assert (e != null);
                    e.printStackTrace();
                }
                return new String[]{null, null};
            }
        }, CLASS_REDEFINER_THREAD);
        sneakyDebugThread.setDaemon(true);
        sneakyDebugThread.start();
    }

    public static List<IDirectory> createDefaultClassPath() {
        ArrayList<String> vals = new ArrayList<String>();
        vals.add(CommonServices.getEntityAccess().getPluginRepositories().toString());
        vals.add(ExecutionEnvironment.removeQuotes(System.getProperty("java.class.path", "")));
        vals.add(CommonServices.getEntityAccess().getWebServerPaths());
        vals.addAll(ExecutionEnvironment.getJarsContainingSpecialClasses());
        vals.add(System.getProperty("sun.boot.class.path", ""));
        vals.add(System.getProperty("java.ext.dirs", ""));
        return ExecutionEnvironment.expand(vals);
    }

    private static String removeQuotes(String classpath) {
        if (classpath.startsWith("\"")) {
            classpath = classpath.substring(1);
        }
        if (classpath.endsWith("\"")) {
            classpath = classpath.substring(0, classpath.length() - 1);
        }
        return classpath;
    }

    private static List<IDirectory> expand(List<String> paths) {
        LinkedHashSet<IDirectory> expanded = new LinkedHashSet<IDirectory>();
        for (String path : paths) {
            for (String pathElement : path.split(File.pathSeparator)) {
                if (pathElement.length() <= 0) continue;
                File filePath = new File(pathElement);
                IDirectory resource = CommonServices.getFileSystem().getIDirectory(filePath);
                expanded.add(resource);
            }
        }
        return new ArrayList<IDirectory>(expanded);
    }

    public boolean isShadowingMode() {
        return this._project.isShadowMode();
    }

    private static Set<String> getJarsContainingSpecialClasses() {
        HashSet<String> paths = new HashSet<String>();
        for (String className : SPECIAL_CLASSES) {
            Class<?> clazz;
            ExecutionEnvironment.getLogger().debug((Object)("Searching JAR that provides " + className + "."));
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                if (ILanguageLevel.Util.STANDARD_GOSU()) continue;
                ExecutionEnvironment.getLogger().error((Object)("Class " + className + " could not be found. Gosu code might fail to compile at runtime."));
                continue;
            }
            CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
            if (codeSource == null) {
                if (ILanguageLevel.Util.STANDARD_GOSU()) continue;
                ExecutionEnvironment.getLogger().error((Object)("Code source for " + clazz.getName() + " is null. Gosu code might fail to compile at runtime."));
                continue;
            }
            URL jarUrl = codeSource.getLocation();
            String path = jarUrl.getPath();
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if (path.endsWith("!")) {
                path = path.substring(0, path.length() - 1);
            }
            if (path.startsWith("file:")) {
                path = path.substring("file:".length());
            }
            path = path.replaceAll("\\+", "%2B");
            try {
                String decodedPath = URLDecoder.decode(path, "UTF-8");
                if (new File(decodedPath).exists()) {
                    paths.add(path);
                    continue;
                }
                ExecutionEnvironment.getLogger().error((Object)("Could not extract filesystem path from the url " + jarUrl.getPath() + ". Gosu code that requires classes from that JAR might fail to compile at runtime."));
            }
            catch (UnsupportedEncodingException ex) {
                throw GosuExceptionUtil.forceThrow((Throwable)ex);
            }
        }
        return paths;
    }

    private static ILogger getLogger() {
        return CommonServices.getEntityAccess().getLogger();
    }

    static {
        SPECIAL_CLASSES = Arrays.asList("javax.servlet.Servlet", "javax.servlet.http.HttpServletRequest");
    }

    private static class DefaultSingleModuleRuntimeProject
    implements IProject {
        private DefaultSingleModuleRuntimeProject() {
        }

        public String getName() {
            return this.getClass().getSimpleName();
        }

        public Object getNativeProject() {
            return this;
        }

        public boolean isDisposed() {
            return false;
        }

        public String toString() {
            return "Default Single Runtime Execution Environment";
        }

        public boolean isHeadless() {
            return false;
        }

        public boolean isShadowMode() {
            return false;
        }
    }
}

