/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.config.CommonServices;
import gw.internal.gosu.parser.GosuParser;
import gw.internal.gosu.parser.IGosuProgramInternal;
import gw.internal.gosu.parser.TypeLord;
import gw.internal.gosu.parser.TypeUsesMap;
import gw.internal.gosu.parser.expressions.EvalExpression;
import gw.internal.gosu.template.TemplateTokenizerInstructor;
import gw.lang.parser.ICapturedSymbol;
import gw.lang.parser.IFileContext;
import gw.lang.parser.IGosuProgramParser;
import gw.lang.parser.IParseResult;
import gw.lang.parser.IParseTree;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.ISymbolTable;
import gw.lang.parser.ITypeUsesMap;
import gw.lang.parser.ParseResult;
import gw.lang.parser.ParserOptions;
import gw.lang.parser.exceptions.ParseResultsException;
import gw.lang.parser.statements.IClassStatement;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.ClassType;
import gw.lang.reflect.gs.GosuClassTypeLoader;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuProgram;
import gw.lang.reflect.gs.ISourceFileHandle;
import gw.lang.reflect.gs.StringSourceFileHandle;
import gw.lang.reflect.module.IModule;
import gw.util.GosuStringUtil;
import java.util.List;

public class GosuProgramParser
implements IGosuProgramParser {
    private static int g_iIndex;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IParseResult parseEval(String strSource, List<ICapturedSymbol> captured, IType enclosingClass, IParsedElement ctxElem, ISymbolTable extSyms) {
        TypeSystem.lock();
        try {
            ITypeUsesMap typeUsedMap;
            IGosuProgramInternal program;
            String typeName = GosuProgramParser.makeEvalKey(strSource, enclosingClass, ctxElem);
            if (ctxElem instanceof EvalExpression && (program = ((EvalExpression)ctxElem).getCachedProgram(typeName)) != null) {
                program.isValid();
                ParseResult parseResult = new ParseResult((IGosuProgram)program);
                return parseResult;
            }
            StringSourceFileHandle sfh = new StringSourceFileHandle(typeName, (CharSequence)strSource, false, ClassType.Eval);
            if (enclosingClass != null) {
                sfh.setParentType(enclosingClass.getName());
            }
            if ((typeUsedMap = this.getTypeUsedMapFrom(ctxElem)) != null) {
                sfh.setTypeUsesMap(typeUsedMap);
            }
            if (ctxElem instanceof EvalExpression) {
                sfh.setCapturedTypeVars(((EvalExpression)ctxElem).getCapturedTypeVars());
            }
            program = (IGosuProgramInternal)GosuClassTypeLoader.getDefaultClassLoader().makeNewClass((ISourceFileHandle)sfh, null);
            program.setEnclosingEvalExpression(ctxElem);
            if (captured != null) {
                for (ICapturedSymbol sym : captured) {
                    program.getParseInfo().addCapturedSymbolSilent(sym);
                }
            }
            sfh.setExternalSymbols(extSyms);
            program.isValid();
            if (ctxElem instanceof EvalExpression) {
                ((EvalExpression)ctxElem).cacheProgram(typeName, program);
            }
            ParseResult parseResult = new ParseResult((IGosuProgram)program);
            return parseResult;
        }
        finally {
            TypeSystem.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IParseResult parseRuntimeExpr(String typeName, String strSource, IGosuClass enclosingClass, ISymbolTable extSyms) {
        TypeSystem.lock();
        try {
            ITypeUsesMap typeUsedMap;
            StringSourceFileHandle sfh = new StringSourceFileHandle(typeName, (CharSequence)strSource, false, ClassType.Eval);
            if (enclosingClass != null) {
                sfh.setParentType(enclosingClass.getName());
            }
            if ((typeUsedMap = enclosingClass.getTypeUsesMap()) != null) {
                sfh.setTypeUsesMap(typeUsedMap);
            }
            IGosuProgramInternal program = (IGosuProgramInternal)GosuClassTypeLoader.getDefaultClassLoader().makeNewClass((ISourceFileHandle)sfh, null);
            sfh.setExternalSymbols(extSyms);
            program.isValid();
            ParseResult parseResult = new ParseResult((IGosuProgram)program);
            return parseResult;
        }
        finally {
            TypeSystem.unlock();
        }
    }

    public static String makeEvalKey(String strSource, IType enclosingClass, IParsedElement ctxElem) {
        return GosuProgramParser.makeEvalKey(strSource, enclosingClass, GosuProgramParser.getEvalExprLocationOffset(ctxElem));
    }

    public static String makeEvalKey(String source, IType enclosingClass, int offset) {
        if (enclosingClass == null) {
            return "toplevel.__Program__eval_0_" + GosuStringUtil.getSHA1String((String)source);
        }
        return enclosingClass.getName() + '.' + "__Program__" + "eval_" + offset + "_" + GosuStringUtil.getSHA1String((String)source);
    }

    private ITypeUsesMap getTypeUsedMapFrom(IParsedElement ctxElem) {
        if (ctxElem instanceof EvalExpression) {
            return ((EvalExpression)ctxElem).getTypeUsesMap();
        }
        IGosuClass gsClass = ctxElem.getGosuClass();
        if (gsClass != null) {
            return ((IGosuClass)TypeLord.getOuterMostEnclosingClass((IType)gsClass)).getTypeUsesMap().copy();
        }
        return new TypeUsesMap();
    }

    private static int getEvalExprLocationOffset(IParsedElement evalExpr) {
        if (evalExpr == null) {
            return GosuProgramParser.getIndex();
        }
        IParseTree location = evalExpr.getLocation();
        return location != null ? location.getOffset() : GosuProgramParser.getIndex();
    }

    public IParseResult parseExpressionOnly(String strSource, ISymbolTable symTable, ParserOptions options) throws ParseResultsException {
        return this.parseExpressionOrProgram(strSource, symTable, options);
    }

    public IParseResult parseProgramOnly(String strSource, ISymbolTable symTable, ParserOptions options) throws ParseResultsException {
        return this.parseExpressionOrProgram(strSource, symTable, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IParseResult parseExpressionOrProgram(String strSource, ISymbolTable symTable, ParserOptions options) throws ParseResultsException {
        TypeSystem.lock();
        try {
            int index = GosuProgramParser.getIndex();
            String name = null;
            IFileContext fileContext = options.getFileContext();
            if (fileContext != null) {
                name = fileContext.getClassName();
            }
            if (name == null) {
                name = "program_.__Program__" + index;
            }
            if (fileContext != null && fileContext.getContextString() != null) {
                name = name + "_" + fileContext.getContextString();
            }
            StringSourceFileHandle sfh = new StringSourceFileHandle(name, (CharSequence)strSource, false, ClassType.Program);
            if (fileContext != null) {
                sfh.setFilePath(fileContext.getFilePath());
            }
            sfh.setParentType(options.getEnclosingType());
            sfh.setTypeUsesMap(options.getTypeUsesMap());
            IGosuProgramInternal program = this.makeProgramClass(symTable, sfh);
            if (options.getParser() != null) {
                program.setEditorParser((GosuParser)options.getParser());
                program.setCreateEditorParser(options.getParser().isEditorParser());
            }
            program.setGenRootExprAccess(options.isBGenRootExprAccess());
            program.setExpectedReturnType(options.getExpectedType());
            program.setTokenizerInstructor(options.getTi());
            program.setSuperType(options.getSuperType());
            program.setAdditionalDFSDecls(options.getAdditionalDFSDecls());
            program.setStatementsOnly(options.isStatementsOnly());
            program.setThrowaway(options.isThrowawayProgram());
            program.setAnonymous(program.isAnonymous() || options.isAnonymous());
            program.setAllowUses(options.allowUses());
            program.setCtxInferenceMgr(options.getCtxInferenceMgr());
            if (options.getScriptPartId() != null) {
                program.setContextType(options.getScriptPartId().getContainingType());
            }
            if (!program.isValid()) {
                throw program.getParseResultsException();
            }
            if (options.getParser() != null) {
                try {
                    IClassStatement classStatement = program.getClassStatement();
                    IParsedElement parent = classStatement.getParent();
                    IParsedElement pe = parent != null ? parent : classStatement;
                    ((GosuParser)options.getParser()).verifyParsedElement(pe);
                }
                catch (ParseResultsException pre) {
                    program.setParseResultsException(pre);
                }
            }
            ParseResult parseResult = new ParseResult((IGosuProgram)program);
            return parseResult;
        }
        finally {
            TypeSystem.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IParseResult parseTemplate(String strSource, ISymbolTable symTable, ParserOptions options) throws ParseResultsException {
        TypeSystem.lock();
        try {
            int index = GosuProgramParser.getIndex();
            String name = null;
            if (options.getFileContext() != null) {
                name = options.getFileContext().getClassName();
            }
            if (name == null) {
                name = "program_.__Program__" + index;
            }
            if (options.getFileContext() != null && options.getFileContext().getContextString() != null) {
                name = name + "_" + options.getFileContext().getContextString();
            }
            StringSourceFileHandle sfh = new StringSourceFileHandle(name, (CharSequence)strSource, false, ClassType.Template);
            if (options.getFileContext() != null) {
                sfh.setFilePath(options.getFileContext().getFilePath());
            }
            sfh.setTypeUsesMap(options.getTypeUsesMap());
            IGosuProgramInternal program = this.makeProgramClass(symTable, sfh);
            if (options.getParser() != null) {
                program.setEditorParser((GosuParser)options.getParser());
                program.setCreateEditorParser(options.getParser().isEditorParser());
            }
            program.setGenRootExprAccess(options.isBGenRootExprAccess());
            program.setExpectedReturnType(options.getExpectedType());
            program.setTokenizerInstructor(options.getTi());
            program.setSuperType(options.getSuperType());
            program.setAdditionalDFSDecls(options.getAdditionalDFSDecls());
            program.setStatementsOnly(options.isStatementsOnly());
            program.setThrowaway(options.isThrowawayProgram());
            program.setAllowUses(options.allowUses());
            program.setCtxInferenceMgr(options.getCtxInferenceMgr());
            if (options.getScriptPartId() != null) {
                program.setContextType(options.getScriptPartId().getContainingType());
            }
            program.setTokenizerInstructor(new TemplateTokenizerInstructor(options.getParser().getTokenizer()));
            if (!program.isValid()) {
                throw program.getParseResultsException();
            }
            if (options.getParser() != null) {
                try {
                    IParsedElement pe = program.getClassStatement().getParent();
                    pe = pe == null ? program.getClassStatement() : pe;
                    ((GosuParser)options.getParser()).verifyParsedElement(pe);
                }
                catch (ParseResultsException pre) {
                    program.setParseResultsException(pre);
                }
            }
            ParseResult parseResult = new ParseResult((IGosuProgram)program);
            return parseResult;
        }
        finally {
            TypeSystem.unlock();
        }
    }

    private IGosuProgramInternal makeProgramClass(ISymbolTable symTable, StringSourceFileHandle sfh) {
        IModule module = TypeSystem.getCurrentModule();
        module = module == null ? TypeSystem.getGlobalModule() : module;
        GosuClassTypeLoader defaultClassLoader = (GosuClassTypeLoader)CommonServices.getTypeSystem().getTypeLoader(GosuClassTypeLoader.class, module);
        return (IGosuProgramInternal)defaultClassLoader.makeNewClass((ISourceFileHandle)sfh, symTable);
    }

    private static synchronized int getIndex() {
        return g_iIndex++;
    }
}

