/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.parser.LocalClassForNameHack;
import gw.internal.gosu.parser.MetaType;
import gw.lang.reflect.BaseFeatureInfo;
import gw.lang.reflect.FeatureManager;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IEventInfo;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IMetaType;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IParameterInfo;
import gw.lang.reflect.IPropertyAccessor;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeDeprecated;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.ITypeInfoMethodInfo;
import gw.lang.reflect.ITypeInfoPropertyInfo;
import gw.lang.reflect.MetaMethodInfoDelegate;
import gw.lang.reflect.MetaPropertyInfoDelegate;
import gw.lang.reflect.MethodInfoDelegate;
import gw.lang.reflect.MethodList;
import gw.lang.reflect.PropertyInfoBase;
import gw.lang.reflect.PropertyInfoDelegate;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.IJavaType;
import gw.lang.reflect.java.JavaTypes;
import gw.lang.reflect.module.IModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public class MetaTypeTypeInfo
extends BaseFeatureInfo
implements IRelativeTypeInfo {
    private FeatureManager _fm;
    private Map<IModule, List<IMethodInfo>> _declaredMethods = new ConcurrentHashMap<IModule, List<IMethodInfo>>();
    private Map<IModule, List<IPropertyInfo>> _declaredProperties = new ConcurrentHashMap<IModule, List<IPropertyInfo>>();

    public MetaTypeTypeInfo(MetaType intrType) {
        super((IType)intrType);
        this._fm = new FeatureManager((IRelativeTypeInfo)this, true);
    }

    public String getName() {
        return this.getOwnersType().getType().getTypeInfo().getName() + " Type";
    }

    public IMetaType getOwnersType() {
        return (IMetaType)super.getOwnersType();
    }

    public boolean isStatic() {
        return true;
    }

    public List<? extends IPropertyInfo> getProperties() {
        return this.getProperties(null);
    }

    public IPropertyInfo getProperty(CharSequence propName) {
        return this.getProperty(null, propName);
    }

    public IPropertyInfo getProperty(IType whosAskin, CharSequence propName) {
        return this._fm.getProperty(this.getAccessibilityForType(whosAskin), propName);
    }

    public MethodList getMethods() {
        return this.getMethods((IType)null);
    }

    public IMethodInfo getMethod(CharSequence methodName, IType ... params) {
        return ITypeInfo.FIND.method((MethodList)this.getMethods(), (CharSequence)methodName, (IType[])params);
    }

    public List<IConstructorInfo> getConstructors() {
        return Collections.emptyList();
    }

    public IConstructorInfo getConstructor(IType ... params) {
        return null;
    }

    public IMethodInfo getCallableMethod(CharSequence strMethod, IType ... params) {
        return ITypeInfo.FIND.callableMethod((MethodList)this.getMethods(), (CharSequence)strMethod, (IType[])params);
    }

    public IConstructorInfo getCallableConstructor(IType ... params) {
        return ITypeInfo.FIND.callableConstructor(this.getConstructors(), (IType[])params);
    }

    public List<IEventInfo> getEvents() {
        return Collections.emptyList();
    }

    public IEventInfo getEvent(CharSequence strEvent) {
        return null;
    }

    private void addForNameMethod(MethodList methods) {
        if (ITypeInfo.FIND.method((MethodList)methods, (CharSequence)"forName", (IType[])new IType[]{JavaTypes.STRING()}) == null) {
            IType iIntrinsicType = TypeSystem.getByFullName((String)LocalClassForNameHack.class.getName(), (IModule)TypeSystem.getGlobalModule());
            StaticMethodInfoDelegate forName = new StaticMethodInfoDelegate((IFeatureInfo)this, iIntrinsicType.getTypeInfo().getMethod((CharSequence)"forName", new IType[]{JavaTypes.STRING()})){

                public boolean isDeprecated() {
                    IMetaType ownerType = (IMetaType)this.getOwnersType();
                    return super.isDeprecated() || ownerType.isLiteral() && !(ownerType.getType() instanceof IMetaType);
                }

                public String getDeprecatedReason() {
                    return "Access this method from the Type property e.g., SomeType.Type." + this.getName();
                }
            };
            methods.add((IMethodInfo)forName);
        }
    }

    private Map<CharSequence, IPropertyInfo> mergeProperties(ITypeInfo typeTypeInfo) {
        HashMap<CharSequence, IPropertyInfo> propertiesByName = new HashMap<CharSequence, IPropertyInfo>();
        if (!this.getOwnersType().isLiteral() || this.getOwnersType().getType() instanceof IMetaType) {
            this.loadMetaTypeProperties(propertiesByName);
        } else {
            DeprecatedStaticPropertyInfoDelegate pi;
            IJavaType intrinsicTypeClass = JavaTypes.getGosuType(ITypeDeprecated.class);
            ITypeInfo intrinsicTypeClassInfo = intrinsicTypeClass.getTypeInfo();
            List properties = intrinsicTypeClassInfo.getProperties();
            if (properties != null) {
                for (IPropertyInfo property : properties) {
                    pi = new DeprecatedStaticPropertyInfoDelegate((IFeatureInfo)this, property);
                    propertiesByName.put(pi.getName(), (IPropertyInfo)pi);
                }
            }
            if ((properties = typeTypeInfo instanceof IRelativeTypeInfo ? ((IRelativeTypeInfo)typeTypeInfo).getProperties(typeTypeInfo.getOwnersType()) : typeTypeInfo.getProperties()) != null) {
                for (IPropertyInfo property : properties) {
                    if (!property.isStatic()) continue;
                    pi = new PropertyInfoDelegate((IFeatureInfo)this, property);
                    propertiesByName.put(pi.getName(), (IPropertyInfo)pi);
                }
            }
            this.addTypeProperty(propertiesByName);
        }
        return propertiesByName;
    }

    private void addTypeProperty(Map<CharSequence, IPropertyInfo> propertiesByName) {
        TypeProperty pi = new TypeProperty();
        IPropertyInfo existing = propertiesByName.get(pi.getName());
        if (existing == null || !existing.getName().equals(pi.getName())) {
            propertiesByName.put(pi.getName(), (IPropertyInfo)pi);
        }
    }

    private List<? extends IMethodInfo> getMethods(ITypeInfo typeInfo) {
        if (typeInfo instanceof IRelativeTypeInfo) {
            return ((IRelativeTypeInfo)typeInfo).getMethods(typeInfo.getOwnersType());
        }
        return typeInfo.getMethods();
    }

    private MethodList mergeMethods(ITypeInfo typeTypeInfo) {
        HashSet<IMethodInfo> tempMethods = new HashSet<IMethodInfo>();
        if (!this.getOwnersType().isLiteral() || this.getOwnersType().getType() instanceof IMetaType) {
            this.loadMetaTypeMethods(tempMethods);
        } else {
            DeprecatedStaticMethodInfoDelegate mi;
            IJavaType intrinsicTypeClass = JavaTypes.getGosuType(ITypeDeprecated.class);
            ITypeInfo intrinsicTypeClassInfo = intrinsicTypeClass.getTypeInfo();
            List<? extends IMethodInfo> methods = this.getMethods(intrinsicTypeClassInfo);
            for (IMethodInfo iMethodInfo : methods) {
                mi = new DeprecatedStaticMethodInfoDelegate((IFeatureInfo)this, iMethodInfo);
                tempMethods.add((IMethodInfo)mi);
            }
            methods = this.getMethods(typeTypeInfo);
            for (IMethodInfo iMethodInfo : methods) {
                if (!iMethodInfo.isStatic()) continue;
                mi = new MethodInfoDelegate((IFeatureInfo)this, iMethodInfo);
                tempMethods.add((IMethodInfo)mi);
            }
        }
        MethodList result = new MethodList();
        result.addAll(tempMethods);
        return result;
    }

    public List<IAnnotationInfo> getDeclaredAnnotations() {
        return Collections.emptyList();
    }

    public IRelativeTypeInfo.Accessibility getAccessibilityForType(IType whosAskin) {
        IType ownersClass = this.getOwnersType().getType();
        if (ownersClass == null || whosAskin == null) {
            return IRelativeTypeInfo.Accessibility.PUBLIC;
        }
        if (this.canAccessPrivateMembers(ownersClass, whosAskin)) {
            return IRelativeTypeInfo.Accessibility.PRIVATE;
        }
        return FeatureManager.getAccessibilityForClass((IType)ownersClass, (IType)whosAskin);
    }

    private boolean canAccessPrivateMembers(IType ownersClass, IType whosAskin) {
        return this.getOwnersType() == whosAskin || this.getTopLevelTypeName(whosAskin).equals(this.getTopLevelTypeName(ownersClass));
    }

    private String getTopLevelTypeName(IType type) {
        while (type.getEnclosingType() != null) {
            type = type.getEnclosingType();
        }
        return type.getName();
    }

    public List<? extends IPropertyInfo> getProperties(IType whosaskin) {
        return this._fm.getProperties(this.getAccessibilityForType(whosaskin));
    }

    public MethodList getMethods(IType whosAskin) {
        return this._fm.getMethods(this.getAccessibilityForType(whosAskin));
    }

    public IMethodInfo getMethod(IType whosaskin, CharSequence methodName, IType ... params) {
        MethodList methods = this.getMethods(whosaskin);
        return ITypeInfo.FIND.method((MethodList)methods, (CharSequence)methodName, (IType[])params);
    }

    public List<? extends IConstructorInfo> getConstructors(IType whosaskin) {
        return Collections.emptyList();
    }

    public IConstructorInfo getConstructor(IType whosAskin, IType[] params) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<? extends IPropertyInfo> getDeclaredProperties() {
        IModule module = TypeSystem.getCurrentModule();
        List<IPropertyInfo> declaredProperties = this._declaredProperties.get(module);
        if (declaredProperties == null) {
            TypeSystem.lock();
            try {
                declaredProperties = this._declaredProperties.get(module);
                if (declaredProperties == null) {
                    ITypeInfo typeTypeInfo = this.getOwnersType().getType().getTypeInfo();
                    Map<CharSequence, IPropertyInfo> propertiesByName = this.mergeProperties(typeTypeInfo);
                    declaredProperties = new ArrayList<IPropertyInfo>(propertiesByName.values());
                    this._declaredProperties.put(module, declaredProperties);
                }
            }
            finally {
                TypeSystem.unlock();
            }
        }
        return declaredProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<? extends IMethodInfo> getDeclaredMethods() {
        IModule module = TypeSystem.getCurrentModule();
        MethodList declaredMethods = this._declaredMethods.get(module);
        if (declaredMethods == null) {
            TypeSystem.lock();
            try {
                declaredMethods = this._declaredMethods.get(module);
                if (declaredMethods == null) {
                    ITypeInfo typeTypeInfo = this.getOwnersType().getType().getTypeInfo();
                    MethodList methods = this.mergeMethods(typeTypeInfo);
                    this.addForNameMethod(methods);
                    declaredMethods = methods;
                    this._declaredMethods.put(module, (List<IMethodInfo>)declaredMethods);
                }
            }
            finally {
                TypeSystem.unlock();
            }
        }
        return declaredMethods;
    }

    public List<? extends IConstructorInfo> getDeclaredConstructors() {
        return Collections.emptyList();
    }

    private void loadMetaTypeProperties(Map<CharSequence, IPropertyInfo> properties) {
        IType type = this.getOwnersType().getType();
        if (type != null) {
            Set<IType> allTypes = this.getTypeInterfaces(this.getTypeOfType(type), this.makeTreeSet());
            for (IType t : allTypes) {
                for (IPropertyInfo pi : t.getTypeInfo().getProperties()) {
                    IPropertyInfo existing = properties.get(pi.getName());
                    if (existing != null && !existing.getFeatureType().isAssignableFrom(pi.getFeatureType())) continue;
                    properties.put(pi.getName(), (IPropertyInfo)new MetaPropertyInfoDelegate((ITypeInfo)this, pi));
                }
            }
        }
    }

    private TreeSet<IType> makeTreeSet() {
        return new TreeSet<IType>(new Comparator<IType>(){

            @Override
            public int compare(IType o1, IType o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
    }

    private IType getTypeOfType(IType type) {
        return TypeSystem.get(type.getClass(), (IModule)TypeSystem.getGlobalModule());
    }

    private void loadMetaTypeMethods(Set<IMethodInfo> methods) {
        IType type = this.getOwnersType().getType();
        if (type != null) {
            Set<IType> allTypes = this.getTypeInterfaces(this.getTypeOfType(type), this.makeTreeSet());
            for (IType t : allTypes) {
                for (IMethodInfo pi : t.getTypeInfo().getMethods()) {
                    if (!this.shouldAddMethod(methods, pi)) continue;
                    methods.add((IMethodInfo)new MetaMethodInfoDelegate((ITypeInfo)this, pi));
                }
            }
        }
    }

    private boolean shouldAddMethod(Set<IMethodInfo> methodInfos, IMethodInfo candidate) {
        Iterator<IMethodInfo> iterator = methodInfos.iterator();
        while (iterator.hasNext()) {
            MetaMethodInfoDelegate current = (MetaMethodInfoDelegate)iterator.next();
            if (current.getBackingMethodInfo().equals(candidate)) {
                return false;
            }
            if (!current.getDisplayName().equals(candidate.getDisplayName()) || !this.areParameterTypesEqual((IMethodInfo)current, candidate)) continue;
            boolean isCovariantOverride = current.getReturnType().isAssignableFrom(candidate.getReturnType());
            if (isCovariantOverride) {
                iterator.remove();
            }
            return isCovariantOverride;
        }
        return true;
    }

    private boolean areParameterTypesEqual(IMethodInfo methodInfo, IMethodInfo candidate) {
        IParameterInfo[] params2;
        IParameterInfo[] params1 = methodInfo.getParameters();
        if (params1.length == (params2 = candidate.getParameters()).length) {
            int l = params1.length;
            for (int i = 0; i < l; ++i) {
                IParameterInfo p1 = params1[i];
                IParameterInfo p2 = params2[i];
                if (p1.getFeatureType().equals(p2.getFeatureType())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private Set<IType> getTypeInterfaces(IType type, Set<IType> set) {
        if (this.getOwnersType().getType() == MetaType.DEFAULT_TYPE.get()) {
            return Collections.singleton(JavaTypes.ITYPE());
        }
        for (IType iface : type.getInterfaces()) {
            if (!iface.getNamespace().startsWith("gw.internal")) {
                set.add(iface);
                continue;
            }
            this.getTypeInterfaces(iface, set);
        }
        return set;
    }

    public class TypeProperty
    extends PropertyInfoBase {
        private IPropertyAccessor _accessor;

        public TypeProperty() {
            super((ITypeInfo)MetaTypeTypeInfo.this);
        }

        public boolean isStatic() {
            return true;
        }

        public boolean isReadable() {
            return true;
        }

        public boolean isWritable(IType whosAskin) {
            return false;
        }

        public IPropertyAccessor getAccessor() {
            return this._accessor != null ? this._accessor : (this._accessor = new IPropertyAccessor(){

                public Object getValue(Object ctx) {
                    return MetaTypeTypeInfo.this.getOwnersType().getType();
                }

                public void setValue(Object ctx, Object value) {
                    throw new IllegalStateException();
                }
            });
        }

        public List<IAnnotationInfo> getDeclaredAnnotations() {
            return Collections.emptyList();
        }

        public boolean isDefaultImpl() {
            return false;
        }

        public String getName() {
            return "Type";
        }

        public IType getFeatureType() {
            return MetaType.get(MetaTypeTypeInfo.this.getOwnersType().getType());
        }
    }

    private static class DeprecatedStaticMethodInfoDelegate
    extends StaticMethodInfoDelegate
    implements ITypeInfoMethodInfo {
        public DeprecatedStaticMethodInfoDelegate(IFeatureInfo container, IMethodInfo source) {
            super(container, source);
        }

        public boolean isDeprecated() {
            return true;
        }

        public IMethodInfo getBackingMethodInfo() {
            return this.getSource();
        }

        public String getDeprecatedReason() {
            return "Access this method from the Type property e.g., SomeType.Type." + this.getName();
        }
    }

    private static class StaticMethodInfoDelegate
    extends MethodInfoDelegate {
        public StaticMethodInfoDelegate(IFeatureInfo container, IMethodInfo source) {
            super(container, source);
        }

        public boolean isStatic() {
            return true;
        }
    }

    private static class DeprecatedStaticPropertyInfoDelegate
    extends PropertyInfoDelegate
    implements ITypeInfoPropertyInfo {
        public DeprecatedStaticPropertyInfoDelegate(IFeatureInfo container, IPropertyInfo source) {
            super(container, source);
        }

        public boolean isStatic() {
            return true;
        }

        public boolean isDeprecated() {
            return true;
        }

        public IPropertyInfo getBackingPropertyInfo() {
            return this.getDelegatePI();
        }

        public String getDeprecatedReason() {
            return "Access this property from the Type property e.g., SomeType.Type." + this.getName();
        }

        public boolean isDefaultImpl() {
            return false;
        }
    }
}

