/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.properties;

import gw.fs.IDirectory;
import gw.fs.IFile;
import gw.internal.gosu.properties.PropertiesPropertySet;
import gw.internal.gosu.properties.PropertiesType;
import gw.internal.gosu.properties.PropertyNode;
import gw.internal.gosu.properties.PropertySet;
import gw.internal.gosu.properties.PropertySetSource;
import gw.internal.gosu.properties.SystemPropertiesPropertySet;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeRef;
import gw.lang.reflect.RefreshKind;
import gw.lang.reflect.TypeLoaderBase;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.module.IModule;
import gw.util.concurrent.LockingLazyVar;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PropertiesTypeLoader
extends TypeLoaderBase {
    public static final Set<String> EXTENSIONS = Collections.singleton("properties");
    private static final String FILE_EXTENSION = "properties";
    private static final String DISPLAY_PROPERTIES = "display.properties";
    protected Set<String> _namespaces;
    private List<PropertySetSource> _sources;
    private final LockingLazyVar<Map<PropertySetSource, TypeNameSet>> _rootTypeNames = new LockingLazyVar<Map<PropertySetSource, TypeNameSet>>(){

        protected Map<PropertySetSource, TypeNameSet> init() {
            HashMap<PropertySetSource, TypeNameSet> result = new HashMap<PropertySetSource, TypeNameSet>();
            for (PropertySetSource source : PropertiesTypeLoader.this._sources) {
                result.put(source, new TypeNameSet(source.getPropertySetNames()));
            }
            return result;
        }
    };

    public PropertiesTypeLoader(IModule module) {
        super(module);
        this.initSources(module);
    }

    private void initSources(IModule module) {
        this._sources = Arrays.asList(SystemPropertiesPropertySet.SOURCE, new PropertiesPropertySet.Source(module));
    }

    public Set<String> computeTypeNames() {
        HashSet<String> result = new HashSet<String>();
        for (TypeNameSet names : ((Map)this._rootTypeNames.get()).values()) {
            names.addTo(result);
        }
        return result;
    }

    public List<String> getHandledPrefixes() {
        return Collections.emptyList();
    }

    public boolean handlesNonPrefixLoads() {
        return true;
    }

    public boolean handlesFile(IFile file) {
        return FILE_EXTENSION.equalsIgnoreCase(file.getExtension()) && !PropertiesTypeLoader.isDisplayPropertiesFile(file.getName());
    }

    public static boolean isDisplayPropertiesFile(String fileName) {
        return fileName.toLowerCase().endsWith(DISPLAY_PROPERTIES);
    }

    public IType getType(String fullyQualifiedName) {
        for (PropertySetSource source : this._sources) {
            TypeNameSet typeNameSet = (TypeNameSet)((Map)this._rootTypeNames.get()).get(source);
            if (typeNameSet == null) continue;
            List<String> possibleMatches = typeNameSet.findMatchesFor(fullyQualifiedName);
            for (String possibleMatch : possibleMatches) {
                Map<String, IType> propertySetTypes = this.createPropertyTypesForPropertySetWithName(source, possibleMatch);
                if (!propertySetTypes.containsKey(fullyQualifiedName)) continue;
                return propertySetTypes.get(fullyQualifiedName);
            }
        }
        return null;
    }

    public void refreshedImpl() {
        this._rootTypeNames.clear();
    }

    private Map<String, IType> createPropertyTypesForPropertySetWithName(PropertySetSource source, String name) {
        HashMap<String, IType> resultMap = new HashMap<String, IType>();
        this.createPropertyTypesFromPropertyNodeTree(resultMap, PropertyNode.buildTree(source.getPropertySet(name)), source.getFile(name));
        return resultMap;
    }

    private IType createPropertyTypesFromPropertyNodeTree(HashMap<String, IType> resultMap, PropertyNode node, IFile file) {
        ITypeRef result = TypeSystem.getOrCreateTypeReference((IType)new PropertiesType(this, node, file));
        resultMap.put(result.getName(), (IType)result);
        for (PropertyNode child : node.getChildren()) {
            if (child.isLeaf()) continue;
            this.createPropertyTypesFromPropertyNodeTree(resultMap, child, file);
        }
        return result;
    }

    public String[] getTypesForFile(IFile file) {
        ArrayList<String> types = new ArrayList<String>();
        boolean foundSource = false;
        for (PropertySetSource source : this._sources) {
            PropertySet ps = source.getPropertySetForFile(file);
            if (ps == null) continue;
            foundSource = true;
            HashMap<String, IType> resultMap = new HashMap<String, IType>();
            this.createPropertyTypesFromPropertyNodeTree(resultMap, PropertyNode.buildTree(ps), file);
            for (IType type : resultMap.values()) {
                types.add(type.getName());
            }
        }
        if (!foundSource) {
            this.initSources(this._module);
            this._rootTypeNames.clear();
        }
        return types.toArray(new String[types.size()]);
    }

    public RefreshKind refreshedFile(IFile file, String[] types, RefreshKind kind) {
        this._rootTypeNames.clear();
        return kind;
    }

    public boolean hasNamespace(String namespace) {
        return this.getAllNamespaces().contains(namespace);
    }

    public Set<String> getAllNamespaces() {
        if (this._namespaces == null) {
            try {
                this._namespaces = TypeSystem.getNamespacesFromTypeNames((Set)this.getAllTypeNames(), new HashSet());
            }
            catch (NullPointerException e) {
                return Collections.emptySet();
            }
        }
        return this._namespaces;
    }

    public void refreshedNamespace(String namespace, IDirectory dir, RefreshKind kind) {
        if (this._namespaces != null) {
            if (kind == RefreshKind.CREATION) {
                this._namespaces.add(namespace);
            } else if (kind == RefreshKind.DELETION) {
                this._namespaces.remove(namespace);
            }
        }
    }

    static class TypeNameSet {
        private final String[] _names;

        public TypeNameSet(Set<String> names) {
            this._names = names.toArray(new String[names.size()]);
            Arrays.sort(this._names, String.CASE_INSENSITIVE_ORDER);
        }

        public void addTo(Collection<String> names) {
            names.addAll(Arrays.asList(this._names));
        }

        public List<String> findMatchesFor(String fullName) {
            List<String> result = Collections.emptyList();
            for (int index = this.getIndexOfLastPossibleMatch(fullName); index >= 0 && this.isPrefix(this._names[index], fullName); --index) {
                if (!this.isMatch(this._names[index], fullName)) continue;
                if (result.isEmpty()) {
                    result = new ArrayList<String>();
                }
                result.add(this._names[index]);
            }
            return result;
        }

        private int getIndexOfLastPossibleMatch(String fullName) {
            int index = Arrays.binarySearch(this._names, fullName, String.CASE_INSENSITIVE_ORDER);
            if (index < 0) {
                int insertionPoint = -index - 1;
                index = insertionPoint - 1;
            }
            return index;
        }

        private boolean isPrefix(String possiblePrefix, String fullName) {
            return fullName.regionMatches(true, 0, possiblePrefix, 0, possiblePrefix.length());
        }

        private boolean isMatch(String prefix, String fullName) {
            return fullName.equalsIgnoreCase(prefix) || fullName.charAt(prefix.length()) == '.';
        }
    }
}

