package gw.internal.gosu.parser;

/**
 * Base class for extended Java types.
 * <p/>
 * NOTE: The structure of this class is tightly coupled to the generation of bytecode in {@link JavaTypeExtensions}.
 * Please do not change it without understanding the associated changes that may be required in the generated bytecode.
 *
 * @see JavaTypeExtensions
 */
public abstract class AbstractExtendedType {
  protected final IJavaTypeInternal _primary;

  protected AbstractExtendedType(IJavaTypeInternal primary) {
    _primary = primary;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    AbstractExtendedType that = (AbstractExtendedType) o;

    return _primary.equals(that._primary);

  }

  @Override
  public int hashCode() {
    return _primary.hashCode();
  }

  @Override
  public String toString() {
    return _primary.toString();
  }
}
