/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.ir.transform.expression;

import gw.config.CommonServices;
import gw.internal.gosu.ir.nodes.IRProperty;
import gw.internal.gosu.ir.nodes.IRPropertyFactory;
import gw.internal.gosu.ir.transform.ExpressionTransformer;
import gw.internal.gosu.ir.transform.TopLevelTransformationContext;
import gw.internal.gosu.ir.transform.expression.AbstractExpressionTransformer;
import gw.internal.gosu.ir.transform.expression.MemberExpansionAccessTransformer;
import gw.internal.gosu.parser.ArrayExpansionPropertyInfo;
import gw.internal.gosu.parser.Expression;
import gw.internal.gosu.parser.GosuVarPropertyInfo;
import gw.internal.gosu.parser.JavaFieldPropertyInfo;
import gw.internal.gosu.parser.LengthProperty;
import gw.internal.gosu.parser.MetaType;
import gw.internal.gosu.parser.MetaTypeTypeInfo;
import gw.internal.gosu.parser.expressions.Identifier;
import gw.internal.gosu.parser.expressions.Literal;
import gw.internal.gosu.parser.expressions.MemberAccess;
import gw.internal.gosu.parser.expressions.MemberExpansionAccess;
import gw.internal.gosu.parser.expressions.SuperAccess;
import gw.internal.gosu.parser.expressions.TypeLiteral;
import gw.internal.gosu.parser.optimizer.SinglePropertyMemberAccessRuntime;
import gw.internal.gosu.runtime.GosuRuntimeMethods;
import gw.lang.Autocreate;
import gw.lang.ShortCircuitingProperty;
import gw.lang.ir.IRElement;
import gw.lang.ir.IRExpression;
import gw.lang.ir.IRStatement;
import gw.lang.ir.IRSymbol;
import gw.lang.ir.IRType;
import gw.lang.ir.expression.IRCompositeExpression;
import gw.lang.ir.statement.IRAssignmentStatement;
import gw.lang.ir.statement.IRSyntheticStatement;
import gw.lang.parser.EvaluationException;
import gw.lang.parser.IBlockClass;
import gw.lang.parser.ICustomExpressionRuntime;
import gw.lang.parser.IExpression;
import gw.lang.parser.Keyword;
import gw.lang.parser.MemberAccessKind;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IEntityAccess;
import gw.lang.reflect.IExpando;
import gw.lang.reflect.IPlaceholder;
import gw.lang.reflect.IPropertyAccessor;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IPropertyInfoDelegate;
import gw.lang.reflect.IRelativeTypeInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.ITypeInfoPropertyInfo;
import gw.lang.reflect.IUncacheableFeature;
import gw.lang.reflect.ReflectUtil;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuEnhancement;
import gw.lang.reflect.java.GosuTypes;
import gw.lang.reflect.java.JavaTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.script.Bindings;
import javax.script.SimpleBindings;

public class MemberAccessTransformer
extends AbstractExpressionTransformer<MemberAccess> {
    public static IRExpression compile(TopLevelTransformationContext cc, MemberAccess expr) {
        MemberAccessTransformer compiler = new MemberAccessTransformer(cc, expr);
        return compiler.compile();
    }

    private MemberAccessTransformer(TopLevelTransformationContext cc, MemberAccess expr) {
        super(cc, expr);
    }

    @Override
    protected IRExpression compile_impl() {
        Expression rootExpr = ((MemberAccess)this._expr()).getRootExpression();
        IType rootType = this.getConcreteType(rootExpr.getType());
        IPropertyInfo pi = ((MemberAccess)this._expr()).getPropertyInfo();
        if (this.isArrayExpansionProperty(pi)) {
            MemberExpansionAccess expr = MemberExpansionAccess.wrap((MemberAccess)this._expr());
            return MemberExpansionAccessTransformer.compile(this._cc(), expr);
        }
        if (((MemberAccess)this._expr()).getExpressionRuntime() instanceof ICustomExpressionRuntime) {
            return this.handleCustomExpressionRuntime((ICustomExpressionRuntime)((MemberAccess)this._expr()).getExpressionRuntime(), ((MemberAccess)this._expr()).getType());
        }
        if (this.isTypeInfoProperty(pi)) {
            ITypeInfoPropertyInfo typeInfoProp = (ITypeInfoPropertyInfo)pi;
            IPropertyInfo backingProp = typeInfoProp.getBackingPropertyInfo();
            return this.handleInstanceMemberAccess(rootExpr, backingProp.getOwnersType(), backingProp, IRPropertyFactory.createIRProperty(backingProp));
        }
        if (this.isStatic(pi)) {
            return this.handleStaticMemberAccess(rootExpr, rootType, pi, IRPropertyFactory.createIRProperty(pi));
        }
        return this.handleInstanceMemberAccess(rootExpr, rootType, pi, IRPropertyFactory.createIRProperty(pi));
    }

    private boolean isArrayExpansionProperty(IPropertyInfo pi) {
        return pi instanceof ArrayExpansionPropertyInfo;
    }

    private boolean isTypeInfoProperty(IPropertyInfo pi) {
        return pi instanceof ITypeInfoPropertyInfo;
    }

    private IRExpression handleInstanceMemberAccess(IExpression rootExpr, IType rootType, IPropertyInfo pi, IRProperty irProperty) {
        IRExpression accessExpression;
        boolean mightRequireAutoCreation = this.mightRequireAutoCreation(rootType, pi);
        boolean bShouldNullShortCircuitCheck = this.shouldNullShortCircuit(rootType, pi, mightRequireAutoCreation);
        if (mightRequireAutoCreation && !bShouldNullShortCircuitCheck) {
            throw new IllegalStateException("Should never have an expression requiring auto-creation that doesn't null-shortcircuit");
        }
        IRExpression root = this.pushRootExpression(rootType, rootExpr, irProperty);
        IRSymbol rootSymbol = null;
        if (bShouldNullShortCircuitCheck) {
            rootSymbol = this._cc().makeAndIndexTempSymbol(root.getType());
            accessExpression = this.buildAccessExpression(rootExpr, rootType, pi, irProperty, (IRExpression)this.identifier(rootSymbol));
        } else {
            accessExpression = this.buildAccessExpression(rootExpr, rootType, pi, irProperty, root);
        }
        accessExpression = this.castIfTypeDerivedFromTypeVariable(irProperty, accessExpression);
        if (mightRequireAutoCreation) {
            accessExpression = this.handleAutoCreationWhenValueIsNull(pi, rootSymbol, accessExpression);
        }
        if (bShouldNullShortCircuitCheck) {
            accessExpression = this.buildComposite(new IRElement[]{this.buildAssignment(rootSymbol, root), this.buildNullCheckTernary((IRExpression)this.identifier(rootSymbol), this.shortCircuitValue(accessExpression.getType()), accessExpression)});
        }
        return accessExpression;
    }

    private boolean shouldNullShortCircuit(IType rootType, IPropertyInfo pi, boolean mightRequireAutoCreation) {
        return !rootType.isPrimitive() && (((MemberAccess)this._expr()).getMemberAccessKind() == MemberAccessKind.NULL_SAFE || !CommonServices.getEntityAccess().getLanguageLevel().isStandard() && (!((MemberAccess)this._expr()).getType().isPrimitive() || ((MemberAccess)this._expr()).getType() == JavaTypes.pBOOLEAN() || ((MemberAccess)this._expr()).getType() == JavaTypes.pINT() && this.isLengthProperty(pi) || pi.hasAnnotation((IType)JavaTypes.getGosuType(ShortCircuitingProperty.class))) || mightRequireAutoCreation && !((MemberAccess)this._expr()).getType().isPrimitive());
    }

    private IRExpression buildAccessExpression(IExpression rootExpr, IType rootType, IPropertyInfo pi, IRProperty irProperty, IRExpression root) {
        if (irProperty == null) {
            return this.callStaticMethod(ReflectUtil.class, "getProperty", new Class[]{Object.class, String.class}, MemberAccessTransformer.exprList(root, this.pushString(((MemberAccess)this._expr()).getMemberExpression())));
        }
        if (irProperty.isField()) {
            IRExpression fieldGetter = this.getField(irProperty, root);
            return this.castIfTypeDerivedFromTypeVariable(irProperty, fieldGetter);
        }
        if (this.isLengthProperty(pi)) {
            return this.buildArrayLength(root);
        }
        if (rootExpr instanceof SuperAccess) {
            return this.callSpecialMethod(MemberAccessTransformer.getDescriptor(rootExpr.getType()), irProperty.getGetterMethod(), root, MemberAccessTransformer.exprList(new IRExpression[0]));
        }
        if (this.isSuperCall(rootExpr)) {
            return this.callSpecialMethod(MemberAccessTransformer.getDescriptor(this._cc().getSuperType()), irProperty.getGetterMethod(), root, MemberAccessTransformer.exprList(new IRExpression[0]));
        }
        if (this.isOuterCall(pi)) {
            return this.pushOuter(this.getNextNonBlockOuter(rootType.getEnclosingType()), rootType, root);
        }
        if (irProperty.isBytecodeProperty()) {
            IRExpression irMethodCall = this.callMethod(irProperty.getGetterMethod(), root, MemberAccessTransformer.exprList(new IRExpression[0]));
            if (!(irProperty.getOwningIType() instanceof IGosuEnhancement)) {
                this.assignStructuralTypeOwner(rootExpr, irMethodCall);
            }
            return irMethodCall;
        }
        return this.callPropertyInfo(rootType, pi, irProperty, root);
    }

    private boolean mightRequireAutoCreation(IType rootType, IPropertyInfo pi) {
        if (((MemberAccess)this._expr()).getExpressionRuntime() instanceof SinglePropertyMemberAccessRuntime && ((SinglePropertyMemberAccessRuntime)((MemberAccess)this._expr()).getExpressionRuntime()).isNestedInLhs()) {
            IType autocreateAnnotationType = GosuTypes.AUTOCREATE();
            List list = pi.getAnnotationsOfType(autocreateAnnotationType);
            if (list != null && !list.isEmpty()) {
                return true;
            }
            if (rootType instanceof IPlaceholder && ((IPlaceholder)rootType).isPlaceholder()) {
                return true;
            }
            IEntityAccess ea = CommonServices.getEntityAccess();
            if (ea.isEntityClass(rootType) && ea.isEntityClass(pi.getFeatureType())) {
                return true;
            }
        }
        return false;
    }

    private IRExpression handleAutoCreationWhenValueIsNull(IPropertyInfo pi, IRSymbol rootSymbol, IRExpression accessExpression) {
        IRSymbol resultSymbol = this._cc().makeAndIndexTempSymbol(accessExpression.getType());
        return this.buildComposite(new IRElement[]{this.buildAssignment(resultSymbol, accessExpression), this.buildNullCheckTernary((IRExpression)this.identifier(resultSymbol), this.autoCreateEntityValue(pi, rootSymbol), (IRExpression)this.identifier(resultSymbol))});
    }

    private IRExpression autoCreateEntityValue(IPropertyInfo pi, IRSymbol rootSymbol) {
        return this.checkCast(((MemberAccess)this._expr()).getType(), this.callStaticMethod(MemberAccessTransformer.class, "autoCreateEntityInstance", new Class[]{Object.class, String.class, String.class}, MemberAccessTransformer.exprList(new IRExpression[]{this.identifier(rootSymbol), this.pushConstant(pi.getOwnersType().getName()), this.pushConstant(pi.getName())})));
    }

    private IType getNextNonBlockOuter(IType type) {
        while (type instanceof IBlockClass) {
            type = type.getEnclosingType();
        }
        return type;
    }

    private boolean isEnhancementProperty(IPropertyInfo pi) {
        return this.getDelegatedEnhancementProperty(pi) != null;
    }

    private IPropertyInfo getDelegatedEnhancementProperty(IPropertyInfo pi) {
        IPropertyInfo delegatePI = null;
        if (pi instanceof IPropertyInfoDelegate && !MemberAccessTransformer.isEnhancementType((delegatePI = ((IPropertyInfoDelegate)pi).getSource()).getOwnersType())) {
            delegatePI = null;
        }
        return delegatePI;
    }

    private IRExpression castIfTypeDerivedFromTypeVariable(IRProperty irProp, IRExpression root) {
        if (irProp == null) {
            return root;
        }
        IType type = ((MemberAccess)this._expr()).getType();
        if (type != JavaTypes.pVOID() && !type.isPrimitive() && !MemberAccessTransformer.getDescriptor(type).isAssignableFrom(irProp.getType())) {
            return this.checkCast(type, root);
        }
        return root;
    }

    private IRExpression handleStaticMemberAccess(IExpression rootExpr, IType rootType, IPropertyInfo pi, IRProperty irProperty) {
        rootType = this.maybeUnwrapMetaType(rootType);
        if (this.isTypeProperty(pi)) {
            if (rootExpr instanceof TypeLiteral) {
                IRExpression result = this.checkCast(pi.getFeatureType(), this.pushType(rootType));
                return this.maybeEvalRoot(rootExpr, result);
            }
            return this.pushRootExpression(rootType, rootExpr, irProperty);
        }
        if (pi != null && irProperty.isBytecodeProperty()) {
            IRExpression result = irProperty.isField() ? this.getField(irProperty, null) : this.callMethod(irProperty.getGetterMethod(), null, MemberAccessTransformer.exprList(new IRExpression[0]));
            return this.maybeEvalRoot(rootExpr, result);
        }
        return this.callPropertyInfo(rootType, pi, irProperty, this.pushType(rootType));
    }

    private IRExpression maybeEvalRoot(IExpression rootExpr, IRExpression result) {
        if (!(rootExpr instanceof Literal)) {
            return new IRCompositeExpression(new IRElement[]{new IRSyntheticStatement(ExpressionTransformer.compile(rootExpr, this._cc())), result});
        }
        return result;
    }

    private boolean isTypeProperty(IPropertyInfo pi) {
        return pi instanceof MetaTypeTypeInfo.TypeProperty;
    }

    private String getField(IPropertyInfo pi) {
        if (!this.isField(pi)) {
            throw new IllegalArgumentException(pi.getName() + " is not a 'field' property");
        }
        while (pi instanceof IPropertyInfoDelegate) {
            pi = ((IPropertyInfoDelegate)pi).getSource();
        }
        if (pi.getClass() == JavaFieldPropertyInfo.class) {
            return ((JavaFieldPropertyInfo)pi).getField().getName();
        }
        return pi.getName();
    }

    private boolean isField(IPropertyInfo pi) {
        return pi instanceof GosuVarPropertyInfo || pi instanceof JavaFieldPropertyInfo || pi instanceof IPropertyInfoDelegate && this.isField(((IPropertyInfoDelegate)pi).getSource());
    }

    private boolean isLengthProperty(IPropertyInfo pi) {
        return pi instanceof LengthProperty || pi instanceof IPropertyInfoDelegate && this.isLengthProperty(((IPropertyInfoDelegate)pi).getSource());
    }

    private boolean isSuperCall(IExpression rootExpr) {
        return rootExpr instanceof Identifier && Keyword.KW_super.equals(((Identifier)rootExpr).getSymbol().getName());
    }

    private boolean isOuterCall(IPropertyInfo rootExpr) {
        return Keyword.KW_outer.equals(rootExpr.getName());
    }

    private IRExpression callPropertyInfo(IType rootType, IPropertyInfo pi, IRProperty irProperty, IRExpression rawRoot) {
        IRExpression root;
        IRSymbol rootSymbol = null;
        ArrayList<Object> preEvaluationStatements = new ArrayList<Object>();
        if (rawRoot != null) {
            rootSymbol = this._cc().makeAndIndexTempSymbol(rawRoot.getType());
            IRAssignmentStatement rootAssignment = this.buildAssignment(rootSymbol, rawRoot);
            preEvaluationStatements.add(rootAssignment);
        }
        if (pi == null || pi.isStatic()) {
            root = this.nullLiteral();
        } else {
            IRStatement nullCheck = this.nullCheckVar(rootSymbol);
            preEvaluationStatements.add(nullCheck);
            root = this.identifier(rootSymbol);
        }
        IRExpression result = this.buildInvocation(rootType, pi, irProperty, rootSymbol, root);
        if (preEvaluationStatements.isEmpty()) {
            return result;
        }
        preEvaluationStatements.add(result);
        return new IRCompositeExpression(preEvaluationStatements);
    }

    private IRExpression buildInvocation(IType rootType, IPropertyInfo pi, IRProperty irProperty, IRSymbol rootSymbol, IRExpression root) {
        IRType piClass;
        IRExpression result;
        if (((MemberAccess)this._expr()).getRootExpression() != null && !(pi instanceof ITypeInfoPropertyInfo)) {
            if (rootType instanceof IPlaceholder && rootSymbol == null) {
                throw new IllegalArgumentException("Cannot invoke a static property reflectively on a placeholder type");
            }
            result = this.callStaticMethod(GosuRuntimeMethods.class, "getProperty", new Class[]{Object.class, IType.class, String.class}, MemberAccessTransformer.exprList(root, this.pushType(rootType), this.pushPropertyName(pi)));
        } else {
            IRExpression typeExpression = ((MemberAccess)this._expr()).getRootExpression() != null && !(pi instanceof ITypeInfoPropertyInfo) ? this.callStaticMethod(TypeSystem.class, "getFromObject", new Class[]{Object.class}, MemberAccessTransformer.exprList(root)) : (pi instanceof ITypeInfoPropertyInfo ? this.callStaticMethod(MetaType.class, "get", new Class[]{IType.class}, MemberAccessTransformer.exprList(root)) : this.pushType(rootType));
            IRExpression getTypeInfo = this.callMethod(IType.class, "getTypeInfo", new Class[0], typeExpression, MemberAccessTransformer.exprList(new IRExpression[0]));
            boolean relativeTypeInfo = pi != null && pi.getOwnersType().getTypeInfo() instanceof IRelativeTypeInfo;
            IRExpression getProperty = relativeTypeInfo ? this.callMethod(IRelativeTypeInfo.class, "getProperty", new Class[]{IType.class, CharSequence.class}, this.checkCast(IRelativeTypeInfo.class, getTypeInfo), MemberAccessTransformer.exprList(this.pushType(rootType), this.pushPropertyName(pi))) : this.callMethod(ITypeInfo.class, "getProperty", new Class[]{CharSequence.class}, getTypeInfo, MemberAccessTransformer.exprList(this.pushPropertyName(pi)));
            IRExpression accessor = this.callMethod(IPropertyInfo.class, "getAccessor", new Class[0], getProperty, MemberAccessTransformer.exprList(new IRExpression[0]));
            result = this.callMethod(IPropertyAccessor.class, "getValue", new Class[]{Object.class}, accessor, MemberAccessTransformer.exprList(root));
        }
        result = pi instanceof IPropertyInfoDelegate ? (!(piClass = irProperty.getType()).isPrimitive() ? this.buildCast(piClass, result) : this.unboxValueToType(((MemberAccess)this._expr()).getType(), result)) : this.unboxValueToType(((MemberAccess)this._expr()).getType(), result);
        return result;
    }

    private IRExpression pushPropertyName(IPropertyInfo pi) {
        if (pi != null) {
            if (pi instanceof IUncacheableFeature) {
                return this.pushConstant(((MemberAccess)this._expr()).getMemberName());
            }
            return this.pushConstant(pi.getName());
        }
        return this.pushString(((MemberAccess)this._expr()).getMemberExpression());
    }

    private IRExpression pushRootExpression(IType rootType, IExpression rootExpr, IRProperty pi) {
        IRType type;
        IRExpression root = ExpressionTransformer.compile(rootExpr, this._cc());
        root = this.boxValue(rootType, root);
        if (!(pi == null || pi.isStatic() || (type = pi.getTargetRootIRType()).isAssignableFrom(root.getType()) || rootExpr.getType() instanceof IGosuClass && ((IGosuClass)rootExpr.getType()).isStructure())) {
            root = this.buildCast(type, root);
        }
        return root;
    }

    private boolean isStatic(IPropertyInfo pi) {
        return pi != null && pi.isStatic();
    }

    public static Object autoCreateEntityInstance(Object rootValue, String typeName, String propertyName) {
        Object value;
        boolean usingAutoCreateAnnotation;
        if (rootValue instanceof IExpando) {
            ((IExpando)rootValue).setDefaultFieldValue(propertyName);
            return ((IExpando)rootValue).getFieldValue(propertyName);
        }
        if (rootValue instanceof Bindings) {
            SimpleBindings value2 = new SimpleBindings();
            ((Bindings)rootValue).put(propertyName, (Object)value2);
            return value2;
        }
        IType entityType = TypeSystem.getByFullName((String)typeName);
        IPropertyInfo property = entityType.getTypeInfo().getProperty((CharSequence)propertyName);
        IEntityAccess ea = CommonServices.getEntityAccess();
        List annotationInfoList = property.getAnnotationsOfType(GosuTypes.AUTOCREATE());
        boolean bl = usingAutoCreateAnnotation = annotationInfoList != null && annotationInfoList.size() > 0;
        if (usingAutoCreateAnnotation) {
            IAnnotationInfo annotation = (IAnnotationInfo)annotationInfoList.get(0);
            Autocreate o = (Autocreate)annotation.getInstance();
            Class block = o.value();
            if (block == null || block.isInterface()) {
                value = property.getFeatureType().getTypeInfo().getConstructor(new IType[0]).getConstructor().newInstance(new Object[0]);
            } else {
                try {
                    value = ((Callable)block.newInstance()).call();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            value = ea.getEntityInstanceFrom(rootValue, property.getFeatureType());
        }
        if (!property.isWritable()) {
            throw new EvaluationException("Property, " + property.getName() + ", on class, " + TypeSystem.getFromObject((Object)rootValue).getRelativeName() + ", is null and immutable.");
        }
        value = CommonServices.getCoercionManager().convertValue(value, property.getFeatureType());
        property.getAccessor().setValue(rootValue, value);
        return usingAutoCreateAnnotation ? property.getAccessor().getValue(rootValue) : value;
    }
}

