/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import com.sun.source.tree.Tree;
import gw.internal.gosu.parser.AsmTypeJavaClassType;
import gw.internal.gosu.parser.GenericTypeVariable;
import gw.internal.gosu.parser.java.classinfo.AsmClassAnnotationInfo;
import gw.internal.gosu.parser.java.classinfo.JavaSourceType;
import gw.internal.gosu.parser.java.classinfo.JavaSourceUtil;
import gw.lang.reflect.FunctionType;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGenericTypeVariable;
import gw.lang.reflect.gs.ISourceFileHandle;
import gw.lang.reflect.java.IJavaAnnotatedElement;
import gw.lang.reflect.java.IJavaClassBytecodeMethod;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.IJavaClassMethod;
import gw.lang.reflect.java.IJavaClassType;
import gw.lang.reflect.java.IJavaClassTypeVariable;
import gw.lang.reflect.java.IJavaMethodInfo;
import gw.lang.reflect.java.JavaSourceElement;
import gw.lang.reflect.java.Parameter;
import gw.lang.reflect.java.asm.AsmAnnotation;
import gw.lang.reflect.java.asm.AsmMethod;
import gw.lang.reflect.java.asm.AsmType;
import gw.lang.reflect.java.asm.IAsmType;
import gw.lang.reflect.module.IModule;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;

public class AsmMethodJavaClassMethod
extends JavaSourceElement
implements IJavaClassMethod,
IJavaClassBytecodeMethod {
    private AsmMethod _method;
    private IModule _module;

    public AsmMethodJavaClassMethod(AsmMethod method, IModule module) {
        this._method = method;
        this._module = module;
    }

    public IType getReturnType() {
        return TypeSystem.getByFullNameIfValid((String)this._method.getReturnType().getNameWithArrayBrackets());
    }

    public IJavaClassInfo getReturnClassInfo() {
        return JavaSourceUtil.getClassInfo(this._method.getReturnType().getNameWithArrayBrackets(), this._module);
    }

    public String getName() {
        return this._method.getName();
    }

    public List<Parameter> getParameterInfos() {
        return this._method.getParameterInfos();
    }

    public IJavaClassInfo getEnclosingClass() {
        return JavaSourceUtil.getClassInfo(this._method.getDeclaringClass(), this._module);
    }

    public IJavaClassInfo[] getParameterTypes() {
        List rawTypes = this._method.getParameters();
        IJavaClassInfo[] types = new IJavaClassInfo[rawTypes.size()];
        for (int i = 0; i < rawTypes.size(); ++i) {
            types[i] = JavaSourceUtil.getClassInfo(((AsmType)rawTypes.get(i)).getNameWithArrayBrackets(), this._module);
        }
        return types;
    }

    public int getModifiers() {
        return this._method.getModifiers();
    }

    public boolean isSynthetic() {
        return this._method.isSynthetic();
    }

    public boolean isBridge() {
        return this._method.isBridge();
    }

    public IJavaClassInfo[] getExceptionTypes() {
        List rawTypes = this._method.getExceptions();
        IJavaClassInfo[] types = new IJavaClassInfo[rawTypes.size()];
        for (int i = 0; i < rawTypes.size(); ++i) {
            types[i] = JavaSourceUtil.getClassInfo(((AsmType)rawTypes.get(i)).getNameWithArrayBrackets(), this._module);
        }
        return types;
    }

    public Object getDefaultValue() {
        return this.normalizeValue(this._method.getAnnotationDefaultValue());
    }

    private Object normalizeValue(Object value) {
        if (value instanceof List) {
            value = this.makeArray((List)value);
        }
        return value;
    }

    private Object makeArray(List l) {
        try {
            IJavaClassInfo ci = this.getReturnClassInfo();
            return AsmClassAnnotationInfo.makeArray(ci, l, (IJavaAnnotatedElement)this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getReturnTypeName() {
        return this._method.getReturnType().getNameWithArrayBrackets();
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this._method.isAnnotationPresent(annotationClass);
    }

    public IAnnotationInfo getAnnotation(Class annotationClass) {
        AsmAnnotation annotation = this._method.getAnnotation(annotationClass);
        return annotation != null ? new AsmClassAnnotationInfo(annotation, (IJavaAnnotatedElement)this) : null;
    }

    public IAnnotationInfo[] getDeclaredAnnotations() {
        List annotations = this._method.getAnnotations();
        IAnnotationInfo[] declaredAnnotations = new IAnnotationInfo[annotations.size()];
        for (int i = 0; i < declaredAnnotations.length; ++i) {
            declaredAnnotations[i] = new AsmClassAnnotationInfo((AsmAnnotation)annotations.get(i), (IJavaAnnotatedElement)this);
        }
        return declaredAnnotations;
    }

    public void setAccessible(boolean accessible) {
        throw new UnsupportedOperationException();
    }

    public Object invoke(Object ctx, Object[] args) throws InvocationTargetException, IllegalAccessException {
        throw new UnsupportedOperationException();
    }

    public IGenericTypeVariable[] getTypeVariables(IJavaMethodInfo mi) {
        List typeVars = this._method.getMethodType().getTypeParameters();
        FunctionType functionType = new FunctionType((IMethodInfo)mi, true);
        IJavaClassTypeVariable[] javaTypeVars = new IJavaClassTypeVariable[typeVars.size()];
        for (int i = 0; i < typeVars.size(); ++i) {
            javaTypeVars[i] = (IJavaClassTypeVariable)AsmTypeJavaClassType.createType((IAsmType)typeVars.get(i), this._module);
        }
        return GenericTypeVariable.convertTypeVars((IType)functionType, mi.getOwnersType(), javaTypeVars);
    }

    public IJavaClassType[] getGenericParameterTypes() {
        List getParam = this._method.getGenericParameters();
        IJavaClassType[] types = new IJavaClassType[getParam.size()];
        for (int i = 0; i < getParam.size(); ++i) {
            IJavaClassType type;
            AsmType rawType = (AsmType)getParam.get(i);
            types[i] = type = AsmTypeJavaClassType.createType((IAsmType)rawType, this._module);
        }
        return types;
    }

    public IJavaClassType getGenericReturnType() {
        return AsmTypeJavaClassType.createType((IAsmType)this._method.getGenericReturnType(), this._module);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.getParameterTypes());
        result = 31 * result + this.getReturnType().hashCode();
        result = 31 * result + this.getName().hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof IJavaClassMethod)) {
            return false;
        }
        IJavaClassMethod jcm = (IJavaClassMethod)o;
        return this.getName().equals(jcm.getName()) && this.getReturnType() == jcm.getReturnType() && Arrays.equals(this.getParameterTypes(), jcm.getParameterTypes());
    }

    public int compareTo(IJavaClassMethod o) {
        return this.getName().compareTo(o.getName());
    }

    public String toString() {
        return this._method.toString();
    }

    public Tree getTree() {
        JavaSourceElement sourceMethod;
        ISourceFileHandle sfh = this.getEnclosingClass().getSourceFileHandle();
        if (sfh != null && (sourceMethod = this.findSourceMethod(sfh)) != null) {
            return sourceMethod.getTree();
        }
        return null;
    }

    private JavaSourceElement findSourceMethod(ISourceFileHandle sfh) {
        IJavaClassInfo sourceType = JavaSourceType.createTopLevel(sfh, this.getEnclosingClass().getModule());
        if (sourceType == null) {
            return null;
        }
        IType enclosingClass = this.getEnclosingClass().getJavaType();
        if (enclosingClass.getEnclosingType() != null) {
            sourceType = this.findInnerSourceType(sourceType, enclosingClass.getName());
        }
        try {
            return (JavaSourceElement)sourceType.getDeclaredMethod(this.getName(), this.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

