/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.parser.GosuAnnotationInfo;
import gw.internal.gosu.parser.IGosuAnnotation;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.TypeLord;
import gw.lang.parser.TypeVarToTypeMap;
import gw.lang.reflect.BaseFeatureInfo;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IAttributedFeatureInfo;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IGenericMethodInfo;
import gw.lang.reflect.IScriptabilityModifier;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGenericTypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class GosuBaseAttributedFeatureInfo
extends BaseFeatureInfo
implements IAttributedFeatureInfo {
    volatile List<IAnnotationInfo> _declaredAnnotations;

    public GosuBaseAttributedFeatureInfo(IFeatureInfo container) {
        super(container);
    }

    protected abstract List<IGosuAnnotation> getGosuAnnotations();

    public List<IAnnotationInfo> getDeclaredAnnotations() {
        this.maybeInitAnnotations();
        return this._declaredAnnotations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeInitAnnotations() {
        if (this._declaredAnnotations == null) {
            TypeSystem.lock();
            try {
                if (this._declaredAnnotations == null) {
                    List<IGosuAnnotation> rawAnnotations = this.getGosuAnnotations();
                    if (rawAnnotations != null) {
                        ArrayList<IAnnotationInfo> lst = new ArrayList<IAnnotationInfo>();
                        for (int i = 0; i < rawAnnotations.size(); ++i) {
                            IGosuAnnotation gosuAnnotation = rawAnnotations.get(i);
                            lst.add(new GosuAnnotationInfo(gosuAnnotation, (IFeatureInfo)this, this.getOwnersType()));
                        }
                        lst.trimToSize();
                        this._declaredAnnotations = lst;
                    } else {
                        this._declaredAnnotations = Collections.emptyList();
                    }
                }
            }
            finally {
                TypeSystem.unlock();
            }
        }
    }

    public boolean isDeprecated() {
        return this.getOwnersType().getTypeInfo().isDeprecated() || super.isDeprecated() || this.hasDeclaredAnnotation(TypeSystem.get(Deprecated.class));
    }

    public String getDeprecatedReason() {
        String thisDeprecated = super.getDeprecatedReason();
        return thisDeprecated == null ? this.getOwnersType().getTypeInfo().getDeprecatedReason() : thisDeprecated;
    }

    public boolean isHidden() {
        return this.getOwnersType().getTypeInfo().isHidden() || super.isHidden();
    }

    public boolean isVisible(IScriptabilityModifier constraint) {
        return super.isVisible(constraint) && this.getOwnersType().getTypeInfo().isVisible(constraint);
    }

    public IGosuClassInternal getOwnersType() {
        return (IGosuClassInternal)super.getOwnersType();
    }

    public IType getActualTypeInContainer(IFeatureInfo container, IType type) {
        IType ownerType = container.getOwnersType();
        if (ownerType.isParameterizedType()) {
            TypeVarToTypeMap actualParamByVarName = TypeLord.mapTypeByVarName(ownerType, ownerType);
            if (container instanceof IGenericMethodInfo) {
                for (IGenericTypeVariable tv : ((IGenericMethodInfo)container).getTypeVariables()) {
                    if (actualParamByVarName.isEmpty()) {
                        actualParamByVarName = new TypeVarToTypeMap();
                    }
                    actualParamByVarName.put(tv.getTypeVariableDefinition().getType(), (IType)tv.getTypeVariableDefinition().getType());
                }
                type = TypeLord.getActualType(type, actualParamByVarName, true);
            }
        }
        return type;
    }
}

