/*
 * Decompiled with CFR 0.152.
 */
package gw.internal.gosu.parser;

import gw.internal.gosu.ir.nodes.IRMethodFactory;
import gw.internal.gosu.ir.nodes.IRMethodFromMethodInfo;
import gw.internal.gosu.ir.transform.AbstractElementTransformer;
import gw.internal.gosu.ir.transform.util.NameResolver;
import gw.internal.gosu.parser.AbstractGenericMethodInfo;
import gw.internal.gosu.parser.DynamicFunctionSymbol;
import gw.internal.gosu.parser.IGosuAnnotation;
import gw.internal.gosu.parser.IGosuClassInternal;
import gw.internal.gosu.parser.ReducedDelegateFunctionSymbol;
import gw.internal.gosu.parser.ReducedDynamicFunctionSymbol;
import gw.internal.gosu.parser.ReducedParameterizedDynamicFunctionSymbol;
import gw.internal.gosu.parser.TypeLord;
import gw.internal.gosu.parser.java.classinfo.CompileTimeExpressionParser;
import gw.lang.Returns;
import gw.lang.ir.IRElement;
import gw.lang.ir.IRType;
import gw.lang.parser.IExpression;
import gw.lang.parser.IReducedDynamicFunctionSymbol;
import gw.lang.parser.IReducedSymbol;
import gw.lang.parser.TypeVarToTypeMap;
import gw.lang.parser.exceptions.ErrantGosuClassException;
import gw.lang.reflect.FunctionType;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IMethodCallHandler;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.NotLazyTypeResolver;
import gw.lang.reflect.ReflectUtil;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGenericTypeVariable;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuMethodInfo;
import gw.lang.reflect.gs.IGosuProgram;
import gw.lang.reflect.java.JavaTypes;
import gw.util.GosuExceptionUtil;
import gw.util.GosuStringUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GosuMethodInfo
extends AbstractGenericMethodInfo
implements IGosuMethodInfo {
    private IType _returnType;
    private IMethodCallHandler _callHandler;

    public GosuMethodInfo(IFeatureInfo container, DynamicFunctionSymbol dfs) {
        super(container, dfs);
    }

    public IType getReturnType() {
        if (this._returnType == null) {
            IType rawReturnType = ((FunctionType)this.getDfs().getType()).getReturnType();
            IGosuClassInternal ownerType = this.getOwnersType();
            if (ownerType.isParameterizedType() && !(this.getDfs() instanceof ReducedParameterizedDynamicFunctionSymbol)) {
                TypeVarToTypeMap actualParamByVarName = TypeLord.mapTypeByVarName((IType)ownerType, (IType)ownerType);
                for (IGenericTypeVariable tv : this.getTypeVariables()) {
                    if (actualParamByVarName.isEmpty()) {
                        actualParamByVarName = new TypeVarToTypeMap();
                    }
                    actualParamByVarName.put(tv.getTypeVariableDefinition().getType(), (IType)tv.getTypeVariableDefinition().getType());
                }
                this._returnType = TypeLord.getActualType(rawReturnType, actualParamByVarName, true);
            } else {
                this._returnType = rawReturnType;
            }
        }
        if (TypeSystem.isDeleted((IType)this._returnType)) {
            this._returnType = TypeSystem.getErrorType();
        }
        if (this._returnType.isGenericType() && !this._returnType.isParameterizedType()) {
            this._returnType = TypeLord.getDefaultParameterizedType(this._returnType);
        }
        return this._returnType;
    }

    public IMethodCallHandler getCallHandler() {
        if (this._callHandler == null) {
            IGosuClassInternal gsClass = this.getGosuClass();
            if (!gsClass.isValid()) {
                throw new ErrantGosuClassException((IGosuClass)gsClass);
            }
            this._callHandler = gsClass.isStructure() && !this.isStatic() ? new ReflectiveMethodCallHandler() : new GosuMethodCallHandler();
        }
        return this._callHandler;
    }

    public String getReturnDescription() {
        List annotation = this.getAnnotationsOfType((IType)JavaTypes.getGosuType(Returns.class));
        if (annotation.isEmpty()) {
            return "";
        }
        String value = (String)((IAnnotationInfo)annotation.get(0)).getFieldValue("value");
        return value == null ? "" : value;
    }

    public IExpression[] getDefaultValueExpressions() {
        ArrayList<IExpression> defValues = new ArrayList<IExpression>();
        for (IReducedSymbol s : this.getArgs()) {
            IExpression defValue = s.getDefaultValueExpression();
            defValues.add(defValue);
        }
        return defValues.toArray(new IExpression[defValues.size()]);
    }

    public String[] getParameterNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (IReducedSymbol a : this.getArgs()) {
            names.add(a.getName());
        }
        return names.toArray(new String[names.size()]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GosuMethodInfo that = (GosuMethodInfo)((Object)o);
        return this.getName().equals(that.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public int compareTo(Object o) {
        return this.getName().compareTo(((IMethodInfo)o).getName());
    }

    public boolean isMethodForProperty() {
        return this.getName().startsWith("@");
    }

    public IGosuMethodInfo getBackingMethodInfo() {
        return this;
    }

    public String toString() {
        return this.getName();
    }

    public static Method getMethod(Class<?> clazz, String strName, Class[] argClasses) {
        Method method;
        if (((String)strName).startsWith("@")) {
            Object object = strName = argClasses.length == 1 ? "set" + ((String)strName).substring(1) : "get" + ((String)strName).substring(1);
        }
        if ((method = AbstractElementTransformer.getDeclaredMethod(clazz, (String)strName, argClasses)) == null) {
            throw new IllegalStateException("Could not find method " + (String)strName + "(" + GosuStringUtil.join((String)",", (Object[])argClasses) + ") on " + clazz);
        }
        method.setAccessible(true);
        return method;
    }

    @Override
    protected List<IGosuAnnotation> getGosuAnnotations() {
        IMethodInfo miTarget;
        IReducedDynamicFunctionSymbol dfs = this.getDfs();
        if (dfs instanceof ReducedDelegateFunctionSymbol && (miTarget = ((ReducedDelegateFunctionSymbol)dfs).getTargetMethodInfo()) != this && miTarget instanceof AbstractGenericMethodInfo) {
            if (this.getOwnersType().isCompiled()) {
                miTarget.getOwnersType().isValid();
            }
            return ((AbstractGenericMethodInfo)miTarget).getGosuAnnotations();
        }
        return super.getGosuAnnotations();
    }

    public boolean hasAnnotationDefault() {
        return this.getDfs().getDefaultValueExpression() != null;
    }

    public Object getAnnotationDefault() {
        IExpression annotationDefault = this.getDfs().getDefaultValueExpression();
        if (annotationDefault != null) {
            return CompileTimeExpressionParser.convertValueToInfoFriendlyValue(annotationDefault.evaluate(), (IFeatureInfo)this.getOwnersType().getTypeInfo());
        }
        return null;
    }

    private class ReflectiveMethodCallHandler
    implements IMethodCallHandler {
        private ReflectiveMethodCallHandler() {
        }

        public Object handleCall(Object ctx, Object ... args) {
            return ReflectUtil.invokeMethod((Object)ctx, (String)GosuMethodInfo.this.getDisplayName(), (Object[])args);
        }
    }

    private class GosuMethodCallHandler
    implements IMethodCallHandler {
        private GosuMethodCallHandler() {
        }

        public Object handleCall(Object gsClassInstance, Object ... args) {
            IReducedDynamicFunctionSymbol dfs = GosuMethodInfo.this.getDfs();
            try {
                boolean isEnhancement = AbstractElementTransformer.requiresImplicitEnhancementArg((ReducedDynamicFunctionSymbol)dfs);
                IGosuClassInternal dfsClass = dfs.getGosuClass();
                if (isEnhancement || dfs.hasTypeVariables() || dfs.getGosuClass() instanceof IGosuProgram) {
                    ArrayList<Object> argList = new ArrayList<Object>();
                    if (isEnhancement) {
                        argList.add(gsClassInstance);
                        if (!dfs.isStatic() && dfs.isReified()) {
                            int i;
                            if (dfsClass.isParameterizedType()) {
                                for (i = 0; i < dfsClass.getTypeParameters().length; ++i) {
                                    IType paramType = dfsClass.getTypeParameters()[i];
                                    argList.add(new NotLazyTypeResolver(paramType));
                                }
                            } else {
                                for (i = 0; i < dfsClass.getGenericTypeVariables().length; ++i) {
                                    IGenericTypeVariable tv = dfsClass.getGenericTypeVariables()[i];
                                    argList.add(new NotLazyTypeResolver(tv.getBoundingType()));
                                }
                            }
                        }
                    }
                    if (dfs.isReified()) {
                        for (IGenericTypeVariable typeVar : dfs.getType().getGenericTypeVariables()) {
                            argList.add(new NotLazyTypeResolver(typeVar.getBoundingType()));
                        }
                    }
                    if (args != null) {
                        argList.addAll(Arrays.asList(args));
                    }
                    args = argList.toArray();
                }
                Class clazz = dfsClass.getBackingClass();
                IRMethodFromMethodInfo irMethod = IRMethodFactory.createIRMethod((IMethodInfo)GosuMethodInfo.this, (IFunctionType)dfs.getType());
                List<IRType> allParameterTypes = irMethod.getAllParameterTypes();
                Class[] paramClasses = new Class[allParameterTypes.size()];
                for (int i = 0; i < allParameterTypes.size(); ++i) {
                    paramClasses[i] = IRElement.maybeEraseStructuralType((IRType)allParameterTypes.get(i)).getJavaClass();
                }
                Method method = GosuMethodInfo.getMethod(clazz, NameResolver.getFunctionName((ReducedDynamicFunctionSymbol)dfs), paramClasses);
                return method.invoke(gsClassInstance, args);
            }
            catch (IllegalAccessException e) {
                throw GosuExceptionUtil.forceThrow((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw GosuExceptionUtil.forceThrow((Throwable)e.getTargetException());
            }
        }
    }
}

